package org.apache.maven.archiva.reporting;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.Map;

/**
 * DefaultReportingManager 
 *
 * @version $Id: DefaultReportingManager.java 755290 2009-03-17 15:53:37Z brett $
 * 
 * @plexus.component role="org.apache.maven.archiva.reporting.ReportingManager"
 *                   role-hint="default"
 */
public class DefaultReportingManager
    implements ReportingManager
{
    /**
     * @plexus.requirement role="org.apache.maven.archiva.reporting.DynamicReportSource"
     */
    private Map<String, DynamicReportSource<?>> reportSourceMap;

    public DynamicReportSource<?> getReport( String id )
    {
        return reportSourceMap.get( id );
    }

    public Map<String, DynamicReportSource<?>> getAvailableReports()
    {
        return reportSourceMap;
    }
}
