package org.apache.maven.archiva.xml;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.dom4j.Document;
import org.dom4j.io.OutputFormat;

import java.io.IOException;
import java.io.Writer;

/**
 * XMLWriter - Making writing XML files easier. 
 *
 * @version $Id: XMLWriter.java 718864 2008-11-19 06:33:35Z brett $
 */
public class XMLWriter
{
    /**
     * Write the Document to the provided Writer, leaving the Writer open.
     * 
     * @param doc the document to write.
     * @param writer the writer to write to.
     * @throws XMLException if there was a problem writing the xml to the writer.
     */
    public static void write( Document doc, Writer writer )
        throws XMLException
    {
        write( doc, writer, false );
    }

    /**
     * Write the Document to the provided Writer, with an option to close the writer upon completion.
     * 
     * @param doc the document to write.
     * @param writer the writer to write to.
     * @param close true to close the writer on completion.
     * @throws XMLException if there was a problem writing the xml to the writer.
     */
    public static void write( Document doc, Writer writer, boolean close )
        throws XMLException
    {
        org.dom4j.io.XMLWriter xmlwriter = null;

        try
        {
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            xmlwriter = new org.dom4j.io.XMLWriter( writer, outputFormat );
            xmlwriter.write( doc );
            xmlwriter.flush();
        }
        catch ( IOException e )
        {
            throw new XMLException( "Unable to write xml contents to writer: " + e.getMessage(), e );
        }
        finally
        {
            if ( close && ( xmlwriter != null ) )
            {
                try
                {
                    xmlwriter.close();
                }
                catch ( IOException e )
                {
                    /* quietly ignore */
                }
            }
        }
    }
}
