/*
 *	epgrec select assist
 *	●セレクトボックスをキー入力で選択可能にする
 * （チャンネル選択用に作りましたが、
 * 汎用に使えるように変更しました）
 * 	セレクトボックスがフォーカス状態の時、
 * 	テキストの頭文字を入力することで
 *		次の候補を選択します
 *		shiftキーを押している場合は前の候補を選択
 * ●放送波選択で選択可能チャンネル変更
 *
 * Version 0.2
 * 17:51 2012/02/24
 *
 * Author : osamu - atelier TRUMPHOUSE
 *
 */


var ER_sub = ER_sub || {};
ER_sub.FRM ={
	// ひらがなカタカタ
	Astr : {
		a : 'あいうえおアイウエオ',
		i : 'いイ', u : 'うウ', e : 'えエ', o : 'おオ',
		k : 'かきくけこカキクケコがぎぐげごガギギゲゴ',
		g : 'がぎぐげごガギギゲゴ',
		s : 'さしすせそサシスセソざじずぜぞザジズゼゾ',
		z : 'ざじずぜぞザジズゼゾ',
		t : 'たちつてとタチツテトだぢづでどダヂヅデド',
		c : 'ちチ',
		d : 'だぢづでどダヂヅデド',
		n : 'なにぬねのナニヌネノ',
		h : 'はひふへほハヒフヘホぱぴぷぺぽパピプペポばびぶべぼバビブベボ',
		p : 'ぱぴぷぺぽパピプペポ',
		b : 'ばびぶべぼバビブベボ',
		m : 'まみむめもマミムメモ',
		y : 'やゆよヤユヨ',
		r : 'らりるれろラリルレロ',
		w : 'わワ'
	},
	// 漢字等
	Kstr : {a : '朝衛青岩秋愛大岡', i : '岩石', e : '衛愛', o : '大岡', k : '関高鹿北九熊火金', g : '群月', s : '札仙静四瀬山信水', j : '時', h : '放北東福広', n : '日新長奈南西', t : '東宝旅富中土動', c : '中', d : '動土', m : '三宮南木', y : '洋山読', r : '琉'},
	// エイリアス
	Xstr : {f : 'h', j : 'z', l : 'r'},
	key_is : function(key, str) {
		if (!key || !str) {return false;}
		key = String.fromCharCode(key).toLowerCase();
		str = ER_sub.STR.toHan(str[0]).toLowerCase();
		if ( key == str ) { return true;}
		if ( this.Xstr[key] != undefined ) { key = this.Xstr[key];}
		if ( this.Astr[key] != undefined && this.Astr[key].indexOf(str) > -1 ){ return true;}
		if ( this.Kstr[key] != undefined && this.Kstr[key].indexOf(str) > -1 ){ return true;}
	},
	selectAssist : function(tg, attr){
		if (!tg) { tg = 'select';}
		attr = attr || 'html';
		switch (attr.toLowerCase()) {
		case 'value':
			keyFn = function(t){return $(t).val();};break;
		case 'accesskey':
			keyFn = function(t){return $(t).attr('accesskey');};break;
		case 'html':
			keyFn = function(t){return $(t).html();};break;
		case 'text':
			keyFn = function(t){return $(t).text();};break;
		default:
			keyFn = function(t){return $(t).attr(attr);};break;
		}
		$(tg).each(function(){
			var $tg = $(this);
			$tg.focus(function(){
				$tg .bind('keydown', (function(ev){
					if (ER_sub.STR.Hstr.indexOf(String.fromCharCode(ev.keyCode)) < 0) {
						return ;
					}
					var S = L = $tg.find('option:selected'),
					select, i=0,iMax=$tg.find('option:enabled').length;
					while (!select) {
						if ( ev.shiftKey ){
							if (S.prevAll('option:enabled').length == 0) {
								S = $tg.find('option:enabled:last');
							} else {
								S = S.prevAll('option:enabled:first');
							}
						} else {
							if (S.nextAll('option:enabled').length == 0) {
								S = $tg.find('option:enabled:first');
							} else {
								S = S.nextAll('option:enabled:first');
							}
						}
						if ( ER_sub.FRM.key_is(ev.keyCode, keyFn(S)) && !S.attr('disabled')){
							select = S;
						} else {
							i++;
							if ( i == iMax -1 ) {
								select = L;
							}
						}
					}
					$tg.val(select.val());
				}));
			}).blur(function(){
				$tg .unbind('keydown');
			});
		});
	}
}

ER_sub.STR ={
	Zstr : '０１２３４５６７８９ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ',
	Hstr : '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
	toHan : function (str) {
		var i,iMax,T,N='';
		for (i = 0, iMax = str.length; i < iMax; i++) {
			T = this.Zstr.indexOf(str[i]);
			if (T > -1) { N += this.Hstr[T];
			} else { N += str[i];}
		}
		return N;
	}
}

$(document).ready(function () {
	if ($('select[name=type]').length == 1 &&
		$('select[name=station]').length == 1){
		ER_sub.FRM.selectAssist();
		var $st_tg = $('select[name=station]');
		$('select[name=type]').change(function(){
//			for IE
//				require jQuery 1.4
//				$st_tg.find('option:disabled').unwrap();
				$st_tg.find('>div').each(
					function(){$(this).after($(this).html());}
				);
				$st_tg.find('>div').remove();
			if ($(this).val() == '*') {
				$st_tg.find('option').removeAttr('disabled').removeClass('disabled');
			} else {
				$st_tg.find('option[value!=0]').attr('disabled', 'disabled').addClass('disabled');
				$st_tg.find('option.'+$(this).val()).removeAttr('disabled').removeClass('disabled');
//				for IE
					$st_tg.find('option:disabled').wrap('<div style="display:none"/>');
				if (!$st_tg.find(':selected').hasClass($(this).val())) {
					$st_tg.val('0');
				}
			}
		});
	}
});

