<?php
session_start();

$err_msg = "";
$page_msg = "";

if($_SESSION['user_id'] != 0 && $_SESSION['user_id'] != "" && $_SESSION['user_id'] != NULL){
    $now_user_id = $_SESSION['user_id'];
    $user_flg    = 1;
}else{
    $now_user_id = session_id();
    $user_flg    = 2;
}

//設定用ファイル読み込み
require 'set/setting.php';
require 'set/user_set.php';
require 'set/cart_set.php';

$mode =  $_POST["mode"];
switch($mode){
    case "sendmail":
        sendmail();
    break;
}

//メール送信
function sendmail(){
    $err_msg = "";

    //文字コードセット
    mb_language("japanese");
    mb_internal_encoding("UTF-8");

    $user_name = $_POST["name"];
    $user_mail = $_POST["mail"];
    $user_subject = $_POST["subject"];
    $user_other = $_POST["other"];

    if(empty($user_name)){
        $err_msg .= "お名前は必須です。<br />";
    }else{
        $user_name        = htmlspecialchars($user_name);
        $user_name        = trim($user_name);
    }

    if(empty($user_mail)){
        $err_msg .= "メールアドレスは必須です。<br />";
    }else{
        $user_mail        = htmlspecialchars($user_mail);
        $user_mail        = trim($user_mail);
    }

    if(empty($user_subject)){
        $err_msg .= "ご用件は必須です。<br />\n";
    }else{
        $user_subject        = htmlspecialchars($user_subject);
        $user_subject        = trim($user_subject);
    }

    if(empty($user_other)){
        $err_msg .= "本文は必須です。<br />\n";
    }else{
        $user_other        = htmlspecialchars($user_other);
        $user_other        = trim($user_other);
    }

    if($err_msg != NULL){
        $GLOBALS['move_page']    = "contact.php";
        $GLOBALS['page_msg']     = "<p class='err_p'>エラー：<br />".$err_msg."</p>";
        $GLOBALS['page_seconds'] = 2;
        $GLOBALS['page_title'] = "送信エラー：入力エラー";
    }else{
        send_act($user_name,$user_mail,$user_subject,$user_other);
    }
}


function send_act($user_name,$user_mail,$user_subject,$user_other){
    //文字コードセット
    mb_language("japanese");
    mb_internal_encoding("UTF-8");


    $user_other = htmlspecialchars($user_other);
    $user_other = str_replace("\t", "&nbsp;", $user_other);
    $user_other = str_replace("\n", "<br/>", $user_other);
    $user_other = str_replace("\r", "", $user_other);
    $user_other = preg_replace('#(http?://[a-zA-Z0-9\;\:\&\_\.\?\/\#\%\&\=\-\+\~\@]+)#',
        '<a href="$1">$1</a>', $user_other);

    $date = date("Y/m/d-H:i:s");   

    //入力者のメールアドレス
    $from = $user_mail;
    $reply_to = $user_mail;
    
    //HP管理者アドレス
    $to       = 'komachangogo@hotmail.co.jp';
    
    $header   =  "From：{$from}\n";
    $header   .= "Replay-To：{$reply_to}\n";
    $header   .= "X-Mailer：myphpmail".phpversion()."\n";

    //本文など
    $message_send = "[お名前]：{$user_name}\n";
    $message["name"] = "[お名前]：<strong>{$user_name}</strong>\n";
    
    $message_send .= "[メール]：{$user_mail}\n";   
    $message["mail"] = "[メール]：<strong>{$user_mail}</strong>\n";

    $message_send .= "[件名]：{$user_subject}\n";    
    $message["subject"] = "[件名]：<strong>{$user_subject}</strong>\n";  

    $message_send .= "[内容]：{$user_other}\n";    
    $message["ohter"] = "[内容]：<strong>{$user_other}</strong>\n";
    
    $message_send .= "[日付]：{$date}\n";
    $message["date"] = "[日付]：<strong>{$date}</strong>\n";

    $mail_re = mb_send_mail($to,$user_subject,$message_send,"From:".$from);

    if($mail_re == TRUE){
        $page_msg = "<div style='text-align:left;'>";
        $page_msg .= "以下の内容で送信しました。<br />\n";
        foreach($message as $value){
            $page_msg .= $value."<br />\n";
        }
        $page_msg .= "</div>";
        $GLOBALS['move_page']    = "contact.php";
        $GLOBALS['page_msg'] = $page_msg;
        $GLOBALS['page_seconds'] = 5;
        $GLOBALS['page_title'] = "メール送信";
    }else{
        $GLOBALS['move_page']    = "contact.php";
        $GLOBALS['page_msg'] = "<p class='err_p'>メール送信できませんでした。</p>";
        $GLOBALS['page_seconds'] = 3;
        $GLOBALS['page_title'] = "送信エラー：システムエラー";
    }
}


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<?php
echo "<meta http-equiv='refresh' content='{$page_seconds}; url={$move_page}'>\n";
echo "<title>{$site_name}-{$page_title}</title>\n";
?>
</head>
<link href="css/main.css" rel="stylesheet" type="text/css" />
<body>
<div class='action_msg_block'>
<?php
echo <<< _ACTION_PAGE_
{$page_msg}
<p>自動でページが戻らない場合→<a href='{$move_page}'>こちら</a></p>

_ACTION_PAGE_;
?>
</div>
</body>
</html>