<?php
session_start();

//設定ファイル読み込み
require 'set/setting.php';
require 'set/user_set.php';
require 'set/user_info_set.php';

//初期化
$show_content = "";
$show_menu = "";
$show_name = "";

//ユーザー判断
if($_SESSION['user_id'] != 0 && $_SESSION['user_id'] != "" && $_SESSION['user_id'] != NULL){
    $show_name = "<p>ようこそ <strong>{$user_data_user_name}({$user_data_user_h_name})</strong> さん</p>\n";
}else{
    $show_name = "<p>ログインしてください。</p>\n";
    $show_name .= <<< _LOGIN_REQUEST_
    <script type='text/javascript'>;
    <!--//\n
    alert('ログインしてください。');
    //-->
    </script>
_LOGIN_REQUEST_;
}

//メインメニュー
function get_menu(){
    global $user_data_user_name,$user_data_user_h_name;
    $show_menu = <<< _SHOW_MENU_
    <div class='main_menu_title'>メインメニュー</div>
    <div class='main_menu_body'>
        <p><a href='scedule.php'>カレンダー</a></p>
        <p><a href='?mode=create_scedule'>スケジュール登録</a></p>
        <p><a href='?mode=scedule_history'>スケジュール履歴</a></p>
        <!--<p><a href='?mode=user_info'>ユーザー情報</a></p>-->
    </div>
    <div class='main_menu_title'>ログイン</div>
    <div class='main_menu_body'>
    <form method='POST' action='act.php'>
        <input type='text' name='user_h_name' style='ime-mode:disabled;' size='15'><br />
        <input type='password' name='pass' style='ime-mode:disabled;' size='15'><br />
        <input type='hidden' name='place' value='main'>
        <input type='hidden' name='act_mode' value='login'>  
        <input type='submit' value='ログイン'>  
    </form>
_SHOW_MENU_;

if($_SESSION['user_id'] != 0 || $_SESSION['user_id'] != "" || $_SESSION['user_id'] != NULL){
$show_menu .= <<< _SHOW_MENU_
<form method='POST' action='act.php'>
    <input type='hidden' name='act_mode' value='logout'>  
    <input type='submit' value='ログアウト'>  
</form>
_SHOW_MENU_;

}
    $show_menu .= "</div>";

    $GLOBALS['show_menu'] = $show_menu;
}


//スケジュール登録
function create_scedule(){

    //初期化
    $show_content = "";
    $scedule_divs = "";
    $scedule_y    = "";
    $scedule_m    = "";
    $scedule_d    = "";
    $scedule_from_time = "";
    $scedule_to_time = "";

    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_div`";
    $scedule_div_rs = mysql_query($str_sql,$db);
    while($scedule_div_data = mysql_fetch_assoc($scedule_div_rs)){
        $division_id   = $scedule_div_data['division_id'];
        $division_name = $scedule_div_data['division_name'];
        $scedule_divs .= <<< _DIVS_SET_
            <option value='$division_id'>$division_name</option>

_DIVS_SET_;
    }

    $select_y = date("Y");
    $select_m = date("m");
    $select_d = date("d");
    for($y_i = $select_y ; $y_i <= SCEDULE_YEAR_LIMIT ;$y_i++){
        $y_i = sprintf("%04d",$y_i);
        if($y_i == $select_y){
            $scedule_y .= "<option value='{$y_i}' selected>{$y_i}</option>\n";
        }else{
            $scedule_y .= "<option value='{$y_i}'>{$y_i}</option>\n";
        }
    }

    for($m_i = 01 ; $m_i <= 12 ;$m_i++){
        $m_i = sprintf("%02d",$m_i);
        if($m_i == $select_m){
            $scedule_m .= "<option value='{$m_i}' selected>{$m_i}</option>\n";
        }else{
            $scedule_m .= "<option value='{$m_i}'>{$m_i}</option>\n";
        }
    }

    for($d_i = 01 ; $d_i <= 31 ;$d_i++){
        $d_i = sprintf("%02d",$d_i);
        if($d_i == $select_d){
            $scedule_d .= "<option value='{$d_i}' selected>{$d_i}</option>\n";
        }else{
            $scedule_d .= "<option value='{$d_i}'>{$d_i}</option>\n";
        }
    }
    
    $scedule_from_time .= "<option value='0' selected>未定</option>";
    $scedule_to_time .= "<option value='0' selected>未定</option>";

    for($t_i = 01 ; $t_i <= 24 ;$t_i++){
        $t_i = sprintf("%02d",$t_i);
        $scedule_from_time .= "<option value='{$t_i}'>{$t_i}:00</option>\n";
        $scedule_to_time .= "<option value='{$t_i}'>{$t_i}:00</option>\n";
    }
    $scedule_to_time .= "<option value='last'>終日</option>";
    
    $show_content = <<< _SHOW_CONTENT_
    <form method='POST' action='act.php'>
        <table class='creat_table'>
            <tr>
                <td width='180'>
                    スケジュールタイトル
                </td>
                <td width='500'>
                    <input type='text' name='title' size='40' maxlength='20'> (20字以内)
                </td>
            </tr>
            <tr>
                <td width='180'>
                    スケジュール区分
                </td>
                <td width='500'>
                    <select name='select_div'>
                        $scedule_divs
                    </select>
                </td>
            </tr>
            <tr>
                <td width='180'>
                    スケジュール実施日時
                </td>
                <td width='500'>
                    <select name='select_y_from'>
                        $scedule_y
                    </select>年
                    <select name='select_m_from'>
                        $scedule_m
                    </select>月
                    <select name='select_d_from'>
                        $scedule_d
                    </select>日
                    <select name='from_time'>
                        $scedule_from_time
                    </select><br />
                    ～
                    <select name='select_y_to'>
                        $scedule_y
                    </select>年
                    <select name='select_m_to'>
                        $scedule_m
                    </select>月
                    <select name='select_d_to'>
                        $scedule_d
                    </select>日
                    <select name='to_time'>
                        $scedule_to_time
                    </select>
                </td>
            </tr>
            <tr>
                <td width='180'>
                    詳細内容
                </td>
                <td width='500'>
                    <textarea name='scedule_body' rows='5' cols='55' /></textarea>
                </td>
            </tr>
            <tr>
                <td colspan='2'>
                    <div style='text-align:right;'>上記内容で
                        <input type='hidden' name='act_mode' value='create_scedule'/>
                        <input type='submit' value='登録'/>
                    </div>
                </td>
            </tr>
        </table>
    </form>

_SHOW_CONTENT_;
    $GLOBALS['page_title'] = "スケジュール登録";
    $GLOBALS['show_content'] = $show_content;
}

//カレンダー表示
function show_top(){
    global $user_data_level,$user_data_dirthday;
    
    $show_content = "";
    $show_icon = "";    

    $year = isset($_GET['y']) ? $_GET['y'] : date("Y");
    if($_GET['y']==""){
        $year = date("Y");
    }
    $month = isset($_GET['m']) ? $_GET['m'] : date("m");
    if($_GET['m']==""){
        $month = date("m");
    }
    $days = isset($_GET['d']) ? $_GET['d'] : date("d");
    if($_GET['d']==""){
        $days = date("d");
    }
    $prev = mktime(0,0,0,$month-1,1,$year);
    $prev_m = date("m",$prev);
    $prev_y = date("Y",$prev);

    $next = mktime(0,0,0,$month+1,1,$year);
    $next_m = date("m",$next);
    $next_y = date("Y",$next);

    $h24 = 24 * 60 * 60;
    $cur = mktime(0,0,0,$month,1,$year);
    $week = date("w",$cur);
    $cur -= ($week * $h24);

    $show_icon .= "<p style='font-size:10px;'>";
    $show_icon .= <<< _ICON_
        <span style='color:#99ff66;'>■</span>－本日&nbsp;&nbsp;<span style='color:#ffcccc;'>■</span>－日曜日&nbsp;&nbsp;<span style='color:#ccffff;'>■</span>－土曜日&nbsp;&nbsp;
_ICON_;

    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_div`";
    $scedule_div_rs = mysql_query($str_sql,$db);
    while($scedule_div_data = mysql_fetch_assoc($scedule_div_rs)){
        $division_id   = $scedule_div_data['division_id'];
        $division_name = $scedule_div_data['division_name'];
        $division_image = $scedule_div_data['division_icon'];
        $show_icon .= <<< _DIVS_SET_
            <img src='$division_image' align='middle'>－$division_name&nbsp;&nbsp;
_DIVS_SET_;
    }
    $show_icon .= "</p>";

    $show_content .= "<div id='calender_body'>\n{$show_icon}\n";

    $show_content .= "<p style='font-size:15px;font-weight:bolder;'>
<a href='?y={$prev_y}&m={$prev_m}'>←前の月</a>&nbsp;[{$year}年{$month}月のスケジュール]&nbsp;<a href='?y={$next_y}&m={$next_m}'>次の月→</a></p>\n";

    $calender_td_width = floor(670 / 7);
//曜日部分
    $show_content .= <<< _WEEK_TITLE_
    <table border='1' id='calender_table' style='background-color:#ffffff;'>
        <tr align='center'>
            <td width='$calender_td_width' style='background-color:#ffcccc;'>日</td>
            <td width='$calender_td_width'>月</td>
            <td width='$calender_td_width'>火</td>
            <td width='$calender_td_width'>水</td>
            <td width='$calender_td_width'>木</td>
            <td width='$calender_td_width'>金</td>
            <td width='$calender_td_width' style='background-color:#ccffff;'>土</td>
        </tr>

_WEEK_TITLE_;

    for($i = 0;$i < 42;$i++){
	    if($i % 7 == 0){
		    $show_content .= "<tr align='center' valign='top'>\n";
	    }

	    $year_n = date("Y");
	    $month_n = date("m");
	    $day_n = date("d");

	    $mon  = date("m",$cur);
	    $day  = date("d",$cur);
	    if($month != $mon){
		    $day = "&nbsp;";
	    }
	    $day_b = $day;
	    $cur += $h24;
	    
		//本日日付
	    if($year == $year_n && $month == $month_n && $day == $day_n){
		    $week_bgcolor = "style='background-color:#99ff66'";
		}elseif($i % 7 == 0){
		    $week_bgcolor = "style='background-color:#ffcccc'";
	    }elseif($i % 7 == 6){
		    $week_bgcolor = "style='background-color:#ccffff'";
	    }else{
            $week_bgcolor = ""; 	
	    }
        $day  = "{$day}<br />\n";
        require 'set/db_connect.php';
        switch($user_data_level){
            case 1:
                $str_sql = "SELECT * FROM `scedule_tbl`";
            break;
            case 2:
                $str_sql = "SELECT * FROM `scedule_tbl` WHERE `user_id`={$_SESSION['user_id']} OR `division`='5'";
            break;
        }

        $scedule_data_rs = mysql_query($str_sql,$db);
        while($scedule_data = mysql_fetch_assoc($scedule_data_rs)){
            $scedule_id         = $scedule_data['id'];
            $scedule_from_time  = $scedule_data['from_time'];
            $scedule_to_time    = $scedule_data['to_time'];
            $scedule_title      = $scedule_data['title'];
            $scedule_division   = $scedule_data['division'];
            $scedule_del_flg   = $scedule_data['del_flg'];
            $scedule_from_time = explode("/",$scedule_from_time);
            $scedule_to_time = explode("/",$scedule_to_time);

            //スケジュールセット
            if($scedule_del_flg != 1){
                //同年同月同日
                if($scedule_from_time[0] == $scedule_to_time[0] && $scedule_from_time[1] == $scedule_to_time[1] && $scedule_from_time[2] == $scedule_to_time[2]){
                    if($scedule_from_time[0] == $year && $scedule_from_time[1] == $mon && $scedule_from_time[2] == $day_b){
                        require 'set/db_connect.php';
                        $str_sql = "SELECT * FROM `scedule_div` WHERE `division_id`={$scedule_division}";
                        $scedule_div_rs = mysql_query($str_sql,$db);
                        $scedule_div_data = mysql_fetch_assoc($scedule_div_rs);
                        $scedule_div_image = $scedule_div_data['division_icon'];

                        $scedule_title = substr($scedule_title, 0, 15)."...";

                        $day .= <<< _SCEDULE_SET_
            <span class='date'><a href='?mode=show_scedule&scedule_id=$scedule_id'><img src='$scedule_div_image' align='middle'>&nbsp;$scedule_title</a></span><br />
            
_SCEDULE_SET_;
                }
                //同年同月複数日
                }elseif($scedule_from_time[0] == $scedule_to_time[0] && $scedule_from_time[1] == $scedule_to_time[1] && $scedule_from_time[2] < $scedule_to_time[2]){
                    if($scedule_from_time[0] == $year && $scedule_from_time[1] == $mon && $scedule_from_time[2] <= $day_b && $scedule_to_time[2] >= $day_b){
                        require 'set/db_connect.php';
                        $str_sql = "SELECT * FROM `scedule_div` WHERE `division_id`={$scedule_division}";
                        $scedule_div_rs = mysql_query($str_sql,$db);
                        $scedule_div_data = mysql_fetch_assoc($scedule_div_rs);
                        $scedule_div_image = $scedule_div_data['division_icon'];

                        $scedule_title = substr($scedule_title, 0, 15)."...";

                        $day .= <<< _SCEDULE_SET_
            <span class='date'><a href='?mode=show_scedule&scedule_id=$scedule_id'><img src='$scedule_div_image' align='middle'>&nbsp;$scedule_title</a></span><br />
            
_SCEDULE_SET_;
                    }
                //同年複数月複数日
                }elseif($scedule_from_time[0] == $scedule_to_time[0] && $scedule_from_time[1] < $scedule_to_time[1]){
                    if($scedule_from_time[0] == $year && $scedule_from_time[1] <= $mon && $scedule_to_time[1] >= $mon && $scedule_from_time[2] >= $day_b && $scedule_to_time[2] <= $day_b){
                        require 'set/db_connect.php';
                        $str_sql = "SELECT * FROM `scedule_div` WHERE `division_id`={$scedule_division}";
                        $scedule_div_rs = mysql_query($str_sql,$db);
                        $scedule_div_data = mysql_fetch_assoc($scedule_div_rs);
                        $scedule_div_image = $scedule_div_data['division_icon'];

                        $scedule_title = substr($scedule_title, 0, 15)."...";

                        $day .= <<< _SCEDULE_SET_
            <span class='date'><a href='?mode=show_scedule&scedule_id=$scedule_id'><img src='$scedule_div_image' align='middle'>&nbsp;$scedule_title</a></span><br />
            
_SCEDULE_SET_;
                    }
                }
            }
        }

        require 'set/db_connect.php';
        switch($user_data_level){
            case 1:
                $str_sql = "SELECT * FROM `user`";
            break;
            case 2:
                $str_sql = "SELECT * FROM `user` WHERE `user_id`={$_SESSION['user_id']}";
            break;
        }
        $user_data_rs = mysql_query($str_sql,$db);
        while($user_data = mysql_fetch_assoc($user_data_rs)){
            $birth_user_h_name = $user_data['h_name'];
            $birth_user_birthday = $user_data['birthday'];
            $birth_user_birthday = explode("/",$birth_user_birthday);
            if($year >= $birth_user_birthday[0] && $mon == $birth_user_birthday[1] && $day_b == $birth_user_birthday[2]){
                $day .= "<span class='date'><img src='images/div_icon_02.gif' align='middle'>&nbsp;{$birth_user_h_name}さんの誕生日</span>";
            }
        }

	    $show_content .= "<td height='80' width='{$calender_td_width}' {$week_bgcolor}>{$day}</td>\n";
	    if($i % 7 == 6){
		    $show_content .= "</tr>\n";
	    }
	    
    }

    $show_content .= "</table>\n";

    $show_content .= $show_icon;
    
    $show_content .= "\n</div>\n";

    $GLOBALS['show_content'] = $show_content;
    $GLOBALS['page_title'] = "トップ";
}

function show_scedule(){
    global $user_data_level;
    $show_content = "";

    $scedule_id = $_GET['scedule_id'];
    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_tbl` WHERE `id`={$scedule_id}";
    $show_scedule_data_rs = mysql_query($str_sql,$db);
    $show_scedule_data = mysql_fetch_assoc($show_scedule_data_rs);

    $show_scedule_id = $show_scedule_data[SCEDULE_ID];
    $show_scedule_user_id = $show_scedule_data[SCEDULE_USER_ID];

    $show_scedule_from_time = $show_scedule_data[SCEDULE_FROM_TIME];
    $show_scedule_to_time = $show_scedule_data[SCEDULE_TO_TIME];
    $show_scedule_from_time = explode("/",$show_scedule_from_time);
    $show_scedule_to_time = explode("/",$show_scedule_to_time);
    
    switch($show_scedule_from_time[3]){
        case 0:
            $show_scedule_from_time[3] = "未定";
        break;
        default:
            $show_scedule_from_time[3] = "{$show_scedule_from_time[3]}:00"; 
    }

    switch($show_scedule_to_time[3]){
        case 0:
            $show_scedule_to_time[3] = "未定";
        break;
        case 5:
            $show_scedule_to_time[3] = "終日";
        break;
        default:
            $show_scedule_to_time[3] = "{$show_scedule_to_time[3]}:00"; 
    }
    
    $show_scedule_act_date = "{$show_scedule_from_time[0]}/{$show_scedule_from_time[1]}/{$show_scedule_from_time[2]}&nbsp;{$show_scedule_from_time[3]}&nbsp;～&nbsp;{$show_scedule_to_time[0]}/{$show_scedule_to_time[1]}/{$show_scedule_to_time[2]}&nbsp;{$show_scedule_to_time[3]}";
    
    $show_scedule_div = $show_scedule_data[SCEDULE_DIVISION];
    $show_scedule_title = $show_scedule_data[SCEDULE_TITLE];
    $show_scedule_body = $show_scedule_data[SCEDULE_BODY];
    $show_scedule_date = $show_scedule_data[SCEDULE_DATE];
    $show_scedule_update = $show_scedule_data[SCEDULE_UPDATE];

    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_div` WHERE `division_id`={$show_scedule_div};";
    $show_scedule_div_rs = mysql_query($str_sql,$db);
    $show_scedule_div_data = mysql_fetch_assoc($show_scedule_div_rs);

    $show_scedule_div_name = $show_scedule_div_data['division_name'];
    $show_scedule_div_image = $show_scedule_div_data['division_icon'];


    if($show_scedule_div == 5 || $user_data_level == 1){
        require 'set/db_connect.php';
        $str_sql = "SELECT * FROM `user` WHERE `user_id`={$show_scedule_user_id};";
        $show_scedule_user_rs = mysql_query($str_sql,$db);
        $show_scedule_user_data = mysql_fetch_assoc($show_scedule_user_rs);
        $show_scedule_user_h_name = $show_scedule_user_data['h_name'];
        $scedule_author = "スケジュール作成者：{$show_scedule_user_h_name}<br />\n";
    }

    $show_content .= <<< _SHOW_SCEDULE_
    <p>
        $scedule_author
        スケジュールタイトル：$show_scedule_title <br />
        スケジュール区分：<img src='$show_scedule_div_image' align='middle'>&nbsp;$show_scedule_div_name <br />
        スケジュール実施日時：$show_scedule_act_date <br />
        詳細内容：$show_scedule_body <br />
        登録日：$show_scedule_date<br />
        更新日：$show_scedule_update<br />
    </p>
    <p>
        (<a href='?mode=edit_scedule&scedule_id=$show_scedule_id'>修正</a>)
    </p>

_SHOW_SCEDULE_;

    $GLOBALS['show_content'] = $show_content;
    $GLOBALS['page_title'] = "スケジュール詳細";
}


//スケジュール修正
function edit_scedule(){

    //初期化
    $show_content = "";
    $scedule_divs = "";
    $scedule_y    = "";
    $scedule_m    = "";
    $scedule_d    = "";
    $scedule_from_time = "";
    $scedule_to_time = "";


    $edit_scedule_id = $_GET['scedule_id'];
    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_tbl` WHERE `id`={$edit_scedule_id}";
    $edit_scedule_data_rs = mysql_query($str_sql,$db);
    $edit_scedule_data = mysql_fetch_assoc($edit_scedule_data_rs);

    $edit_scedule_id = $edit_scedule_data[SCEDULE_ID];
    $edit_scedule_user_id = $edit_scedule_data[SCEDULE_USER_ID];

    $edit_scedule_from_time = $edit_scedule_data[SCEDULE_FROM_TIME];
    $edit_scedule_to_time = $edit_scedule_data[SCEDULE_TO_TIME];
    $edit_scedule_from_time = explode("/",$edit_scedule_from_time);
    $edit_scedule_to_time = explode("/",$edit_scedule_to_time);
    
    $edit_scedule_div = $edit_scedule_data[SCEDULE_DIVISION];
    $edit_scedule_title = $edit_scedule_data[SCEDULE_TITLE];
    $edit_scedule_body = $edit_scedule_data[SCEDULE_BODY];
    $edit_scedule_date = $edit_scedule_data[SCEDULE_DATE];
    $edit_scedule_update = $edit_scedule_data[SCEDULE_UPDATE];

    require 'set/db_connect.php';
    $str_sql = "SELECT * FROM `scedule_div`";
    $scedule_div_rs = mysql_query($str_sql,$db);
    while($scedule_div_data = mysql_fetch_assoc($scedule_div_rs)){
        $division_id   = $scedule_div_data['division_id'];
        $division_name = $scedule_div_data['division_name'];
        if($division_id == $edit_scedule_div){
        $scedule_divs .= <<< _DIVS_SET_
            <option value='$division_id' selected>$division_name</option>

_DIVS_SET_;
        }else{
        $scedule_divs .= <<< _DIVS_SET_
            <option value='$division_id'>$division_name</option>

_DIVS_SET_;
        }
    }


    for($y_i = $edit_scedule_from_time[0] ; $y_i <= SCEDULE_YEAR_LIMIT ;$y_i++){
        $y_i = sprintf("%04d",$y_i);
        if($y_i == $edit_scedule_from_time[0]){
            $scedule_from_y .= "<option value='{$y_i}' selected>{$y_i}</option>\n";
        }else{
            $scedule_from_y .= "<option value='{$y_i}'>{$y_i}</option>\n";
        }
    }

    for($y_i = $edit_scedule_to_time[0] ; $y_i <= SCEDULE_YEAR_LIMIT ;$y_i++){
        $y_i = sprintf("%04d",$y_i);
        if($y_i == $edit_scedule_to_time[0]){
            $scedule_to_y .= "<option value='{$y_i}' selected>{$y_i}</option>\n";
        }else{
            $scedule_to_y .= "<option value='{$y_i}'>{$y_i}</option>\n";
        }
    }

    for($m_i = 01 ; $m_i <= 12 ;$m_i++){
        $m_i = sprintf("%02d",$m_i);
        if($m_i == $edit_scedule_from_time[1]){
            $scedule_from_m .= "<option value='{$m_i}' selected>{$m_i}</option>\n";
        }else{
            $scedule_from_m .= "<option value='{$m_i}'>{$m_i}</option>\n";
        }
    }

    for($m_i = 01 ; $m_i <= 12 ;$m_i++){
        $m_i = sprintf("%02d",$m_i);
        if($m_i == $edit_scedule_to_time[1]){
            $scedule_to_m .= "<option value='{$m_i}' selected>{$m_i}</option>\n";
        }else{
            $scedule_to_m .= "<option value='{$m_i}'>{$m_i}</option>\n";
        }
    }

    for($d_i = 01 ; $d_i <= 31 ;$d_i++){
        $d_i = sprintf("%02d",$d_i);
        if($d_i == $edit_scedule_from_time[2]){
            $scedule_from_d .= "<option value='{$d_i}' selected>{$d_i}</option>\n";
        }else{
            $scedule_from_d .= "<option value='{$d_i}'>{$d_i}</option>\n";
        }
    }

    for($d_i = 01 ; $d_i <= 31 ;$d_i++){
        $d_i = sprintf("%02d",$d_i);
        if($d_i == $edit_scedule_to_time[2]){
            $scedule_to_d .= "<option value='{$d_i}' selected>{$d_i}</option>\n";
        }else{
            $scedule_to_d .= "<option value='{$d_i}'>{$d_i}</option>\n";
        }
    }

    for($t_i = 01 ; $t_i <= 24 ;$t_i++){
        $t_i = sprintf("%02d",$t_i);
        if($edit_scedule_from_time[3] == 0){
            $scedule_from_time .= "<option value='0' selected>未定</option>";
        }elseif($edit_scedule_from_time[3] == $t_i){
            $scedule_from_time .= "<option value='{$t_i}' selected>{$t_i}:00</option>\n";
        }else{
            $scedule_from_time .= "<option value='{$t_i}'>{$t_i}:00</option>\n";
        }
    }

    for($t_i = 01 ; $t_i <= 24 ;$t_i++){
        $t_i = sprintf("%02d",$t_i);
        if($edit_scedule_to_time[3] == 0){
            $scedule_to_time .= "<option value='0' selected>未定</option>";
        }elseif($edit_scedule_to_time[3] == "last"){
            $scedule_to_time .= "<option value='last' selected>終日</option>";
        }elseif($edit_scedule_to_time[3] == $t_i){
            $scedule_to_time .= "<option value='{$t_i}' selected>{$t_i}:00</option>\n";
        }else{
            $scedule_to_time .= "<option value='{$t_i}'>{$t_i}:00</option>\n";
        }
    }
    
    $show_content = <<< _SHOW_CONTENT_
    <form method='POST' action='act.php'>
        <table class='creat_table'>
            <tr>
                <td width='180'>
                    スケジュールタイトル
                </td>
                <td width='500'>
                    <input type='text' name='title' value='$edit_scedule_title' size='40' maxlength='20'> (20字以内)
                </td>
            </tr>
            <tr>
                <td width='180'>
                    スケジュール区分
                </td>
                <td width='500'>
                    <select name='select_div'>
                        $scedule_divs
                    </select>
                </td>
            </tr>
            <tr>
                <td width='180'>
                    スケジュール実施日時
                </td>
                <td width='500'>
                    <select name='select_y_from'>
                        $scedule_from_y
                    </select>年
                    <select name='select_m_from'>
                        $scedule_from_m
                    </select>月
                    <select name='select_d_from'>
                        $scedule_from_d
                    </select>日
                    <select name='from_time'>
                        $scedule_from_time
                    </select><br />
                    ～
                    <select name='select_y_to'>
                        $scedule_to_y
                    </select>年
                    <select name='select_m_to'>
                        $scedule_to_m
                    </select>月
                    <select name='select_d_to'>
                        $scedule_to_d
                    </select>日
                    <select name='to_time'>
                        $scedule_to_time
                    </select>   
                </td>
            </tr>
            <tr>
                <td width='180'>
                    詳細内容
                </td>
                <td width='500'>
                    <textarea name='scedule_body' rows='5' cols='55' />$edit_scedule_body</textarea>
                </td>
            </tr>
            <tr>
                <td colspan='2'>
                    <div style='text-align:right;'>上記内容で
                        <input type='hidden' name='act_mode' value='edit_scedule'/>
                        <input type='hidden' name='scedule_id' value='$edit_scedule_id'/>
                        <input type='submit' value='修正'/>
                    </div>
                </td>
            </tr>
        </table>
    </form>
    <form method='POST' action='act.php'>
        <table class='creat_table'>
            <tr>
                <td colspan='2'>
                    <div style='text-align:right;'>上記スケジュールを
                        <input type='hidden' name='act_mode' value='del_scedule'/>
                        <input type='hidden' name='scedule_id' value='$edit_scedule_id'/>
                        <input type='submit' value='削除'/>
                    </div>
                </td>
            </tr>
        </table>
    </form>
    

_SHOW_CONTENT_;
    $GLOBALS['page_title'] = "スケジュール修正";
    $GLOBALS['show_content'] = $show_content;
}


//履歴
function scedule_history(){
    global $user_data_level;
    $history_i = "";
    $show_content = "";

    require 'set/db_connect.php';
    switch($user_data_level){
        case 1:
            $str_sql = "SELECT * FROM `scedule_tbl`";
        break;
        case 2:
            $str_sql = "SELECT * FROM `scedule_tbl` WHERE `user_id`={$_SESSION['user_id']}";
        break;
    }
    $scedule_history_data_rs = mysql_query($str_sql,$db);
    
    $history_i = 1;
    while($scedule_history_data = mysql_fetch_assoc($scedule_history_data_rs)){
        $scedule_history_id = $scedule_history_data[SCEDULE_ID];
        //$scedule_history_user_id = $scedule_history_data[SCEDULE_USER_ID];
        $scedule_history_title = $scedule_history_data[SCEDULE_TITLE];
        $scedule_history_from_time = $scedule_history_data[SCEDULE_FROM_TIME];
        $scedule_history_to_time = $scedule_history_data[SCEDULE_TO_TIME];
        $scedule_history_del_flg = $scedule_history_data[SCEDULE_DEL_FLG];
        $scedule_history_from_time = explode("/",$scedule_history_from_time);
        $scedule_history_to_time = explode("/",$scedule_history_to_time);
    
        switch($scedule_history_from_time[3]){
            case 0:
                $scedule_history_from_time[3] = "未定";
            break;
            default:
                $scedule_history_from_time[3] = "{$scedule_history_from_time[3]}:00"; 
        }

        switch($scedule_history_to_time[3]){
            case 0:
                $scedule_history_to_time[3] = "未定";
            break;
            case 5:
                $scedule_history_to_time[3] = "終日";
            break;
            default:
                $scedule_history_to_time[3] = "{$scedule_history_to_time[3]}:00"; 
        }
    
        $scedule_history_act_date = "{$scedule_history_from_time[0]}/{$scedule_history_from_time[1]}/{$scedule_history_from_time[2]}&nbsp;{$scedule_history_from_time[3]}&nbsp;～&nbsp;{$scedule_history_to_time[0]}/{$scedule_history_to_time[1]}/{$scedule_history_to_time[2]}&nbsp;{$scedule_history_to_time[3]}";
    
        $scedule_history_div = $scedule_history_data[SCEDULE_DIVISION];

        require 'set/db_connect.php';
        $str_sql = "SELECT * FROM `scedule_div` WHERE `division_id`={$scedule_history_div}";
        $scedule_history_div_rs = mysql_query($str_sql,$db);
        $scedule_history_div_data = mysql_fetch_assoc($scedule_history_div_rs);

        $show_scedule_div_image = $scedule_history_div_data['division_icon'];
        if($scedule_history_del_flg != 1){
            $show_content .= <<< _SHOW_HISTORY_
            $history_i&nbsp;:&nbsp;<a href='?mode=show_scedule&scedule_id=$scedule_history_id'><img src='$show_scedule_div_image' align='middle'>&nbsp;$scedule_history_title&nbsp;$scedule_history_act_date&nbsp;</a><br/>

_SHOW_HISTORY_;
            $history_i++;
        }
    }

    $GLOBALS['show_content'] = "<p>{$show_content}</p>\n";
    $GLOBALS['page_title'] = "スケジュール履歴";
}


function read_me(){

$show_content = <<< _READ_ME_
<p>
セッション管理機能付のスケジュールカレンダーです。<br />
スケジュールの登録、修正、削除ができます。<br />
基本的に自分が登録したスケジュールしか区分を選ぶ際に「共通」を選ぶと、<br />
全ユーザーに公開されます。今のところ修正もできます。そのうちさせないようにしますが。<br />
スーパーユーザー権限のユーザーは全スケジュールの閲覧・修正が可能です。あ、僕です（<br />
<br />
あと、ユーザー登録の際に誕生日入れるようになってますが、入れたら、自動的にカレンダーに反映されます。生年以前の年には入らないようになってます。<br />
<br />
で、スケジュール管理のページは登録ユーザーしか入れません。<br />
このページが見れてるってことはたぶん登録ユーザーだと思います。<br />
ログインしてない状態で入る時に「ログインしてください」ってメッセージがでて、<br />
その上にリンクはあるけど、ページは飛べないようにしてあります。<br />
<br />
アイコンは即興で作りました。スケジュールの区分もわりと適当ですが、<br />
要望があれば増やします。あと、アイコンは随時募集中です←<br />
<br />
Ver.1.0の段階でわかっているバグもいくつかありますが、一応、ちゃんと機能してるので、こっそり直します。結構、日にち絡めて計算するのって難しいんですよ＞＜<br />
<br />
今回のプログラムは覚えたてのセッションが本当に使えるのかっていうのをやってみた実験プログラム、要はサンプルみたいなものなので、実用レベルに達するにはもう少し時間がかかるかもしれません。<br />
<br />
いつものようにお持ち帰り用の圧縮ファイルは → <a href='../../DL/m_scedule.zip'>こちら</a> ←<br />
一応、ＤＢもついてます。Readmeつけていませんが、とりあえずsetフォルダのsetting内のDBの設定だとかを環境に合わせて変えてください。<br />
あとはindex.phpにブラウザからアクセスすればOKです。act.phpはあくまで追加、更新等の処理を行なうためだけの中継ページに過ぎません。<br />
<br />
デザインはしんぷるいずざべすとを目指しました（ｷﾘｯ <br />
更新履歴：<br />
2010年10月4日 Ver.1.0リリース

_READ_ME_;
    $GLOBALS['show_content'] = "<p>{$show_content}</p>\n";
    $GLOBALS['page_title'] = "色々使い方とか説明とか"; 
}


if($_SESSION['user_id'] == 0 || $_SESSION['user_id'] == "" || $_SESSION['user_id'] == NULL){
    $show_content .= "<p class='err_p'>".PAGE_CANT_ACCESS_ERR."</p>";
    $show_content .= "<meta http-equiv='refresh' content='3; url=index.php'>\n";
    $page_title = "ログインしてください";
    $show_menu  = "ログインしてください";
}else{
    get_menu();
    $mode = $_GET['mode'];
    switch($mode){
        case "create_scedule":
            create_scedule();
        break;
        case "show_scedule":
            show_scedule();
        break;
        case "edit_scedule":
            edit_scedule();
        break;
        case "scedule_history":
            scedule_history();
        break;
        case "read_me":
            read_me();
        break;
        default:
            show_top();
    }

}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<title>スケジュール管理</title></head>
<link href="css/main.css" rel="stylesheet" type="text/css" />

<body>
<a href="../../index.html">トップへ</a>
<div id='main'>
<?php
echo "\t<h1 id='scedule_header'><a href='scedule.php'>".SCEDULE_PAGE_TITLE."</a><br />\n";
echo "\t<span class='pagetitle'>─{$page_title}─</span></h1>\n";
echo $show_name;
echo "\t<p><a href='?mode=read_me'>いろいろ使い方とか解説とか</a></p>\n";
echo <<< _CONTENT_
<div id='menu'>
$show_menu
</div>
<div id='content'>
$show_content
</div>
_CONTENT_;
echo "\t<div id='footer'>".SCEDULE_FOOTER."</div>\n";
echo BACK_TOP;
?>
</div>

</body>
</html>