/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.io.IOException;
import java.io.InputStream;

public class BitReader {
    private byte[] buf = new byte[9];
    private InputStream is;
    private int rembits;
    private int remval;

    public BitReader(InputStream in) {
        this.is = in;
        this.remval = 0;
        this.rembits = 0;
    }

    public long readBit(int bits) throws IOException {
        if (bits > 63) {
            throw new IOException("bits too big: " + bits);
        }
        if (bits <= 0) {
            throw new IOException("bits must be positive: " + bits);
        }
        int n = (bits + 7 - this.rembits) / 8;
        if (n > 0) {
            int r = 0;
            int j = 0;
            while (j < n && (r = this.is.read(this.buf, j, n - j)) > 0) {
                j += r;
            }
        }
        long ret = this.remval;
        int i = 0;
        while (this.rembits < bits) {
            ret = (ret << 8) + (long)(this.buf[i++] & 0xFF);
            this.rembits += 8;
        }
        this.rembits -= bits;
        this.remval = (int)(ret & (long)((1 << this.rembits) - 1));
        return ret >>= this.rembits;
    }
}

