/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;

public class Stopwatch {
    private static Date startedDate = new Date();
    private static Date stopedDate = new Date();
    public static JLabel out = null;
    private static String FMT1 = "s\u79d2SSS\u30df\u30ea";
    private static String FMT2 = "m\u5206ss\u79d2SSS\u30df\u30ea";
    private static String FMT3 = "H\u6642\u9593mm\u5206ss\u79d2SSS\u30df\u30ea";
    private static long LONG_MINUIT = 60000L;
    private static long LONG_HOUR = 60L * LONG_MINUIT;

    public static void start() {
        startedDate = new Date();
    }

    public static void stop() {
        stopedDate = new Date();
    }

    public static void setup(JLabel display) {
        out = display;
    }

    private static boolean isSetup() {
        return out != null;
    }

    public static void clear() {
        if (Stopwatch.isSetup()) {
            out.setText(" ");
        }
    }

    public static long getStartTime() {
        return startedDate.getTime();
    }

    public static long getStopTime() {
        return stopedDate.getTime();
    }

    public static long getElapsedTime() {
        return new Date().getTime() - Stopwatch.getStartTime();
    }

    public static String format(long time) {
        Date date = new Date(time);
        if (time < 0L) {
            return "";
        }
        if (time < LONG_MINUIT) {
            return new SimpleDateFormat(FMT1).format(date);
        }
        if (time < LONG_HOUR) {
            return new SimpleDateFormat(FMT2).format(date);
        }
        return new SimpleDateFormat(FMT3).format(date);
    }

    public static String formatElapsedTime() {
        return Stopwatch.format(Stopwatch.getElapsedTime());
    }

    public static void show() {
        if (Stopwatch.isSetup()) {
            out.setText("\u7d4c\u904e\u6642\u9593\u3000" + Stopwatch.formatElapsedTime());
        }
    }

    public static String formatLatency() {
        return Stopwatch.format(Stopwatch.getStopTime() - Stopwatch.getStartTime());
    }
}

