/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.util.BitReader;
import saccubus.util.Cws2Fws;
import saccubus.util.Stopwatch;

public class FFmpeg {
    private final String exePath;
    private StringBuffer sb;
    private String LastFrame = "";
    private String LastError = "\u30a8\u30e9\u30fc\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";

    public FFmpeg(String path) {
        this.exePath = path.replace("\\", "/");
    }

    public void setCmd(String string) {
        this.sb = new StringBuffer();
        this.sb.append("\"");
        this.sb.append(this.exePath);
        this.sb.append("\" ");
        this.sb.append(string);
    }

    public void addCmd(String string) {
        this.sb.append(string);
    }

    public void addFile(File file) {
        String path = file.getPath().replace("\\", "/");
        if (path.indexOf(32) >= 0 || path.indexOf("\u3000") >= 0) {
            this.sb.append(" \"");
            this.sb.append(path);
            this.sb.append("\"");
        } else {
            this.sb.append(path);
        }
    }

    public String getCmd() {
        return this.sb.substring(0);
    }

    public int exec(int abortedCode, CallbackInterface callback) {
        this.LastError = "\u30a8\u30e9\u30fc\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";
        this.LastFrame = "";
        Process process = null;
        BufferedReader ebr = null;
        try {
            String e;
            process = Runtime.getRuntime().exec(this.getCmd());
            ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((e = ebr.readLine()) != null) {
                callback.doEveryLoop(e);
                Stopwatch.show();
                if (e.startsWith("frame=")) {
                    this.LastFrame = e;
                } else {
                    this.LastError = e;
                }
                if (!callback.checkStop()) continue;
                process.destroy();
                callback.doAbort(e);
                int n = abortedCode;
                return n;
            }
            process.waitFor();
            int n = process.exitValue();
            return n;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        finally {
            try {
                process.getErrorStream().close();
                ebr.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int exec(JLabel status, int abortedCode, ConvertStopFlag flag) {
        System.out.println("\n\n----\nProcessing FFmpeg...\n----\n\n");
        class FFmpegCallback
        implements CallbackInterface {
            private JLabel status;
            private ConvertStopFlag flag;

            public FFmpegCallback(JLabel status, ConvertStopFlag flag) {
                this.status = status;
                this.flag = flag;
            }

            @Override
            public boolean checkStop() {
                return this.flag.needStop();
            }

            @Override
            public void doAbort(String e) {
                this.status.setText("ffmpeg\u306e\u5b9f\u884c\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            }

            @Override
            public void doEveryLoop(String e) {
                if (e.startsWith("frame=")) {
                    this.status.setText(e);
                } else if (!e.endsWith("No accelerated colorspace conversion found")) {
                    System.out.println(e);
                }
            }
        }
        return this.exec(abortedCode, new FFmpegCallback(status, flag));
    }

    public String getLastFrame() {
        return this.LastFrame;
    }

    public String getLastError() {
        return this.LastError;
    }

    public Aspect getAspect(File videoFile, StringBuffer sb) {
        long height;
        long width;
        block19: {
            StringBuffer output = new StringBuffer();
            if (Cws2Fws.isFws(videoFile)) {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(videoFile);
                        BitReader br = new BitReader(fis);
                        int bit = (int)br.readBit(32);
                        bit = (int)br.readBit(32);
                        bit = (int)br.readBit(5);
                        width = br.readBit(bit);
                        width = br.readBit(bit);
                        width /= 20L;
                        height = br.readBit(bit);
                        height = br.readBit(bit);
                        height /= 20L;
                        break block19;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.setCmd("-y -i ");
            this.addFile(videoFile);
            System.out.println("get aspect: " + this.getCmd());
            class GetAspectCallback
            implements CallbackInterface {
                private final /* synthetic */ StringBuffer val$output;

                GetAspectCallback(StringBuffer stringBuffer) {
                    this.val$output = stringBuffer;
                }

                @Override
                public void doEveryLoop(String e) {
                    if (e.indexOf("Video") >= 0) {
                        System.out.println(e);
                        this.val$output.append(String.valueOf(e.trim()) + "\n");
                    }
                }

                @Override
                public boolean checkStop() {
                    return false;
                }

                @Override
                public void doAbort(String e) {
                }
            }
            int code = this.exec(-9, new GetAspectCallback(output));
            String src = output.toString();
            src = src.replaceAll("[^0-9x]", "_");
            String[] list = src.split("_+");
            src = "1x1";
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.indexOf(120) > 0) {
                    src = s;
                    break;
                }
                ++n2;
            }
            list = src.split("x");
            try {
                width = Long.parseLong(list[0]);
                height = Long.parseLong(list[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        sb.append("(" + width + "x" + height + ")");
        double aspect = (double)width / (double)height;
        sb.append(String.format("%.3f", aspect));
        System.out.println("width hight:" + width + "x" + height + ", aspect: " + String.format("%.3f", aspect));
        if (aspect > 1.7) {
            return Aspect.WIDE;
        }
        return Aspect.NORMAL;
    }

    public static enum Aspect {
        NORMAL,
        WIDE;

    }

    public static interface CallbackInterface {
        public void doEveryLoop(String var1);

        public boolean checkStop();

        public void doAbort(String var1);
    }
}

