/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.util.Stopwatch;

public class FFmpeg {
    private final String exePath;
    private StringBuffer sb;
    private String LastFrame = "";
    private String LastError = "\u30a8\u30e9\u30fc\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";

    public FFmpeg(String path) {
        this.exePath = path.replace("\\", "/");
    }

    public void setCmd(String string) {
        this.sb = new StringBuffer();
        this.sb.append("\"");
        this.sb.append(this.exePath);
        this.sb.append("\" ");
        this.sb.append(string);
    }

    public void addCmd(String string) {
        this.sb.append(string);
    }

    public void addFile(File file) {
        this.addQuote(file.getPath());
    }

    void addQuote(String string) {
        this.sb.append(" \"");
        this.sb.append(string.replace("\\", "/"));
        this.sb.append("\"");
    }

    public String getCmd() {
        return this.sb.substring(0);
    }

    public int exec(JLabel status, int abortedCode, ConvertStopFlag flag) {
        this.LastError = "\u30a8\u30e9\u30fc\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";
        this.LastFrame = "";
        Process process = null;
        BufferedReader ebr = null;
        try {
            String e;
            System.out.println("\n\n----\nProcessing FFmpeg...\n----\n\n");
            process = Runtime.getRuntime().exec(this.getCmd());
            ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((e = ebr.readLine()) != null) {
                if (e.startsWith("frame=")) {
                    status.setText(e);
                    this.LastFrame = e;
                    Stopwatch.show();
                } else {
                    this.LastError = e;
                    if (!e.endsWith("No accelerated colorspace conversion found")) {
                        System.out.println(e);
                    }
                }
                if (!flag.needStop()) continue;
                process.destroy();
                status.setText("\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
                int n = abortedCode;
                return n;
            }
            process.waitFor();
            int n = process.exitValue();
            return n;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        finally {
            try {
                process.getErrorStream().close();
                ebr.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getLastFrame() {
        return this.LastFrame;
    }

    public String getLastError() {
        return this.LastError;
    }
}

