/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.ConvertingSetting;
import saccubus.MyDateFormat;
import saccubus.conv.CombineXML;
import saccubus.conv.ConvertToVideoHook;
import saccubus.net.NicoClient;
import saccubus.util.Cws2Fws;

public class Converter
extends Thread {
    private ConvertingSetting Setting;
    private String Tag;
    private String VideoID;
    private String VideoTitle;
    private String Time;
    private JLabel Status;
    private final ConvertStopFlag StopFlag;
    private static final String TMP_COMMENT = "./vhook.tmp";
    private static final String TMP_OWNERCOMMENT = "./vhookowner.tmp";
    private static final String VIDEO_URL_PARSER = "http://www.nicovideo.jp/watch/";
    public static final String OWNER_EXT = "[Owner].xml";
    private static final String TMP_COMBINED_XML = "./tmp_comment.xml";
    private String OtherVideo;
    private File VideoFile = null;
    private File CommentFile = null;
    private File OwnerCommentFile = null;
    private File ConvertedVideoFile = null;
    private File CommentMiddleFile = null;
    private File OwnerMiddleFile = null;
    String LastError;
    private static final int CODE_CONVERTING_ABORTED = 100;
    private String ExtOption;
    private String InOption;
    private String OutOption;
    private String MainOption;
    private static final String TCOMMENT_EXT = ".txml";

    public Converter(String url, String time, ConvertingSetting setting, JLabel status, ConvertStopFlag flag) {
        int index;
        url = url.trim();
        this.Tag = url.startsWith(VIDEO_URL_PARSER) ? ((index = url.indexOf(63, VIDEO_URL_PARSER.length())) >= 0 ? url.substring(VIDEO_URL_PARSER.length(), index) : url.substring(VIDEO_URL_PARSER.length())) : url;
        this.VideoID = "[" + this.Tag + "]";
        this.Time = time;
        this.Setting = setting;
        this.Status = status;
        this.StopFlag = flag;
    }

    public File getVideoFile() {
        return this.VideoFile;
    }

    private void sendtext(String text) {
        this.Status.setText(text);
    }

    private boolean isSaveConverted() {
        return this.Setting.isSaveConverted();
    }

    private boolean isSaveVideo() {
        return this.Setting.isSaveVideo();
    }

    private boolean isSaveComment() {
        return this.Setting.isSaveComment();
    }

    private boolean isSaveOwnerComment() {
        return this.Setting.isSaveOwnerComment();
    }

    private boolean isConvertWithComment() {
        return this.Setting.isConvertWithComment();
    }

    private boolean isConvertWithOwnerComment() {
        return this.Setting.isConvertWithOwnerComment();
    }

    private boolean isVideoFixFileName() {
        return this.Setting.isVideoFixFileName();
    }

    private boolean isCommentFixFileName() {
        return this.Setting.isCommentFixFileName();
    }

    private String getProxy() {
        return this.Setting.getProxy();
    }

    private int getProxyPort() {
        return this.Setting.getProxyPort();
    }

    private String getMailAddress() {
        return this.Setting.getMailAddress();
    }

    private String getPassword() {
        return this.Setting.getPassword();
    }

    private boolean isDeleteVideoAfterConverting() {
        return this.Setting.isDeleteVideoAfterConverting();
    }

    private boolean isDeleteCommentAfterConverting() {
        return this.Setting.isDeleteCommentAfterConverting();
    }

    private boolean useProxy() {
        return this.Setting.useProxy();
    }

    private boolean checkOK() {
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u3057\u3066\u3044\u307e\u3059");
        if (!(this.isSaveConverted() || this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment())) {
            this.sendtext("\u4f55\u3082\u3059\u308b\u3053\u3068\u304c\u3042\u308a\u307e\u305b\u3093");
            return false;
        }
        if (this.isSaveConverted()) {
            File a = new File(this.Setting.getFFmpegPath());
            if (!a.canRead()) {
                this.sendtext("FFmpeg\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            if (this.Setting.getVhookPath().indexOf(32) >= 0) {
                this.sendtext("\u3059\u3044\u307e\u305b\u3093\u3002\u73fe\u5728vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u306b\u306f\u534a\u89d2\u7a7a\u767d\u306f\u4f7f\u3048\u307e\u305b\u3093\u3002");
                return false;
            }
            a = new File(this.Setting.getVhookPath());
            if (!a.canRead()) {
                this.sendtext("Vhook\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            a = new File(this.Setting.getFontPath());
            if (!a.canRead()) {
                this.sendtext("\u30d5\u30a9\u30f3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                return false;
            }
            if (!this.detectOption()) {
                this.sendtext("\u5909\u63db\u30aa\u30d7\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                return false;
            }
        } else {
            if (this.isDeleteVideoAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u52d5\u753b\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                return false;
            }
            if (this.isDeleteCommentAfterConverting()) {
                this.sendtext("\u5909\u63db\u3057\u306a\u3044\u306e\u306b\u3001\u30b3\u30e1\u30f3\u30c8\u524a\u9664\u3057\u3061\u3083\u3063\u3066\u826f\u3044\u3093\u3067\u3059\u304b\uff1f");
                return false;
            }
        }
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment()) {
            if (this.getMailAddress() == null || this.getMailAddress().equals("") || this.getPassword() == null || this.getPassword().equals("")) {
                this.sendtext("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304b\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u7a7a\u767d\u3067\u3059\u3002");
                return false;
            }
            if (this.useProxy() && (this.getProxy() == null || this.getProxy().length() <= 0 || this.getProxyPort() < 0 || this.getProxyPort() > 65535)) {
                this.sendtext("\u30d7\u30ed\u30ad\u30b7\u306e\u8a2d\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
        }
        this.sendtext("\u30c1\u30a7\u30c3\u30af\u7d42\u4e86");
        return true;
    }

    private NicoClient getNicoClient() {
        if (this.isSaveVideo() || this.isSaveComment() || this.isSaveOwnerComment()) {
            String proxy = null;
            int proxy_port = -1;
            if (this.useProxy()) {
                proxy = this.getProxy();
                proxy_port = this.getProxyPort();
            }
            this.sendtext("\u30ed\u30b0\u30a4\u30f3\u4e2d");
            NicoClient client = new NicoClient(this.getMailAddress(), this.getPassword(), this.StopFlag, proxy, proxy_port);
            if (!client.isLoggedIn()) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557");
            } else {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u6210\u529f");
            }
            return client;
        }
        return null;
    }

    private boolean saveVideo(NicoClient client) {
        File folder = this.Setting.getVideoFixFileNameFolder();
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58");
        if (this.isSaveVideo()) {
            if (this.isVideoFixFileName()) {
                folder.mkdir();
                this.VideoFile = new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + ".flv");
            } else {
                this.VideoFile = this.Setting.getVideoFile();
            }
            this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u52d5\u753b\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            this.VideoFile = client.getVideo(this.VideoFile, this.Status);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.VideoFile == null) {
                this.sendtext("\u52d5\u753b\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return false;
            }
        } else if (this.isSaveConverted()) {
            if (this.isVideoFixFileName()) {
                String videoFilename = this.detectTitleFromVideo(folder);
                if (videoFilename == null) {
                    if (this.OtherVideo == null) {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    } else {
                        this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c.flv\u3067\u3042\u308a\u307e\u305b\u3093\uff1a" + this.OtherVideo);
                    }
                    return false;
                }
                this.VideoFile = new File(folder, videoFilename);
                if (!this.VideoFile.canRead()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                    return false;
                }
            } else {
                this.VideoFile = this.Setting.getVideoFile();
                if (!this.VideoFile.exists()) {
                    this.sendtext("\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    return false;
                }
            }
        }
        this.sendtext("\u52d5\u753b\u306e\u4fdd\u5b58\u3092\u7d42\u4e86");
        return true;
    }

    private boolean saveComment(NicoClient client) {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isSaveComment()) {
            if (this.isCommentFixFileName()) {
                folder.mkdir();
                String ext = ".xml";
                if (this.Setting.isAddTimeStamp()) {
                    MyDateFormat mdf = new MyDateFormat();
                    ext = this.Time == null || this.Time.equals("") ? "[" + mdf.formatNow() + "]" + ext : (mdf.makeTime(this.Time) ? "[" + mdf.formatDate() + "]" + ext : "[" + this.Time + "]" + ext);
                }
                this.CommentFile = new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + ext);
            } else {
                this.CommentFile = this.Setting.getCommentFile();
            }
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            String back_comment = this.Setting.getBackComment();
            if (this.Setting.isFixCommentNum()) {
                back_comment = client.getBackCommentFromLength(back_comment);
            }
            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            this.CommentFile = client.getComment(this.CommentFile, this.Status, back_comment);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.CommentFile == null) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return false;
            }
        }
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private boolean saveOwnerComment(NicoClient client) {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isSaveOwnerComment()) {
            if (this.isCommentFixFileName()) {
                folder.mkdir();
                this.OwnerCommentFile = new File(folder, String.valueOf(this.VideoID) + this.VideoTitle + OWNER_EXT);
            } else {
                this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
            }
            this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb\u4e2d");
            if (client == null) {
                this.sendtext("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u306a\u3044\u306e\u306b\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u306b\u306a\u308a\u307e\u3057\u305f");
                return false;
            }
            this.OwnerCommentFile = client.getOwnerComment(this.OwnerCommentFile, this.Status);
            if (this.stopFlagReturn()) {
                return false;
            }
            if (this.OwnerCommentFile == null) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557");
                return false;
            }
        }
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4fdd\u5b58\u7d42\u4e86");
        return true;
    }

    private boolean convertComment() {
        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithComment()) {
            if (this.Setting.isAddTimeStamp() && this.isCommentFixFileName()) {
                ArrayList<String> pathlist = this.detectFilelistFromComment(folder);
                if (pathlist == null || pathlist.isEmpty()) {
                    this.sendtext(String.valueOf(this.Tag) + ": \u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u30fb\u904e\u53bb\u30ed\u30b0\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    return false;
                }
                if (pathlist.size() > 1) {
                    ArrayList<File> filelist = new ArrayList<File>();
                    int i = 0;
                    while (i < pathlist.size()) {
                        filelist.add(new File(folder, pathlist.get(i)));
                        ++i;
                    }
                    this.CommentFile = new File(TMP_COMBINED_XML);
                    if (!CombineXML.combineXML(filelist, this.CommentFile)) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u7d50\u5408\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\uff08\u30d0\u30b0\uff1f\uff09");
                        return false;
                    }
                } else {
                    File comfile = new File(folder, pathlist.get(0));
                    if (this.isSaveComment() && comfile.getPath() != this.CommentFile.getPath()) {
                        this.sendtext("\u4fdd\u5b58\u3057\u305f\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            if (!this.isSaveComment()) {
                if (this.isCommentFixFileName()) {
                    if (!this.Setting.isAddTimeStamp()) {
                        String commentfilename = this.detectTitleFromComment(folder);
                        if (commentfilename == null) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                            return false;
                        }
                        this.CommentFile = new File(folder, commentfilename);
                        if (!this.CommentFile.canRead()) {
                            this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                            return false;
                        }
                    }
                } else {
                    this.CommentFile = this.Setting.getCommentFile();
                    if (!this.CommentFile.exists()) {
                        this.sendtext("\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            this.CommentMiddleFile = this.convertToCommentMiddle(this.CommentFile, TMP_COMMENT);
            if (this.CommentMiddleFile == null) {
                this.sendtext("\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
                return false;
            }
        }
        return true;
    }

    private boolean convertOwnerComment() {
        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u306e\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u5909\u63db\u4e2d");
        File folder = this.Setting.getCommentFixFileNameFolder();
        if (this.isConvertWithOwnerComment()) {
            if (!this.isSaveOwnerComment()) {
                if (this.isCommentFixFileName()) {
                    String ownerfilename = this.detectTitleFromOwnerComment(folder);
                    if (ownerfilename == null) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u30d5\u30a9\u30eb\u30c0\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                    this.OwnerCommentFile = new File(folder, ownerfilename);
                    if (!this.OwnerCommentFile.canRead()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                        return false;
                    }
                } else {
                    this.OwnerCommentFile = this.Setting.getOwnerCommentFile();
                    if (!this.OwnerCommentFile.exists()) {
                        this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                        return false;
                    }
                }
            }
            this.OwnerMiddleFile = this.convertToCommentMiddle(this.OwnerCommentFile, TMP_OWNERCOMMENT);
            if (this.OwnerMiddleFile == null) {
                this.sendtext("\u6295\u7a3f\u8005\u30b3\u30e1\u30f3\u30c8\u5909\u63db\u306b\u5931\u6557\u3002\u304a\u305d\u3089\u304f\u6b63\u898f\u8868\u73fe\u306e\u9593\u9055\u3044\uff1f");
                return false;
            }
        }
        return true;
    }

    private void deleteCommentFile() {
        this.CommentFile.delete();
    }

    private File convertToCommentMiddle(File commentfile, String outpath) {
        File middlefile = new File(outpath);
        if (!ConvertToVideoHook.convert(commentfile, middlefile, this.Setting.getNG_ID(), this.Setting.getNG_Word())) {
            return null;
        }
        return middlefile;
    }

    private boolean convertVideo() {
        this.sendtext("\u52d5\u753b\u306e\u5909\u63db\u3092\u958b\u59cb");
        File folder = this.Setting.getConvFixFileNameFolder();
        if (this.Setting.isConvFixFileName()) {
            folder.mkdir();
            String conv_name = this.VideoTitle;
            if (!this.Setting.isNotAddVideoID_Conv()) {
                conv_name = conv_name == null ? this.VideoID : String.valueOf(this.VideoID) + conv_name;
            }
            if (conv_name == null || conv_name.isEmpty()) {
                this.sendtext("\u5909\u63db\u5f8c\u306e\u30d3\u30c7\u30aa\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u78ba\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            this.ConvertedVideoFile = new File(folder, String.valueOf(conv_name) + this.ExtOption);
        } else {
            String filename = this.Setting.getConvertedVideoFile().getPath();
            if (!filename.endsWith(this.ExtOption)) {
                filename = String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + this.ExtOption;
                this.ConvertedVideoFile = new File(filename);
            } else {
                this.ConvertedVideoFile = this.Setting.getConvertedVideoFile();
            }
        }
        if (this.ConvertedVideoFile.getPath().equals(this.VideoFile.getPath())) {
            this.sendtext("\u5909\u63db\u5f8c\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u5909\u63db\u524d\u306e\u52d5\u753b\u30d5\u30a1\u30a4\u30eb\u3068\u540c\u3058\u3067\u3059");
            return false;
        }
        int code = this.converting_video(TMP_COMMENT, TMP_OWNERCOMMENT);
        if (code == 0) {
            this.sendtext("\u5909\u63db\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            return true;
        }
        if (code != 100) {
            this.sendtext("\u5909\u63db\u30a8\u30e9\u30fc\uff1a" + this.LastError);
        }
        return false;
    }

    @Override
    public void run() {
        try {
            if (!this.checkOK()) {
                return;
            }
            NicoClient client = this.getNicoClient();
            if (client != null) {
                if (!client.isLoggedIn()) {
                    return;
                }
                if (!client.getVideoInfo(this.Tag, this.Time)) {
                    this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557");
                    return;
                }
                this.sendtext(String.valueOf(this.Tag) + "\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u6210\u529f");
                if (this.stopFlagReturn()) {
                    return;
                }
                this.VideoTitle = client.getVideoTitle();
            }
            if (!this.saveVideo(client) || this.stopFlagReturn()) {
                return;
            }
            if (!this.saveComment(client) || this.stopFlagReturn()) {
                return;
            }
            if (!this.saveOwnerComment(client) || this.stopFlagReturn()) {
                return;
            }
            if (!this.isSaveConverted()) {
                this.sendtext("\u52d5\u753b\u30fb\u30b3\u30e1\u30f3\u30c8\u3092\u4fdd\u5b58\u3057\u3001\u5909\u63db\u306f\u884c\u3044\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                return;
            }
            if (!this.convertComment() || this.stopFlagReturn()) {
                return;
            }
            if (!this.convertOwnerComment() || this.stopFlagReturn()) {
                return;
            }
            if (this.convertVideo()) {
                if (this.isDeleteCommentAfterConverting() && this.CommentFile != null) {
                    this.deleteCommentFile();
                }
                if (this.isDeleteVideoAfterConverting() && this.VideoFile != null) {
                    this.VideoFile.delete();
                }
            }
        }
        finally {
            this.StopFlag.finished();
        }
    }

    private int converting_video(String vhook_path, String vhookowner_path) {
        Process process = null;
        BufferedReader ebr = null;
        File fwsFile = Cws2Fws.createFws(this.VideoFile);
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(this.Setting.getFFmpegPath().replace("\\", "/"));
        sb.append("\"");
        sb.append(" -y ");
        sb.append(this.MainOption);
        sb.append(" ");
        sb.append(this.InOption);
        sb.append(" -i ");
        if (fwsFile == null) {
            sb.append("\"");
            sb.append(this.VideoFile.getPath().replace("\\", "/"));
            sb.append("\"");
        } else {
            sb.append(fwsFile.getPath().replace("\\", "/"));
        }
        sb.append(" ");
        sb.append(this.OutOption);
        sb.append(" \"");
        sb.append(this.ConvertedVideoFile.getPath().replace("\\", "/"));
        sb.append("\"");
        if (!this.Setting.isVhookDisabled() && !this.addVhookSetting(sb, vhook_path, vhookowner_path)) {
            return -1;
        }
        String cmd = sb.substring(0);
        System.out.println("arg:" + cmd);
        try {
            String e;
            System.out.println("\n\n----\nProcessing FFmpeg...\n----\n\n");
            process = Runtime.getRuntime().exec(cmd);
            ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((e = ebr.readLine()) != null) {
                this.LastError = e;
                if (this.LastError.startsWith("frame=")) {
                    this.sendtext(this.LastError);
                } else if (!this.LastError.endsWith("No accelerated colorspace conversion found")) {
                    System.out.println(e);
                }
                if (!this.stopFlagReturn()) continue;
                process.destroy();
                return 100;
            }
            process.waitFor();
            int n = process.exitValue();
            return n;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return -1;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        finally {
            try {
                process.getErrorStream().close();
                ebr.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean addVhookSetting(StringBuffer sb, String vhook_path, String vhookowner_path) {
        try {
            sb.append(" -vfilters \"vhext=");
            sb.append(this.Setting.getVhookPath().replace("\\", "/"));
            sb.append("|");
            if (this.CommentMiddleFile != null) {
                sb.append("--data-user:");
                sb.append(URLEncoder.encode(vhook_path.replace("\\", "/"), "Shift_JIS"));
                sb.append("|");
            }
            if (this.OwnerMiddleFile != null) {
                sb.append("--data-owner:");
                sb.append(URLEncoder.encode(vhookowner_path.replace("\\", "/"), "Shift_JIS"));
                sb.append("|");
            }
            sb.append("--font:");
            sb.append(URLEncoder.encode(this.Setting.getFontPath().replace("\\", "/"), "Shift_JIS"));
            sb.append("|");
            sb.append("--font-index:");
            sb.append(this.Setting.getFontIndex());
            sb.append("|");
            sb.append("--show-user:");
            sb.append(this.Setting.getVideoShowNum());
            sb.append("|");
            sb.append("--shadow:");
            sb.append(this.Setting.getShadowIndex());
            sb.append("|");
            if (this.Setting.isVhook_ShowConvertingVideo()) {
                sb.append("--enable-show-video");
                sb.append("|");
            }
            if (this.Setting.isFixFontSize()) {
                sb.append("--enable-fix-font-size");
                sb.append("|");
            }
            if (this.Setting.isOpaqueComment()) {
                sb.append("--enable-opaque-comment");
            }
            sb.append("\"");
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isConverted() {
        return this.StopFlag.isConverted();
    }

    private boolean stopFlagReturn() {
        if (this.StopFlag.needStop()) {
            this.sendtext("\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            return true;
        }
        return false;
    }

    public ConvertStopFlag getStopFlag() {
        return this.StopFlag;
    }

    private boolean detectOption() {
        boolean ret;
        block6: {
            if (this.Setting.getOptionFile() != null) {
                try {
                    Properties prop = new Properties();
                    prop.loadFromXML(new FileInputStream(this.Setting.getOptionFile()));
                    this.ExtOption = prop.getProperty("EXT", null);
                    this.InOption = prop.getProperty("IN", null);
                    this.OutOption = prop.getProperty("OUT", null);
                    this.MainOption = prop.getProperty("MAIN", null);
                    if (this.ExtOption != null && this.InOption != null && this.OutOption != null && this.MainOption != null) {
                        ret = true;
                        break block6;
                    }
                    ret = false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    ret = false;
                }
            } else {
                this.ExtOption = this.Setting.getCmdLineOptionExt();
                this.InOption = this.Setting.getCmdLineOptionIn();
                this.OutOption = this.Setting.getCmdLineOptionOut();
                this.MainOption = this.Setting.getCmdLineOptionMain();
                ret = true;
            }
        }
        if (!this.ExtOption.startsWith(".")) {
            this.ExtOption = "." + this.ExtOption;
        }
        return ret;
    }

    private String detectTitleFromVideo(File dir) {
        String[] list = dir.list(new VideoIDFilter(this.VideoID));
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].startsWith(this.VideoID)) {
                String path = list[i];
                if (!path.endsWith(".flv")) {
                    this.OtherVideo = path;
                } else {
                    if (this.VideoTitle != null) {
                        return path;
                    }
                    this.VideoTitle = path.substring(this.VideoID.length());
                    int lastindex = this.VideoTitle.lastIndexOf(46);
                    if (lastindex >= 0) {
                        this.VideoTitle = this.VideoTitle.substring(0, lastindex);
                    }
                    return path;
                }
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromComment(File dir) {
        String[] list = dir.list(new VideoIDFilter(this.VideoID));
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT)) {
                if (this.VideoTitle == null) {
                    int fromindex = this.VideoID.length();
                    int index = path.lastIndexOf("[");
                    this.VideoTitle = index >= fromindex ? path.substring(fromindex, index) : path.substring(fromindex, path.lastIndexOf("."));
                }
                return path;
            }
            ++i;
        }
        return null;
    }

    private String detectTitleFromOwnerComment(File dir) {
        String[] list = dir.list(new VideoIDFilter(this.VideoID));
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            block8: {
                String ext;
                String path;
                block7: {
                    block6: {
                        path = list[i];
                        if (!path.endsWith(OWNER_EXT)) break block6;
                        ext = OWNER_EXT;
                        break block7;
                    }
                    if (!path.endsWith(TCOMMENT_EXT)) break block8;
                    ext = TCOMMENT_EXT;
                }
                if (this.VideoTitle == null) {
                    this.VideoTitle = path.substring(this.VideoID.length(), path.lastIndexOf(ext));
                }
                return path;
            }
            ++i;
        }
        return null;
    }

    private ArrayList<String> detectFilelistFromComment(File dir) {
        String[] list = dir.list(new VideoIDFilter(this.VideoID));
        if (list == null) {
            return null;
        }
        ArrayList<String> filelist = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            String path = list[i];
            if (path.endsWith(".xml") && !path.endsWith(OWNER_EXT)) {
                if (this.VideoTitle == null) {
                    int fromindex = this.VideoID.length();
                    int index = path.lastIndexOf("[");
                    this.VideoTitle = index >= fromindex ? path.substring(fromindex, index) : path.substring(fromindex, path.lastIndexOf(".xml"));
                }
                filelist.add(path);
            }
            ++i;
        }
        if (filelist.isEmpty()) {
            return null;
        }
        return filelist;
    }

    class VideoIDFilter
    implements FilenameFilter {
        private final String VideoTag;

        public VideoIDFilter(String videoTag) {
            this.VideoTag = videoTag;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(this.VideoTag) >= 0;
        }
    }
}

