# グラフクラス
class WebGraph

  def initialize
    @page_index = 0
    @link_index = 0
    @page_list = []
    @link_list = []
  end

  def get_page_id(url)
    @page_list.each do |page|
      if page.url == url
        return page.id
      end
    end
    # 引数のurlがグラフに含まれなかった場合は新たに追加する
    new_page = self.add_page(url)
    return new_page.id
  end

  def insert_link(from_id, to_id)
    @link_list.each do |link|
      if link.from_id == from_id && link.to_id == to_id
          return # すでに存在するリンクの場合はなにもしない
      end
    end
    # 引数のfrom_id, to_idからなるリンクがグラフに含まれなかった場合は新たに追加する
    self.add_link(from_id, to_id)
  end

  def insert_links(links)
    links.each do |link|
      value = '(' + link[:from_id].to_s + ', ' + link[:to_id].to_s + ')'
      insert_link(link[:from_id], link[:to_id])
    end
  end

  def add_page(url)
    page = Page.new(@page_index, url)
    @page_list.push(page)
    @page_index += 1
    return page
  end

  def add_link(from_id, to_id)
    link = Link.new(@link_index, from_id, to_id)
    @link_list.push(link)
    @link_index += 1
    return link
  end

  def print_graph
    @page_list.each do |page|
      puts page.id.to_s + " " + page.url
    end
    @link_list.each do |link|
      puts link.id.to_s + " " + link.from_id.to_s + " " + link.to_id.to_s
    end
  end


end

# ノードクラス
class Page
  attr_accessor :id, :url
  def initialize(url_id, url)
    @id =url_id
    @url = url
  end
end

# エッジクラス
class Link
  attr_accessor :id, :from_id, :to_id
  def initialize(link_id, from_page_id, to_page_id)
    @id = link_id
    @from_id = from_page_id
    @to_id = to_page_id
  end
end