<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractFilterForm.class.php";

define('REGPAY_PAYPALIPN_SORT_KEY_PAYPALIPN_ID', 1);
define('REGPAY_PAYPALIPN_SORT_KEY_FIRSTNAME', 2);
define('REGPAY_PAYPALIPN_SORT_KEY_LASTNAME', 3);
define('REGPAY_PAYPALIPN_SORT_KEY_PAYER_BUSINESS_NAME', 4);
define('REGPAY_PAYPALIPN_SORT_KEY_ITEM_NAME', 5);
define('REGPAY_PAYPALIPN_SORT_KEY_MC_GROSS', 6);
define('REGPAY_PAYPALIPN_SORT_KEY_MC_CURRENCY', 7);
define('REGPAY_PAYPALIPN_SORT_KEY_TAX', 8);
define('REGPAY_PAYPALIPN_SORT_KEY_PAYMENT_TYPE', 9);
define('REGPAY_PAYPALIPN_SORT_KEY_PAYMENT_STATUS', 10);
define('REGPAY_PAYPALIPN_SORT_KEY_TXN_ID', 11);
define('REGPAY_PAYPALIPN_SORT_KEY_TXN_TYPE', 12);
define('REGPAY_PAYPALIPN_SORT_KEY_RECIVER_EMAIL', 13);
define('REGPAY_PAYPALIPN_SORT_KEY_PAYER_EMAIL', 14);
define('REGPAY_PAYPALIPN_SORT_KEY_UID', 15);
define('REGPAY_PAYPALIPN_SORT_KEY_GID', 16);
define('REGPAY_PAYPALIPN_SORT_KEY_PAYMENTDATE', 17);
define('REGPAY_PAYPALIPN_SORT_KEY_DEFAULT', REGPAY_PAYPALIPN_SORT_KEY_PAYPALIPN_ID);

class Regpay_Admin_PaypalipnFilterForm extends Regpay_AbstractFilterForm
{
	var $mSortKeys = array(
		REGPAY_PAYPALIPN_SORT_KEY_PAYPALIPN_ID => 'paypalipn_id',
		REGPAY_PAYPALIPN_SORT_KEY_FIRSTNAME => 'firstname',
		REGPAY_PAYPALIPN_SORT_KEY_LASTNAME => 'lastname',
		REGPAY_PAYPALIPN_SORT_KEY_PAYER_BUSINESS_NAME => 'payer_business_name',
		REGPAY_PAYPALIPN_SORT_KEY_ITEM_NAME => 'item_name',
		REGPAY_PAYPALIPN_SORT_KEY_MC_GROSS => 'mc_gross',
		REGPAY_PAYPALIPN_SORT_KEY_MC_CURRENCY => 'mc_currency',
		REGPAY_PAYPALIPN_SORT_KEY_TAX => 'tax',
		REGPAY_PAYPALIPN_SORT_KEY_PAYMENT_TYPE => 'payment_type',
		REGPAY_PAYPALIPN_SORT_KEY_PAYMENT_STATUS => 'payment_status',
		REGPAY_PAYPALIPN_SORT_KEY_TXN_ID => 'txn_id',
		REGPAY_PAYPALIPN_SORT_KEY_TXN_TYPE => 'txn_type',
		REGPAY_PAYPALIPN_SORT_KEY_RECIVER_EMAIL => 'reciver_email',
		REGPAY_PAYPALIPN_SORT_KEY_PAYER_EMAIL => 'payer_email',
		REGPAY_PAYPALIPN_SORT_KEY_UID => 'uid',
		REGPAY_PAYPALIPN_SORT_KEY_GID => 'gid',
		REGPAY_PAYPALIPN_SORT_KEY_PAYMENTDATE => 'paymentdate'
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return REGPAY_PAYPALIPN_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();
	
		$root =& XCube_Root::getSingleton();
	
		if (($value = $root->mContext->mRequest->getRequest('paypalipn_id')) !== null) {
			$this->mNavi->addExtra('paypalipn_id', $value);
			$this->_mCriteria->add(new Criteria('paypalipn_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('firstname')) !== null) {
			$this->mNavi->addExtra('firstname', $value);
			$this->_mCriteria->add(new Criteria('firstname', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('lastname')) !== null) {
			$this->mNavi->addExtra('lastname', $value);
			$this->_mCriteria->add(new Criteria('lastname', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payer_business_name')) !== null) {
			$this->mNavi->addExtra('payer_business_name', $value);
			$this->_mCriteria->add(new Criteria('payer_business_name', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('item_name')) !== null) {
			$this->mNavi->addExtra('item_name', $value);
			$this->_mCriteria->add(new Criteria('item_name', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('mc_gross')) !== null) {
			$this->mNavi->addExtra('mc_gross', $value);
			$this->_mCriteria->add(new Criteria('mc_gross', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('mc_currency')) !== null) {
			$this->mNavi->addExtra('mc_currency', $value);
			$this->_mCriteria->add(new Criteria('mc_currency', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('tax')) !== null) {
			$this->mNavi->addExtra('tax', $value);
			$this->_mCriteria->add(new Criteria('tax', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payment_type')) !== null) {
			$this->mNavi->addExtra('payment_type', $value);
			$this->_mCriteria->add(new Criteria('payment_type', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payment_status')) !== null) {
			$this->mNavi->addExtra('payment_status', $value);
			$this->_mCriteria->add(new Criteria('payment_status', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('txn_id')) !== null) {
			$this->mNavi->addExtra('txn_id', $value);
			$this->_mCriteria->add(new Criteria('txn_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('txn_type')) !== null) {
			$this->mNavi->addExtra('txn_type', $value);
			$this->_mCriteria->add(new Criteria('txn_type', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('reciver_email')) !== null) {
			$this->mNavi->addExtra('reciver_email', $value);
			$this->_mCriteria->add(new Criteria('reciver_email', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('payer_email')) !== null) {
			$this->mNavi->addExtra('payer_email', $value);
			$this->_mCriteria->add(new Criteria('payer_email', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('uid')) !== null) {
			$this->mNavi->addExtra('uid', $value);
			$this->_mCriteria->add(new Criteria('uid', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('gid')) !== null) {
			$this->mNavi->addExtra('gid', $value);
			$this->_mCriteria->add(new Criteria('gid', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('paymentdate')) !== null) {
			$this->mNavi->addExtra('paymentdate', $value);
			$this->_mCriteria->add(new Criteria('paymentdate', $value));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
