<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/class/Legacy_Validator.class.php";

class Regpay_Admin_PaypalipnEditForm extends XCube_ActionForm
{
	/**
	 * @public
	 */
	function getTokenName()
	{
		return "module.regpay.Admin_PaypalipnEditForm.TOKEN";
	}
	public function validatepaymentdate()
    {
    	$datetime = $this->get('paymentdate');
        $this->set('paymentdate', strtotime($datetime));
    }
	
	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['paypalipn_id'] =& new XCube_IntProperty('paypalipn_id');
		$this->mFormProperties['firstname'] =& new XCube_StringProperty('firstname');
		$this->mFormProperties['lastname'] =& new XCube_StringProperty('lastname');
		$this->mFormProperties['payer_business_name'] =& new XCube_StringProperty('payer_business_name');
		$this->mFormProperties['item_name'] =& new XCube_StringProperty('item_name');
		$this->mFormProperties['mc_gross'] =& new XCube_IntProperty('mc_gross');
		$this->mFormProperties['mc_currency'] =& new XCube_StringProperty('mc_currency');
		$this->mFormProperties['tax'] =& new XCube_IntProperty('tax');
		$this->mFormProperties['payment_type'] =& new XCube_StringProperty('payment_type');
		$this->mFormProperties['payment_status'] =& new XCube_StringProperty('payment_status');
		$this->mFormProperties['txn_id'] =& new XCube_StringProperty('txn_id');
		$this->mFormProperties['txn_type'] =& new XCube_StringProperty('txn_type');
		$this->mFormProperties['reciver_email'] =& new XCube_StringProperty('reciver_email');
		$this->mFormProperties['payer_email'] =& new XCube_StringProperty('payer_email');
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['gid'] =& new XCube_IntProperty('gid');
		$this->mFormProperties['paymentdate'] =& new XCube_IntProperty('paymentdate');
	
		//
		// Set field properties
		//
		$this->mFieldProperties['paypalipn_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['paypalipn_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['paypalipn_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYPALIPN_ID);
	
		$this->mFieldProperties['firstname'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['firstname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['firstname']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_FIRSTNAME, '60');
		$this->mFieldProperties['firstname']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_FIRSTNAME, '60');
		$this->mFieldProperties['firstname']->addVar('maxlength', '60');
	
		$this->mFieldProperties['lastname'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['lastname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['lastname']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_LASTNAME, '60');
		$this->mFieldProperties['lastname']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_LASTNAME, '60');
		$this->mFieldProperties['lastname']->addVar('maxlength', '60');
	
		$this->mFieldProperties['payer_business_name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payer_business_name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payer_business_name']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYER_BUSINESS_NAME, '32');
		$this->mFieldProperties['payer_business_name']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYER_BUSINESS_NAME, '32');
		$this->mFieldProperties['payer_business_name']->addVar('maxlength', '32');
	
		$this->mFieldProperties['item_name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['item_name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['item_name']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_ITEM_NAME, '64');
		$this->mFieldProperties['item_name']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_ITEM_NAME, '64');
		$this->mFieldProperties['item_name']->addVar('maxlength', '64');
	
		$this->mFieldProperties['mc_gross'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['mc_gross']->setDependsByArray(array('required'));
		$this->mFieldProperties['mc_gross']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_MC_GROSS);
	
		$this->mFieldProperties['mc_currency'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['mc_currency']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['mc_currency']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_MC_CURRENCY, '5');
		$this->mFieldProperties['mc_currency']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_MC_CURRENCY, '5');
		$this->mFieldProperties['mc_currency']->addVar('maxlength', '5');
	
		$this->mFieldProperties['tax'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['tax']->setDependsByArray(array('required'));
		$this->mFieldProperties['tax']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_TAX);
	
		$this->mFieldProperties['payment_type'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payment_type']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payment_type']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYMENT_TYPE, '32');
		$this->mFieldProperties['payment_type']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYMENT_TYPE, '32');
		$this->mFieldProperties['payment_type']->addVar('maxlength', '32');
	
		$this->mFieldProperties['payment_status'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payment_status']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payment_status']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYMENT_STATUS, '32');
		$this->mFieldProperties['payment_status']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYMENT_STATUS, '32');
		$this->mFieldProperties['payment_status']->addVar('maxlength', '32');
	
		$this->mFieldProperties['txn_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['txn_id']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['txn_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_TXN_ID, '32');
		$this->mFieldProperties['txn_id']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_TXN_ID, '32');
		$this->mFieldProperties['txn_id']->addVar('maxlength', '32');
	
		$this->mFieldProperties['txn_type'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['txn_type']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['txn_type']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_TXN_TYPE, '10');
		$this->mFieldProperties['txn_type']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_TXN_TYPE, '10');
		$this->mFieldProperties['txn_type']->addVar('maxlength', '10');
	
		$this->mFieldProperties['reciver_email'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['reciver_email']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['reciver_email']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_RECIVER_EMAIL, '64');
		$this->mFieldProperties['reciver_email']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_RECIVER_EMAIL, '64');
		$this->mFieldProperties['reciver_email']->addVar('maxlength', '64');
	
		$this->mFieldProperties['payer_email'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['payer_email']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['payer_email']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYER_EMAIL, '64');
		$this->mFieldProperties['payer_email']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_PAYER_EMAIL, '64');
		$this->mFieldProperties['payer_email']->addVar('maxlength', '64');
	
		$this->mFieldProperties['uid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_UID);
	
		$this->mFieldProperties['gid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['gid']->setDependsByArray(array('required'));
		$this->mFieldProperties['gid']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_GID);
	
		$this->mFieldProperties['paymentdate'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['paymentdate']->setDependsByArray(array('required'));
		$this->mFieldProperties['paymentdate']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYMENTDATE);
	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('paypalipn_id', $obj->get('paypalipn_id'));
		$this->set('firstname', $obj->get('firstname'));
		$this->set('lastname', $obj->get('lastname'));
		$this->set('payer_business_name', $obj->get('payer_business_name'));
		$this->set('item_name', $obj->get('item_name'));
		$this->set('mc_gross', $obj->get('mc_gross'));
		$this->set('mc_currency', $obj->get('mc_currency'));
		$this->set('tax', $obj->get('tax'));
		$this->set('payment_type', $obj->get('payment_type'));
		$this->set('payment_status', $obj->get('payment_status'));
		$this->set('txn_id', $obj->get('txn_id'));
		$this->set('txn_type', $obj->get('txn_type'));
		$this->set('reciver_email', $obj->get('reciver_email'));
		$this->set('payer_email', $obj->get('payer_email'));
		$this->set('uid', $obj->get('uid'));
		$this->set('gid', $obj->get('gid'));
		$this->set('paymentdate', $obj->get('paymentdate'));
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('paypalipn_id', $this->get('paypalipn_id'));
		$obj->set('firstname', $this->get('firstname'));
		$obj->set('lastname', $this->get('lastname'));
		$obj->set('payer_business_name', $this->get('payer_business_name'));
		$obj->set('item_name', $this->get('item_name'));
		$obj->set('mc_gross', $this->get('mc_gross'));
		$obj->set('mc_currency', $this->get('mc_currency'));
		$obj->set('tax', $this->get('tax'));
		$obj->set('payment_type', $this->get('payment_type'));
		$obj->set('payment_status', $this->get('payment_status'));
		$obj->set('txn_id', $this->get('txn_id'));
		$obj->set('txn_type', $this->get('txn_type'));
		$obj->set('reciver_email', $this->get('reciver_email'));
		$obj->set('payer_email', $this->get('payer_email'));
		$obj->set('uid', $this->get('uid'));
		$obj->set('gid', $this->get('gid'));
		$obj->set('paymentdate', $this->get('paymentdate'));
	}
}

?>
