<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractFilterForm.class.php";

define('REGPAY_PAYPALAMOUNT_SORT_KEY_PAYPALAMOUNT_ID', 1);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_GROUP_ID', 2);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_PAY_TYPE', 3);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_AMOUNT', 4);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_UNIT', 5);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_BUSINESS', 6);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_HOSTED_BUTTON_ID', 7);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_DATETIME', 8);
define('REGPAY_PAYPALAMOUNT_SORT_KEY_DEFAULT', REGPAY_PAYPALAMOUNT_SORT_KEY_PAYPALAMOUNT_ID);

class Regpay_Admin_PaypalamountFilterForm extends Regpay_AbstractFilterForm
{
	var $mSortKeys = array(
		REGPAY_PAYPALAMOUNT_SORT_KEY_PAYPALAMOUNT_ID => 'paypalamount_id',
		REGPAY_PAYPALAMOUNT_SORT_KEY_GROUP_ID => 'group_id',
		REGPAY_PAYPALAMOUNT_SORT_KEY_PAY_TYPE => 'pay_type',
		REGPAY_PAYPALAMOUNT_SORT_KEY_AMOUNT => 'amount',
		REGPAY_PAYPALAMOUNT_SORT_KEY_UNIT => 'unit',
		REGPAY_PAYPALAMOUNT_SORT_KEY_BUSINESS => 'business',
		REGPAY_PAYPALAMOUNT_SORT_KEY_HOSTED_BUTTON_ID => 'hosted_button_id',
		REGPAY_PAYPALAMOUNT_SORT_KEY_DATETIME => 'datetime'
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return REGPAY_PAYPALAMOUNT_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();
	
		$root =& XCube_Root::getSingleton();
	
		if (($value = $root->mContext->mRequest->getRequest('paypalamount_id')) !== null) {
			$this->mNavi->addExtra('paypalamount_id', $value);
			$this->_mCriteria->add(new Criteria('paypalamount_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('group_id')) !== null) {
			$this->mNavi->addExtra('group_id', $value);
			$this->_mCriteria->add(new Criteria('group_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('pay_type')) !== null) {
			$this->mNavi->addExtra('pay_type', $value);
			$this->_mCriteria->add(new Criteria('pay_type', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('amount')) !== null) {
			$this->mNavi->addExtra('amount', $value);
			$this->_mCriteria->add(new Criteria('amount', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('unit')) !== null) {
			$this->mNavi->addExtra('unit', $value);
			$this->_mCriteria->add(new Criteria('unit', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('business')) !== null) {
			$this->mNavi->addExtra('business', $value);
			$this->_mCriteria->add(new Criteria('business', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('hosted_button_id')) !== null) {
			$this->mNavi->addExtra('hosted_button_id', $value);
			$this->_mCriteria->add(new Criteria('hosted_button_id', $value));
		}
	
		if (($value = $root->mContext->mRequest->getRequest('datetime')) !== null) {
			$this->mNavi->addExtra('datetime', $value);
			$this->_mCriteria->add(new Criteria('datetime', $value));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
