<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/class/Legacy_Validator.class.php";

class Regpay_Admin_PaypalamountEditForm extends XCube_ActionForm
{
	/**
	 * @public
	 */
	function getTokenName()
	{
		return "module.regpay.Admin_PaypalamountEditForm.TOKEN";
	}

	/**
	 * @public
	 */
	public function validatedatetime()
    {
        $this->set('datetime', time());
    }

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['paypalamount_id'] =& new XCube_IntProperty('paypalamount_id');
		$this->mFormProperties['group_id'] =& new XCube_IntProperty('group_id');
		$this->mFormProperties['pay_type'] =& new XCube_IntProperty('pay_type');
		$this->mFormProperties['amount'] =& new XCube_IntProperty('amount');
		$this->mFormProperties['unit'] =& new XCube_StringProperty('unit');
		$this->mFormProperties['business'] =& new XCube_StringProperty('business');
		$this->mFormProperties['hosted_button_id'] =& new XCube_StringProperty('hosted_button_id');
		$this->mFormProperties['datetime'] =& new XCube_IntProperty('datetime');

		//
		// Set field properties
		//
		$this->mFieldProperties['paypalamount_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['paypalamount_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['paypalamount_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAYPALAMOUNT_ID);

		$this->mFieldProperties['group_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['group_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['group_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_GROUP_ID);

		$this->mFieldProperties['pay_type'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['pay_type']->setDependsByArray(array('required'));
		$this->mFieldProperties['pay_type']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_PAY_TYPE);

		$this->mFieldProperties['amount'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['amount']->setDependsByArray(array('required'));
		$this->mFieldProperties['amount']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_AMOUNT);

		$this->mFieldProperties['unit'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['unit']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['unit']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_UNIT, '4');
		$this->mFieldProperties['unit']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_UNIT, '4');
		$this->mFieldProperties['unit']->addVar('maxlength', '4');

		$this->mFieldProperties['business'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['business']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['business']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_BUSINESS, '255');
		$this->mFieldProperties['business']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_BUSINESS, '255');
		$this->mFieldProperties['business']->addVar('maxlength', '255');

		$this->mFieldProperties['hosted_button_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['hosted_button_id']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['hosted_button_id']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_HOSTED_BUTTON_ID, '255');
		$this->mFieldProperties['hosted_button_id']->addMessage('maxlength', _MD_REGPAY_ERROR_MAXLENGTH, _MD_REGPAY_LANG_HOSTED_BUTTON_ID, '255');
		$this->mFieldProperties['hosted_button_id']->addVar('maxlength', '255');

		$this->mFieldProperties['datetime'] =& new XCube_FieldProperty($this);
		//$this->mFieldProperties['datetime']->setDependsByArray(array('required'));
		$this->mFieldProperties['datetime']->addMessage('required', _MD_REGPAY_ERROR_REQUIRED, _MD_REGPAY_LANG_DATETIME);
	}

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('paypalamount_id', $obj->get('paypalamount_id'));
		$this->set('group_id', $obj->get('group_id'));
		$this->set('pay_type', $obj->get('pay_type'));
		$this->set('amount', $obj->get('amount'));
		$this->set('unit', $obj->get('unit'));
		$this->set('business', $obj->get('business'));
		$this->set('hosted_button_id', $obj->get('hosted_button_id'));
		$this->set('datetime', $obj->get('datetime'));
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		$obj->set('paypalamount_id', $this->get('paypalamount_id'));
		$obj->set('group_id', $this->get('group_id'));
		$obj->set('pay_type', $this->get('pay_type'));
		$obj->set('amount', $this->get('amount'));
		$obj->set('unit', $this->get('unit'));
		$obj->set('business', $this->get('business'));
		$obj->set('hosted_button_id', $this->get('hosted_button_id'));
		$obj->set('datetime', $this->get('datetime'));
	}
}

?>
