<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractDeleteAction.class.php";

class Regpay_Admin_PaypalpdtDeleteAction extends Regpay_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret_val = xoops_getrequest('paypalpdt_id');
		return $ret_val;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mAsset->load('handler', "paypalpdt");
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_setupActionForm()
	{
		// $this->mActionForm =& new Regpay_Admin_PaypalpdtDeleteForm();
		$this->mActionForm =& $this->mAsset->create('form', "admin.delete_paypalpdt");
		$this->mActionForm->prepare();
		return $this->mActionForm;
	}

	/**
	 * @public
	 */
	function executeViewInput(&$render)
	{
		$render->setTemplateName("paypalpdt_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('paypalpdt', $this->mObject);
		$render->setAttribute('object', $this->mObject);

	}

	/**
	 * @public
	 */
	function executeViewSuccess(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalpdtList");
	}

	/**
	 * @public
	 */
	function executeViewError(&$render)
	{
		$this->mRoot->mController->executeRedirect("./index.php?action=PaypalpdtList", 1, _MD_REGPAY_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalpdtList");
	}
}

?>
