<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractEditAction.class.php";

class Regpay_Admin_PaypalipnEditAction extends Regpay_AbstractEditAction
{
	/**
	 * @protected
	 */
	function _getId()
	{
		return xoops_getrequest('paypalipn_id');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mAsset->load('handler', "paypalipn");
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		// $this->mActionForm =& new Regpay_Admin_PaypalipnEditForm();
		$this->mActionForm =& $this->mAsset->create('form', "admin.edit_paypalipn");
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput(&$render)
	{
		$render->setTemplateName("paypalipn_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('paypalipn', $this->mObject);
		$render->setAttribute('object', $this->mObject);
	}

	/**
	 * @public
	 */
	function executeViewSuccess(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalipnList");
	}

	/**
	 * @public
	 */
	function executeViewError(&$render)
	{
		$this->mRoot->mController->executeRedirect("./index.php?action=PaypalipnList", 1, _MD_REGPAY_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalipnList");
	}
}

?>
