<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractListAction.class.php";

class Regpay_Admin_PaypalamountListAction extends Regpay_AbstractListAction
{
	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mAsset->load('handler', "paypalamount");
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
		// $filter =& new Regpay_Admin_PaypalamountFilterForm();
		$filter =& $this->mAsset->create('filter', "admin.paypalamount");
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * @protected
	 */
	function _getBaseUrl()
	{
		return "./index.php?action=PaypalamountList";
	}

	/**
	 * @public
	 */
	function executeViewIndex(&$render)
	{
		$render->setTemplateName("paypalamount_list.html");
		#cubson::lazy_load_array('paypalamount', $this->mObjects);
		$render->setAttribute('objects', $this->mObjects);
		$render->setAttribute('pageNavi', $this->mFilter->mNavi);

		$xoopsDB =& Database::getInstance();
		$sql = "SELECT * FROM `".$xoopsDB->prefix('groups')."` WHERE 1=1;";
		$rs = $xoopsDB->query($sql);
		while($row = $xoopsDB->fetchArray($rs)){
			$group_id[$row['groupid']] = $row['name'];
		}
		$render->setAttribute('group_id', $group_id);

		$pay_type = array(
					1 => _MD_REGPAY_LANG_PAY_TYPE_1,
					2 => _MD_REGPAY_LANG_PAY_TYPE_2,
				);
		$render->setAttribute('pay_type', $pay_type);

	}
}

?>
