<?php
/**
 * @file
 * @package regpay
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/regpay/class/AbstractEditAction.class.php";

class Regpay_Admin_PaypalamountEditAction extends Regpay_AbstractEditAction
{
	/**
	 * @protected
	 */
	function _getId()
	{
		return xoops_getrequest('paypalamount_id');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mAsset->load('handler', "paypalamount");
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		// $this->mActionForm =& new Regpay_Admin_PaypalamountEditForm();
		$this->mActionForm =& $this->mAsset->create('form', "admin.edit_paypalamount");
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput(&$render)
	{
		$render->setTemplateName("paypalamount_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		#cubson::lazy_load('paypalamount', $this->mObject);
		$render->setAttribute('object', $this->mObject);

		$unit = array(
					'JPY' => 'JPY',
					'USD' => 'USD',
					'EUR' => 'EUR',
					'GBP' => 'GBP',
					'CAD' => 'CAD',
				);
		$render->setAttribute('unit', $unit);

		$xoopsDB =& Database::getInstance();
		$sql = "SELECT * FROM `".$xoopsDB->prefix('groups')."` WHERE `groupid` <> 3;";
		$rs = $xoopsDB->query($sql);
		while($row = $xoopsDB->fetchArray($rs)){
			$group_id[$row['groupid']] = $row['name'];
		}
		$render->setAttribute('group_id', $group_id);

		$pay_type = array(
					1 => _MD_REGPAY_LANG_PAY_TYPE_1,
					2 => _MD_REGPAY_LANG_PAY_TYPE_2,
				);
		$render->setAttribute('pay_type', $pay_type);
	}

	/**
	 * @public
	 */
	function executeViewSuccess(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalamountList");
	}

	/**
	 * @public
	 */
	function executeViewError(&$render)
	{
		$this->mRoot->mController->executeRedirect("./index.php?action=PaypalamountList", 1, _MD_REGPAY_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel(&$render)
	{
		$this->mRoot->mController->executeForward("./index.php?action=PaypalamountList");
	}
}

?>
