package jp.arcanum.myaddress.pages.update;

import jp.arcanum.myaddress.pages.list.ListPage;
import jp.arcanum.myaddress.util.MyUtil;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.validator.NumberValidator;

public class AddPage extends AbstractDetailPage{

	/**
	 * Oij
	 */
	private TextField _namekanji = new TextField("NAME_KANJI", new Model());
	
	/**
	 * OiJij
	 */
	private TextField _namekana = new TextField("NAME_KANA", new Model());
	
	/**
	 * X֔ԍiRj
	 */
	private TextField _yubinkami = new TextField("YUBIN_KAMI", new Model());
	
	/**
	 * X֔ԍiSj
	 */
	private TextField _yubinshimo = new TextField("YUBIN_SHIMO", new Model());
	
	
	/**
	 * Z
	 */
	private TextArea _address = new TextArea("ADDRESS", new Model());
	
	/**
	 * dbԍ
	 */
	private TextField _telno = new TextField("TEL", new Model());

	/**
	 * e`wԍ
	 */
	private TextField _faxno = new TextField("FAX", new Model());

	/**
	 * ǉ{^
	 */
	private Button _add = new Button("ADD"){
		public void onSubmit(){
			onClickAdd();
		}
	};
	
	
	/**
	 * RXgN^
	 * @param param y[WԈ
	 *
	 */
	public AddPage(PageParameters param){
		
		//@Oij
		_form.add(_namekanji);
		
		
		//@OiJij
		_form.add(_namekana);
		
		
		//@X֔ԍiRj
		_form.add(_yubinkami);
		
		//@X֔ԍiSj
		_form.add(_yubinshimo);
		
		
		//@Z
		_form.add(_address);
		
		
		//@dbԍ
		_form.add(_telno);
		
		
		//@e`wԍ
		_form.add(_faxno);
		
		
		//@ǉ{^
		_form.add(_add);
		
	}
	
	
	/**
	 * ǉ{^
	 *
	 */
	private void onClickAdd(){
		
		
		//@Oij
		String namekanji = MyUtil.trimAll((String)_namekanji.getModelObject());
		if(namekanji.equals("")){
			error("Oij͂ĂB");
			return;
		}
		if(namekanji.getBytes().length > 50){
			error("Oij͂TOoCgȓłB");
			return;
		}
		
		//@OiJij
		String namekana  = MyUtil.trimAll((String)_namekana.getModelObject());
		if(namekana.equals("")){
			error("OiJij͂ĂB");
			return;
		}
		if(namekana.getBytes().length > 50){
			error("OiJij͂TOoCgȓłB");
			return;
		}
		
		//@X֔ԍ
		String yubin = MyUtil.trimAll((String)_yubinkami.getModelObject()) +
				       MyUtil.trimAll((String)_yubinshimo.getModelObject());
		if(!yubin.matches("[0-9][0-9][0-9][0-9][0-9][0-9][0-9]")){
			error("X֔ԍsł");
			return;
		}
		
		//@Z
		String address = MyUtil.trimAll((String)_address.getModelObject());
		if(address.equals("")){
			error("Z͂ĂB");
			return;
		}
		if(address.getBytes().length > 200){
			error("Z͂QOOoCgȓɂĂB");
			return;
		}
		
		//@dbԍ
		String telno = MyUtil.trimAll((String)_telno.getModelObject());
		if(!telno.matches("[0-9-]+")){
			error("dbԍsłB");
			return;
		}
		
		//@e`wԍ
		String faxno = MyUtil.trimAll((String)_faxno.getModelObject());
		if(!faxno.equals("") && !faxno.matches("[0-9-]+")){
			error("e`wԍsłB");
			return;
		}
		
		
		String sql = "INSERT INTO MYADDRESS VALUES(" +
					 "NEXT VALUE FOR SQADDRID," +
					 MyUtil.quote(namekanji) + "," +
					 MyUtil.quote(namekana) + "," +
					 MyUtil.quote(yubin) + "," +
					 MyUtil.quote(address) + "," +
					 MyUtil.quote(telno) + "," +
					 MyUtil.quote(faxno) + 
					 ")";
		
		int insert = MyUtil.update(sql);
		
	
		//@ꗗɖ߂
		setResponsePage(ListPage.class);

		
	}
	
	
}
