package jp.arcanum.myaddress;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

import javax.servlet.ServletContext;

import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;

import jp.arcanum.myaddress.pages.list.ListPage;


public class MyAddressApp extends WebApplication{


    public static final String DB_URL    = "jdbc:hsqldb:hsql://localhost:9001";
    public static final String DB_DRIVER = "org.hsqldb.jdbcDriver";
    public static final String DB_USER   = "sa";
    public static final String DB_PASS   = "";
    private static final String DATA_DIR  = "WEB-INF/data/db";

    
	/**
	 * z[y[Wiy[Wj擾
	 */
	public Class getHomePage() {
		return ListPage.class;
	}
	
	/**
	 * 
	 */
	protected void init() {

		super.init();
		
		// LN^GR[fBOݒ
        getRequestCycleSettings().setResponseRequestEncoding("UTF-8");
        getMarkupSettings().setDefaultMarkupEncoding("UTF-8");

        //@f[^x[XJn܂B
        try {
            ServletContext context = getServletContext();
            org.hsqldb.Server.main(new String[]{"-database",context.getRealPath(DATA_DIR),
                                                "-no_system_exit","true"});
        } catch(RuntimeException ex){
            throw ex;
        } catch(Exception ex){
            throw new RuntimeException(ex);
        }
        
	}
	

	/**
	 * AvP[VIꍇ̏
	 */
	protected void onDestroy() {
		super.onDestroy();

		//@f[^x[XI܂B
		try {
            Class.forName(DB_DRIVER);
            Connection conn = DriverManager.getConnection(DB_URL,DB_USER,DB_PASS);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("SHUTDOWN;");
            stmt.close();
            conn.close();
        } catch(RuntimeException ex){
            throw ex;
        } catch(Exception ex){
            throw new RuntimeException(ex);
        }

	
	}
	
	
}
