/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.io.ThresholdingOutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private OutputStream currentOutputStream;
    private ByteArrayOutputStream memoryOutputStream;
    private final File outputFile;

    public DeferredFileOutputStream(int threshold, File outputFile) {
        super(threshold);
        this.outputFile = outputFile;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        byte[] data = this.memoryOutputStream.toByteArray();
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        fos.write(data);
        this.currentOutputStream = fos;
        this.memoryOutputStream = null;
    }
}

