/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.io.File;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.target.resource.ResourceStreamRequestTarget;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.string.Strings;

public class DownloadLink
extends Link {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private boolean deleteAfter;

    public DownloadLink(String id, File file) {
        super(id);
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.setModel(new Model(file));
    }

    public DownloadLink(String id, IModel model) {
        super(id, model);
    }

    public DownloadLink(String id, IModel model, String fileName) {
        super(id, model);
        this.fileName = fileName;
    }

    public DownloadLink(String id, File file, String fileName) {
        super(id);
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (Strings.isEmpty(fileName)) {
            throw new IllegalArgumentException("fileName cannot be an empty string");
        }
        this.setModel(new Model(file));
        this.fileName = fileName;
    }

    public void onClick() {
        final File file = (File)this.getModelObject();
        if (file == null) {
            throw new IllegalStateException(this.getClass().getName() + " failed to retrieve a File object from model");
        }
        final String fn = this.fileName != null ? this.fileName : file.getName();
        FileResourceStream resourceStream = new FileResourceStream(new org.apache.wicket.util.file.File(file));
        this.getRequestCycle().setRequestTarget(new ResourceStreamRequestTarget(resourceStream){

            public String getFileName() {
                return fn;
            }

            public void respond(RequestCycle requestCycle) {
                super.respond(requestCycle);
                if (DownloadLink.this.deleteAfter) {
                    file.delete();
                }
            }
        });
    }

    public final DownloadLink setDeleteAfterDownload(boolean deleteAfter) {
        this.deleteAfter = deleteAfter;
        return this;
    }
}

