/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.StringList;

public final class Path
implements IResourcePath {
    private final List folders = new ArrayList();

    public Path() {
    }

    public Path(Folder folder) {
        this.add(folder);
    }

    public Path(Folder[] folders) {
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                this.add(folders[i]);
            }
        }
    }

    public void add(Folder folder) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder " + folder + " does not exist");
        }
        this.folders.add(folder);
    }

    public void add(String path) {
        this.add(new Folder(path));
    }

    public IResourceStream find(Class clazz, String pathname) {
        for (int i = 0; i < this.folders.size(); ++i) {
            Folder folder = (Folder)this.folders.get(i);
            File file = new File(folder, pathname);
            if (!file.exists()) continue;
            return new FileResourceStream(file);
        }
        return null;
    }

    public List getFolders() {
        return this.folders;
    }

    public int size() {
        return this.folders.size();
    }

    public String toString() {
        return "[folders = " + StringList.valueOf(this.folders) + "]";
    }
}

