/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.resource.loader.IStringResourceLoader;

public class BundleStringResourceLoader
implements IStringResourceLoader {
    private final String bundleName;

    public BundleStringResourceLoader(String bundleName) {
        this.bundleName = bundleName;
    }

    public final String loadStringResource(Class clazz, String key, Locale locale, String style) {
        if (locale == null) {
            locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final String loadStringResource(Component component, String key) {
        Locale locale = component != null ? component.getLocale() : null;
        return this.loadStringResource(null, key, locale, null);
    }
}

