/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;
import org.apache.wicket.protocol.http.pagestore.FileChannelPool;
import org.apache.wicket.protocol.http.pagestore.PageWindowManager;
import org.apache.wicket.protocol.http.pagestore.SerializedPagesCache;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskPageStore
extends AbstractPageStore
implements SecondLevelCacheSessionStore.ISerializationAwarePageStore {
    private final int maxSizePerPageMap;
    private final int maxSizePerSession;
    private final FileChannelPool fileChannelPool;
    private final File fileStoreFolder;
    private final String appName;
    private Map sessionIdToEntryMap = new ConcurrentHashMap();
    private final Map pagesToSaveAll = new ConcurrentHashMap();
    private final Map pagesToSaveActive = new ConcurrentHashMap();
    private PageSavingThread pageSavingThread = null;
    private int lastRecentlySerializedPagesCacheSize = 50;
    private final SerializedPagesCache serializedPagesCache = new SerializedPagesCache(this.getLastRecentlySerializedPagesCacheSize());
    private static final Logger log = LoggerFactory.getLogger((Class)DiskPageStore.class);

    private File getStoreFolder() {
        File storeFolder = new File(this.fileStoreFolder, this.appName + "-filestore");
        return storeFolder;
    }

    private File getSessionFolder(String sessionId, boolean create) {
        File storeFolder = this.getStoreFolder();
        sessionId = sessionId.replace('*', '_');
        sessionId = sessionId.replace('/', '_');
        File sessionFolder = new File(storeFolder, sessionId);
        if (create && !sessionFolder.exists()) {
            this.mkdirs(sessionFolder);
        }
        return sessionFolder;
    }

    private void mkdirs(File file) {
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 10; ++i) {
                if (!file.mkdirs()) continue;
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        log.error("Failed to make directory " + file);
    }

    private String getPageMapFileName(String sessionId, String pageMapName, boolean createSessionFolder) {
        File sessionFolder = this.getSessionFolder(sessionId, createSessionFolder);
        return new File(sessionFolder, "pm-" + pageMapName).getAbsolutePath();
    }

    protected int getMaxSizePerPageMap() {
        return this.maxSizePerPageMap;
    }

    protected int getMaxSizePerSession() {
        return this.maxSizePerSession;
    }

    protected File getFileStoreFolder() {
        return this.fileStoreFolder;
    }

    public DiskPageStore(File fileStoreFolder, int maxSizePerPagemap, int maxSizePerSession, int fileChannelPoolCapacity) {
        this.maxSizePerPageMap = maxSizePerPagemap;
        this.maxSizePerSession = maxSizePerSession;
        this.fileChannelPool = new FileChannelPool(fileChannelPoolCapacity);
        this.fileStoreFolder = fileStoreFolder;
        if (maxSizePerSession < this.maxSizePerPageMap) {
            throw new IllegalArgumentException("Provided maximum session size must be bigger than maximum pagemap size");
        }
        this.fileStoreFolder.mkdirs();
        this.appName = Application.get().getApplicationKey();
        this.loadIndex();
        this.initPageSavingThread();
    }

    private void loadIndex() {
        File storeFolder = this.getStoreFolder();
        File index = new File(storeFolder, "DiskPageStoreIndex");
        if (index.exists() && index.length() > 0L) {
            try {
                FileInputStream stream = new FileInputStream(index);
                ObjectInputStream ois = new ObjectInputStream(stream);
                Map map = (Map)ois.readObject();
                this.sessionIdToEntryMap = new ConcurrentHashMap(map);
                Iterator entries = this.sessionIdToEntryMap.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    SessionEntry sessionEntry = (SessionEntry)entry.getValue();
                    sessionEntry.diskPageStore = this;
                }
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                log.error("Couldn't load DiskPageStore index from file " + index + ".", (Throwable)e);
            }
        }
        index.delete();
    }

    private void saveIndex() {
        File storeFolder = this.getStoreFolder();
        if (storeFolder.exists()) {
            File index = new File(storeFolder, "DiskPageStoreIndex");
            index.delete();
            try {
                FileOutputStream stream = new FileOutputStream(index);
                ObjectOutputStream oos = new ObjectOutputStream(stream);
                oos.writeObject(this.sessionIdToEntryMap);
                ((OutputStream)stream).close();
            }
            catch (Exception e) {
                log.error("Couldn't write DiskPageStore index to file " + index + ".", (Throwable)e);
            }
        }
    }

    private static File getDefaultFileStoreFolder() {
        File dir = (File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (dir != null) {
            return dir;
        }
        try {
            return File.createTempFile("file-prefix", null).getParentFile();
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public DiskPageStore(int maxSizePerPagemap, int maxSizePerSession, int fileChannelPoolCapacity) {
        this(DiskPageStore.getDefaultFileStoreFolder(), maxSizePerPagemap, maxSizePerSession, fileChannelPoolCapacity);
    }

    public DiskPageStore() {
        this((int)Bytes.megabytes(10L).bytes(), (int)Bytes.megabytes(100L).bytes(), 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.isSynchronous()) {
            Map map = this.pagesToSaveAll;
            synchronized (map) {
                Iterator i = this.pagesToSaveAll.entrySet().iterator();
                while (i.hasNext()) {
                    List pages;
                    Map.Entry entry = i.next();
                    String sessionId = (String)entry.getKey();
                    List list = pages = (List)entry.getValue();
                    synchronized (list) {
                        this.flushPagesToSaveList(sessionId, pages);
                    }
                }
            }
        }
        this.saveIndex();
        this.fileChannelPool.destroy();
        if (this.pageSavingThread != null) {
            this.pageSavingThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionEntry getSessionEntry(String sessionId, boolean createIfDoesNotExist) {
        SessionEntry entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
        if (entry == null && createIfDoesNotExist) {
            Map map = this.sessionIdToEntryMap;
            synchronized (map) {
                entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
                if (entry == null) {
                    entry = new SessionEntry(this);
                    entry.sessionId = sessionId;
                    this.sessionIdToEntryMap.put(sessionId, entry);
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            byte[] data;
            if (this.isSynchronous()) {
                data = entry.loadPage(pagemap, id, versionNumber, ajaxVersionNumber);
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    data = entry.loadPage(pagemap, id, versionNumber, ajaxVersionNumber);
                }
            }
            if (data != null) {
                return this.deserializePage(data, versionNumber);
            }
        }
        return null;
    }

    public void pageAccessed(String sessionId, Page page) {
    }

    private void removePage(SessionEntry entry, String pageMap, int id) {
        if (id != -1) {
            entry.removePage(pageMap, id);
        } else {
            entry.removePageMap(pageMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(String sessionId, String pageMap, int id) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            if (this.isSynchronous()) {
                this.removePage(entry, pageMap, id);
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    this.removePage(entry, pageMap, id);
                }
            }
        }
    }

    protected void storeSerializedPages(String sessionId, List pages) {
        SessionEntry entry = this.getSessionEntry(sessionId, true);
        if (this.isSynchronous()) {
            Iterator i = pages.iterator();
            while (i.hasNext()) {
                AbstractPageStore.SerializedPage serializedPage = (AbstractPageStore.SerializedPage)i.next();
                entry.savePage(serializedPage);
            }
        } else {
            this.schedulePagesSave(sessionId, pages);
        }
    }

    protected void onPagesSerialized(String sessionId, List pages) {
    }

    public void storePage(String sessionId, Page page) {
        List pages = this.serializePage(page);
        this.serializedPagesCache.storePage(sessionId, page, pages);
        this.onPagesSerialized(sessionId, pages);
        this.storeSerializedPages(sessionId, pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String sessionId) {
        SessionEntry entry = (SessionEntry)this.sessionIdToEntryMap.get(sessionId);
        if (entry != null) {
            if (this.isSynchronous()) {
                entry.unbind();
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    entry.unbind();
                }
                this.pagesToSaveAll.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPagesToSaveList(String sessionId) {
        ArrayList list = (ArrayList)this.pagesToSaveAll.get(sessionId);
        if (list == null) {
            Map map = this.pagesToSaveAll;
            synchronized (map) {
                list = (List)this.pagesToSaveAll.get(sessionId);
                if (list == null) {
                    list = new ArrayList();
                    this.pagesToSaveAll.put(sessionId, list);
                }
            }
        }
        return list;
    }

    protected void flushPagesToSaveList(String sessionId, List list) {
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                try {
                    AbstractPageStore.SerializedPage page = (AbstractPageStore.SerializedPage)i.next();
                    this.getSessionEntry(sessionId, true).savePage(page);
                }
                catch (Exception e) {
                    log.error("Error flushing page", (Throwable)e);
                }
            }
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePagesSave(String sessionId, List pages) {
        List list;
        List list2 = list = this.getPagesToSaveList(sessionId);
        synchronized (list2) {
            list.addAll(pages);
            if (list.size() > 0 && !this.pagesToSaveActive.containsKey(sessionId)) {
                this.pagesToSaveActive.put(sessionId, list);
            }
        }
    }

    private void initPageSavingThread() {
        if (!this.isSynchronous()) {
            this.pageSavingThread = new PageSavingThread();
            Thread t = new Thread((Runnable)this.pageSavingThread, "PageSavingThread-" + this.appName);
            t.setDaemon(true);
            t.setPriority(10);
            t.start();
        }
    }

    protected int getSavingThreadSleepTime() {
        return 100;
    }

    protected boolean isSynchronous() {
        return false;
    }

    public void setLastRecentlySerializedPagesCacheSize(int lastRecentlySerializedPagesCacheSize) {
        this.lastRecentlySerializedPagesCacheSize = lastRecentlySerializedPagesCacheSize;
    }

    protected int getLastRecentlySerializedPagesCacheSize() {
        return this.lastRecentlySerializedPagesCacheSize;
    }

    private SerializedPagesCache.SerializedPageWithSession stripSerializedPage(SerializedPagesCache.SerializedPageWithSession page) {
        ArrayList<AbstractPageStore.SerializedPage> pages = new ArrayList<AbstractPageStore.SerializedPage>(page.pages.size());
        Iterator i = page.pages.iterator();
        while (i.hasNext()) {
            AbstractPageStore.SerializedPage sp = (AbstractPageStore.SerializedPage)i.next();
            pages.add(new AbstractPageStore.SerializedPage(sp.getPageId(), sp.getPageMapName(), sp.getVersionNumber(), sp.getAjaxVersionNumber(), null));
        }
        return new SerializedPagesCache.SerializedPageWithSession(page.sessionId, page.pageId, page.pageMapName, page.versionNumber, page.ajaxVersionNumber, pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPageData(String sessionId, int pageId, String pageMapName, int versionNumber, int ajaxVersionNumber) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            byte[] data;
            if (this.isSynchronous()) {
                data = entry.loadPage(pageMapName, pageId, versionNumber, ajaxVersionNumber);
            } else {
                List pages;
                List list = pages = this.getPagesToSaveList(sessionId);
                synchronized (list) {
                    this.flushPagesToSaveList(sessionId, pages);
                    data = entry.loadPage(pageMapName, pageId, versionNumber, ajaxVersionNumber);
                }
            }
            return data;
        }
        return null;
    }

    private SerializedPagesCache.SerializedPageWithSession restoreStrippedSerializedPage(SerializedPagesCache.SerializedPageWithSession page) {
        ArrayList<AbstractPageStore.SerializedPage> pages = new ArrayList<AbstractPageStore.SerializedPage>(page.pages.size());
        Iterator i = page.pages.iterator();
        while (i.hasNext()) {
            AbstractPageStore.SerializedPage sp = (AbstractPageStore.SerializedPage)i.next();
            byte[] data = this.getPageData(page.sessionId, sp.getPageId(), sp.getPageMapName(), sp.getVersionNumber(), sp.getAjaxVersionNumber());
            pages.add(new AbstractPageStore.SerializedPage(sp.getPageId(), sp.getPageMapName(), sp.getVersionNumber(), sp.getAjaxVersionNumber(), data));
        }
        return new SerializedPagesCache.SerializedPageWithSession(page.sessionId, page.pageId, page.pageMapName, page.versionNumber, page.ajaxVersionNumber, pages);
    }

    public Serializable prepareForSerialization(String sessionId, Object page) {
        SerializedPagesCache.SerializedPageWithSession result = null;
        if (page instanceof Page) {
            result = this.serializedPagesCache.getPage((Page)page);
            if (result == null) {
                List serialized = this.serializePage((Page)page);
                result = this.serializedPagesCache.storePage(sessionId, (Page)page, serialized);
            }
        } else if (page instanceof SerializedPagesCache.SerializedPageWithSession) {
            SerializedPagesCache.SerializedPageWithSession serialized = (SerializedPagesCache.SerializedPageWithSession)page;
            result = serialized.page.get() == SerializedPagesCache.SerializedPageWithSession.NO_PAGE ? this.restoreStrippedSerializedPage(serialized) : serialized;
        }
        if (result != null) {
            return result;
        }
        return (Serializable)page;
    }

    protected boolean storeAfterSessionReplication() {
        return true;
    }

    public Object restoreAfterSerialization(Serializable serializable) {
        if (!this.storeAfterSessionReplication() || serializable instanceof Page) {
            return serializable;
        }
        if (serializable instanceof SerializedPagesCache.SerializedPageWithSession) {
            SerializedPagesCache.SerializedPageWithSession page = (SerializedPagesCache.SerializedPageWithSession)serializable;
            if (page.page == null || page.page.get() != SerializedPagesCache.SerializedPageWithSession.NO_PAGE) {
                this.storeSerializedPages(page.sessionId, page.pages);
                return this.stripSerializedPage(page);
            }
            return page;
        }
        String type = serializable != null ? serializable.getClass().getName() : null;
        throw new IllegalArgumentException("Unknown object type " + type);
    }

    public Page convertToPage(Object page) {
        if (page instanceof Page) {
            return (Page)page;
        }
        if (page instanceof SerializedPagesCache.SerializedPageWithSession) {
            SerializedPagesCache.SerializedPageWithSession serialized = (SerializedPagesCache.SerializedPageWithSession)page;
            if (serialized.page == null || serialized.page.get() != SerializedPagesCache.SerializedPageWithSession.NO_PAGE) {
                this.storeSerializedPages(serialized.sessionId, serialized.pages);
            }
            return this.getPage(serialized.sessionId, serialized.pageMapName, serialized.pageId, serialized.versionNumber, serialized.ajaxVersionNumber);
        }
        String type = page != null ? page.getClass().getName() : null;
        throw new IllegalArgumentException("Unknown object type + type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        SessionEntry entry = this.getSessionEntry(sessionId, false);
        if (entry != null) {
            List pages;
            if (this.isSynchronous()) {
                return entry.exists(pageMapName, pageId, pageVersion);
            }
            List list = pages = this.getPagesToSaveList(sessionId);
            synchronized (list) {
                this.flushPagesToSaveList(sessionId, pages);
                return entry.exists(pageMapName, pageId, pageVersion);
            }
        }
        return false;
    }

    private class PageSavingThread
    implements Runnable {
        private volatile Boolean stop = Boolean.FALSE;

        private PageSavingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.stop == Boolean.FALSE) {
                while (DiskPageStore.this.pagesToSaveActive.isEmpty() && this.stop == Boolean.FALSE) {
                    try {
                        Thread.sleep(DiskPageStore.this.getSavingThreadSleepTime());
                    }
                    catch (InterruptedException ignore) {}
                }
                Iterator i = DiskPageStore.this.pagesToSaveActive.entrySet().iterator();
                while (i.hasNext()) {
                    List pages;
                    Map.Entry entry = i.next();
                    String sessionId = (String)entry.getKey();
                    List list = pages = (List)entry.getValue();
                    synchronized (list) {
                        try {
                            DiskPageStore.this.flushPagesToSaveList(sessionId, pages);
                        }
                        catch (Exception e) {
                            log.error("Error flushing serialized pages from worker thread for session " + sessionId, (Throwable)e);
                        }
                        i.remove();
                    }
                }
            }
            this.stop = null;
        }

        public void stop() {
            if (this.stop == null) {
                return;
            }
            this.stop = Boolean.TRUE;
            while (this.stop != null) {
                try {
                    Thread.sleep(DiskPageStore.this.getSavingThreadSleepTime());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class SessionEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String sessionId;
        private final List pageMapEntryList = new ArrayList();
        private transient DiskPageStore diskPageStore;

        protected SessionEntry(DiskPageStore diskPageStore) {
            this.diskPageStore = diskPageStore;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public int getTotalSize() {
            int result = 0;
            Iterator i = this.pageMapEntryList.iterator();
            while (i.hasNext()) {
                PageMapEntry entry = (PageMapEntry)i.next();
                if (entry.manager == null) continue;
                result += entry.manager.getTotalSize();
            }
            return result;
        }

        public List getPageMapEntryList() {
            return Collections.unmodifiableList(this.pageMapEntryList);
        }

        public PageMapEntry getPageMapEntry(String pageMapName, boolean create) {
            PageMapEntry result = null;
            Iterator i = this.pageMapEntryList.iterator();
            while (i.hasNext()) {
                PageMapEntry entry = (PageMapEntry)i.next();
                if (entry.pageMapName != pageMapName && (entry.pageMapName == null || !entry.pageMapName.equals(pageMapName))) continue;
                result = entry;
            }
            if (result == null && create) {
                result = new PageMapEntry();
                result.pageMapName = pageMapName;
                result.fileName = this.diskPageStore.getPageMapFileName(this.sessionId, pageMapName, true);
                result.manager = new PageWindowManager(this.diskPageStore.getMaxSizePerPageMap());
                this.pageMapEntryList.add(result);
            }
            return result;
        }

        private void removePageMapEntry(PageMapEntry entry) {
            this.diskPageStore.fileChannelPool.closeAndDeleteFileChannel(entry.fileName);
            this.pageMapEntryList.remove(entry);
        }

        public synchronized void removePageMap(String pageMapName) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null) {
                this.removePageMapEntry(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void savePage(AbstractPageStore.SerializedPage page) {
            if (page.getData() != null) {
                PageMapEntry entry = this.getPageMapEntry(page.getPageMapName(), true);
                PageWindowManager.PageWindow window = entry.manager.createPageWindow(page.getPageId(), page.getVersionNumber(), page.getAjaxVersionNumber(), page.getData().length);
                this.pageMapEntryList.remove(entry);
                this.pageMapEntryList.add(entry);
                while (this.getTotalSize() > this.diskPageStore.getMaxSizePerSession() && this.pageMapEntryList.size() > 1) {
                    this.removePageMapEntry((PageMapEntry)this.pageMapEntryList.get(0));
                }
                FileChannel channel = this.diskPageStore.fileChannelPool.getFileChannel(entry.fileName, true);
                try {
                    channel.write(ByteBuffer.wrap(page.getData()), window.getFilePartOffset());
                }
                catch (IOException e) {
                    log.error("Error writing to a channel " + channel, (Throwable)e);
                }
                finally {
                    this.diskPageStore.fileChannelPool.returnFileChannel(channel);
                }
            }
        }

        public synchronized void removePage(String pageMapName, int pageId) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null) {
                entry.manager.removePage(pageId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] loadPage(PageWindowManager.PageWindow window, String pageMapFileName) {
            byte[] result = null;
            FileChannel channel = this.diskPageStore.fileChannelPool.getFileChannel(pageMapFileName, false);
            if (channel != null) {
                ByteBuffer buffer = ByteBuffer.allocate(window.getFilePartSize());
                try {
                    channel.read(buffer, window.getFilePartOffset());
                    if (buffer.hasArray()) {
                        result = buffer.array();
                    }
                }
                catch (IOException e) {
                    log.error("Error reading from file channel " + channel, (Throwable)e);
                }
                finally {
                    this.diskPageStore.fileChannelPool.returnFileChannel(channel);
                }
            }
            return result;
        }

        public synchronized byte[] loadPage(String pageMapName, int id, int versionNumber, int ajaxVersionNumber) {
            PageWindowManager.PageWindow window;
            byte[] result = null;
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            if (entry != null && (window = entry.manager.getPageWindow(id, versionNumber, ajaxVersionNumber)) != null) {
                result = this.loadPage(window, entry.fileName);
            }
            return result;
        }

        public synchronized void unbind() {
            while (this.pageMapEntryList.size() > 0) {
                this.removePageMapEntry((PageMapEntry)this.pageMapEntryList.get(this.pageMapEntryList.size() - 1));
            }
            File sessionFolder = this.diskPageStore.getSessionFolder(this.sessionId, false);
            if (sessionFolder.exists()) {
                sessionFolder.delete();
            }
        }

        public synchronized boolean exists(String pageMapName, int pageId, int versionNumber) {
            PageMapEntry entry = this.getPageMapEntry(pageMapName, false);
            return entry != null && entry.getManager().getPageWindow(pageId, versionNumber, -1) != null;
        }
    }

    protected static class PageMapEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String pageMapName;
        private String fileName;
        private PageWindowManager manager;

        protected PageMapEntry() {
        }

        public String getPageMapName() {
            return this.pageMapName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public PageWindowManager getManager() {
            return this.manager;
        }
    }
}

