/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.wicket.AccessStackPageMap;
import org.apache.wicket.Application;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Request;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.AbstractHttpSessionStore;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebSession;

public class HttpSessionStore
extends AbstractHttpSessionStore {
    public HttpSessionStore(Application application) {
        super(application);
    }

    public IPageMap createPageMap(String name) {
        return new AccessStackPageMap(name);
    }

    public Object getAttribute(Request request, String name) {
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest);
        if (httpSession != null) {
            return httpSession.getAttribute(this.getSessionAttributePrefix(webRequest) + name);
        }
        return null;
    }

    public List getAttributeNames(Request request) {
        ArrayList<String> list = new ArrayList<String>();
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest);
        if (httpSession != null) {
            Enumeration names = httpSession.getAttributeNames();
            String prefix = this.getSessionAttributePrefix(webRequest);
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(prefix)) continue;
                list.add(name.substring(prefix.length()));
            }
        }
        return list;
    }

    public void removeAttribute(Request request, String name) {
        if (!this.isSessionValid()) {
            return;
        }
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest);
        if (httpSession != null) {
            Object value;
            String attributeName = this.getSessionAttributePrefix(webRequest) + name;
            IRequestLogger logger = this.application.getRequestLogger();
            if (logger != null && (value = httpSession.getAttribute(attributeName)) != null) {
                logger.objectRemoved(value);
            }
            httpSession.removeAttribute(attributeName);
        }
    }

    public void setAttribute(Request request, String name, Object value) {
        if (!this.isSessionValid()) {
            return;
        }
        WebRequest webRequest = this.toWebRequest(request);
        HttpSession httpSession = this.getHttpSession(webRequest);
        if (httpSession != null) {
            IRequestLogger logger = this.application.getRequestLogger();
            String attributeName = this.getSessionAttributePrefix(webRequest) + name;
            if (logger != null) {
                if (httpSession.getAttribute(attributeName) == null) {
                    logger.objectCreated(value);
                } else {
                    logger.objectUpdated(value);
                }
            }
            httpSession.setAttribute(attributeName, value);
        }
    }

    private String getSessionAttributePrefix(WebRequest request) {
        return this.application.getSessionAttributePrefix(request);
    }

    private boolean isSessionValid() {
        Session session;
        if (Session.exists() && (session = Session.get()) instanceof WebSession) {
            return !((WebSession)session).isSessionInvalidated();
        }
        return true;
    }
}

