/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.transformer.ITransformer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.response.StringResponse;

public abstract class AbstractOutputTransformerContainer
extends MarkupContainer
implements ITransformer {
    private static final long serialVersionUID = 1L;
    private boolean transformBodyOnly = true;

    public AbstractOutputTransformerContainer(String id) {
        super(id);
    }

    public AbstractOutputTransformerContainer(String id, IModel model) {
        super(id, model);
    }

    public MarkupContainer setTransformBodyOnly(boolean value) {
        this.transformBodyOnly = value;
        return this;
    }

    protected Response newResponse() {
        return new StringResponse();
    }

    public abstract CharSequence transform(Component var1, CharSequence var2) throws Exception;

    protected final void onComponentTagBody(final MarkupStream markupStream, final ComponentTag openTag) {
        if (this.transformBodyOnly) {
            this.execute(new Runnable(){

                public void run() {
                    AbstractOutputTransformerContainer.super.onComponentTagBody(markupStream, openTag);
                }
            });
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }

    protected final void onRender(final MarkupStream markupStream) {
        if (!this.transformBodyOnly) {
            this.execute(new Runnable(){

                public void run() {
                    AbstractOutputTransformerContainer.super.onRender(markupStream);
                }
            });
        } else {
            super.onRender(markupStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execute(Runnable code) {
        Response webResponse = this.getResponse();
        try {
            Response response = this.newResponse();
            if (response == null) {
                throw new IllegalStateException("newResponse() must not return null");
            }
            this.getRequestCycle().setResponse(response);
            code.run();
            try {
                CharSequence output = this.transform(this, response.toString());
                webResponse.write(output);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error while transforming the output: " + this, ex);
            }
        }
        finally {
            this.getRequestCycle().setResponse(webResponse);
        }
    }
}

