/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoLinkResolver
implements IComponentResolver {
    private static final TagReferenceResolver DEFAULT_ATTRIBUTE_RESOLVER = new TagReferenceResolver("href");
    private static final Logger log = LoggerFactory.getLogger((Class)AutoLinkResolver.class);
    private static final long serialVersionUID = 1L;
    private final Map tagNameToAutolinkResolverDelegates = new HashMap();
    private final Map tagNameToTagReferenceResolvers = new HashMap();

    public AutoLinkResolver() {
        TagReferenceResolver hrefTagReferenceResolver = new TagReferenceResolver("href");
        TagReferenceResolver srcTagReferenceResolver = new TagReferenceResolver("src");
        this.tagNameToTagReferenceResolvers.put("a", hrefTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("link", hrefTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("script", srcTagReferenceResolver);
        this.tagNameToTagReferenceResolvers.put("img", srcTagReferenceResolver);
        this.tagNameToAutolinkResolverDelegates.put("a", new AnchorResolverDelegate());
        this.tagNameToAutolinkResolverDelegates.put("link", new ResourceReferenceResolverDelegate("href"));
        this.tagNameToAutolinkResolverDelegates.put("script", new ResourceReferenceResolverDelegate("src"));
        this.tagNameToAutolinkResolverDelegates.put("img", new ResourceReferenceResolverDelegate("src"));
    }

    public final void addTagReferenceResolver(String tagName, String attributeName, IAutolinkResolverDelegate resolver) {
        TagReferenceResolver tagReferenceResolver = new TagReferenceResolver(attributeName);
        this.tagNameToTagReferenceResolvers.put(tagName, tagReferenceResolver);
        this.tagNameToAutolinkResolverDelegates.put(tagName, resolver);
    }

    public final IAutolinkResolverDelegate getAutolinkResolverDelegate(String tagName) {
        return (IAutolinkResolverDelegate)this.tagNameToAutolinkResolverDelegates.get(tagName);
    }

    public final boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag.isAutolinkEnabled()) {
            Component link = this.resolveAutomaticLink(container, "_autolink_", tag);
            container.autoAdd(link, markupStream);
            if (log.isDebugEnabled()) {
                log.debug("Added autolink " + link);
            }
            return true;
        }
        return false;
    }

    private final Component resolveAutomaticLink(MarkupContainer container, String id, ComponentTag tag) {
        ITagReferenceResolver referenceResolver;
        Page page = container.getPage();
        String autoId = id + Integer.toString(page.getAutoIndex());
        String tagName = tag.getName();
        if (tag.getId() == null) {
            tag.setId(autoId);
            tag.setAutoComponentTag(true);
        }
        if ((referenceResolver = (ITagReferenceResolver)this.tagNameToTagReferenceResolvers.get(tagName)) == null) {
            referenceResolver = DEFAULT_ATTRIBUTE_RESOLVER;
        }
        String reference = referenceResolver.getReference(tag);
        PathInfo pathInfo = new PathInfo(reference);
        IAutolinkResolverDelegate autolinkResolverDelegate = (IAutolinkResolverDelegate)this.tagNameToAutolinkResolverDelegates.get(tagName);
        Component autoComponent = null;
        if (autolinkResolverDelegate != null) {
            autoComponent = autolinkResolverDelegate.newAutoComponent(container, autoId, pathInfo);
        }
        if (autoComponent == null) {
            autoComponent = new AutolinkExternalLink(autoId, pathInfo.reference);
        }
        return autoComponent;
    }

    private static final class TagReferenceResolver
    implements ITagReferenceResolver {
        private final String attribute;

        public TagReferenceResolver(String attribute) {
            this.attribute = attribute;
        }

        public String getReference(ComponentTag tag) {
            return tag.getAttributes().getString(this.attribute);
        }
    }

    private static final class ResourceReferenceResolverDelegate
    extends AbstractAutolinkResolverDelegate {
        private final String attribute;

        public ResourceReferenceResolverDelegate(String attribute) {
            this.attribute = attribute;
        }

        public Component newAutoComponent(MarkupContainer container, String autoId, PathInfo pathInfo) {
            return this.newPackageResourceReferenceAutoComponent(container, autoId, pathInfo, this.attribute);
        }
    }

    private static final class ResourceReferenceAutolink
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final String attribute;
        private final ResourceReference resourceReference;

        public ResourceReferenceAutolink(String id, Class clazz, String href, String attribute) {
            super(id);
            this.attribute = attribute;
            this.resourceReference = PackageResource.exists(clazz, href, this.getLocale(), this.getStyle()) ? new ResourceReference(clazz, href, this.getLocale(), this.getStyle()) : null;
        }

        public boolean isTransparentResolver() {
            return true;
        }

        protected final void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (this.resourceReference != null) {
                CharSequence url = this.getRequestCycle().urlFor(this.resourceReference);
                tag.put(this.attribute, Strings.replaceAll(url, "&", "&amp;"));
            }
        }
    }

    private static interface ITagReferenceResolver {
        public String getReference(ComponentTag var1);
    }

    private static final class AutolinkExternalLink
    extends ExternalLink {
        private static final long serialVersionUID = 1L;

        public AutolinkExternalLink(String id, String href) {
            super(id, href);
        }

        public boolean isTransparentResolver() {
            return true;
        }
    }

    private static final class AnchorResolverDelegate
    extends AbstractAutolinkResolverDelegate {
        private static final String attribute = "href";
        private final Set supportedPageExtensions = new HashSet(4);

        public AnchorResolverDelegate() {
            this.supportedPageExtensions.add("html");
            this.supportedPageExtensions.add("xml");
            this.supportedPageExtensions.add("wml");
            this.supportedPageExtensions.add("svg");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Component newAutoComponent(MarkupContainer container, String autoId, PathInfo pathInfo) {
            if (pathInfo.extension == null || !this.supportedPageExtensions.contains(pathInfo.extension)) return this.newPackageResourceReferenceAutoComponent(container, autoId, pathInfo, attribute);
            Page page = container.getPage();
            IClassResolver defaultClassResolver = page.getApplication().getApplicationSettings().getClassResolver();
            String className = Packages.absolutePath(page.getClass(), pathInfo.path);
            if ((className = ((Object)Strings.replaceAll(className, "/", ".")).toString()).startsWith(".")) {
                className = className.substring(1);
            }
            try {
                Class clazz = defaultClassResolver.resolveClass(className);
                return new AutolinkBookmarkablePageLink(autoId, clazz, pathInfo.pageParameters, pathInfo.anchor);
            }
            catch (ClassNotFoundException ex) {
                Class clazz;
                log.warn("Did not find corresponding java class: " + className);
                MarkupContainer parentWithContainer = container;
                if (container.getParent() != null) {
                    parentWithContainer = container.findParentWithAssociatedMarkup();
                }
                if (!(parentWithContainer instanceof Page) || pathInfo.path.startsWith("/") || !page.getMarkupStream().isMergedMarkup() || (clazz = container.getMarkupStream().getTag().getMarkupClass()) == null) return null;
                className = Packages.absolutePath(clazz, pathInfo.path);
                try {
                    clazz = defaultClassResolver.resolveClass(className);
                    return new AutolinkBookmarkablePageLink(autoId, clazz, pathInfo.getPageParameters(), pathInfo.anchor);
                }
                catch (ClassNotFoundException ex2) {
                    log.warn("Did not find corresponding java class: " + className);
                    return null;
                }
            }
        }
    }

    public static final class PathInfo {
        private final boolean absolute;
        private final String anchor;
        private final String extension;
        private final PageParameters pageParameters;
        private final String path;
        private final String reference;

        public PathInfo(String reference) {
            String infoPath;
            this.reference = reference;
            int queryStringPos = reference.indexOf("?");
            if (queryStringPos != -1) {
                String queryString = reference.substring(queryStringPos + 1);
                this.pageParameters = new PageParameters();
                RequestUtils.decodeParameters(queryString, this.pageParameters);
                infoPath = reference.substring(0, queryStringPos);
            } else {
                this.pageParameters = null;
                infoPath = reference;
            }
            this.absolute = infoPath.startsWith("/") || infoPath.startsWith("\\");
            String extension = null;
            int pos = infoPath.lastIndexOf(".");
            if (pos != -1) {
                extension = infoPath.substring(pos + 1);
                infoPath = infoPath.substring(0, pos);
            }
            String anchor = null;
            if (extension != null && (pos = extension.indexOf(35)) != -1) {
                anchor = extension.substring(pos);
                extension = extension.substring(0, pos);
            }
            this.path = infoPath;
            this.extension = extension;
            this.anchor = anchor;
        }

        public final String getAnchor() {
            return this.anchor;
        }

        public final String getExtension() {
            return this.extension;
        }

        public final PageParameters getPageParameters() {
            return this.pageParameters;
        }

        public final String getPath() {
            return this.path;
        }

        public final String getReference() {
            return this.reference;
        }

        public final boolean isAbsolute() {
            return this.absolute;
        }
    }

    public static interface IAutolinkResolverDelegate {
        public Component newAutoComponent(MarkupContainer var1, String var2, PathInfo var3);
    }

    public static final class AutolinkBookmarkablePageLink
    extends BookmarkablePageLink {
        private static final long serialVersionUID = 1L;
        private final String anchor;
        public static boolean autoEnable = true;

        public AutolinkBookmarkablePageLink(String id, Class pageClass, PageParameters parameters, String anchor) {
            super(id, pageClass, parameters);
            this.anchor = anchor;
            this.setAutoEnable(autoEnable);
        }

        public boolean isTransparentResolver() {
            return true;
        }

        protected CharSequence getURL() {
            CharSequence url = super.getURL();
            if (this.anchor != null) {
                url = url + this.anchor;
            }
            return url;
        }
    }

    public static abstract class AbstractAutolinkResolverDelegate
    implements IAutolinkResolverDelegate {
        protected final Component newPackageResourceReferenceAutoComponent(MarkupContainer container, String autoId, PathInfo pathInfo, String attribute) {
            if (!pathInfo.absolute) {
                ResourceReferenceAutolink autoLink;
                Class clazz = container.getMarkupStream().getContainerClass();
                if (container.getMarkupStream().getTag().getMarkupClass() != null) {
                    clazz = container.getMarkupStream().getTag().getMarkupClass();
                }
                if ((autoLink = new ResourceReferenceAutolink(autoId, clazz, pathInfo.reference, attribute)).resourceReference != null) {
                    return autoLink;
                }
            }
            return null;
        }
    }
}

