/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.util.string.Strings;

public class InternalFrame
extends WebMarkupContainer
implements ILinkListener {
    private static final long serialVersionUID = 1L;
    private final IPageLink pageLink;
    private final String pageMapName;

    public InternalFrame(String id, IPageMap pageMap, final Class c) {
        this(id, pageMap, new IPageLink(){
            private static final long serialVersionUID = 1L;

            public Page getPage() {
                return Session.get().getPageFactory().newPage(c);
            }

            public Class getPageIdentity() {
                return c;
            }
        });
        if (!Page.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
        }
    }

    public InternalFrame(String id, IPageMap pageMap, final Page page) {
        this(id, pageMap, new IPageLink(){
            private static final long serialVersionUID = 1L;

            public Page getPage() {
                return page;
            }

            public Class getPageIdentity() {
                return page.getClass();
            }
        });
    }

    public InternalFrame(String id, IPageMap pageMap, IPageLink pageLink) {
        super(id);
        this.pageMapName = pageMap.getName();
        this.pageLink = pageLink;
    }

    protected CharSequence getURL() {
        return this.urlFor(ILinkListener.INTERFACE);
    }

    protected final void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "iframe");
        CharSequence url = this.getURL();
        tag.put("src", Strings.replaceAll(url, "&", "&amp;"));
        super.onComponentTag(tag);
    }

    public final void onLinkClicked() {
        RequestCycle.get().getRequest().getRequestParameters().setPageMapName(this.pageMapName);
        this.setResponsePage(this.pageLink.getPage());
    }

    public final IPageMap getPageMap() {
        return PageMap.forName(this.pageMapName);
    }
}

