/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Resource;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResources {
    private static final Logger log = LoggerFactory.getLogger((Class)SharedResources.class);
    private final Map classAliasMap = new WeakHashMap();
    private final Map aliasClassMap = new HashMap();
    private final Map resourceMap = new HashMap();

    public static String resourceKey(String path, Locale locale, String style) {
        CharSequence parentEscape = Application.get().getResourceSettings().getParentFolderPlaceholder();
        String extension = Files.extension(path);
        String basePath = Files.basePath(path, extension);
        basePath = ((Object)Strings.replaceAll(basePath, "../", parentEscape + "/")).toString();
        AppendingStringBuffer buffer = new AppendingStringBuffer(basePath.length() + 16);
        buffer.append(basePath);
        if (style != null) {
            buffer.append('_');
            buffer.append(style);
        }
        if (locale != null) {
            buffer.append('_');
            boolean l = locale.getLanguage().length() != 0;
            boolean c = locale.getCountry().length() != 0;
            boolean v = locale.getVariant().length() != 0;
            buffer.append(locale.getLanguage());
            if (c || l && v) {
                buffer.append('_').append(locale.getCountry());
            }
            if (v && (l || c)) {
                buffer.append('_').append(locale.getVariant());
            }
        }
        if (extension != null) {
            buffer.append('.');
            buffer.append(extension);
        }
        return buffer.toString();
    }

    SharedResources(Application application) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Class scope, String name, Locale locale, String style, Resource resource) {
        String key = this.resourceKey(scope, name, locale, style);
        Map map = this.resourceMap;
        synchronized (map) {
            Resource value = (Resource)this.resourceMap.get(key);
            if (value == null) {
                this.resourceMap.put(key, resource);
                if (log.isDebugEnabled()) {
                    log.debug("added shared resource " + key);
                }
            }
        }
    }

    public final void add(String name, Locale locale, Resource resource) {
        this.add(Application.class, name, locale, null, resource);
    }

    public final void add(String name, Resource resource) {
        this.add(Application.class, name, null, null, resource);
    }

    public final Resource get(Class scope, String name, Locale locale, String style, boolean exact) {
        String key;
        Resource resource;
        if (locale != null && style != null) {
            String resourceKey = this.resourceKey(scope, name, locale, style);
            resource = this.get(resourceKey);
            if (resource != null) {
                return resource;
            }
            if (exact) {
                return null;
            }
        }
        if (locale != null) {
            key = this.resourceKey(scope, name, locale, null);
            resource = this.get(key);
            if (resource != null) {
                return resource;
            }
            if (exact) {
                return null;
            }
        }
        if (style != null) {
            key = this.resourceKey(scope, name, null, style);
            resource = this.get(key);
            if (resource != null) {
                return resource;
            }
            if (exact) {
                return null;
            }
        }
        key = this.resourceKey(scope, name, null, null);
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Resource get(String key) {
        Map map = this.resourceMap;
        synchronized (map) {
            return (Resource)this.resourceMap.get(key);
        }
    }

    public final void putClassAlias(Class clz, String alias) {
        this.classAliasMap.put(clz, alias);
        this.aliasClassMap.put(alias, new WeakReference<Class>(clz));
    }

    public final Class getAliasClass(String alias) {
        Object classRef = this.aliasClassMap.get(alias);
        if (classRef == null) {
            return null;
        }
        return (Class)((WeakReference)classRef).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(String key) {
        Map map = this.resourceMap;
        synchronized (map) {
            this.resourceMap.remove(key);
        }
    }

    public String resourceKey(Class scope, String path, Locale locale, String style) {
        String alias = (String)this.classAliasMap.get(scope);
        if (alias == null) {
            alias = scope.getName();
        }
        return alias + '/' + SharedResources.resourceKey(path, locale, style);
    }
}

