/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.version.undo.Change;

public abstract class BreadCrumbLink
extends Link {
    private static final long serialVersionUID = 1L;
    private final IBreadCrumbModel breadCrumbModel;

    public BreadCrumbLink(String id, IBreadCrumbModel breadCrumbModel) {
        super(id);
        this.breadCrumbModel = breadCrumbModel;
    }

    public void onClick() {
        final IBreadCrumbParticipant active = this.breadCrumbModel.getActive();
        if (active == null) {
            throw new IllegalStateException("The model has no active bread crumb. Before using " + (Object)((Object)this) + ", you have to have at least one bread crumb in the model");
        }
        IBreadCrumbParticipant participant = this.getParticipant(active.getComponent().getId());
        this.addStateChange(new Change(){
            private static final long serialVersionUID = 1L;

            public void undo() {
                BreadCrumbLink.this.breadCrumbModel.setActive(active);
            }
        });
        this.breadCrumbModel.setActive(participant);
    }

    protected abstract IBreadCrumbParticipant getParticipant(String var1);
}

