package jp.arcanum.myaddress.pages.update;

import java.util.Map;

import jp.arcanum.myaddress.pages.list.ListPage;
import jp.arcanum.myaddress.util.MyUtil;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.Model;

public class DeletePage extends AbstractDetailPage {

	/**
	 * Oij
	 */
	private Label _namekanji = new Label("NAME_KANJI", new Model());
	
	/**
	 * OiJij
	 */
	private Label _namekana = new Label("NAME_KANA", new Model());
	
	/**
	 * X֔ԍiRj
	 */
	private Label _yubinkami = new Label("YUBIN_KAMI", new Model());
	
	/**
	 * X֔ԍiSj
	 */
	private Label _yubinshimo = new Label("YUBIN_SHIMO", new Model());
	
	
	/**
	 * Z
	 */
	private MultiLineLabel _address = new MultiLineLabel("ADDRESS", new Model());
	
	/**
	 * dbԍ
	 */
	private Label _telno = new Label("TEL", new Model());

	/**
	 * e`wԍ
	 */
	private Label _faxno = new Label("FAX", new Model());

	
	/**
	 * 폜{^
	 */
	private Button _delete = new Button("DELETE"){
		public void onSubmit(){
			onClickDelete();
		}
	};
	
	
	/**
	 * RXgN^
	 * @param param y[WԈ
	 *
	 */
	public DeletePage(PageParameters param){
		
		//@Oij
		_form.add(_namekanji);
		
		
		//@OiJij
		_form.add(_namekana);
		
		
		//@X֔ԍiRj
		_form.add(_yubinkami);
		
		
		//@X֔ԍiSj
		_form.add(_yubinshimo);
		
		
		//@Z
		_form.add(_address);
		
		
		//@dbԍ
		_form.add(_telno);
		
		
		//@e`wԍ
		_form.add(_faxno);
		
		
		//@폜{^
		_form.add(_delete);
		
		//@XVΏۂ
		Map target = selectTarget(param.getInt(ADDRID));
		if(target == null){
			error("XVΏۂ̃R[hł܂łB");
			_delete.setVisible(false);
			return;
		}
		setTarget(target);
		
		
		
		//@Oij
		_namekanji.setModelObject(target.get("NAME_KANJI"));
		
		//@OiJij
		_namekana.setModelObject(target.get("NAME_KANA"));
		
		//@X֔ԍ
		String yubin = (String)target.get("YUBIN");
		_yubinkami.setModelObject(yubin.substring(0,3));
		_yubinshimo.setModelObject(yubin.substring(3));
		
		//@Z
		_address.setModelObject(target.get("ADDRESS"));
		
		//@dbԍ
		_telno.setModelObject(target.get("TEL_NO"));
		
		//@e`wԍ
		_faxno.setModelObject(target.get("FAX_NO"));

		
	}
	
	
	
	/**
	 * 폜{^
	 *
	 */
	private void onClickDelete(){
		
		
		//XVΏۂ擾
		Map target = (Map)getTarget();
		
		String sql = "DELETE FROM MYADDRESS WHERE ADDRID=" + target.get("ADDRID"); 
		
		
		int delete = MyUtil.update(sql);
		
		//@ꗗɖ߂
		setResponsePage(ListPage.class);

	}
	
}
