/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.MockWebApplication;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.diff.DiffUtil;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.DummyPanelPage;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.ITestPageSource;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.TestPanelSource;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWicketTester
extends MockWebApplication {
    private static final Logger log = LoggerFactory.getLogger((Class)BaseWicketTester.class);
    static /* synthetic */ Class class$java$lang$String;

    public BaseWicketTester() {
        this(new DummyWebApplication(), null);
    }

    public BaseWicketTester(final Class homePage) {
        this(new WebApplication(){

            public Class getHomePage() {
                return homePage;
            }

            protected void outputDevelopmentModeWarning() {
            }

            protected ISessionStore newSessionStore() {
                return new HttpSessionStore(this);
            }
        }, null);
    }

    public BaseWicketTester(WebApplication application) {
        this(application, null);
    }

    public BaseWicketTester(WebApplication application, String path) {
        super(application, path);
    }

    public final Page startPage(ITestPageSource testPageSource) {
        this.startPage(DummyHomePage.class);
        DummyHomePage page = (DummyHomePage)this.getLastRenderedPage();
        page.setTestPageSource(testPageSource);
        this.executeListener(page.getTestPageLink());
        return this.getLastRenderedPage();
    }

    public void executeListener(Component component) {
        this.setupRequestAndResponse();
        this.getServletRequest().setRequestToComponent(component);
        this.processRequestCycle();
    }

    public void executeBehavior(AbstractAjaxBehavior behavior) {
        WebRequestCycle cycle = this.createRequestCycle();
        CharSequence url = behavior.getCallbackUrl(false);
        this.setupRequestAndResponse(true);
        cycle = this.createRequestCycle();
        this.getServletRequest().setRequestToRedirectString(((Object)url).toString());
        this.processRequestCycle(cycle);
    }

    public final Page startPage(Page page) {
        return this.startPage(new TestPageSource(page));
    }

    public final Page startPage(Class pageClass) {
        this.processRequestCycle(pageClass);
        return this.getLastRenderedPage();
    }

    public final Page startPage(Class pageClass, PageParameters parameters) {
        this.processRequestCycle(pageClass, parameters);
        return this.getLastRenderedPage();
    }

    public FormTester newFormTester(String path) {
        return this.newFormTester(path, true);
    }

    public FormTester newFormTester(String path, boolean fillBlankString) {
        return new FormTester(path, (Form)this.getComponentFromLastRenderedPage(path), this, fillBlankString);
    }

    public final Panel startPanel(final TestPanelSource testPanelSource) {
        return (Panel)this.startPage(new ITestPageSource(){
            private static final long serialVersionUID = 1L;

            public Page getTestPage() {
                return new DummyPanelPage(testPanelSource);
            }
        }).get("panel");
    }

    public final Panel startPanel(final Class panelClass) {
        return (Panel)this.startPage(new ITestPageSource(){
            private static final long serialVersionUID = 1L;

            public Page getTestPage() {
                return new DummyPanelPage(new TestPanelSource(this){
                    private static final long serialVersionUID = 1L;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Panel getTestPanel(String panelId) {
                        try {
                            Constructor<T> c = 3.access$100(this.this$1).getConstructor(class$java$lang$String == null ? (class$java$lang$String = BaseWicketTester.class$("java.lang.String")) : class$java$lang$String);
                            return (Panel)c.newInstance(panelId);
                        }
                        catch (SecurityException e) {
                            throw BaseWicketTester.access$300(3.access$200(this.this$1), e);
                        }
                        catch (NoSuchMethodException e) {
                            throw BaseWicketTester.access$300(3.access$200(this.this$1), e);
                        }
                        catch (InstantiationException e) {
                            throw BaseWicketTester.access$300(3.access$200(this.this$1), e);
                        }
                        catch (IllegalAccessException e) {
                            throw BaseWicketTester.access$300(3.access$200(this.this$1), e);
                        }
                        catch (InvocationTargetException e) {
                            throw BaseWicketTester.access$300(3.access$200(this.this$1), e);
                        }
                    }
                });
            }

            static /* synthetic */ Class access$100(3 x0) {
                return x0.panelClass;
            }

            static /* synthetic */ BaseWicketTester access$200(3 x0) {
                return x0.BaseWicketTester.this;
            }
        }).get("panel");
    }

    public void startComponent(Component component) {
        if (component instanceof FormComponent) {
            ((FormComponent)component).processInput();
        }
        component.beforeRender();
    }

    private RuntimeException convertoUnexpect(Exception e) {
        return new WicketRuntimeException("tester: unexpected", e);
    }

    public Component getComponentFromLastRenderedPage(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
            return component;
        }
        if (component.isVisibleInHierarchy()) {
            return component;
        }
        return null;
    }

    public Result hasLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        return this.isEqual(expectedLabelText, label.getModelObjectAsString());
    }

    public Result isPageLink(String path, Class expectedPageClass) {
        PageLink pageLink = (PageLink)this.getComponentFromLastRenderedPage(path);
        try {
            Field iPageLinkField = pageLink.getClass().getDeclaredField("pageLink");
            iPageLinkField.setAccessible(true);
            IPageLink iPageLink = (IPageLink)iPageLinkField.get(pageLink);
            return this.isEqual(expectedPageClass, iPageLink.getPageIdentity());
        }
        catch (SecurityException e) {
            throw this.convertoUnexpect(e);
        }
        catch (NoSuchFieldException e) {
            throw this.convertoUnexpect(e);
        }
        catch (IllegalAccessException e) {
            throw this.convertoUnexpect(e);
        }
    }

    public Result isComponent(String path, Class expectedComponentClass) {
        Component component = this.getComponentFromLastRenderedPage(path);
        return this.isTrue("component '" + Classes.simpleName(component.getClass()) + "' is not type:" + Classes.simpleName(expectedComponentClass), expectedComponentClass.isAssignableFrom(component.getClass()));
    }

    public Result isVisible(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
        }
        return this.isTrue("component '" + path + "' is not visible", component.isVisibleInHierarchy());
    }

    public Result isInvisible(String path) {
        return this.isNull("component '" + path + "' is visible", this.getComponentFromLastRenderedPage(path));
    }

    public Result ifContains(String pattern) {
        return this.isTrue("pattern '" + pattern + "' not found", this.getServletResponse().getDocument().matches("(?s).*" + pattern + ".*"));
    }

    public void assertListView(String path, List expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void clickLink(String path) {
        this.clickLink(path, true);
    }

    public void clickLink(String path, boolean isAjax) {
        Component linkComponent = this.getComponentFromLastRenderedPage(path);
        if (linkComponent instanceof AjaxLink) {
            if (!isAjax) {
                this.fail("Link " + path + "is an AjaxLink and will " + "not be invoked when AJAX (javascript) is disabled.");
            }
            AjaxLink link = (AjaxLink)linkComponent;
            this.setupRequestAndResponse(true);
            WebRequestCycle requestCycle = this.createRequestCycle();
            BaseWicketTester.callOnBeginRequest(requestCycle);
            AjaxRequestTarget target = new AjaxRequestTarget(link.getPage());
            requestCycle.setRequestTarget(target);
            link.onClick(target);
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof AjaxFallbackLink && isAjax) {
            AjaxFallbackLink link = (AjaxFallbackLink)linkComponent;
            this.setupRequestAndResponse(true);
            WebRequestCycle requestCycle = this.createRequestCycle();
            AjaxRequestTarget target = new AjaxRequestTarget(link.getPage());
            requestCycle.setRequestTarget(target);
            link.onClick(target);
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof AjaxSubmitLink) {
            if (!isAjax) {
                this.fail("Link " + path + "is an AjaxSubmitLink and " + "will not be invoked when AJAX (javascript) is disabled.");
            }
            AjaxSubmitLink link = (AjaxSubmitLink)linkComponent;
            List behaviors = link.getBehaviors();
            AjaxFormSubmitBehavior ajaxFormSubmitBehavior = null;
            Iterator iter = behaviors.iterator();
            while (iter.hasNext()) {
                AjaxFormSubmitBehavior submitBehavior;
                Object behavior = iter.next();
                if (!(behavior instanceof AjaxFormSubmitBehavior)) continue;
                ajaxFormSubmitBehavior = submitBehavior = (AjaxFormSubmitBehavior)behavior;
            }
            String failMessage = "No form submit behavior found on the submit link. Strange!!";
            this.notNull(failMessage, ajaxFormSubmitBehavior);
            this.setupRequestAndResponse(true);
            WebRequestCycle requestCycle = this.createRequestCycle();
            this.submitAjaxFormSubmitBehavior(ajaxFormSubmitBehavior);
            ajaxFormSubmitBehavior.onRequest();
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof SubmitLink) {
            SubmitLink submitLink = (SubmitLink)linkComponent;
            String pageRelativePath = submitLink.getInputName();
            this.getParametersForNextRequest().put(pageRelativePath, "x");
            this.submitForm(submitLink.getForm().getPageRelativePath());
        } else if (linkComponent instanceof AbstractLink) {
            AbstractLink link = (AbstractLink)linkComponent;
            if (link instanceof BookmarkablePageLink) {
                BookmarkablePageLink bookmarkablePageLink = (BookmarkablePageLink)link;
                try {
                    Field parametersField = BookmarkablePageLink.class.getDeclaredField("parameters");
                    Method getParametersMethod = BookmarkablePageLink.class.getDeclaredMethod("getPageParameters", null);
                    getParametersMethod.setAccessible(true);
                    PageParameters parameters = (PageParameters)getParametersMethod.invoke((Object)bookmarkablePageLink, null);
                    this.setParametersForNextRequest(parameters);
                }
                catch (Exception e) {
                    this.fail("Internal error in WicketTester. Please report this in Wickets Issue Tracker.");
                }
            }
            this.executeListener(link);
        } else {
            this.fail("Link " + path + " is not a Link, AjaxLink, AjaxFallbackLink or AjaxSubmitLink");
        }
    }

    public void submitForm(String path) {
        Form form = (Form)this.getComponentFromLastRenderedPage(path);
        this.executeListener(form);
    }

    public void setParameterForNextRequest(String componentPath, Object value) {
        Component c;
        if (this.getLastRenderedPage() == null) {
            this.fail("before using this method, at least one page has to be rendered");
        }
        if ((c = this.getComponentFromLastRenderedPage(componentPath)) == null) {
            this.fail("component " + componentPath + " was not found");
            return;
        }
        if (c instanceof FormComponent) {
            this.getParametersForNextRequest().put(((FormComponent)c).getInputName(), value);
        } else {
            this.getParametersForNextRequest().put(c.getPath(), value);
        }
    }

    public Result isRenderedPage(Class expectedRenderedPageClass) {
        Page page = this.getLastRenderedPage();
        if (page == null) {
            return Result.fail("page was null");
        }
        if (!page.getClass().isAssignableFrom(expectedRenderedPageClass)) {
            return this.isEqual(Classes.simpleName(expectedRenderedPageClass), Classes.simpleName(page.getClass()));
        }
        return Result.pass();
    }

    public void assertResultPage(Class pageClass, String filename) throws Exception {
        String document = this.getServletResponse().getDocument();
        DiffUtil.validatePage(document, pageClass, filename, true);
    }

    public Result isResultPage(String expectedDocument) throws Exception {
        String document = this.getServletResponse().getDocument();
        return this.isTrue("expected rendered page equals", document.equals(expectedDocument));
    }

    public Result hasNoErrorMessage() {
        List messages = this.getMessages(400);
        return this.isTrue("expect no error message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public Result hasNoInfoMessage() {
        List messages = this.getMessages(200);
        return this.isTrue("expect no info message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public List getMessages(final int level) {
        FeedbackMessages feedbackMessages = Session.get().getFeedbackMessages();
        List allMessages = feedbackMessages.messages(new IFeedbackMessageFilter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(FeedbackMessage message) {
                return message.getLevel() == level;
            }
        });
        ArrayList<Serializable> actualMessages = new ArrayList<Serializable>();
        Iterator iter = allMessages.iterator();
        while (iter.hasNext()) {
            actualMessages.add(((FeedbackMessage)iter.next()).getMessage());
        }
        return actualMessages;
    }

    public void dumpPage() {
        log.info(this.getServletResponse().getDocument());
    }

    public void debugComponentTrees() {
        this.debugComponentTrees("");
    }

    public void debugComponentTrees(String filter) {
        log.info("debugging ----------------------------------------------");
        Iterator iter = WicketTesterHelper.getComponentData(this.getLastRenderedPage()).iterator();
        while (iter.hasNext()) {
            WicketTesterHelper.ComponentData obj = (WicketTesterHelper.ComponentData)iter.next();
            if (!obj.path.matches(".*" + filter + ".*")) continue;
            log.info("path\t" + obj.path + " \t" + obj.type + " \t[" + obj.value + "]");
        }
    }

    public Result isComponentOnAjaxResponse(Component component) {
        Result result;
        String failMessage = "A component which is null could not have been added to the AJAX response";
        this.notNull(failMessage, component);
        if (!component.isVisible() && (result = this.isTrue(failMessage = "A component which is invisible and doesn't render a placeholder tag will not be rendered at all and thus won't be accessible for subsequent AJAX interaction", component.getOutputMarkupPlaceholderTag())).wasFailed()) {
            return result;
        }
        failMessage = "The Previous response was not an AJAX response. You need to execute an AJAX event, using clickLink, before using this assert";
        String ajaxResponse = this.getServletResponse().getDocument();
        boolean isAjaxResponse = ajaxResponse.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?><ajax-response>");
        result = this.isTrue(failMessage, isAjaxResponse);
        if (result.wasFailed()) {
            return result;
        }
        failMessage = "The component doesn't have a markup id, which means that it can't have been added to the AJAX response";
        String markupId = component.getMarkupId();
        result = this.isTrue(failMessage, !Strings.isEmpty(markupId));
        if (result.wasFailed()) {
            return result;
        }
        boolean isComponentInAjaxResponse = ajaxResponse.matches("(?s).*<component id=\"" + markupId + "\"[^>]*?>.*");
        failMessage = "Component wasn't found in the AJAX response";
        return this.isTrue(failMessage, isComponentInAjaxResponse);
    }

    public void executeAjaxEvent(String componentPath, String event) {
        Component component = this.getComponentFromLastRenderedPage(componentPath);
        this.executeAjaxEvent(component, event);
    }

    public void executeAjaxEvent(Component component, String event) {
        HttpServletRequest req;
        String failMessage = "Can't execute event on a component which is null.";
        this.notNull(failMessage, component);
        failMessage = "event must not be null";
        this.notNull(failMessage, event);
        AjaxEventBehavior ajaxEventBehavior = null;
        List behaviors = component.getBehaviors();
        Iterator iter = behaviors.iterator();
        while (iter.hasNext()) {
            AjaxEventBehavior tmp;
            IBehavior behavior = (IBehavior)iter.next();
            if (!(behavior instanceof AjaxEventBehavior) || !event.equals((tmp = (AjaxEventBehavior)behavior).getEvent())) continue;
            ajaxEventBehavior = tmp;
        }
        failMessage = "No AjaxEventBehavior found on component: " + component.getId() + " which matches the event: " + event;
        this.notNull(failMessage, ajaxEventBehavior);
        WebRequestCycle requestCycle = RequestCycle.get() == null ? this.setupRequestAndResponse(true) : (WebRequestCycle)RequestCycle.get();
        if (!requestCycle.getWebRequest().isAjax() && (req = requestCycle.getWebRequest().getHttpServletRequest()) instanceof MockHttpServletRequest) {
            ((MockHttpServletRequest)req).addHeader("Wicket-Ajax", "Yes");
        }
        if (ajaxEventBehavior instanceof AjaxFormSubmitBehavior) {
            AjaxFormSubmitBehavior ajaxFormSubmitBehavior = (AjaxFormSubmitBehavior)ajaxEventBehavior;
            this.submitAjaxFormSubmitBehavior(ajaxFormSubmitBehavior);
        }
        ajaxEventBehavior.onRequest();
        this.processRequestCycle(requestCycle);
    }

    public TagTester getTagByWicketId(String wicketId) {
        return TagTester.createTagByAttribute(this.getServletResponse().getDocument(), "wicket:id", wicketId);
    }

    public TagTester getTagById(String id) {
        return TagTester.createTagByAttribute(this.getServletResponse().getDocument(), "id", id);
    }

    private void submitAjaxFormSubmitBehavior(AjaxFormSubmitBehavior behavior) {
        Form form = null;
        try {
            Field formField = AjaxFormSubmitBehavior.class.getDeclaredField("form");
            formField.setAccessible(true);
            form = (Form)formField.get(behavior);
        }
        catch (Exception e) {
            this.fail(e.getMessage());
        }
        String failMessage = "No form attached to the submitlink.";
        this.notNull(failMessage, form);
        form.visitFormComponents(new FormComponent.AbstractVisitor(){

            public void onFormComponent(FormComponent formComponent) {
                if (!(formComponent instanceof RadioGroup) && !(formComponent instanceof CheckGroup)) {
                    String name = formComponent.getInputName();
                    String value = formComponent.getValue();
                    if (BaseWicketTester.this.getServletRequest().getParameterMap().get(name) == null) {
                        BaseWicketTester.this.getServletRequest().setParameter(name, value);
                    }
                }
            }
        });
    }

    public String getContentTypeFromResponseHeader() {
        String contentType = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Type");
        if (contentType == null) {
            throw new WicketRuntimeException("No Content-Type header found");
        }
        return contentType;
    }

    public int getContentLengthFromResponseHeader() {
        String contentLength = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Length");
        if (contentLength == null) {
            throw new WicketRuntimeException("No Content-Length header found");
        }
        return Integer.parseInt(contentLength);
    }

    public String getLastModifiedFromResponseHeader() {
        return ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Last-Modified");
    }

    public String getContentDispositionFromResponseHeader() {
        return ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Disposition");
    }

    private Result isTrue(String message, boolean condition) {
        if (condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    private Result isEqual(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return Result.pass();
        }
        if (expected != null && expected.equals(actual)) {
            return Result.pass();
        }
        String message = "expected:<" + expected + "> but was:<" + actual + ">";
        return Result.fail(message);
    }

    private void notNull(String message, Object object) {
        if (object == null) {
            this.fail(message);
        }
    }

    private Result isNull(String message, Object object) {
        if (object != null) {
            return Result.fail(message);
        }
        return Result.pass();
    }

    private void fail(String message) {
        throw new WicketRuntimeException(message);
    }

    public static void callOnBeginRequest(RequestCycle rc) {
        try {
            Method method = RequestCycle.class.getDeclaredMethod("onBeginRequest", null);
            method.setAccessible(true);
            method.invoke((Object)rc, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception invoking requestcycle.onbeginrequest()", e);
        }
    }

    static /* synthetic */ RuntimeException access$300(BaseWicketTester x0, Exception x1) {
        return x0.convertoUnexpect(x1);
    }

    public static class DummyWebApplication
    extends WebApplication {
        public Class getHomePage() {
            return class$org$apache$wicket$util$tester$DummyHomePage == null ? (class$org$apache$wicket$util$tester$DummyHomePage = BaseWicketTester.class$("org.apache.wicket.util.tester.DummyHomePage")) : class$org$apache$wicket$util$tester$DummyHomePage;
        }

        protected void outputDevelopmentModeWarning() {
        }

        protected ISessionStore newSessionStore() {
            return new HttpSessionStore(this);
        }
    }

    private static final class TestPageSource
    implements ITestPageSource {
        private final Page page;
        private static final long serialVersionUID = 1L;

        private TestPageSource(Page page) {
            this.page = page;
        }

        public Page getTestPage() {
            return this.page;
        }
    }
}

