/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import org.apache.wicket.Application;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.SharedResources;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class CompressedPackageResource
extends PackageResource {
    private static final long serialVersionUID = 1L;
    private final IResourceStream resourceStream = this.newResourceStream();

    public static PackageResource get(Class scope, String path, Locale locale, String style) {
        SharedResources sharedResources = Application.get().getSharedResources();
        PackageResource resource = (PackageResource)sharedResources.get(scope, path, locale, style, true);
        if (resource == null) {
            resource = new CompressedPackageResource(scope, path, locale, style);
            sharedResources.add(scope, path, locale, style, resource);
        }
        return resource;
    }

    protected CompressedPackageResource(Class scope, String path, Locale locale, String style) {
        super(scope, path, locale, style);
    }

    protected IResourceStream newResourceStream() {
        return new CompressingResourceStream(){
            private static final long serialVersionUID = 1L;

            protected IResourceStream getOriginalResourceStream() {
                return CompressedPackageResource.this.getPackageResourceStream();
            }
        };
    }

    protected IResourceStream getPackageResourceStream() {
        return CompressedPackageResource.super.getResourceStream();
    }

    public IResourceStream getResourceStream() {
        return this.resourceStream;
    }

    private boolean supportsCompression() {
        if (Application.get().getResourceSettings().getDisableGZipCompression()) {
            return false;
        }
        WebRequest request = (WebRequest)RequestCycle.get().getRequest();
        String s = request.getHttpServletRequest().getHeader("Accept-Encoding");
        if (s == null) {
            return false;
        }
        return s.indexOf("gzip") >= 0;
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (this.supportsCompression()) {
            response.setHeader("Content-Encoding", "gzip");
        }
    }

    protected abstract class CompressingResourceStream
    implements IResourceStream {
        private static final long serialVersionUID = 1L;
        private transient SoftReference cache = new SoftReference<Object>(null);
        private Time timeStamp = null;

        protected CompressingResourceStream() {
        }

        public void close() throws IOException {
        }

        public String getContentType() {
            return this.getOriginalResourceStream().getContentType();
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            if (CompressedPackageResource.this.supportsCompression()) {
                return new ByteArrayInputStream(this.getCompressedContent());
            }
            return this.getOriginalResourceStream().getInputStream();
        }

        public Locale getLocale() {
            return this.getOriginalResourceStream().getLocale();
        }

        public Time lastModifiedTime() {
            return this.getOriginalResourceStream().lastModifiedTime();
        }

        public long length() {
            if (CompressedPackageResource.this.supportsCompression()) {
                return this.getCompressedContent().length;
            }
            return this.getOriginalResourceStream().length();
        }

        public void setLocale(Locale locale) {
            this.getOriginalResourceStream().setLocale(locale);
        }

        private byte[] getCompressedContent() {
            IResourceStream stream = this.getOriginalResourceStream();
            try {
                byte[] ret;
                if (this.cache != null && (ret = (byte[])this.cache.get()) != null && this.timeStamp != null && this.timeStamp.equals(stream.lastModifiedTime())) {
                    return ret;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                GZIPOutputStream zout = new GZIPOutputStream(out);
                Streams.copy(stream.getInputStream(), zout);
                zout.close();
                stream.close();
                ret = out.toByteArray();
                this.timeStamp = stream.lastModifiedTime();
                this.cache = new SoftReference<byte[]>(ret);
                return ret;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract IResourceStream getOriginalResourceStream();
    }
}

