/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IComponentSource;
import org.apache.wicket.IComponentSourceProvider;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupContainer
extends Component {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)MarkupContainer.class);
    private Object children;
    private transient MarkupStream markupStream;

    public MarkupContainer(String id) {
        super(id);
    }

    public MarkupContainer(String id, IModel model) {
        super(id, model);
    }

    public final MarkupContainer add(Component child) {
        this.checkHierarchyChange(child);
        if (child == null) {
            throw new IllegalArgumentException("argument child may not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Add " + child.getId() + " to " + this);
        }
        this.addedComponent(child);
        if (this.put(child) != null) {
            throw new IllegalArgumentException(this.exceptionMessage("A child with id '" + child.getId() + "' already exists"));
        }
        return this;
    }

    public final MarkupContainer addOrReplace(Component child) {
        this.checkHierarchyChange(child);
        if (child == null) {
            throw new IllegalArgumentException("argument child must be not null");
        }
        if (this.get(child.getId()) == null) {
            this.add(child);
        } else {
            this.replace(child);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean autoAdd(Component component, MarkupStream markupStream) {
        if (component == null) {
            throw new IllegalArgumentException("argument component may not be null");
        }
        component.setAuto(true);
        int index = this.children_indexOf(component);
        if (index >= 0) {
            this.children_remove(index);
        }
        this.add(component);
        component.prepareForRender();
        try {
            if (markupStream == null) {
                component.render();
            } else {
                component.render(markupStream);
            }
        }
        finally {
            component.afterRender();
        }
        return true;
    }

    public final boolean autoAdd(Component component) {
        return this.autoAdd(component, null);
    }

    public final boolean contains(Component component, boolean recurse) {
        if (component == null) {
            throw new IllegalArgumentException("argument component may not be null");
        }
        if (recurse) {
            Component current = component;
            while (current != null) {
                MarkupContainer parent = current.getParent();
                if (parent == this) {
                    return true;
                }
                current = parent;
            }
            return false;
        }
        return component.getParent() == this;
    }

    public final Component get(String path) {
        if (path == null || path.trim().equals("")) {
            return this;
        }
        String id = Strings.firstPathComponent(path, ':');
        Component child = this.children_get(id);
        if (child == null && this.isTransparentResolver() && this.getParent() != null) {
            child = this.getParent().get(path);
        }
        if (child != null) {
            String path2 = Strings.afterFirstPathComponent(path, ':');
            return child.get(path2);
        }
        return child;
    }

    public MarkupStream getAssociatedMarkupStream(boolean throwException) {
        try {
            return this.getApplication().getMarkupSettings().getMarkupCache().getMarkupStream(this, false, throwException);
        }
        catch (MarkupException ex) {
            throw ex;
        }
        catch (WicketRuntimeException ex) {
            throw new MarkupNotFoundException(this.exceptionMessage("Markup of type '" + this.getMarkupType() + "' for component '" + this.getClass().getName() + "' not found." + " Enable debug messages for org.apache.wicket.util.resource to get a list of all filenames tried"), ex);
        }
    }

    public final MarkupStream getMarkupStream() {
        return this.markupStream;
    }

    public String getMarkupType() {
        return this.getPage().getMarkupType();
    }

    public void internalAdd(Component child) {
        if (log.isDebugEnabled()) {
            log.debug("internalAdd " + child.getId() + " to " + this);
        }
        this.addedComponent(child);
        this.put(child);
    }

    public boolean isTransparentResolver() {
        return false;
    }

    public final Iterator iterator() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < MarkupContainer.this.children_size();
            }

            public Object next() {
                return MarkupContainer.this.children_get(this.index++);
            }

            public void remove() {
                Component removed = MarkupContainer.this.children_remove(--this.index);
                MarkupContainer.this.checkHierarchyChange(removed);
                MarkupContainer.this.removedComponent(removed);
            }
        };
    }

    public final Iterator iterator(Comparator comparator) {
        List<Object> sorted;
        if (this.children == null) {
            sorted = Collections.EMPTY_LIST;
        } else if (this.children instanceof Component) {
            sorted = new ArrayList<Object>(1);
            sorted.add(this.children);
        } else {
            sorted = this.children instanceof ChildList ? new ArrayList((ChildList)this.children) : Arrays.asList((Component[])this.children);
        }
        Collections.sort(sorted, comparator);
        return sorted.iterator();
    }

    public final IResourceStream newMarkupResourceStream(Class containerClass) {
        throw new IllegalStateException("this method is not used any more (and shouldn't be called by clients anyway)");
    }

    public void remove(Component component) {
        this.checkHierarchyChange(component);
        if (component == null) {
            throw new IllegalArgumentException("argument component may not be null");
        }
        this.children_remove(component);
        this.removedComponent(component);
    }

    public final void remove(String id) {
        if (id == null) {
            throw new IllegalArgumentException("argument id may not be null");
        }
        Component component = this.get(id);
        if (component == null) {
            throw new WicketRuntimeException("Unable to find a component with id '" + id + "' to remove");
        }
        this.remove(component);
    }

    public final void removeAll() {
        if (this.children != null) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                final Object removedChildren;
                {
                    this.removedChildren = MarkupContainer.this.children;
                }

                public String toString() {
                    return "RemoveAllChange[component: " + MarkupContainer.this.getPath() + ", removed Children: " + this.removedChildren + "]";
                }

                public void undo() {
                    MarkupContainer.this.children = this.removedChildren;
                    int size = MarkupContainer.this.children_size();
                    for (int i = 0; i < size; ++i) {
                        Component child = MarkupContainer.this.children_get(i);
                        child.setParent(MarkupContainer.this);
                    }
                }
            });
            int size = this.children_size();
            for (int i = 0; i < size; ++i) {
                Object childObject = this.children_get(i, false);
                if (!(childObject instanceof Component)) continue;
                Component child = (Component)childObject;
                child.detachModel();
                child.setParent(null);
            }
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderAssociatedMarkup(String openTagName, String exceptionMessage) {
        MarkupStream originalMarkupStream = this.getMarkupStream();
        MarkupStream associatedMarkupStream = this.getAssociatedMarkupStream(true);
        associatedMarkupStream.skipUntil(openTagName);
        this.setMarkupStream(associatedMarkupStream);
        ComponentTag associatedMarkupOpenTag = associatedMarkupStream.getTag();
        if (associatedMarkupOpenTag == null || !associatedMarkupOpenTag.isOpen() || !(associatedMarkupOpenTag instanceof WicketTag)) {
            associatedMarkupStream.throwMarkupException(exceptionMessage);
        }
        try {
            this.setIgnoreAttributeModifier(true);
            this.renderComponentTag(associatedMarkupOpenTag);
            associatedMarkupStream.next();
            if (this.getApplication().getDebugSettings().isOutputMarkupContainerClassName()) {
                this.getResponse().write("<!-- MARKUP FOR ");
                this.getResponse().write(this.getClass().getName());
                this.getResponse().write(" BEGIN -->");
            }
            this.renderComponentTagBody(associatedMarkupStream, associatedMarkupOpenTag);
            if (this.getApplication().getDebugSettings().isOutputMarkupContainerClassName()) {
                this.getResponse().write("<!-- MARKUP FOR ");
                this.getResponse().write(this.getClass().getName());
                this.getResponse().write(" END -->");
            }
            this.renderClosingComponentTag(associatedMarkupStream, associatedMarkupOpenTag, false);
            this.setMarkupStream(originalMarkupStream);
        }
        finally {
            this.setIgnoreAttributeModifier(false);
        }
    }

    public final MarkupContainer replace(Component child) {
        this.checkHierarchyChange(child);
        if (child == null) {
            throw new IllegalArgumentException("argument child must be not null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Replacing " + child.getId() + " in " + this);
        }
        if (child.getParent() != this) {
            Component replaced = this.put(child);
            if (replaced == null) {
                throw new WicketRuntimeException(this.exceptionMessage("Cannot replace a component which has not been added: id='" + child.getId() + "', component=" + child));
            }
            this.removedComponent(replaced);
            this.addedComponent(child);
            child.markupIndex = replaced.markupIndex;
            child.setMarkupIdImpl(replaced.getMarkupIdImpl());
        }
        return this;
    }

    public Component setModel(final IModel model) {
        final IModel previous = this.getModelImpl();
        super.setModel(model);
        if (previous instanceof IComponentInheritedModel) {
            this.visitChildren(new Component.IVisitor(){

                public Object component(Component component) {
                    IModel compModel = component.getModel();
                    if (compModel instanceof IWrapModel) {
                        compModel = ((IWrapModel)compModel).getWrappedModel();
                    }
                    if (compModel == previous) {
                        component.setModel(null);
                    } else if (compModel == model) {
                        component.modelChanged();
                    }
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
        }
        return this;
    }

    public final int size() {
        return this.children_size();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MarkupContainer ");
        buffer.append(super.toString(true));
        if (detailed) {
            if (this.getMarkupStream() != null) {
                buffer.append(", markupStream = " + this.getMarkupStream());
            }
            if (this.children_size() != 0) {
                buffer.append(", children = ");
                int size = this.children_size();
                for (int i = 0; i < size; ++i) {
                    Component child = this.children_get(i);
                    if (i != 0) {
                        buffer.append(' ');
                    }
                    buffer.append(child.toString());
                }
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public final Object visitChildren(Class clazz, Component.IVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("argument visitor may not be null");
        }
        for (int i = 0; i < this.children_size(); ++i) {
            Component child = this.children_get(i);
            Object value = null;
            if ((clazz == null || clazz.isInstance(child)) && (value = visitor.component(child)) != Component.IVisitor.CONTINUE_TRAVERSAL && value != Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER) {
                return value;
            }
            if (!(child instanceof MarkupContainer) || value == Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER || (value = ((MarkupContainer)child).visitChildren(clazz, visitor)) == Component.IVisitor.CONTINUE_TRAVERSAL || value == Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER) continue;
            return value;
        }
        return null;
    }

    public final Object visitChildren(Component.IVisitor visitor) {
        return this.visitChildren(null, visitor);
    }

    private final void addedComponent(Component component) {
        if (component == this) {
            throw new IllegalArgumentException("Component can't be added to itself");
        }
        MarkupContainer parent = component.getParent();
        if (parent != null) {
            parent.remove(component);
        }
        component.setParent(this);
        Page page = this.findPage();
        IDebugSettings debugSettings = Application.get().getDebugSettings();
        if (debugSettings.isLinePreciseReportingOnAddComponentEnabled()) {
            component.setMetaData(ADDED_AT_KEY, (Serializable)((Object)Strings.toString(component, new MarkupException("added"))));
        }
        if (page != null) {
            page.componentAdded(component);
        }
        if (this.isPreparedForRender()) {
            component.beforeRender();
        }
    }

    private final void children_add(Component child) {
        if (this.children == null) {
            this.children = child;
        } else {
            if (!(this.children instanceof ChildList)) {
                this.children = new ChildList(this.children);
            }
            ((ChildList)this.children).add(child);
        }
    }

    private final Component children_get(int index) {
        return (Component)this.children_get(index, true);
    }

    private final Object postprocess(Object object, boolean reconstruct, MarkupContainer parent, int index) {
        if (reconstruct && object instanceof ComponentSourceEntry) {
            object = ((ComponentSourceEntry)object).reconstruct(parent, index);
        }
        return object;
    }

    private final Object children_get(int index, boolean reconstruct) {
        Object component = null;
        if (this.children != null) {
            if (!(this.children instanceof Object[]) && !(this.children instanceof ChildList)) {
                if (index != 0) {
                    throw new ArrayIndexOutOfBoundsException("index " + index + " is greater then 0");
                }
                component = this.postprocess(this.children, reconstruct, this, 0);
                if (this.children != component) {
                    this.children = component;
                }
            } else {
                Object[] children = null;
                children = this.children instanceof ChildList ? ((ChildList)this.children).childs : (Object[])this.children;
                if (children[index] != (component = this.postprocess(children[index], reconstruct, this, index))) {
                    children[index] = component;
                }
            }
        }
        return component;
    }

    private final String getId(Object object) {
        if (object instanceof Component) {
            return ((Component)object).getId();
        }
        if (object instanceof ComponentSourceEntry) {
            return ((ComponentSourceEntry)object).id;
        }
        throw new IllegalArgumentException("Unknown type of object " + object);
    }

    private final Component children_get(String id) {
        Component component;
        block5: {
            block4: {
                if (this.children == null) {
                    return null;
                }
                component = null;
                if (this.children instanceof Object[] || this.children instanceof List) break block4;
                if (!this.getId(this.children).equals(id) || this.children == (component = (Component)this.postprocess(this.children, true, this, 0))) break block5;
                this.children = component;
                break block5;
            }
            Object[] children = null;
            int size = 0;
            if (this.children instanceof ChildList) {
                children = ((ChildList)this.children).childs;
                size = ((ChildList)this.children).size;
            } else {
                children = (Object[])this.children;
                size = children.length;
            }
            for (int i = 0; i < size; ++i) {
                if (!this.getId(children[i]).equals(id)) continue;
                component = (Component)this.postprocess(children[i], true, this, i);
                if (children[i] == component) break;
                children[i] = component;
                break;
            }
        }
        return component;
    }

    private final int children_indexOf(Component child) {
        if (this.children == null) {
            return -1;
        }
        if (!(this.children instanceof Object[]) && !(this.children instanceof ChildList)) {
            if (this.getId(this.children).equals(child.getId())) {
                return 0;
            }
        } else {
            Object[] children;
            int size = 0;
            if (this.children instanceof Object[]) {
                children = (Object[])this.children;
                size = children.length;
            } else {
                children = ((ChildList)this.children).childs;
                size = ((ChildList)this.children).size;
            }
            for (int i = 0; i < size; ++i) {
                if (!this.getId(children[i]).equals(child.getId())) continue;
                return i;
            }
        }
        return -1;
    }

    private final Component children_remove(Component component) {
        int index = this.children_indexOf(component);
        if (index != -1) {
            return this.children_remove(index);
        }
        return null;
    }

    private final Component children_remove(int index) {
        Object removed;
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof Component || this.children instanceof ComponentSourceEntry) {
            if (index == 0) {
                Component removed2 = (Component)this.postprocess(this.children, true, null, -1);
                this.children = null;
                return removed2;
            }
            throw new IndexOutOfBoundsException();
        }
        if (this.children instanceof Object[]) {
            Object[] c = (Object[])this.children;
            removed = c[index];
            if (c.length == 2) {
                if (index == 0) {
                    this.children = c[1];
                } else if (index == 1) {
                    this.children = c[0];
                } else {
                    throw new IndexOutOfBoundsException();
                }
                return (Component)this.postprocess(removed, true, null, -1);
            }
            this.children = new ChildList(this.children);
        }
        ChildList lst = (ChildList)this.children;
        removed = lst.remove(index);
        if (lst.size == 1) {
            this.children = lst.get(0);
        }
        return (Component)this.postprocess(removed, true, null, -1);
    }

    /*
     * WARNING - void declaration
     */
    private final Object children_set(int index, Object child, boolean reconstruct) {
        void var4_4;
        if (index >= 0 && index < this.children_size()) {
            Object replaced;
            if (this.children instanceof Component || this.children instanceof ComponentSourceEntry) {
                replaced = this.children;
                this.children = child;
            } else if (this.children instanceof ChildList) {
                replaced = ((ChildList)this.children).set(index, child);
            } else {
                Object[] children = (Object[])this.children;
                replaced = children[index];
                children[index] = child;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this.postprocess(var4_4, reconstruct, null, -1);
    }

    private final Component children_set(int index, Component child) {
        return (Component)this.children_set(index, child, true);
    }

    private final int children_size() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof Component || this.children instanceof ComponentSourceEntry) {
            return 1;
        }
        if (this.children instanceof ChildList) {
            return ((ChildList)this.children).size;
        }
        return ((Object[])this.children).length;
    }

    private final Component put(Component child) {
        int index = this.children_indexOf(child);
        if (index == -1) {
            this.children_add(child);
            return null;
        }
        return this.children_set(index, child);
    }

    private final void removedComponent(Component component) {
        Page page = component.findPage();
        if (page != null) {
            page.componentRemoved(component);
        }
        component.detach();
        component.setParent(null);
    }

    private final void renderNext(MarkupStream markupStream) {
        MarkupElement element = markupStream.get();
        if (element instanceof ComponentTag && !markupStream.atCloseTag()) {
            ComponentTag tag = (ComponentTag)element;
            String id = tag.getId();
            Component component = this.get(id);
            if (component != null) {
                component.render(markupStream);
            } else {
                for (MarkupContainer container = this; container != null; container = container.findParent(class$org$apache$wicket$MarkupContainer == null ? MarkupContainer.class$("org.apache.wicket.MarkupContainer") : class$org$apache$wicket$MarkupContainer)) {
                    if (!(container instanceof IComponentResolver) || !((IComponentResolver)((Object)container)).resolve(this, markupStream, tag)) continue;
                    return;
                }
                List componentResolvers = this.getApplication().getPageSettings().getComponentResolvers();
                Iterator iterator = componentResolvers.iterator();
                while (iterator.hasNext()) {
                    IComponentResolver resolver = (IComponentResolver)iterator.next();
                    if (!resolver.resolve(this, markupStream, tag)) continue;
                    return;
                }
                if (tag instanceof WicketTag) {
                    if (((WicketTag)tag).isChildTag()) {
                        markupStream.throwMarkupException("Found " + tag.toString() + " but no <wicket:extend>");
                    } else {
                        markupStream.throwMarkupException("Failed to handle: " + tag.toString());
                    }
                }
                markupStream.throwMarkupException("Unable to find component with id '" + id + "' in " + this + ". This means that you declared wicket:id=" + id + " in your markup, but that you either did not add the " + "component to your page at all, or that the hierarchy does not match.");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Rendering raw markup");
            }
            this.getResponse().write(element.toCharSequence());
            markupStream.next();
        }
    }

    protected final MarkupStream findMarkupStream() {
        MarkupContainer c = this;
        while (c.getMarkupStream() == null) {
            if ((c = c.getParent()) != null) continue;
            throw new WicketRuntimeException(this.exceptionMessage("No markup found"));
        }
        return c.getMarkupStream();
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderComponentTagBody(markupStream, openTag);
    }

    protected void onRender(MarkupStream markupStream) {
        this.renderComponent(markupStream);
    }

    protected void renderAll(MarkupStream markupStream) {
        while (markupStream.hasMore()) {
            int index = markupStream.getCurrentIndex();
            this.renderNext(markupStream);
            if (index != markupStream.getCurrentIndex()) continue;
            markupStream.throwMarkupException("Component at markup stream index " + index + " failed to advance the markup stream");
        }
    }

    protected final void renderComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        ComponentTag origOpenTag;
        if (markupStream != null && markupStream.getCurrentIndex() > 0 && (origOpenTag = (ComponentTag)markupStream.get(markupStream.getCurrentIndex() - 1)).isOpenClose()) {
            return;
        }
        boolean render = openTag.requiresCloseTag();
        if (!render) {
            boolean bl = render = !openTag.hasNoCloseTag();
        }
        if (render) {
            while (markupStream.hasMore() && !markupStream.get().closes(openTag)) {
                int index = markupStream.getCurrentIndex();
                this.renderNext(markupStream);
                if (index != markupStream.getCurrentIndex()) continue;
                markupStream.throwMarkupException("Markup element at index " + index + " failed to advance the markup stream");
            }
        }
    }

    protected final void setMarkupStream(MarkupStream markupStream) {
        this.markupStream = markupStream;
    }

    void detachChildren() {
        super.detachChildren();
        int i = this.children_size();
        while (i-- > 0) {
            Object child = this.children_get(i, false);
            if (!(child instanceof Component)) continue;
            Component component = (Component)child;
            component.detach();
            if (child instanceof IComponentSourceProvider) {
                ComponentSourceEntry entry = new ComponentSourceEntry(this, component, ((IComponentSourceProvider)child).getComponentSource());
                this.children_set(i, entry, false);
                continue;
            }
            if (!component.isAuto()) continue;
            this.children_remove(i);
        }
        if (this.children instanceof ChildList) {
            ChildList lst = (ChildList)this.children;
            Object[] tmp = new Object[lst.size];
            System.arraycopy(lst.childs, 0, tmp, 0, lst.size);
            this.children = tmp;
        }
    }

    void internalMarkRendering() {
        super.internalMarkRendering();
        int size = this.children_size();
        for (int i = 0; i < size; ++i) {
            Component child = this.children_get(i);
            child.internalMarkRendering();
        }
    }

    private Component[] copyChildren() {
        int size = this.children_size();
        Component[] result = new Component[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.children_get(i);
        }
        return result;
    }

    void onBeforeRenderChildren() {
        super.onBeforeRenderChildren();
        Component[] children = this.copyChildren();
        try {
            for (int i = 0; i < children.length; ++i) {
                Component child = children[i];
                if (child.getParent() != this) continue;
                child.beforeRender();
            }
        }
        catch (RuntimeException ex) {
            if (ex instanceof WicketRuntimeException) {
                throw ex;
            }
            throw new WicketRuntimeException("Error attaching this container for rendering: " + this, ex);
        }
    }

    void onAfterRenderChildren() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Component child = (Component)iter.next();
            child.afterRender();
        }
        super.onAfterRenderChildren();
    }

    public boolean hasAssociatedMarkup() {
        return this.getApplication().getMarkupSettings().getMarkupCache().hasAssociatedMarkup(this);
    }

    void setRenderAllowed() {
        super.setRenderAllowed();
        this.visitChildren(new Component.IVisitor(){

            public Object component(Component component) {
                boolean renderAllowed = component.isActionAuthorized(Component.RENDER);
                component.setRenderAllowed(renderAllowed);
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    private static class ChildList
    extends AbstractList
    implements IClusterable {
        private static final long serialVersionUID = -7861580911447631127L;
        private int size;
        private Object[] childs;

        public ChildList(Object children) {
            if (children instanceof Object[]) {
                this.childs = (Object[])children;
                this.size = this.childs.length;
            } else {
                this.childs = new Object[3];
                this.add(children);
            }
        }

        public Object get(int index) {
            return this.childs[index];
        }

        public int size() {
            return this.size;
        }

        public boolean add(Object o) {
            this.ensureCapacity(this.size + 1);
            this.childs[this.size++] = o;
            return true;
        }

        public void add(int index, Object element) {
            if (index > this.size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            this.ensureCapacity(this.size + 1);
            System.arraycopy(this.childs, index, this.childs, index + 1, this.size - index);
            this.childs[index] = element;
            ++this.size;
        }

        public Object set(int index, Object element) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            Object oldValue = this.childs[index];
            this.childs[index] = element;
            return oldValue;
        }

        public Object remove(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            Object oldValue = this.childs[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.childs, index + 1, this.childs, index, numMoved);
            }
            this.childs[--this.size] = null;
            return oldValue;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.childs.length;
            if (minCapacity > oldCapacity) {
                Object[] oldData = this.childs;
                int newCapacity = oldCapacity * 2;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.childs = new Object[newCapacity];
                System.arraycopy(oldData, 0, this.childs, 0, this.size);
            }
        }
    }

    private static class ComponentSourceEntry
    extends org.apache.wicket.ComponentSourceEntry {
        private static final long serialVersionUID = 1L;

        private ComponentSourceEntry(MarkupContainer container, Component component, IComponentSource componentSource) {
            super(container, component, componentSource);
        }

        protected void setChild(MarkupContainer parent, int index, Component child) {
            parent.children_set(index, child, false);
        }
    }
}

