/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyResolver {
    private static final int RETURN_NULL = 0;
    private static final int CREATE_NEW_VALUE = 1;
    private static final int RESOLVE_CLASS = 2;
    private static final Map applicationToClassesToGetAndSetters = new ConcurrentHashMap(2);
    private static final Logger log = LoggerFactory.getLogger((Class)PropertyResolver.class);
    static /* synthetic */ Class class$java$lang$Object;

    public static final Object getValue(String expression, Object object) {
        if (expression == null || expression.equals("") || object == null) {
            return object;
        }
        ObjectAndGetSetter getter = PropertyResolver.getObjectAndGetSetter(expression, object, 0);
        if (getter == null) {
            return null;
        }
        return getter.getValue();
    }

    public static final void setValue(String expression, Object object, Object value, PropertyResolverConverter converter) {
        if (expression == null || expression.equals("")) {
            throw new WicketRuntimeException("Empty expression setting value: " + value + " on object: " + object);
        }
        if (object == null) {
            throw new WicketRuntimeException("Attempted to set property value on a null object. Property expression: " + expression + " Value: " + value);
        }
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 1);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for setting value: " + value + " on: " + object);
        }
        setter.setValue(value, converter == null ? new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale()) : converter);
    }

    public static final Class getPropertyClass(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target classs of: " + object);
        }
        return setter.getTargetClass();
    }

    public static final Field getPropertyField(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target classs of: " + object);
        }
        return setter.getField();
    }

    public static final Method getPropertyGetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target classs of: " + object);
        }
        return setter.getGetter();
    }

    public static final Method getPropertySetter(String expression, Object object) {
        ObjectAndGetSetter setter = PropertyResolver.getObjectAndGetSetter(expression, object, 2);
        if (setter == null) {
            throw new WicketRuntimeException("Null object returned for expression: " + expression + " for getting the target classs of: " + object);
        }
        return setter.getSetter();
    }

    private static ObjectAndGetSetter getObjectAndGetSetter(String expression, Object object, int tryToCreateNull) {
        IGetAndSet getAndSetter;
        String expressionBracketsSeperated = ((Object)Strings.replaceAll(expression, "[", ".[")).toString();
        int index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, 0);
        int lastIndex = 0;
        Object value = object;
        Class clz = value.getClass();
        String exp = expressionBracketsSeperated;
        while (index != -1) {
            exp = expressionBracketsSeperated.substring(lastIndex, index);
            getAndSetter = null;
            try {
                getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
            }
            catch (WicketRuntimeException ex) {
                index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, index + 1);
                if (index == -1) {
                    exp = expressionBracketsSeperated.substring(lastIndex);
                    break;
                }
                String indexExpression = expressionBracketsSeperated.substring(lastIndex, index);
                getAndSetter = PropertyResolver.getGetAndSetter(indexExpression, clz);
            }
            Object newValue = null;
            if (value != null) {
                newValue = getAndSetter.getValue(value);
            }
            if (newValue == null) {
                if (tryToCreateNull == 1) {
                    newValue = getAndSetter.newValue(value);
                    if (newValue == null) {
                        return null;
                    }
                } else if (tryToCreateNull == 2) {
                    clz = getAndSetter.getTargetClass();
                } else {
                    return null;
                }
            }
            if ((value = newValue) != null) {
                clz = value.getClass();
            }
            if ((index = PropertyResolver.getNextDotIndex(expressionBracketsSeperated, lastIndex = index + 1)) != -1) continue;
            exp = expressionBracketsSeperated.substring(lastIndex);
            break;
        }
        getAndSetter = PropertyResolver.getGetAndSetter(exp, clz);
        return new ObjectAndGetSetter(getAndSetter, value);
    }

    private static int getNextDotIndex(String expression, int start) {
        boolean insideBracket = false;
        for (int i = start; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '.' && !insideBracket) {
                return i;
            }
            if (ch == '[') {
                insideBracket = true;
                continue;
            }
            if (ch != ']') continue;
            insideBracket = false;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final IGetAndSet getGetAndSetter(String exp, Class clz) {
        IGetAndSet getAndSetter;
        Map classesToGetAndSetters = PropertyResolver.getClassesToGetAndSetters();
        Map getAndSetters = (Map)classesToGetAndSetters.get(clz);
        if (getAndSetters == null) {
            getAndSetters = new ConcurrentHashMap(8);
            classesToGetAndSetters.put(clz, getAndSetters);
        }
        if ((getAndSetter = (IGetAndSet)getAndSetters.get(exp)) != null) return getAndSetter;
        Method method = null;
        Field field = null;
        if (exp.startsWith("[")) {
            exp = exp.substring(1, exp.length() - 1);
        } else {
            method = exp.endsWith("()") ? PropertyResolver.findMethod(clz, exp) : PropertyResolver.findGetter(clz, exp);
        }
        if (method == null) {
            if (List.class.isAssignableFrom(clz)) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ListGetSet(index);
                }
                catch (NumberFormatException ex) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method != null) {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), null);
                    }
                    field = PropertyResolver.findField(clz, exp);
                    if (field == null) throw new WicketRuntimeException("The expression '" + exp + "' is neither an index nor is it a method or field for the list " + clz);
                    getAndSetter = new FieldGetAndSetter(field);
                }
            } else if (Map.class.isAssignableFrom(clz)) {
                getAndSetter = new MapGetSet(exp);
            } else if (clz.isArray()) {
                try {
                    int index = Integer.parseInt(exp);
                    getAndSetter = new ArrayGetSet(clz.getComponentType(), index);
                }
                catch (NumberFormatException ex) {
                    if (!exp.equals("length") && !exp.equals("size")) throw new WicketRuntimeException("can't parse the exp " + exp + " as an index for an array lookup");
                    getAndSetter = new ArrayLengthGetSet();
                }
            } else {
                field = PropertyResolver.findField(clz, exp);
                if (field == null) {
                    method = PropertyResolver.findMethod(clz, exp);
                    if (method == null) {
                        int index = exp.indexOf(46);
                        if (index == -1) throw new WicketRuntimeException("No get method defined for class: " + clz + " expression: " + exp);
                        String propertyName = exp.substring(0, index);
                        String propertyIndex = exp.substring(index + 1);
                        try {
                            int parsedIndex = Integer.parseInt(propertyIndex);
                            String name = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                            method = clz.getMethod("get" + name, Integer.TYPE);
                            getAndSetter = new ArrayPropertyGetSet(method, parsedIndex);
                        }
                        catch (Exception e) {
                            throw new WicketRuntimeException("no get method defined for class: " + clz + " expression: " + propertyName);
                        }
                    } else {
                        getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), field);
                    }
                } else {
                    getAndSetter = new FieldGetAndSetter(field);
                }
            }
        } else {
            field = PropertyResolver.findField(clz, exp);
            getAndSetter = new MethodGetAndSet(method, MethodGetAndSet.findSetter(method, clz), field);
        }
        getAndSetters.put(exp, getAndSetter);
        return getAndSetter;
    }

    private static Field findField(Class clz, String expression) {
        Field field = null;
        try {
            field = clz.getField(expression);
        }
        catch (Exception e) {
            for (Class tmp = clz; tmp != null && tmp != (class$java$lang$Object == null ? PropertyResolver.class$("java.lang.Object") : class$java$lang$Object); tmp = tmp.getSuperclass()) {
                Field[] fields = tmp.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].getName().equals(expression)) continue;
                    fields[i].setAccessible(true);
                    return fields[i];
                }
            }
            log.debug("Cannot find field " + clz + "." + expression);
        }
        return field;
    }

    private static final Method findGetter(Class clz, String expression) {
        String name = Character.toUpperCase(expression.charAt(0)) + expression.substring(1);
        Method method = null;
        try {
            method = clz.getMethod("get" + name, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clz.getMethod("is" + name, null);
            }
            catch (Exception e) {
                log.debug("Cannot find getter " + clz + "." + expression);
            }
        }
        return method;
    }

    private static final Method findMethod(Class clz, String expression) {
        if (expression.endsWith("()")) {
            expression = expression.substring(0, expression.length() - 2);
        }
        Method method = null;
        try {
            method = clz.getMethod(expression, null);
        }
        catch (Exception e) {
            log.debug("Cannot find method " + clz + "." + expression);
        }
        return method;
    }

    private PropertyResolver() {
    }

    private static Map getClassesToGetAndSetters() {
        Object key = null;
        key = Application.exists() ? Application.get() : PropertyResolver.class;
        Map result = (Map)applicationToClassesToGetAndSetters.get(key);
        if (result == null) {
            result = new ConcurrentHashMap(64);
            applicationToClassesToGetAndSetters.put(key, result);
        }
        return result;
    }

    public static void destroy(Application application) {
        applicationToClassesToGetAndSetters.remove(application);
    }

    private static class FieldGetAndSetter
    extends AbstractGetAndSet {
        private final Field field;

        public FieldGetAndSetter(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        public Object getValue(Object object) {
            try {
                return this.field.get(object);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error getting field value of field " + this.field + " from object " + object, ex);
            }
        }

        public Object newValue(Object object) {
            Class<?> clz = this.field.getType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.field.set(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set field " + this.field + " to " + value, (Throwable)e);
            }
            return value;
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.field.getType());
            try {
                this.field.set(object, value);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error setting field value of field " + this.field + " on object " + object + ", value " + value, ex);
            }
        }

        public Class getTargetClass() {
            return this.field.getType();
        }

        public Field getField() {
            return this.field;
        }
    }

    private static final class MethodGetAndSet
    extends AbstractGetAndSet {
        private final Method getMethod;
        private final Method setMethod;
        private final Field field;

        MethodGetAndSet(Method getMethod, Method setMethod, Field field) {
            this.getMethod = getMethod;
            this.getMethod.setAccessible(true);
            this.field = field;
            this.setMethod = setMethod;
        }

        public final Object getValue(Object object) {
            Object ret = null;
            try {
                ret = this.getMethod.invoke(object, null);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        public final void setValue(Object object, Object value, PropertyResolverConverter converter) {
            if (this.setMethod != null) {
                Object converted = converter.convert(value, this.getMethod.getReturnType());
                if (converted == null) {
                    if (value != null) {
                        throw new ConversionException("Can't convert value: " + value + " to class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                    }
                    if (this.getMethod.getReturnType().isPrimitive()) {
                        throw new ConversionException("Can't convert null value to a primitive class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                    }
                }
                try {
                    this.setMethod.invoke(object, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("no set method defined for value: " + value + " on object: " + object);
            }
        }

        private static final Method findSetter(Method getMethod, Class clz) {
            String name = getMethod.getName();
            name = name.startsWith("get") ? "set" + name.substring(3) : "set" + name.substring(2);
            try {
                Method method = clz.getMethod(name, getMethod.getReturnType());
                if (method != null) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                Method[] methods = clz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] parameterTypes;
                    if (!methods[i].getName().equals(name) || (parameterTypes = methods[i].getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(getMethod.getReturnType())) continue;
                    return methods[i];
                }
                log.debug("Cannot find setter corresponding to " + getMethod);
            }
            catch (Exception e) {
                log.debug("Cannot find setter corresponding to " + getMethod);
            }
            return null;
        }

        public Object newValue(Object object) {
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.setMethod.invoke(object, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value, (Throwable)e);
            }
            return value;
        }

        public Class getTargetClass() {
            return this.getMethod.getReturnType();
        }

        public Method getGetter() {
            return this.getMethod;
        }

        public Method getSetter() {
            return this.setMethod;
        }

        public Field getField() {
            return this.field;
        }
    }

    private static final class ArrayPropertyGetSet
    extends AbstractGetAndSet {
        private final Integer index;
        private final Method getMethod;
        private Method setMethod;

        ArrayPropertyGetSet(Method method, int index) {
            this.index = new Integer(index);
            this.getMethod = method;
        }

        private static final Method findSetter(Method getMethod, Class clz) {
            String name = getMethod.getName();
            name = "set" + name.substring(3);
            try {
                return clz.getMethod(name, Integer.TYPE, getMethod.getReturnType());
            }
            catch (Exception e) {
                log.debug("Cannot find setter method corresponding to " + getMethod);
                return null;
            }
        }

        public Object getValue(Object object) {
            Object ret = null;
            try {
                ret = this.getMethod.invoke(object, this.index);
            }
            catch (InvocationTargetException ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex.getCause());
            }
            catch (Exception ex) {
                throw new WicketRuntimeException("Error calling index property method: " + this.getMethod + " on object: " + object, ex);
            }
            return ret;
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            if (this.setMethod == null) {
                this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod != null) {
                Object converted = converter.convert(value, this.getMethod.getReturnType());
                if (converted == null && value != null) {
                    throw new ConversionException("Can't convert value: " + value + " to class: " + this.getMethod.getReturnType() + " for setting it on " + object);
                }
                try {
                    this.setMethod.invoke(object, this.index, converted);
                }
                catch (InvocationTargetException ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex.getCause());
                }
                catch (Exception ex) {
                    throw new WicketRuntimeException("Error index property calling method: " + this.setMethod + " on object: " + object, ex);
                }
            } else {
                throw new WicketRuntimeException("no set method defined for value: " + value + " on object: " + object);
            }
        }

        public Class getTargetClass() {
            return this.getMethod.getReturnType();
        }

        public Object newValue(Object object) {
            if (this.setMethod == null) {
                this.setMethod = ArrayPropertyGetSet.findSetter(this.getMethod, object.getClass());
            }
            if (this.setMethod == null) {
                log.warn("Null setMethod");
                return null;
            }
            Class<?> clz = this.getMethod.getReturnType();
            Object value = null;
            try {
                value = clz.newInstance();
                this.setMethod.invoke(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value + " at index " + this.index, (Throwable)e);
            }
            return value;
        }
    }

    private static final class ArrayLengthGetSet
    extends AbstractGetAndSet {
        ArrayLengthGetSet() {
        }

        public Object getValue(Object object) {
            return new Integer(Array.getLength(object));
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            throw new WicketRuntimeException("Cant set the length on an array");
        }

        public Object newValue(Object object) {
            throw new WicketRuntimeException("Cant get a new value from a length of an array");
        }

        public Class getTargetClass() {
            return Integer.TYPE;
        }
    }

    private static final class ArrayGetSet
    extends AbstractGetAndSet {
        private final int index;
        private final Class clzComponentType;

        ArrayGetSet(Class clzComponentType, int index) {
            this.clzComponentType = clzComponentType;
            this.index = index;
        }

        public Object getValue(Object object) {
            return Array.get(object, this.index);
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            value = converter.convert(value, this.clzComponentType);
            Array.set(object, this.index, value);
        }

        public Object newValue(Object object) {
            Object value = null;
            try {
                value = this.clzComponentType.newInstance();
                Array.set(object, this.index, value);
            }
            catch (Exception e) {
                log.warn("Cannot set new value " + value + " at index " + this.index + " for array holding elements of class " + this.clzComponentType, (Throwable)e);
            }
            return value;
        }

        public Class getTargetClass() {
            return this.clzComponentType;
        }
    }

    private static final class ListGetSet
    extends AbstractGetAndSet {
        private final int index;

        ListGetSet(int index) {
            this.index = index;
        }

        public Object getValue(Object object) {
            return ((List)object).get(this.index);
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            List lst = (List)object;
            if (lst.size() > this.index) {
                lst.set(this.index, value);
            } else if (lst.size() == this.index) {
                lst.add(value);
            } else {
                while (lst.size() < this.index) {
                    lst.add(null);
                }
                lst.add(value);
            }
        }

        public Object newValue(Object object) {
            return null;
        }
    }

    private static final class MapGetSet
    extends AbstractGetAndSet {
        private final String key;

        MapGetSet(String key) {
            this.key = key;
        }

        public Object getValue(Object object) {
            return ((Map)object).get(this.key);
        }

        public void setValue(Object object, Object value, PropertyResolverConverter converter) {
            ((Map)object).put(this.key, value);
        }

        public Object newValue(Object object) {
            return null;
        }
    }

    private static abstract class AbstractGetAndSet
    implements IGetAndSet {
        private AbstractGetAndSet() {
        }

        public Field getField() {
            return null;
        }

        public Method getGetter() {
            return null;
        }

        public Method getSetter() {
            return null;
        }

        public Class getTargetClass() {
            return null;
        }
    }

    private static interface IGetAndSet {
        public Object getValue(Object var1);

        public Class getTargetClass();

        public Object newValue(Object var1);

        public void setValue(Object var1, Object var2, PropertyResolverConverter var3);

        public Field getField();

        public Method getGetter();

        public Method getSetter();
    }

    private static final class ObjectAndGetSetter {
        private final IGetAndSet getAndSetter;
        private final Object value;

        public ObjectAndGetSetter(IGetAndSet getAndSetter, Object value) {
            this.getAndSetter = getAndSetter;
            this.value = value;
        }

        public void setValue(Object value, PropertyResolverConverter converter) {
            this.getAndSetter.setValue(this.value, value, converter);
        }

        public Object getValue() {
            return this.getAndSetter.getValue(this.value);
        }

        public Class getTargetClass() {
            return this.getAndSetter.getTargetClass();
        }

        public Field getField() {
            return this.getAndSetter.getField();
        }

        public Method getGetter() {
            return this.getAndSetter.getGetter();
        }

        public Method getSetter() {
            return this.getAndSetter.getSetter();
        }
    }
}

