/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.wicket.AbortException;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;

public final class DefaultPageFactory
implements IPageFactory {
    private final Map constructorForClass = new ConcurrentHashMap();

    public final Page newPage(Class pageClass) {
        try {
            Constructor constructor = pageClass.getConstructor(null);
            return this.newPage(constructor, null);
        }
        catch (NoSuchMethodException e) {
            Constructor constructor = this.constructor(pageClass, PageParameters.class);
            if (constructor != null) {
                return this.newPage(constructor, (Object)new PageParameters());
            }
            throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does not have a default contructor", e);
        }
    }

    public final Page newPage(Class pageClass, PageParameters parameters) {
        Constructor constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            return this.newPage(constructor, (Object)parameters);
        }
        return this.newPage(pageClass);
    }

    private final Constructor constructor(Class pageClass, Class argumentType) {
        Constructor constructor = (Constructor)this.constructorForClass.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getConstructor(argumentType);
                this.constructorForClass.put(pageClass, constructor);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return constructor;
    }

    private final Page newPage(Constructor constructor, Object argument) {
        try {
            if (argument != null) {
                return (Page)constructor.newInstance(argument);
            }
            return (Page)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AbortException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
    }

    private String createDescription(Constructor constructor, Object argument) {
        if (argument != null) {
            return "Can't instantiate page using constructor " + constructor + " and argument " + argument;
        }
        return "Can't instantiate page using constructor " + constructor;
    }
}

