/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;

public final class WicketMessageTagHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final String WICKET_MESSAGE_ATTRIBUTE_NAME = "wicket:message";
    public static final String WICKET_MESSAGE_CONTAINER_ID = "_message_attr_";
    public static final IBehavior ATTRIBUTE_LOCALIZER = new AttributeLocalizer();

    public final MarkupElement nextTag() throws ParseException {
        ComponentTag tag = this.nextComponentTag();
        if (tag == null || tag.isClose()) {
            return tag;
        }
        String wicketMessageAttribute = tag.getAttributes().getString(WICKET_MESSAGE_ATTRIBUTE_NAME);
        if (wicketMessageAttribute != null && wicketMessageAttribute.trim().length() > 0) {
            if (tag.getId() == null) {
                tag.setId(WICKET_MESSAGE_CONTAINER_ID);
                tag.setAutoComponentTag(true);
                tag.setModified(true);
            }
            tag.addBehavior(new AttributeLocalizer());
        }
        return tag;
    }

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (WICKET_MESSAGE_CONTAINER_ID.equals(tag.getId())) {
            Component wc = null;
            wc = tag.isOpenClose() ? new WebComponent(WICKET_MESSAGE_CONTAINER_ID + container.getPage().getAutoIndex()) : new WebMarkupContainer(WICKET_MESSAGE_CONTAINER_ID + container.getPage().getAutoIndex());
            container.autoAdd(wc, markupStream);
            return true;
        }
        return false;
    }

    public static class AttributeLocalizer
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;

        public void onComponentTag(Component component, ComponentTag tag) {
            String expr = tag.getAttributes().getString(WicketMessageTagHandler.WICKET_MESSAGE_ATTRIBUTE_NAME);
            if (!Strings.isEmpty(expr)) {
                expr = expr.trim();
                String[] attrsAndKeys = expr.split(",");
                for (int i = 0; i < attrsAndKeys.length; ++i) {
                    String attrAndKey = attrsAndKeys[i];
                    int colon = attrAndKey.lastIndexOf(":");
                    if (attrAndKey.length() < 3 || colon < 1 || colon > attrAndKey.length() - 2) {
                        throw new WicketRuntimeException("wicket:message attribute contains an invalid value [[" + expr + "]], must be of form (attr:key)+");
                    }
                    String attr = attrAndKey.substring(0, colon);
                    String key = attrAndKey.substring(colon + 1);
                    String value = tag.getAttributes().containsKey(attr) ? component.getString(key, null, tag.getAttributes().getString(attr)) : component.getString(key);
                    tag.put(attr, value);
                }
            }
        }
    }
}

