/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Collection;
import org.apache.wicket.RequestContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;

public class Check
extends LabeledWebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_DISABLED = "disabled";
    private short uuid = (short)-1;

    public Check(String id) {
        super(id);
    }

    public Check(String id, IModel model) {
        super(id, model);
    }

    public final String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "check" + this.uuid;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        CheckGroup group = (CheckGroup)this.findParent(CheckGroup.class);
        if (group == null) {
            throw new WicketRuntimeException("Check component [" + this.getPath() + "] cannot find its parent CheckGroup");
        }
        String uuid = this.getValue();
        tag.put("name", group.getInputName());
        tag.put("value", uuid);
        Collection collection = (Collection)group.getModelObject();
        if (collection == null) {
            throw new WicketRuntimeException("CheckGroup [" + group.getPath() + "] contains a null model object, must be an object of type java.util.Collection");
        }
        if (group.hasRawInput()) {
            String[] input = group.getInputAsArray();
            if (input != null) {
                for (int i = 0; i < input.length; ++i) {
                    if (!uuid.equals(input[i])) continue;
                    tag.put("checked", "checked");
                }
            }
        } else if (collection.contains(this.getModelObject())) {
            tag.put("checked", "checked");
        }
        if (group.wantOnSelectionChangedNotifications()) {
            CharSequence url = group.urlFor(IOnChangeListener.INTERFACE);
            Form form = (Form)group.findParent(Form.class);
            if (form != null) {
                RequestContext rc = RequestContext.get();
                if (rc.isPortletRequest()) {
                    url = ((PortletRequestContext)rc).getLastEncodedPath();
                }
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&amp;" : "?") + group.getInputName() + "=' + this.value;");
            }
        }
        if (!(this.isActionAuthorized(ENABLE) && this.isEnabled() && group.isEnabled())) {
            tag.put(ATTR_DISABLED, ATTR_DISABLED);
        }
    }

    public Check setLabel(IModel labelModel) {
        this.setLabelInternal(labelModel);
        return this;
    }
}

