/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Util;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static final int MAX_CODE_POINT = 0x10FFFF;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int n, int n2, int n3) {
        super(source, n, n2);
        this.codePoint = n3;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(charSequence.length() * 2), charSequence, false).toString();
    }

    public static String encode(char c) {
        return CharacterReference.appendEncode(new StringBuffer(MAX_ENTITY_REFERENCE_LENGTH), c).toString();
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(charSequence.length() * 2), charSequence, true).toString();
    }

    public static String decode(CharSequence charSequence) {
        return CharacterReference.decode(charSequence, false, false);
    }

    public static String decode(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(charSequence, bl, false);
    }

    private static String decode(CharSequence charSequence, boolean bl, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '&') continue;
            return CharacterReference.appendDecode(new StringBuffer(charSequence.length()), charSequence, i, bl, bl2).toString();
        }
        return ((Object)charSequence).toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence charSequence) {
        return CharacterReference.decodeCollapseWhiteSpace(charSequence, false);
    }

    static String decodeCollapseWhiteSpace(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuffer(charSequence.length()), charSequence), false, bl);
    }

    public static String reencode(CharSequence charSequence) {
        return CharacterReference.encode(CharacterReference.decode(charSequence, true));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int n) {
        String string = null;
        if (n != 39) {
            string = CharacterEntityReference.getCharacterReferenceString(n);
        }
        if (string == null) {
            string = NumericCharacterReference.getCharacterReferenceString(n);
        }
        return string;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int n) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int n) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int n) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), n).toString();
    }

    static final StringBuffer appendUnicodeText(StringBuffer stringBuffer, int n) {
        stringBuffer.append("U+");
        String string = Integer.toString(n, 16).toUpperCase();
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static CharacterReference parse(CharSequence charSequence) {
        return CharacterReference.construct(new Source(((Object)charSequence).toString()), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence charSequence) {
        CharacterReference characterReference = CharacterReference.parse(charSequence);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char c) {
        return c > '\u007f' || CharacterEntityReference.getName(c) != null && (c != '\'' || Config.IsApostropheEncoded);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    private static StringBuffer appendEncode(StringBuffer stringBuffer, char c) {
        if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(stringBuffer, c, false)) {
            return stringBuffer;
        }
        return stringBuffer.append(c);
    }

    static StringBuffer appendEncode(StringBuffer stringBuffer, CharSequence charSequence, boolean bl) {
        int n;
        if (charSequence == null) {
            return stringBuffer;
        }
        int n2 = 0;
        int n3 = charSequence.length();
        if (charSequence instanceof Segment) {
            Segment segment = (Segment)charSequence;
            n2 = n = segment.getBegin();
            n3 += n;
            charSequence = segment.source.string;
        }
        boolean bl2 = Config.IsApostropheEncoded;
        for (n = n2; n < n3; ++n) {
            int n4;
            char c = charSequence.charAt(n);
            if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(stringBuffer, c, bl)) continue;
            int n5 = n + 1;
            if (c != ' ') {
                if (c != '\t') {
                    if (c == '\r' && n5 < n3 && charSequence.charAt(n5) == '\n') {
                        ++n;
                    }
                    stringBuffer.append("<br />");
                    continue;
                }
                n4 = 4;
            } else {
                n4 = 1;
            }
            while (n5 < n3) {
                c = charSequence.charAt(n5);
                if (c == ' ') {
                    ++n4;
                } else {
                    if (c != '\t') break;
                    n4 += 4;
                }
                ++n5;
            }
            if (n4 == 1) {
                stringBuffer.append(' ');
                continue;
            }
            if (n4 % 2 == 1) {
                stringBuffer.append(' ');
            }
            while (n4 >= 2) {
                stringBuffer.append("&nbsp; ");
                n4 -= 2;
            }
            n = n5 - 1;
        }
        return stringBuffer;
    }

    private static final boolean appendEncodeCheckForWhiteSpaceFormatting(StringBuffer stringBuffer, char c, boolean bl) {
        String string = CharacterEntityReference.getName(c);
        if (string != null) {
            if (c == '\'') {
                if (Config.IsApostropheEncoded) {
                    stringBuffer.append("&#39;");
                } else {
                    stringBuffer.append(c);
                }
            } else {
                CharacterEntityReference.appendCharacterReferenceString(stringBuffer, string);
            }
        } else if (c > '\u007f') {
            CharacterReference.appendDecimalCharacterReferenceString(stringBuffer, c);
        } else if (!bl || !CharacterReference.isWhiteSpace(c)) {
            stringBuffer.append(c);
        } else {
            return false;
        }
        return true;
    }

    static CharacterReference findPreviousOrNext(Source source, int n, boolean bl) {
        return CharacterReference.findPreviousOrNext(source, n, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL, bl);
    }

    private static CharacterReference findPreviousOrNext(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings, boolean bl) {
        ParseText parseText = source.getParseText();
        int n2 = n = bl ? parseText.lastIndexOf('&', n) : parseText.indexOf('&', n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, n, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            n = bl ? parseText.lastIndexOf('&', n - 1) : parseText.indexOf('&', n + 1);
        }
        return null;
    }

    static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#x").append(Integer.toString(n, 16)).append(';');
    }

    static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#").append(n).append(';');
    }

    private static CharacterReference construct(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source.getParseText().charAt(n) != '&') {
                return null;
            }
            return source.getParseText().charAt(n + 1) == '#' ? NumericCharacterReference.construct(source, n, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, n, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static StringBuffer appendDecode(StringBuffer stringBuffer, CharSequence charSequence, int n, boolean bl, boolean bl2) {
        CharacterReference characterReference;
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(bl);
        int n2 = 0;
        Source source = new Source(charSequence);
        while ((characterReference = CharacterReference.findPreviousOrNext(source, n, unterminatedCharacterReferenceSettings, false)) != null) {
            int n3;
            if (n2 != characterReference.getBegin()) {
                Util.appendTo(stringBuffer, charSequence, n2, characterReference.getBegin());
            }
            stringBuffer.append((char)((n3 = characterReference.getChar()) == 160 && bl2 ? 32 : n3));
            n = n2 = characterReference.getEnd();
        }
        if (n2 != charSequence.length()) {
            Util.appendTo(stringBuffer, charSequence, n2, charSequence.length());
        }
        return stringBuffer;
    }

    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuffer sb = new StringBuffer(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char c) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, c);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                Util.appendTo(this.out, (CharSequence)this.sb);
            }
        }

        public void write(int n) throws IOException {
            this.write((char)n);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.write(cArray[i]);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.write(string.charAt(i));
            }
        }
    }
}

