<?php /*~ routine.inc.php
.---------------------------------------------------------------------------.
|  Software: Routines Library                                        |
|   Version: 0.1                                                            |
|   Contact: via http://www.uniwits.com/contact                             |
|      Info: http://www.uniwits.com/                                        |
|   Support: http://www.uniwits.com/support                                 |
|      Note: This library is designed for Linux and compatible systems.     |
| ------------------------------------------------------------------------- |
|     Admin: Yuxiang Mao (project admininistrator)                          |
|   Authors: Yuxiang Mao (Uniwits) contact@uniwits.com                      |
|   Founder: Yuxiang Mao                                                    |
| Copyright (c) 2010-2012, Yuxiang Mao. All Rights Reserved.                |
| ------------------------------------------------------------------------- |
|   License: Distributed under Uniwits Shareware License (USL)              |
|            http://www.uniwits.com/licenses/shareware/                     |
| This program is distributed as a part of software provided by Uniwits     |
| System WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      |
| ------------------------------------------------------------------------- |
*/ if (GET('NOCOOKIE') && !$_COOKIE['COOKIE-OK']) define('NOCOOKIE',1); else define('NOCOOKIE',0); if (!defined('COOKIEPFX')) define('COOKIEPFX',''); require_once('maps.common.inc.php'); function basic_member_info($key,$default=false) { $memberbasic=$_SESSION['uniwits.memberbasic']; if (!$memberbasic) return $default; if (isset($memberbasic[$key])) return $memberbasic[$key]; return $default; } function basic_member_set_info($key,$value) { $_SESSION['uniwits.memberbasic'][$key]=$value; } function current_mb_id() { return 0+@basic_member_info('mb_id',0); } function current_mb_nickname() { return @basic_member_info('mb_nickname',''); } function compere_id_requested() { global $Config; return $Config->DefaultCPID; } function is_valid_compere() { $cp_status=@basic_member_info('cp_status',false); return $cp_status=='VALID'; } function deduce_user_language() { global $Config; $candidates=explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']); $candmap=array(); foreach ($candidates as $cand) { list($lang,$score_eq)=explode(';',$cand); if (!$score_eq) $score_eq='q=1'; list($tmp,$score)=explode('=',$score_eq); $candmap[$lang]=$score; } arsort($candmap); $lang_deduced=getCodeMapCountry2Language(get_user_countrycode(),$Config->Language); foreach ($candmap as $lang=>$score) { list($mainlang,$sublang)=explode('-',$lang); $language_file=$Config->Paths['lang.system']."/".$lang.$Config->LangFileSuffix; if (is_file($language_file)) { $lang_deduced=$lang; break; } $language_file=$Config->Paths['lang.system']."/".$mainlang.$Config->LangFileSuffix; if (is_file($language_file)) { $lang_deduced=$mainlang; break; } } set_user_language($lang_deduced); return $lang_deduced; } function get_user_language() { global $Config; $lang=COOKIE($Config->CookieName['uniwits_lang']); if (!$lang) $lang=deduce_user_language(); return $lang; } function set_user_language($lang) { global $Config; SET_LIFELONG_COOKIE($Config->CookieName['uniwits_lang'],$lang); } function language_requested() { $lang=TGET('LANG'); if ($lang) return $lang; return get_user_language(); } function parse_datetime($date_and_time) { if (!$date_and_time) return 0; list($date,$time)=explode(' ',trim($date_and_time)); $dateparts=explode('-',$date); $timeparts=explode(':',$time); return gmmktime($timeparts[0],$timeparts[1],$timeparts[2],$dateparts[1],$dateparts[2],$dateparts[0]); } function is_member() { return current_mb_id(); } function password_hash($plaintext) { return sha1($plaintext); } function service_logout($sesskeypfx) { purge_array_by_key_prefix($_SESSION,$sesskeypfx); } function emit_cookie($name,$value,$lifeseconds=0) { global $Config; setcookie($name,$value,$lifeseconds?time()+$lifeseconds:0,$Config->COOKIE_PATH,$Config->COOKIE_DOMAIN); } function emit_lifelong_cookie($name,$value) { global $Config; setcookie($name,$value,0x7fffffff,$Config->COOKIE_PATH,$Config->COOKIE_DOMAIN); } function COOKIE($name) { if (NOCOOKIE) { $expire=$_SESSION['_COOKIE'][$name]['expire']; $path=$_SESSION['_COOKIE'][$name]['path']; if (strncmp($_SERVER['REQUEST_URI'],$path,strlen($path))!=0) return NULL; if ($expire && $expire<time()) unset($_SESSION['_COOKIE'][$name]); return @$_SESSION['_COOKIE'][$name]['value']; } else return $_COOKIE[$name]; } function SET_COOKIE($name,$value,$lifeseconds=0) { global $Config; if (NOCOOKIE) { $_SESSION['_COOKIE'][$name]['expire']=$lifeseconds?time()+$lifeseconds:0; $_SESSION['_COOKIE'][$name]['value']=$value; $_SESSION['_COOKIE'][$name]['path']=$Config->COOKIE_PATH; } else { $_COOKIE[$name]=$value; emit_cookie($name,$value,$lifeseconds); } } function SET_LIFELONG_COOKIE($name,$value) { global $Config; if (NOCOOKIE) { $_SESSION['_COOKIE'][$name]['expire']=0x7fffffff; $_SESSION['_COOKIE'][$name]['value']=$value; $_SESSION['_COOKIE'][$name]['path']=$Config->COOKIE_PATH; } else { $_COOKIE[$name]=$value; emit_lifelong_cookie($name,$value,$lifeseconds); } } function emit_userpcid_cookie() { global $Config; if (!COOKIE($Config->CookieName['userpcid'])) { $userpcid=REMOTE_ADDR().'.'.uniwits_time(); SET_LIFELONG_COOKIE($Config->CookieName['userpcid'],$userpcid); } } function get_userpcid() { global $Config; return COOKIE($Config->CookieName['userpcid']); } function get_user_ipdata() { global $Config,$REMOTE_IS_SEARCHENGINE; $ipdata_serialized=COOKIE($Config->CookieName['uniwits_ipdata']); $ipdata=unserialize(base64_decode($ipdata_serialized)); if ($ipdata && $ipdata['Ip']==REMOTE_ADDR()) return $ipdata; if (!$REMOTE_IS_SEARCHENGINE && function_exists('query_ipinfo')) $ipdata=query_ipinfo(REMOTE_ADDR()); if ($ipdata) { if (!$ipdata['CountryCode'] || $ipdata['CountryCode']=='RD') { $ipdata['CountryCode']=$Config->CountryCode; $ipdata['Gmtoffset']=$Config->TimeZoneSeconds; $ipdata['Ip']=REMOTE_ADDR(); } $ipdata_serialized=base64_encode(serialize($ipdata)); SET_LIFELONG_COOKIE($Config->CookieName['uniwits_ipdata'],$ipdata_serialized); } return $ipdata; } function get_user_countrycode() { $countrycode=GET('COUNTRY_CODE'); if ($countrycode) return $countrycode; $countrycode=COOKIE('COUNTRY_CODE'); if ($countrycode) return $countrycode; $ipdata=get_user_ipdata(); $countrycode=$ipdata['CountryCode']; return ctype_alpha($countrycode)?$countrycode:false; } function set_user_countrycode($countrycode) { SET_LIFELONG_COOKIE('COUNTRY_CODE',$countrycode); } function get_user_time_zone() { global $Config; $tzs=basic_member_info('mb_timezone_minutes'); if ($tzs!==false) return $tzs; if (COOKIE($Config->CookieName['uniwits_timebias'])===null) { $ipdata=get_user_ipdata(); return $ipdata['Gmtoffset']/60; } return 0+COOKIE($Config->CookieName['uniwits_timebias']); } function is_user_time_zone_defined() { global $Config; $tzs=basic_member_info('mb_timezone_minutes'); if ($tzs!==false) return true; if (COOKIE($Config->CookieName['uniwits_timebias'])!==null) return true; $ipdata=get_user_ipdata(); return ctype_alpha($ipdata['CountryCode']) && $ipdata['CountryCode']!='RD'; } function set_temporary_user_time_zone($timezone_bias_minutes) { global $Config; SET_COOKIE($Config->CookieName['uniwits_timebias'],0+$timezone_bias_minutes); } function get_timezone_name($bias_minutes) { if ($bias_minutes<0) $sign='-'; else if ($bias_minutes>0) $sign='+'; else $sign=' '; return 'GMT '.($bias_minutes?sprintf('%s%02d:%02d',$sign,abs((int)($bias_minutes/60)),abs($bias_minutes%60)):''); } function loadTextMap($langfilename,$keysubstridx,$lang=false) { global $Config; clearstatcache(); $files=LanguageFiles($langfilename,$lang); $inodes=array(); foreach ($files as $f) array_push($inodes,base_convert(fileinode($f),10,36)); sort($inodes); $cachename=implode('-',$inodes).'#'.$keysubstridx; $map=cache_load_depfiles(0,$Config->CachePrefix,$langfilename,$cachename,'textmap',$files); if (!$map) { $labels=array(); for ($fi=sizeof($files)-1;$fi>=0;$fi--) if (file_exists($files[$fi])) $labels+=TemplateLoader::loadLabelFromFile($files[$fi]); asort($labels); $map=array(); foreach ($labels as $l=>$n) $map[substr($l,$keysubstridx)]=$n; cache_save(0,$Config->CachePrefix,$langfilename,$cachename,$map,'textmap'); } return $map; } function compute_common_lang_cache_name($lang_name,&$depfiles=array()) { global $Config; $depfiles=glob($Config->Paths['lang.system']."/".'??.'.$lang_name.$Config->LangFileSuffix); $inodes=array(); foreach ($depfiles as $df) array_push($inodes,base_convert(fileinode($df),10,36)); sort($inodes); return implode('-',$inodes); } function load_common_lang_index($langfilename,$keysubstridx) { global $Config; $depfiles=array(); $cachename=compute_common_lang_cache_name($langfilename,$depfiles); $commonidxs=cache_load_depfiles(0,$Config->CachePrefix,$langfilename,$cachename,'commonidxs',$depfiles); if (!$commonidxs) { $commonidxs=array(); foreach ($depfiles as $df) { list($lang,$others)=explode('.',basename($df),2); $map=loadTextMap($langfilename,$keysubstridx,$lang); $keys=array_keys($map); if (!$commonidxs) $commonidxs=$keys; else $commonidxs=array_intersect($commonidxs,$keys); $emptyidxs=array(); foreach ($commonidxs as $ci) { if (!$map[$ci]) array_push($emptyidxs,$ci); } foreach ($emptyidxs as $ei) unset($commonidxs[$ei]); } cache_save(0,$Config->CachePrefix,$langfilename,$cachename,$commonidxs,'commonidxs'); } return $commonidxs; } function loadCountryNames($lang=false) { $commonidxs=load_common_lang_index('countrynames',-2); $fullmap=loadTextMap('countrynames',-2,$lang); $commonmap=array(); foreach ($commonidxs as $idx) if ($fullmap[$idx]) $commonmap[$idx]=$fullmap[$idx]; return $commonmap; } function loadCurrencyNames($lang=false) { $commonidxs=load_common_lang_index('currencynames',-3); $fullmap=loadTextMap('currencynames',-3,$lang); $commonmap=array(); foreach ($commonidxs as $idx) if ($fullmap[$idx]) $commonmap[$idx]=$fullmap[$idx]; return $commonmap; } function loadInfoDisclosureFields($lang=false) { return loadTextMap('info.disclosure',11,$lang); } function loadValueMap($lang=false) { $countrymap=loadCountryNames($lang); $valuemap=loadTextMap('valuemap',0,$lang); foreach ($countrymap as $c=>$v) $valuemap['mb_country.'.$c]=$v; return $valuemap; } function loadLocalCurrencyNameMap() { return loadTextMap('currencyunits',-6,'_'); } function get_allowed_html_tags() { global $Config; return $Config->Allowed_HTML_Tags; } function format_money($amount,$currency) { switch ($currency) { case "JPY": $amount=(float)$amount; $afloor=floor($amount); if ($afloor==$amount) return sprintf("%0.0f",$amount); } return sprintf("%0.2f",$amount); } function jump_to_url($targeturl=null,$backurl=null) { global $Config; if (!$targeturl) $targeturl=TGET('targeturl'); if (!$backurl) $backurl=TGET('backurl'); if (!$backurl && $_SERVER['HTTP_REFERER']) { $bup=parseURL($_SERVER['HTTP_REFERER']); $backurl=$bup['path'].($bup['query']?'?'.$bup['query']:''); } if (!$backurl) $backurl=dirname_ending_with_slash($_SERVER['REQUEST_URI']); $ru_parts=array( 'path'=>dirname_ending_with_slash($_SERVER['REQUEST_URI']).(NOCOOKIE?'m/':''), 'query'=>'cmd=relogin&gotourl='.urlencode($backurl) ); $return_url=build_full_url($ru_parts,array('host'=>$Config->SERVER_NAME)); $targeturl.=strpos($targeturl,'?')===false?'?':'&'; $targeturl.='returnurl='.urlencode($return_url); $t_parts=parseURL($targeturl); $target_url=build_full_url($t_parts,array('host'=>$Config->SERVER_NAME)); header("Location: ".$target_url); } function jump_to_login_server_url($targetlocalurl=null,$backurl=null) { global $dataset; $urlprefix=$dataset['LOGIN_SERVER_PREFIX']; $cpid=compere_id_requested(); if (!$cpid && is_valid_compere()) $cpid=current_mb_id(); if ($cpid) $urlprefix.='/s'.$cpid; jump_to_url($urlprefix.$targetlocalurl,$backurl); } function is_https() { if ($_SERVER['HTTPS']) return true; if ($_SERVER['HTTP_SSL']) return true; return false; } function compute_user_path($userid,$prefix=false,$suffix=false) { return $prefix.implode('/',str_split(base_convert($userid,10,36),2)).$suffix; } function call_api_by_post($url,$methodname,$args) { $post=$args; $post['cmd']=$methodname; $postdata=http_build_query($post); $ch=curl_init($url); curl_setopt($ch,CURLOPT_POST,TRUE); curl_setopt($ch,CURLOPT_POSTFIELDS,$postdata); curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE); $xmltext=curl_exec($ch); DEBUG($xmltext); if ($xmltext) $xml=simplexml_load_string($xmltext); else $xml=null; curl_close($ch); if ($xml->Status=='OK') return (array)$xml->Result; else return false; } function call_login_server_api($methodname,$args) { global $dataset; if (!$dataset['LOGIN_SERVER_PREFIX']) { trigger_error('Stage error, $dataset[\'LOGIN_SERVER_PREFIX\'] has not been set.',E_USER_ERROR); return false; } return call_api_by_post($dataset['LOGIN_SERVER_PREFIX'].'/apis/callpost',$methodname,$args); } ?>