 /*~ toolbox.js
.---------------------------------------------------------------------------.
|  Software: JavaScript Toolbox Library                                     |
|   Version: 0.1                                                            |
|   Contact: via http://www.uniwits.com/contact                             |
|      Info: http://www.uniwits.com/                                        |
|   Support: http://www.uniwits.com/support                                 |
| ------------------------------------------------------------------------- |
|     Admin: Yuxiang Mao (project admininistrator)                          |
|   Authors: Yuxiang Mao (Uniwits) contact@uniwits.com                      |
|   Founder: Yuxiang Mao                                                    |
| Copyright (c) 2010-2011, Yuxiang Mao. All Rights Reserved.                |
| ------------------------------------------------------------------------- |
|   License: Distributed under Uniwits Shareware License (USL)              |
|            http://www.uniwits.com/licenses/shareware/                     |
| This program is distributed as a part of software provided by Uniwits     |
| System WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      |
| ------------------------------------------------------------------------- |
*/ if (this.UNIWITS===undefined) UNIWITS=new Object(); if (UNIWITS.Toolbox===undefined) UNIWITS.Toolbox=new Object(); if (UNIWITS._Toolbox===undefined) { UNIWITS._Toolbox=new Object(); } UNIWITS.Toolbox.padLeft=function (str,pad,width) { str=''+str; while (str.length<width) str=pad+str; return str.substr(str.length-width); }; UNIWITS.Toolbox.getopt=function(obj,property,defaultvalue) { if (property instanceof Array) { var o=obj; for (var i=0;i<property.length;i++) o=this.getopt(o,property[i],defaultvalue); return o?o:defaultvalue; } else { try { var o=obj[property]; return typeof o!='undefined'?o:defaultvalue; } catch (e) { return defaultvalue; } } }; UNIWITS.Toolbox.selectOptionByValue=function (selectId_or_obj,value,clearNotSelected) { var selectObj; if (typeof selectId_or_obj=="string") selectObj=document.getElementById(selectId_or_obj); else selectObj=selectId_or_obj; if (selectObj==null || selectObj.tagName!='SELECT') return; for (var oi=0;oi<selectObj.options.length;oi++) { if (selectObj.options[oi].value==value) selectObj.options[oi].selected=true; else if (clearNotSelected) selectObj.options[oi].selected=false; } }; UNIWITS.Toolbox.selectRadioByName=function (radioName,value,clearNotSelected) { var radios=document.getElementsByName(radioName); if (radios==null || radios.length==0) return; for (var ri in radios) { if (radios[oi].tagName=='INPUT' && radios[oi].type=='radio') if (radios[oi].value==value) radios[oi].checked=true; else if (clearNotSelected) radios[oi].checked=false; } }; UNIWITS.Toolbox.checkBoxById=function (checkboxId,value,clearNotSelected) { var cb=document.getElementById(checkboxId); if (cb==null) return; if (cb.tagName=='INPUT' && cb.type=='checkbox') if (cb.value==value) cb.checked=true; else if (clearNotSelected) cb.checked=false; }; UNIWITS.Toolbox.biasTime=function ( fromTime, nYears, nMonths, nDays, nHours, nMinutes, nSeconds, nMilliseconds) { var date=new Date(); if (typeof fromDate=="number") date.setTime(fromDate); else if (fromDate instanceof Date) date.setTime(fromDate.getTime()); else if (typeof fromDate=="string") date.setTime(Date.parse(fromDate)); if (nMilliseconds!==undefined) date.setMilliseconds(date.getMilliseconds()+nMilliseconds); if (nSeconds!==undefined) date.setSeconds(date.getSeconds()+nSeconds); if (nSeconds!==undefined) date.setMinutes(date.getMinutes()+nMinutes); if (nSeconds!==undefined) date.setHours(date.getHours()+nHours); if (nSeconds!==undefined) date.setDate(date.getDate()+nDays); if (nSeconds!==undefined) date.setMonth(date.getMonth()+nMonths); if (nSeconds!==undefined) date.setYear(date.getYear()+nYears); return date; }; UNIWITS.Toolbox.splitString=function (string,delimiterArray) { var strArr; if (string instanceof Array) strArr=string; else strArr=[string]; if (delimiterArray instanceof Array) delimiterArray=[delimiterArray]; for (var dai in delimiterArray) { var resultArr=new Array(); for (var si in strArr) { var ra=strArr[si].split(delimiterArray[dai]); for (var ri in ra) resultArr.push(ra[ri]); } strArr=resultArr; } }; UNIWITS.Toolbox.parseCookies=function () { var cookielist=document.cookie.split(';'); var cookies=new Array(); var sdreg=/ /g; for (var i in cookielist) { var parts=cookielist[i].split('='); var name=parts[0].replace(sdreg,''); cookies[name]=parts[1]; } return cookies; }; UNIWITS.Toolbox.strlen_utf8=function (string) { var cv,len=0; for (var i=0;i<string.length;i++) { cv=string.charCodeAt(i); if (0x00000<=cv && cv<=0x0007F) len+=1; else if (0x00080<=cv && cv<=0x007FF) len+=2; else if (0x00800<=cv && cv<=0x0D7FF) len+=3; else if (0x0E000<=cv && cv<=0x0FFFF) len+=3; else if (0x10000<=cv && cv<=0x10FFFF) len+=4; } return len; }; UNIWITS.Toolbox.getXMLHttpRequest=function (onResponse) { xmlhttp=null; if (window.XMLHttpRequest) { xmlhttp=new XMLHttpRequest(); } else if (window.ActiveXObject) { xmlhttp=new ActiveXObject("Microsoft.XMLHTTP"); } if (xmlhttp!=null) { if (onResponse!==undefined) xmlhttp.onreadystatechange=onResponse; } else { alert("Your browser does not support XMLHTTP."); } return xmlhttp; }; UNIWITS.Toolbox.XMLHttpRequestGetText=function (url) { var xhr=UNIWITS.Toolbox.getXMLHttpRequest(); xhr.open('GET',url,false,null,null); xhr.send(null); if (xhr.status==200) return xhr.responseText; return null; }; UNIWITS.Toolbox.XMLHttpRequestGetXML=function (url) { var xhr=UNIWITS.Toolbox.getXMLHttpRequest(); xhr.open('GET',url,false,null,null); xhr.send(null); if (xhr.status==200) return xhr.responseXML; return null; }; UNIWITS.Toolbox.loadXMLDoc=function(dname) { try { xmlDoc=new ActiveXObject("Microsoft.XMLDOM"); } catch(e) { try { xmlDoc=document.implementation.createDocument("","",null); } catch(e) { alert(e.message) } } try { xmlDoc.async=false; xmlDoc.load(dname); return(xmlDoc); } catch(e) { alert(e.message) } return(null); }; UNIWITS.Toolbox.loadXMLString=function (txt) { try { xmlDoc=new ActiveXObject("Microsoft.XMLDOM"); xmlDoc.async="false"; xmlDoc.loadXML(txt); return(xmlDoc); } catch(e) { try { parser=new DOMParser(); xmlDoc=parser.parseFromString(txt,"text/xml"); return(xmlDoc); } catch(e) { alert(e.message) } } return(null); }; UNIWITS.Toolbox.xmlToString=function (xmlNode) { try { return new XMLSerializer().serializeToString(xmlNode); } catch(e) { return xmlNode.xml; } }; UNIWITS.Toolbox.xmlFirstChildByName=function (xmlNode,name) { for (var ni in xmlNode.childNodes) { if (xmlNode.childNodes[ni].nodeName==name) return xmlNode.childNodes[ni]; } return null; }; UNIWITS.Toolbox.xmlChildrenByName=function (xmlNode,name) { var children=new Array(); for (var ni in xmlNode.childNodes) { if (xmlNode.childNodes[ni].nodeName==name) children.push(xmlNode.childNodes[ni]); } return children; }; UNIWITS.Toolbox.retrieveUrlParameter=function (url,pname) { var qi=url.indexOf('?'),csi; if (qi<0) return null; csi=url.indexOf(pname+"=",qi); if (csi<0) return null; var pvsi=csi+pname.length+1; var pvei=url.indexOf('&',pvsi); if (pvei<0) pvei=url.length; return url.substring(pvsi,pvei); }; UNIWITS.Toolbox.replaceUrlParameter=function (url,pname,pvalue) { var qi=url.indexOf('?'),csi; csi=qi; if (csi<0) csi=0; csi=url.indexOf(pname+"=",csi); if (csi<0) { return url+(qi<0?'?':'&')+pname+'='+pvalue; } else { var pvsi=csi+pname.length+1; var pvei=url.indexOf('&',pvsi); if (pvei<0) pvei=url.length; var newurl=url.substring(0,csi); newurl+=pname+"="; newurl+=pvalue; newurl+=url.substring(pvei,url.length); return newurl; } }; UNIWITS.Toolbox.mergeObject=function (objTo,objFrom) { if (typeof objFrom=="object") for (var i in objFrom) objTo[i]=objFrom[i]; return objTo; }; UNIWITS.Toolbox.createElement=function (name,properties,htmlcontent,styles) { var o=document.createElement(name); if (properties) for (var p in properties) eval("o."+p+"=properties[p]"); if (htmlcontent) { if (typeof htmlcontent=="string") o.innerHTML=htmlcontent; else if (typeof htmlcontent=="object") o.appendChild(htmlcontent); else o.innerHTML=''+htmlcontent; } UNIWITS.Toolbox.setStyles(o,styles); return o; }; UNIWITS.Toolbox.setStyles=function (element,styles) { if (styles) for (var s in styles) { var v=styles[s]; eval("element.style."+s+"=v"); } }; UNIWITS.Toolbox.preload_image=function () { var args=arguments; var imgs=new Array(); for (var i=0,m=0;i<args.length;i++) { if (typeof args[i]=="string") { imgs[m]=new Image(); imgs[m].src=args[i]; m++; } else if (typeof args[i]=="object" && args[i] instanceof Array) { for (var j=0;j<args[i].length;j++) { imgs[m]=new Image(); imgs[m].src=args[i][j]; m++; } } } return imgs; }; if (!UNIWITS._Toolbox.ECWI_elements) UNIWITS._Toolbox.ECWI_elements=new Array(); if (!UNIWITS._Toolbox.ECWI_status) UNIWITS._Toolbox.ECWI_status=new Object(); if (!UNIWITS._Toolbox.ECWI_divobj) UNIWITS._Toolbox.ECWI_divobj=null; UNIWITS.Toolbox.placeWaitingImage=function (element,imageurl,bgColor) { var pos=UNIWITS.Toolbox.absPos(element); var x=pos.x; var y=pos.y; if (!UNIWITS._Toolbox.ECWI_divobj) { var divobj=UNIWITS._Toolbox.ECWI_divobj=document.createElement('DIV'); divobj.style.position='absolute'; divobj.style.display='none'; document.body.appendChild(divobj); } else divobj=UNIWITS._Toolbox.ECWI_divobj; divobj.style.zIndex='50000'; divobj.style.backgroundImage='url('+imageurl+')'; divobj.style.left=x+'px'; divobj.style.top=y+'px'; divobj.style.width=element.offsetWidth+'px'; divobj.style.height=element.offsetHeight+'px'; divobj.style.backgroundColor=bgColor; divobj.style.backgroundPosition='center center'; divobj.style.backgroundRepeat='no-repeat'; divobj.style.display=''; window.setTimeout("UNIWITS._Toolbox.ECWI_divobj.style.display='none'",10000); }; UNIWITS._Toolbox.ECWI_callback=function (elemidx,urlidx,coloridx) { var elem=UNIWITS._Toolbox.ECWI_elements[elemidx]; var imgurl=UNIWITS._Toolbox.ECWI_elements[urlidx]; var bgColor=UNIWITS._Toolbox.ECWI_elements[coloridx]; var href=null; if (elem.tagName=='A') { var hreflastchar=''; try { hreflastchar=elem.href.charAt(elem.href.length-1); } catch (e) {} var samepagefraction=elem.protocol==location.protocol && elem.hostname==location.hostname && (elem.pathname.charAt(0)!='/'?'/'+elem.pathname:elem.pathname)==(location.pathname.charAt(0)!='/'?'/'+location.pathname:location.pathname) && elem.hash; var javascript=elem.protocol.toLowerCase()=='javascript:'; if (!elem.target && !samepagefraction && !javascript) UNIWITS.Toolbox.placeWaitingImage(elem,imgurl,bgColor); } else if (elem.tagName=='INPUT') { if (elem.type=='submit') UNIWITS.Toolbox.placeWaitingImage(elem,imgurl,bgColor); } }; UNIWITS._Toolbox.ECWI_populate_pending=function (urlidx,coloridx) { for (var ci=0;ci<10 && UNIWITS._Toolbox.ECWI_status.pendingElementQueue.length>0;ci++) { var elemidx=UNIWITS._Toolbox.ECWI_elements.length; var elem=UNIWITS._Toolbox.ECWI_status.pendingElementQueue.shift(); UNIWITS._Toolbox.ECWI_elements.push(elem); if (!elem.onclick) { var f; eval('f=function() { UNIWITS._Toolbox.ECWI_callback('+elemidx+','+urlidx+','+coloridx+'); }'); UNIWITS.Toolbox.installWrapperEvent(elem,'onclick',f); } } if (UNIWITS._Toolbox.ECWI_status.pendingElementQueue.length>0) setTimeout("UNIWITS._Toolbox.ECWI_populate_pending("+urlidx+","+coloridx+");",20); }; UNIWITS.Toolbox.enableClickWaitingImage=function (elements,imageurl,bgColor) { UNIWITS.Toolbox.preload_image(imageurl); var urlidx=UNIWITS._Toolbox.ECWI_elements.length++; var coloridx=UNIWITS._Toolbox.ECWI_elements.length++; UNIWITS._Toolbox.ECWI_elements[urlidx]=imageurl; UNIWITS._Toolbox.ECWI_elements[coloridx]=bgColor; if (!UNIWITS._Toolbox.ECWI_status.pendingElementQueue) UNIWITS._Toolbox.ECWI_status.pendingElementQueue=new Array(); for (var ei=0;ei<elements.length;ei++) UNIWITS._Toolbox.ECWI_status.pendingElementQueue.push(elements[ei]); setTimeout("UNIWITS._Toolbox.ECWI_populate_pending("+urlidx+","+coloridx+");",20); }; UNIWITS.Toolbox.linkify=function (text,target) { var exp =/((^\b|[^'"]\b)(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/ig; return text.replace(exp,"<a href='$1'"+(target?"target='"+target+"'":"")+">$1</a>"); }; UNIWITS.Toolbox.installTempMethod=function (obj,func) { var methodname; do { methodname="tmp"+Math.floor(Math.random()*100000000); } while (obj[methodname]); obj[methodname]=func; return methodname; }; if (!window.getComputedStyle) { window.getComputedStyle =function(el, pseudo) { var cs={ el : el, getPropertyValue : function(prop) { var re =/(\-([a-z]){1})/g; if (prop == 'float') prop ='styleFloat'; if (re.test(prop)) { prop =prop.replace(re, function () { return arguments[2].toUpperCase(); }); } return el.currentStyle[prop] ? el.currentStyle[prop] : null; } }; return cs; } }; UNIWITS.Toolbox.installWrapperEvent=function (obj,methodname,newEventFunc) { var name4old=null; if (obj[methodname]) name4old=UNIWITS.Toolbox.installTempMethod(obj,obj[methodname]); var name4new=UNIWITS.Toolbox.installTempMethod(obj,newEventFunc); var wrapperstr="obj[methodname]=function () {"+ (name4old?"this."+name4old+"();":"")+ (name4new?"this."+name4new+"();":"")+ "}"; eval(wrapperstr); return name4old; }; UNIWITS.Toolbox.AutoHeighter=function (textareaobj,options) { if (!UNIWITS._Toolbox.AutoHeighters) UNIWITS._Toolbox.AutoHeighters=new Array(); this.index=UNIWITS._Toolbox.AutoHeighters.length++; UNIWITS._Toolbox.AutoHeighters[this.index]=this; this.sizedobj=textareaobj; this.options=options; this.onkeypress_name4old=null; this.onmouseup_name4old=null; this.onfocus_name4old=null; this.onblur_name4old=null; this.timerid=-1; this.attach=function () { var f; eval("f=function() { window.setTimeout('UNIWITS._Toolbox.AutoHeighter_onupdate("+this.index+")', 100); }"); this.onkeypress_name4old=UNIWITS.Toolbox.installWrapperEvent(this.sizedobj,"onkeypress",f); this.onmouseup_name4old=UNIWITS.Toolbox.installWrapperEvent(this.sizedobj,"onmouseup",f); eval("f=function() { UNIWITS._Toolbox.AutoHeighter_onfocus("+this.index+"); }"); this.onfocus_name4old=UNIWITS.Toolbox.installWrapperEvent(this.sizedobj,"onfocus",f); eval("f=function() { UNIWITS._Toolbox.AutoHeighter_onblur("+this.index+"); }"); this.onblur_name4old=UNIWITS.Toolbox.installWrapperEvent(this.sizedobj,"onblur",f); this.sizedobj.style.overflow="hidden"; UNIWITS._Toolbox.AutoHeighter_onupdate(this.index); this.timerid=window.setInterval("UNIWITS._Toolbox.AutoHeighter_onupdate("+this.index+")",500); }; this.detach=function () { this.sizedobj["onkeypress"]=undefined; this.sizedobj["onmouseup"]=undefined; window.clearInterval(this.timerid); this.timerid=-1; }; }; UNIWITS._Toolbox.AutoHeighter_onfocus=function (index) { var sizer=UNIWITS._Toolbox.AutoHeighters[index]; if (sizer.timerid<0) sizer.timerid=window.setInterval("UNIWITS._Toolbox.AutoHeighter_onupdate("+sizer.index+")",500); }; UNIWITS._Toolbox.AutoHeighter_onblur=function (index) { var sizer=UNIWITS._Toolbox.AutoHeighters[index]; if (sizer.timerid>=0) window.clearInterval(sizer.timerid); }; UNIWITS._Toolbox.AutoHeighter_onupdate=function (index) { var sizer=UNIWITS._Toolbox.AutoHeighters[index]; if (sizer.options.heightlimit && typeof sizer.sizedobj.clientHeight!="undefined") { var heightlimit=Math.min(sizer.options.heightlimit,sizer.sizedobj.scrollHeight); if (sizer.sizedobj.clientHeight<heightlimit && heightlimit<=sizer.sizedobj.scrollHeight) { var h=sizer.options.borderheight?heightlimit+sizer.options.borderheight:heightlimit; sizer.sizedobj.style.height=h+"px"; } if (sizer.sizedobj.clientHeight<sizer.sizedobj.scrollHeight && sizer.sizedobj.style.overflow!="auto") { var width=getComputedStyle(sizer.sizedobj,null).getPropertyValue('width'); sizer.sizedobj.style.overflow="auto"; sizer.sizedobj.style.width=width; } } }; UNIWITS.Toolbox.absPos=function (element) { var x=0,y=0,p,offp; while (element && element!=document.body) { p=element.offsetParent; offp=p==document.body || p.tagName=='HTML'?null:p; x+=element.offsetLeft-(offp && offp.scrollLeft?offp.scrollLeft:0); y+=element.offsetTop-(offp && offp.scrollTop?offp.scrollTop:0); if (element.style.position=='absolute') break; element=p; } return {x:x,y:y}; }; UNIWITS.Toolbox.dockElement=function(element,dockToElem,options) { element.style.position='absolute'; var horz=UNIWITS.Toolbox.getopt(options,'horz','left'); var vert=UNIWITS.Toolbox.getopt(options,'vert','above'); var vside=UNIWITS.Toolbox.getopt(options,'vside','inner'); var hside=UNIWITS.Toolbox.getopt(options,'hside','inner'); var vspacing=UNIWITS.Toolbox.getopt(options,'vspacing',0); var hspacing=UNIWITS.Toolbox.getopt(options,'hspacing',0); var pos; if (dockToElem==undefined) { pos={ x:document.documentElement.scrollLeft?document.documentElement.scrollLeft:document.body.scrollLeft, y:document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop }; dockToElem={ offsetWidth: UNIWITS.Toolbox.clientWidth(), offsetHeight: UNIWITS.Toolbox.clientHeight() }; } else pos=UNIWITS.Toolbox.absPos(dockToElem); if (horz=='center') pos.x+=Math.floor((dockToElem.offsetWidth-element.offsetWidth)/2); if (horz=='left') { if (hside=='outer') { pos.x-=element.offsetWidth; pos.x-=hspacing; } else pos.x+=hspacing; } if (horz=='right') { pos.x+=dockToElem.offsetWidth; if (hside=='outer') pos.x+=hspacing; else { pos.x-=element.offsetWidth; pos.x-=hspacing; } } if (vert=='center') pos.y+=Math.floor((dockToElem.offsetHeight-element.offsetHeight)/2); if (vert=='above') { if (vside=='outer') { pos.y-=element.offsetHeight; pos.y-=vspacing; } else pos.y+=vspacing; } if (vert=='below') { pos.y+=dockToElem.offsetHeight; if (vside=='outer') pos.y+=vspacing; else { pos.y-=element.offsetHeight; pos.y-=vspacing; } } element.style.left=pos.x+'px'; element.style.top=pos.y+'px'; }; if (!UNIWITS._Toolbox.floatTip_div) UNIWITS._Toolbox.floatTip_div=null; if (!UNIWITS._Toolbox.floatTips) UNIWITS._Toolbox.floatTips=new Array(); UNIWITS.Toolbox.installFloatTip=function (id_or_obj,text_or_func,options) { var tipInfo=new Object(); var idx=UNIWITS._Toolbox.floatTips.length++,f; tipInfo.triggerObj=typeof id_or_obj=="string"?document.getElementById(id_or_obj):id_or_obj; if (!tipInfo.triggerObj) return; UNIWITS._Toolbox.floatTips[idx]=tipInfo; if (options.cursor) tipInfo.triggerObj.style.cursor=options.cursor; tipInfo.text_or_func=text_or_func; tipInfo.options=options; eval("f=function () { UNIWITS._Toolbox.floatTip_display("+idx+"); }"); UNIWITS.Toolbox.installWrapperEvent(tipInfo.triggerObj,"onclick",f); UNIWITS.Toolbox.installWrapperEvent(tipInfo.triggerObj,"onmouseover",f); eval("f=function () { UNIWITS._Toolbox.floatTip_hide("+idx+"); }"); UNIWITS.Toolbox.installWrapperEvent(tipInfo.triggerObj,"onmouseout",f); }; UNIWITS.Toolbox.installFloatTips=function (id_or_obj_and_text_or_func_array,options) { var i; for (var i=0;i<id_or_obj_and_text_or_func_array.length;i++) UNIWITS.Toolbox.installFloatTip(id_or_obj_and_text_or_func_array[i].id_or_obj,id_or_obj_and_text_or_func_array[i].text_or_func,options); }; UNIWITS._Toolbox.floatTip_display=function (idx) { var tipInfo=UNIWITS._Toolbox.floatTips[idx]; if (!UNIWITS._Toolbox.floatTip_div) { UNIWITS._Toolbox.floatTip_div=document.createElement('DIV'); UNIWITS._Toolbox.floatTip_div.style.position='absolute'; UNIWITS._Toolbox.floatTip_div.style.display='none'; UNIWITS._Toolbox.floatTip_div.appendChild(document.createElement('SPAN')); UNIWITS._Toolbox.floatTip_div.zIndex=3; document.body.appendChild(UNIWITS._Toolbox.floatTip_div); } if (UNIWITS._Toolbox.floatTip_div.style.display!='none') return; if (typeof tipInfo.text_or_func=="string") UNIWITS._Toolbox.floatTip_div.lastChild.innerHTML=tipInfo.text_or_func; else tipInfo.text_or_func(UNIWITS._Toolbox.floatTip_div.lastChild); UNIWITS._Toolbox.floatTip_div.className=UNIWITS.Toolbox.getopt(tipInfo.options,'className',''); UNIWITS.Toolbox.setStyles(UNIWITS._Toolbox.floatTip_div,UNIWITS.Toolbox.getopt(tipInfo.options,'styles',{})); UNIWITS._Toolbox.floatTip_div.style.visibility='hidden'; UNIWITS._Toolbox.floatTip_div.style.display=''; setTimeout("UNIWITS._Toolbox.floatTip_adjustposition("+idx+")",10); }; UNIWITS._Toolbox.floatTip_adjustposition=function (idx) { var tipInfo=UNIWITS._Toolbox.floatTips[idx]; var abspos=UNIWITS.Toolbox.absPos(tipInfo.triggerObj); var align=UNIWITS.Toolbox.getopt(tipInfo.options,'align','left'); if (align=='right') abspos.x=abspos.x+tipInfo.triggerObj.offsetWidth-UNIWITS._Toolbox.floatTip_div.offsetWidth; else if (align=='center') abspos.x=abspos.x+(tipInfo.triggerObj.offsetWidth-UNIWITS._Toolbox.floatTip_div.offsetWidth)/2; var vdocking=UNIWITS.Toolbox.getopt(tipInfo.options,'vdocking',''); if (vdocking=='above') abspos.y=abspos.y-UNIWITS._Toolbox.floatTip_div.offsetHeight; else if (vdocking=='below') abspos.y=abspos.y+tipInfo.triggerObj.offsetHeight; abspos.x+=UNIWITS.Toolbox.getopt(tipInfo.options,'dx',0); abspos.y+=UNIWITS.Toolbox.getopt(tipInfo.options,'dy',0); if (UNIWITS.Toolbox.getopt(tipInfo.options,'fitWindow',true)) { if (abspos.x+UNIWITS._Toolbox.floatTip_div.offsetWidth>document.body.scrollLeft+UNIWITS.Toolbox.clientWidth()) abspos.x=document.body.scrollLeft+UNIWITS.Toolbox.clientWidth()-UNIWITS._Toolbox.floatTip_div.offsetWidth; if (abspos.x<document.body.scrollLeft) abspos.x=document.body.scrollLeft; if (abspos.x+UNIWITS._Toolbox.floatTip_div.offsetWidth>document.body.scrollLeft+UNIWITS.Toolbox.clientWidth()) UNIWITS._Toolbox.floatTip_div.offsetWidth=UNIWITS.Toolbox.clientWidth(); } UNIWITS._Toolbox.floatTip_div.style.left=abspos.x+'px'; UNIWITS._Toolbox.floatTip_div.style.top=abspos.y+'px'; UNIWITS._Toolbox.floatTip_div.style.visibility='visible'; }; UNIWITS._Toolbox.floatTip_hide=function () { if (UNIWITS._Toolbox.floatTip_div) { UNIWITS._Toolbox.floatTip_div.style.display='none'; var o,t,spanobj=UNIWITS._Toolbox.floatTip_div.lastChild; while (o=spanobj.firstChild) { t=o; o=o.nextSibling; spanobj.removeChild(t); } } }; UNIWITS.Toolbox.clientWidth=function () { return window.innerWidth?window.innerWidth:(document.documentElement.clientWidth?document.documentElement.clientWidth:document.body.clientWidth); }; UNIWITS.Toolbox.clientHeight=function () { return window.innerHeight?window.innerHeight:(document.documentElement.clientHeight?document.documentElement.clientHeight:document.body.clientHeight); }; UNIWITS.Toolbox.scrollTop=function () { return Math.max(document.body.scrollTop,document.documentElement.scrollTop); }; if (!UNIWITS._Toolbox.palette) UNIWITS._Toolbox.palette={ objtable: new Array() }; UNIWITS.Toolbox.Palette=function(options) { this.options=options; this.index=UNIWITS._Toolbox.palette.objtable.length++; UNIWITS._Toolbox.palette.objtable[this.index]=this; this.colorTuner='r'; this.colorBlockTable=new Array(); this.colorTuner=new Array(); this.colorIndicator=new Array(); this.brightTuner=new Array(); this.brightIndicator=new Array(); this.rowIndicator=new Array(); this.columnIndicator=new Array(); this.brightIndex=0; this.colorIndex=0; this.rowIndex=0; this.colIndex=0; this.colorCurrentBox=null; this.colorPreviewBox=null; this.colorNameBox=null; this.colorNameText=null; this.brightIndexHover=15; this.colorIndexHover=0; this.rowIndexHover=0; this.colIndexHover=0; this.brightIndexSel=15; this.colorIndexSel=0; this.rowIndexSel=0; this.colIndexSel=0; this.currentColorName=null; this.paletteObject=null; this.getopt=function(obj,property,defaultvalue) { if (property instanceof Array) { var o=obj; for (var i=0;i<property.length;i++) o=this.getopt(o,property[i],defaultvalue); return o?o:defaultvalue; } else { try { var o=obj[property]; return o?o:defaultvalue; } catch (e) { return defaultvalue; } } }; this.createRGB=function(r,g,b) { var cp,name='#'; cp=Number(r).toString(16); if (cp.length<2) cp='0'+cp; name+=cp; cp=Number(g).toString(16); if (cp.length<2) cp='0'+cp; name+=cp; cp=Number(b).toString(16); if (cp.length<2) cp='0'+cp; name+=cp; return name; }; this.createRow=function() { var rowdiv=document.createElement('DIV'); rowdiv.style.display="block"; rowdiv.style.whiteSpace="nowrap"; rowdiv.style.padding="0px"; rowdiv.style.margin="0px"; rowdiv.style.height=this.getopt(this.options,'colorHeight',8)+'px'; rowdiv.style.lineHeight=rowdiv.style.height; rowdiv.style.cursor="pointer"; return rowdiv; }; this.createColorBlock=function(colorname,rowidx,colidx) { var color=document.createElement('SPAN'); color.style.padding="0px 0px 0px 0px"; color.style.margin="0px 0px 0px 0px"; color.style.display="inline-block"; color.style.overflow="hidden"; color.style.height=this.getopt(this.options,'colorHeight',8)+'px'; color.style.lineHeight=color.style.height; color.style.width=this.getopt(this.options,'colorWidth',8)+'px'; color.style.backgroundColor=colorname; color.style.verticalAlign="top"; color.style.cursor="pointer"; var idx=UNIWITS._Toolbox.palette.objtable.length++; UNIWITS._Toolbox.palette.objtable[idx]={ base: this, obj: color, rowidx: rowidx, colidx: colidx }; var f; eval("f=function () { UNIWITS._Toolbox.palette.objtable["+idx+"].base.onColorBlockClick( UNIWITS._Toolbox.palette.objtable["+idx+"] ); }"); color.onclick=f; eval("f=function () { UNIWITS._Toolbox.palette.objtable["+idx+"].base.onColorBlockMouseOver( UNIWITS._Toolbox.palette.objtable["+idx+"] ); }"); color.onmouseover=f; return color; }; this.createSeparatorH=function(sepidx) { var sepspan=document.createElement('SPAN'); sepspan.style.padding="0px 0px 0px 0px"; sepspan.style.margin="0px 0px 0px 0px"; sepspan.style.display="inline-block"; sepspan.style.overflow="hidden"; sepspan.style.verticalAlign="top"; sepspan.style.lineHeight=this.getopt(this.options,'colorHeight',8)+'px'; sepspan.style.height=sepspan.style.lineHeight; sepspan.style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; var idx=UNIWITS._Toolbox.palette.objtable.length++; UNIWITS._Toolbox.palette.objtable[idx]={ base: this, obj: sepspan, sepidx: sepidx }; return sepspan; }; this.createSeparatorV=function(sepidx) { var sepspan=document.createElement('SPAN'); sepspan.style.padding="0px 0px 0px 0px"; sepspan.style.margin="0px 0px 0px 0px"; sepspan.style.display="inline-block"; sepspan.style.overflow="hidden"; sepspan.style.verticalAlign="bottom"; sepspan.style.lineHeight=this.getopt(this.options,'sepspanHeight',8)+'px'; sepspan.style.height=sepspan.style.lineHeight; sepspan.style.width=this.getopt(this.options,'colorWidth',8)+'px'; var idx=UNIWITS._Toolbox.palette.objtable.length++; UNIWITS._Toolbox.palette.objtable[idx]={ base: this, obj: sepspan, sepidx: sepidx }; return sepspan; }; this.createSeparatorB=function(sepidx) { var sepspan=document.createElement('SPAN'); sepspan.style.padding="0px 0px 0px 0px"; sepspan.style.margin="0px 0px 0px 0px"; sepspan.style.display="inline-block"; sepspan.style.overflow="hidden"; sepspan.style.verticalAlign="top"; sepspan.style.lineHeight=this.getopt(this.options,'sepspanHeight',8)+'px'; sepspan.style.height=sepspan.style.lineHeight; sepspan.style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; var idx=UNIWITS._Toolbox.palette.objtable.length++; UNIWITS._Toolbox.palette.objtable[idx]={ base: this, obj: sepspan, sepidx: sepidx }; return sepspan; }; this.createColorPreview=function() { var span=document.createElement('SPAN'); span.style.padding="0px 0px 0px 0px"; span.style.margin="0px 0px 0px 0px"; span.style.display="inline-block"; span.style.overflow="hidden"; span.style.height=this.getopt(this.options,'colorHeight',8)+'px'; span.style.lineHeight=span.style.height; span.style.width=this.getopt(this.options,'colorWidth',8)*2+'px'; span.style.verticalAlign='bottom'; span.style.backgroundColor=''; span.style.cursor="pointer"; span.style.border="1px solid black"; return span; }; this.createColorNameBox=function() { var span=document.createElement('SPAN'); span.style.display='inline-block'; span.style.width=this.getopt(this.options,'colornameWidth',64)+'px'; span.style.height=this.getopt(this.options,'colorHeight',8)+'px'; span.style.verticalAlign='bottom'; span.style.border="1px solid black"; span.style.overflow="visible"; var input=document.createElement('INPUT'); input.type="text"; input.style.border="none"; input.style.padding="0px 0px 0px 0px"; input.style.margin="0px 0px 0px 0px"; input.style.fontSize=this.getopt(this.options,'colorTextSize',this.getopt(this.options,'colorHeight',8))+'px'; input.style.width=this.getopt(this.options,'colornameWidth',64)+'px'; input.style.height=input.style.fontSize; input.style.lineHeight=this.getopt(this.options,'colorHeight',8)+'px'; input.style.verticalAlign='top'; span.appendChild(input); return { encloser: span, input: input }; }; this.createPalette=function() { var colorseldiv=document.createElement('SPAN'); this.paletteObject=colorseldiv; var color,rowdiv,colorname; colorseldiv.style.display="inline-block"; colorseldiv.style.width=(this.getopt(this.options,'colorWidth',8)*17+this.getopt(this.options,'sepspanWidth',8)*2)+'px'; colorseldiv.style.textAlign="left"; colorseldiv.style.backgroundColor=this.getopt(this.options,'backgroundColor','white'); rowdiv=this.createRow(); rowdiv.style.lineHeight=this.getopt(this.options,'inforowheight',16)+'px'; rowdiv.style.height=rowdiv.style.lineHeight; colorseldiv.appendChild(rowdiv); rowdiv.appendChild(this.createSeparatorB(-1)); rowdiv.appendChild(this.colorCurrentBox=this.createColorPreview()); rowdiv.appendChild(this.createSeparatorB(-1)); rowdiv.appendChild(this.colorPreviewBox=this.createColorPreview()); rowdiv.appendChild(this.createSeparatorB(-1)); var cnb=this.createColorNameBox(); rowdiv.appendChild(cnb.encloser); this.colorNameText=cnb.input; rowdiv=this.createRow(); rowdiv.style.lineHeight=this.getopt(this.options,'sepspanheight',8)+2+'px'; rowdiv.style.height=rowdiv.style.lineHeight; rowdiv.style.overflow="visible"; rowdiv.appendChild(this.createSeparatorB(-1)); for (var c=0;c<16;c++) { this.columnIndicator[c]=this.createSeparatorV(c); rowdiv.appendChild(this.columnIndicator[c]); } colorseldiv.appendChild(rowdiv); this.colorBlockTable.length=16; this.colorTuner.length=16; this.colorIndicator.length=16; this.brightTuner.length=16; this.brightIndicator.length=16; this.rowIndicator.length=16; this.columnIndicator.length=16; for (var r=0;r<16;r++) { rowdiv=this.createRow(); rowdiv.style.lineHeight=this.getopt(this.options,'colorHeight',8)+'px'; rowdiv.style.height=rowdiv.style.lineHeight; rowdiv.style.overflow="hidden"; rowdiv.appendChild(this.rowIndicator[r]=this.createSeparatorH(r)); colorseldiv.appendChild(rowdiv); this.colorBlockTable[r]=new Array(); this.colorBlockTable[r].length=16; for (var c=0;c<16;c++) { this.colorBlockTable[r][c]=this.createColorBlock('',r,c); rowdiv.appendChild(this.colorBlockTable[r][c]); } rowdiv.appendChild(this.colorIndicator[r]=this.createSeparatorH(r)); this.colorTuner[r]=this.createColorBlock('',r,16); rowdiv.appendChild(this.colorTuner[r]); } rowdiv=this.createRow(); rowdiv.style.lineHeight=this.getopt(this.options,'sepspanheight',8)+'px'; rowdiv.style.height=rowdiv.style.lineHeight; rowdiv.style.overflow="visible"; rowdiv.appendChild(this.createSeparatorB(-1)); for (var c=0;c<16;c++) { this.brightIndicator[c]=this.createSeparatorV(c); rowdiv.appendChild(this.brightIndicator[c]); } colorseldiv.appendChild(rowdiv); rowdiv=this.createRow(); rowdiv.appendChild(this.createSeparatorH(-1)); for (var c=0;c<16;c++) { this.brightTuner[c]=this.createColorBlock('',16,c); rowdiv.appendChild(this.brightTuner[c]); } colorseldiv.appendChild(rowdiv); this.currentColorName=this.getopt(this.options,'initColor','#000000'); var ccni=this.decomposeColor(this.currentColorName); this.colorIndexSel=Math.floor(ccni[2]/16); this.rowIndexSel=Math.floor(ccni[0]/16); this.colIndexSel=Math.floor(ccni[1]/16); this.brightIndexSel=this.computebrightindex(this.rowIndexSel,this.colIndexSel,this.colorIndexSel); this.UpdateIndicators(); return colorseldiv; }; this.updateColorTable=function() { for (var r=0;r<16;r++) { for (var c=0;c<16;c++) { colorname=this.createRGB(r*16+15,c*16+15,0); this.colorBlockTable[r][c].style.backgroundColor=colorname; } colorname=this.createRGB(0,0,r*16+15); this.colorTuner[r].style.backgroundColor=colorname; } for (var c=0;c<16;c++) { colorname=this.createRGB(c*16+15,c*16+15,c*16+15); this.brightTuner[c].style.backgroundColor=colorname; } }; this.computebrightindex=function(rowidx,colidx,coloridx) { return Math.floor((rowidx+colidx+coloridx)/3); }; this.onColorBlockClick=function (info) { if (info.rowidx>=0 && info.rowidx<16 && info.colidx>=0 && info.colidx<16) { this.rowIndicator[this.rowIndexSel].style.backgroundColor=''; this.rowIndicator[this.rowIndexSel].style.marginLeft="0px"; this.rowIndicator[this.rowIndexSel].style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; this.columnIndicator[this.colIndexSel].style.backgroundColor=''; this.columnIndicator[this.colIndexSel].style.marginTop="0px"; this.columnIndicator[this.colIndexSel].style.height=this.getopt(this.options,'sepspanHeight',8)+'px'; this.rowIndexSel=info.rowidx; this.colIndexSel=info.colidx; } if (info.rowidx>=0 && info.rowidx<16 && info.colidx==16) { this.colorIndicator[this.colorIndexSel].style.backgroundColor=''; this.colorIndicator[this.colorIndexSel].style.marginLeft="0px"; this.colorIndicator[this.colorIndexSel].style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; this.colorIndexSel=info.rowidx; } if (info.rowidx==16 && info.colidx>=0 && info.colidx<16) { this.brightIndicator[this.brightIndexSel].style.backgroundColor=''; this.brightIndicator[this.brightIndexSel].style.marginTop="0px"; this.brightIndicator[this.brightIndexSel].style.height=this.getopt(this.options,'sepspanHeight',8)+'px'; this.brightIndexSel=info.colidx; this.rowIndexSel=this.rowIndexHover; this.colIndexSel=this.colIndexHover; this.colorIndexSel=this.colorIndexHover; } this.UpdateIndicators(); var colorCallBack=this.getopt(this.options,'oncolorclick',null); if (typeof colorCallBack=="function") colorCallBack(this.currentColorName); }; this.onColorBlockMouseOver=function (info) { if (info.rowidx>=0 && info.rowidx<16 && info.colidx>=0 && info.colidx<16) { this.rowIndexHover=info.rowidx; this.colIndexHover=info.colidx; this.colorIndexHover=this.colorIndexSel; this.brightIndexHover=this.computebrightindex(this.rowIndexHover,this.colIndexHover,this.colorIndexHover); } if (info.rowidx>=0 && info.rowidx<16 && info.colidx==16) { this.rowIndexHover=this.rowIndexSel; this.colIndexHover=this.colIndexSel; this.colorIndexHover=info.rowidx; this.brightIndexHover=this.computebrightindex(this.rowIndexHover,this.colIndexHover,this.colorIndexHover); } if (info.rowidx==16 && info.colidx>=0 && info.colidx<16) { this.brightIndexHover=info.colidx; var ac=this.adjustColorBright(this.rowIndexSel,this.colIndexSel,this.colorIndexSel,this.brightIndexHover); this.rowIndexHover=ac.rowidx; this.colIndexHover=ac.colidx; this.colorIndexHover=ac.coloridx; } this.UpdateIndicators(); }; this.decomposeColor=function (colorname) { if (colorname.charAt(0)=='#') { return [parseInt(colorname.substr(1,2),16),parseInt(colorname.substr(3,2),16),parseInt(colorname.substr(5,2),16)]; } else { var colorparts=colorname.substring(4,colorname.length-1).split(","); return [parseInt(colorparts[0]),parseInt(colorparts[1]),parseInt(colorparts[2])]; } }; this.computeColor=function(rowidx,colidx,coloridx) { var r=rowidx*16+15,g=colidx*16+15,b=coloridx*16+15; return this.createRGB(r,g,b); }; this.adjustColorBright=function(rowidx,colidx,coloridx,tobrightidx) { var brightidx=this.computebrightindex(rowidx,colidx,coloridx); if (brightidx!=tobrightidx && brightidx>0) { rowidx=Math.max(Math.min(15,Math.floor(rowidx*tobrightidx/brightidx))); colidx=Math.max(Math.min(15,Math.floor(colidx*tobrightidx/brightidx))); coloridx=Math.max(Math.min(15,Math.floor(coloridx*tobrightidx/brightidx))); } return {rowidx: rowidx, colidx: colidx, coloridx: coloridx}; }; this.UpdateIndicators=function () { if (this.colorIndex!=this.colorIndexHover) { this.colorIndicator[this.colorIndex].style.backgroundColor=''; this.colorIndicator[this.colorIndex].style.marginLeft="0px"; this.colorIndicator[this.colorIndex].style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; this.colorIndex=this.colorIndexHover; } if (this.brightIndex!=this.brightIndexHover) { this.brightIndicator[this.brightIndex].style.backgroundColor=''; this.brightIndicator[this.brightIndex].style.marginTop="0px"; this.brightIndicator[this.brightIndex].style.height=this.getopt(this.options,'sepspanHeight',8)+'px'; this.brightIndex=this.brightIndexHover; } if (this.rowIndex!=this.rowIndexHover) { this.rowIndicator[this.rowIndex].style.backgroundColor=''; this.rowIndicator[this.rowIndex].style.marginLeft="0px"; this.rowIndicator[this.rowIndex].style.width=this.getopt(this.options,'sepspanWidth',8)+'px'; this.rowIndex=this.rowIndexHover; } if (this.colIndex!=this.colIndexHover) { this.columnIndicator[this.colIndex].style.backgroundColor=''; this.columnIndicator[this.colIndex].style.marginTop="0px"; this.columnIndicator[this.colIndex].style.height=this.getopt(this.options,'sepspanHeight',8)+'px'; this.colIndex=this.colIndexHover; } var colorname=this.createRGB(Math.floor(Math.random()*255),Math.floor(Math.random()*255),Math.floor(Math.random()*255)); colorname='gray'; var tv,v; tv=this.getopt(this.options,'sepspanWidth',8); v=Math.floor(tv/2); this.colorIndicator[this.colorIndexSel].style.backgroundColor=colorname; this.colorIndicator[this.colorIndexSel].style.marginLeft=v+"px"; this.colorIndicator[this.colorIndexSel].style.width=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanHeight',8); v=Math.floor(tv/2); this.brightIndicator[this.brightIndexSel].style.backgroundColor=colorname; this.brightIndicator[this.brightIndexSel].style.marginTop=v+"px"; this.brightIndicator[this.brightIndexSel].style.height=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanWidth',8); v=Math.floor(tv/2); this.rowIndicator[this.rowIndexSel].style.backgroundColor=colorname; this.rowIndicator[this.rowIndexSel].style.marginLeft=v+"px"; this.rowIndicator[this.rowIndexSel].style.width=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanHeight',8); v=Math.floor(tv/2); this.columnIndicator[this.colIndexSel].style.backgroundColor=colorname; this.columnIndicator[this.colIndexSel].style.marginTop=v+"px"; this.columnIndicator[this.colIndexSel].style.height=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanWidth',8); v=Math.floor(tv/4); this.colorIndicator[this.colorIndex].style.backgroundColor=colorname; this.colorIndicator[this.colorIndex].style.marginLeft=v+"px"; this.colorIndicator[this.colorIndex].style.width=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanHeight',8); v=Math.floor(tv/4); this.brightIndicator[this.brightIndex].style.backgroundColor=colorname; this.brightIndicator[this.brightIndex].style.marginTop=v+"px"; this.brightIndicator[this.brightIndex].style.height=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanWidth',8); v=Math.floor(tv/4); this.rowIndicator[this.rowIndex].style.backgroundColor=colorname; this.rowIndicator[this.rowIndex].style.marginLeft=v+"px"; this.rowIndicator[this.rowIndex].style.width=(tv-v)+'px'; tv=this.getopt(this.options,'sepspanHeight',8); v=Math.floor(tv/4); this.columnIndicator[this.colIndex].style.backgroundColor=colorname; this.columnIndicator[this.colIndex].style.marginTop=v+"px"; this.columnIndicator[this.colIndex].style.height=(tv-v)+'px'; this.currentColorName=this.computeColor(this.rowIndexSel,this.colIndexSel,this.colorIndexSel); this.colorCurrentBox.style.backgroundColor=this.currentColorName; this.colorPreviewBox.style.backgroundColor=this.computeColor(this.rowIndexHover,this.colIndexHover,this.colorIndexHover); this.colorNameText.value=this.currentColorName; }; }; if (!UNIWITS._Toolbox.Calender) UNIWITS._Toolbox.Calender={ objlist: new Array() }; UNIWITS.Toolbox.Calender=function (options) { this.options=options; this.calendarPanel=null; this.dateRowObjs=Array(); this.dateTable=Array(); this.timeTable=Array(); this.dateLinkTable=Array(); this.selectedDate=null; this.enabledDateSet=[]; this._default_month_names=[ 'Jan.', 'Feb.', 'Mar.', 'Apr.', 'May.', 'Jun.', 'Jul.', 'Aug.', 'Sep.', 'Oct.', 'Nov.', 'Dec.' ]; this._default_weekday_names=[ 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat' ]; this.initialize=function () { this.index=UNIWITS._Toolbox.Calender.objlist.length; UNIWITS._Toolbox.Calender.objlist[this.index]=this; this.selectedDate=this.getopt(this.options,'initDate',new Date()); this.panelstyles={ display: 'inline-block', backgroundColor: this.getopt(this.options,'backgroundColor','white'), whiteSpace: 'nowrap', width: this.getopt(this.options,'dayWidth',19)*7+this.getopt(this.options,'widthExtra',10)+'px', padding : '0px', margin : '0px', textAlign: 'center' }; this.monthstyles={ display: 'inline-block', color: this.getopt(this.options,'monthColor','black'), width: this.getopt(this.options,'dayWidth',19)*3+4+'px', overflow: 'hidden', textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'monthBG','#ffffff'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.pagingstyles={ display: 'inline-block', color: this.getopt(this.options,'pagingColor','blue'), width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'monthBG','#ffffff'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.closestyles={ display: 'inline-block', color: this.getopt(this.options,'closeColor','black'), width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'monthBG','#ffffff'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.headerstyles={ display: 'inline-block', width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'headerBG','#ffffa0'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.daystyles={ display: 'inline-block', width: this.getopt(this.options,'dayWidth',19)+'px', padding : '0px', margin : '0px', overflow: 'hidden', color: this.getopt(this.options,'othermonthdayColor','#000000'), textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'dayBG','#ffffe0'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.selecteddaystyles={ display: 'inline-block', width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', color: this.getopt(this.options,'othermonthdayColor','#000000'), textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'dayBG','#d0ffe0'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.disableddaystyles={ display: 'inline-block', width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', color: this.getopt(this.options,'othermonthdayColor','#cccccc'), textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'dayBG','#eeeeee'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.othermonthdaystyles={ display: 'inline-block', width: this.getopt(this.options,'dayWidth',19)+'px', overflow: 'hidden', color: this.getopt(this.options,'othermonthdayColor','#999999'), textAlign: this.getopt(this.options,'dayAlign','center'), border: this.getopt(this.options,'dayBorder','1px solid white'), backgroundColor: this.getopt(this.options,'dayBG','#ffffe0'), fontSize: this.getopt(this.options,'dayFontSize',11)+'px' }; this.sundaystyles={ color: this.getopt(this.options,'sundayColor','#dd0000') }; this.saturdaystyles={ color: this.getopt(this.options,'saturdayColor','#0000dd') }; this.linkstyles={ width: '100%', display: 'inline-block', cursor: 'pointer' }; if (this.getopt(this.options,'panelClassName',null)) this.panelstyles={}; if (this.getopt(this.options,'monthClassName',null)) this.monthstyles={}; if (this.getopt(this.options,'pagingClassName',null)) this.pagingstyles={}; if (this.getopt(this.options,'closeClassName',null)) this.closestyles={}; if (this.getopt(this.options,'headerClassName',null)) this.headerstyles={}; if (this.getopt(this.options,'dayClassName',null)) this.daystyles={}; if (this.getopt(this.options,'selectedDayClassName',null)) this.selecteddaystyles={}; if (this.getopt(this.options,'disabledDayClassName',null)) this.disableddaystyles={}; if (this.getopt(this.options,'otherMonthDayClassName',null)) this.othermonthdaystyles={}; if (this.getopt(this.options,'sundayClassName',null)) this.sundaystyles={}; if (this.getopt(this.options,'saturdayClassName',null)) this.saturdaystyles={}; if (this.getopt(this.options,'linkClassName',null)) this.linkstyles={}; UNIWITS.Toolbox.mergeObject(this.panelstyles,this.getopt(this.options,'panelStyles',null)); UNIWITS.Toolbox.mergeObject(this.monthstyles,this.getopt(this.options,'monthStyles',null)); UNIWITS.Toolbox.mergeObject(this.pagingstyles,this.getopt(this.options,'pagingStyles',null)); UNIWITS.Toolbox.mergeObject(this.closestyles,this.getopt(this.options,'closeStyles',null)); UNIWITS.Toolbox.mergeObject(this.headerstyles,this.getopt(this.options,'headerStyles',null)); UNIWITS.Toolbox.mergeObject(this.daystyles,this.getopt(this.options,'dayStyles',null)); UNIWITS.Toolbox.mergeObject(this.selecteddaystyles,this.getopt(this.options,'selectedDayStyles',null)); UNIWITS.Toolbox.mergeObject(this.disableddaystyles,this.getopt(this.options,'disabledDayStyles',null)); UNIWITS.Toolbox.mergeObject(this.othermonthdaystyles,this.getopt(this.options,'otherMonthDayStyles',null)); UNIWITS.Toolbox.mergeObject(this.linkstyles,this.getopt(this.options,'linkStyles',null)); this.calendarPanel=UNIWITS.Toolbox.createElement('SPAN',null,null,this.panelstyles); this.calendarPanel.className=this.getopt(this.options,'panelClassName',''); this.dateRowObjs.length=6; this.dateTable.length=6; this.timeTable.length=6; this.dateLinkTable.length=6; this.titleRowObj=document.createElement('DIV'); this.calendarPanel.appendChild(this.titleRowObj); var f; var linkPageLeft=UNIWITS.Toolbox.createElement('A',{onclick: eval("f=function(){UNIWITS._Toolbox.Calender.objlist["+this.index+"].onPageLeft()}")},this.getopt(this.options,'pageIconLeft','&lt;&lt;'),this.linkstyles); var linkPageRight=UNIWITS.Toolbox.createElement('A',{onclick: eval("f=function(){UNIWITS._Toolbox.Calender.objlist["+this.index+"].onPageRight()}")},this.getopt(this.options,'pageIconRight','&gt;&gt;'),this.linkstyles); var linkClose=UNIWITS.Toolbox.createElement('A',{onclick: eval("f=function(){UNIWITS._Toolbox.Calender.objlist["+this.index+"].onClose()}")},this.getopt(this.options,'closeIcon','x'),this.linkstyles); this.titleRowObj.appendChild(UNIWITS.Toolbox.createElement('SPAN',{className: this.getopt(this.options,'closeClassName','')},'&nbsp;',this.closestyles)); this.titleRowObj.appendChild(UNIWITS.Toolbox.createElement('SPAN',{className: this.getopt(this.options,'pagingClassName','')},linkPageLeft,this.pagingstyles)); this.monthNameObj=this.titleRowObj.appendChild(UNIWITS.Toolbox.createElement('SPAN',{className: this.getopt(this.options,'monthClassName','')},'&nbsp;',this.monthstyles)); this.titleRowObj.appendChild(UNIWITS.Toolbox.createElement('SPAN',{className: this.getopt(this.options,'pagingClassName','')},linkPageRight,this.pagingstyles)); this.titleRowObj.appendChild(UNIWITS.Toolbox.createElement('SPAN',{className: this.getopt(this.options,'closeClassName','')},linkClose,this.closestyles)); this.headerRowObj=document.createElement('DIV'); this.calendarPanel.appendChild(this.headerRowObj); var weekdayNames=this.getopt(this.options,'weekdayNames',this._default_weekday_names); for (var c=0;c<7;c++) { var hdrObj=UNIWITS.Toolbox.createElement('SPAN',null,null,this.headerstyles); this.headerRowObj.appendChild(hdrObj); hdrObj.innerHTML=weekdayNames[c]; hdrObj.className=this.getopt(this.options,'headerClassName',''); } for (var r=0;r<6;r++) { this.dateRowObjs[r]=document.createElement('DIV'); this.dateTable[r]=new Array(); this.timeTable[r]=new Array(); this.dateLinkTable[r]=new Array(); this.calendarPanel.appendChild(this.dateRowObjs[r]); for (var c=0;c<7;c++) { this.dateTable[r][c]=UNIWITS.Toolbox.createElement('SPAN',null,null,this.othermonthdaystyles); this.dateTable[r][c].className=this.getopt(this.options,'dayClassName',''); this.timeTable[r][c]=0; this.dateLinkTable[r][c]=UNIWITS.Toolbox.createElement('A',null,null,this.linkstyles); this.dateLinkTable[r][c].className=this.getopt(this.options,'linkClassName',''); this.dateTable[r][c].appendChild(this.dateLinkTable[r][c]); this.dateRowObjs[r].appendChild(this.dateTable[r][c]); this.dateLinkTable[r][c].innerHTML='&nbsp;'; eval("this.dateLinkTable[r][c].onclick=function(){UNIWITS._Toolbox.Calender.objlist["+this.index+"].onDayClick("+r+","+c+")}"); } } this.enabledDateSet=[]; var enabledates=this.getopt(this.options,'enabledDates',[]); for (var edi in enabledates) { var ed=enabledates[edi]; if (ed instanceof Date) { this.enabledDateSet['Y'+ed.getFullYear()+'M'+(ed.getMonth()+1)+'D'+ed.getDate()]=true; } else if (ed instanceof Array) { this.enabledDateSet['Y'+ed['year']+'M'+ed['month']+'D'+ed['date']]=true; } else if (ed instanceof Object) { this.enabledDateSet['Y'+ed.year+'M'+ed.month+'D'+ed.date]=true; } else { var e=new Error(); e.message="Unsupported date type"; throw e; } } this.disabledDateSet=[]; var disabledates=this.getopt(this.options,'disabledDates',[]); for (var edi in disabledates) { var ed=disabledates[edi]; if (ed instanceof Date) { this.disabledDateSet['Y'+ed.getFullYear()+'M'+(ed.getMonth()+1)+'D'+ed.getDate()]=true; } else if (ed instanceof Array) { this.disabledDateSet['Y'+ed['year']+'M'+ed['month']+'D'+ed['date']]=true; } else if (ed instanceof Object) { this.disabledDateSet['Y'+ed.year+'M'+ed.month+'D'+ed.date]=true; } else { var e=new Error(); e.message="Unsupported date type"; throw e; } } }; this.getopt=function(obj,property,defaultvalue) { if (property instanceof Array) { var o=obj; for (var i=0;i<property.length;i++) o=this.getopt(o,property[i],defaultvalue); return o?o:defaultvalue; } else { try { var o=obj[property]; return o?o:defaultvalue; } catch (e) { return defaultvalue; } } }; this.isDateEnabled=function (dateobj) { var lowestDate=this.getopt(this.options,'lowestDate',null); var highestDate=this.getopt(this.options,'highestDate',null); var lowestTime=lowestDate && lowestDate instanceof Date?lowestDate.getTime():0; var highestTime=highestDate && highestDate instanceof Date?highestDate.getTime():Number.MAX_VALUE; var isinrange=lowestTime<=dateobj.getTime() && dateobj.getTime()<=highestTime; var dateName='Y'+dateobj.getFullYear()+'M'+(dateobj.getMonth()+1)+'D'+dateobj.getDate(); if (this.enabledDateSet[dateName]) return true; if (this.disabledDateSet[dateName]) return false; return isinrange; }; this.recreateCalendar=function() { var dateObj=new Date(); dateObj.setTime(this.selectedDate.getTime()); var curDate=dateObj.getDate(); var curMonth=dateObj.getMonth(); var weekDay=0,curWeekDay; var iDate=1; var iCol=0,iRow=0; dateObj.setDate(1); var iweekday=dateObj.getDay(); dateObj.setTime(dateObj.getTime()-iweekday*1000*3600*24); for (;iCol<iweekday;iCol++) { var enabled=this.isDateEnabled(dateObj); UNIWITS.Toolbox.setStyles(this.dateTable[iRow][iCol],enabled?this.othermonthdaystyles:this.disableddaystyles); this.dateLinkTable[iRow][iCol].innerHTML=dateObj.getDate(); this.timeTable[iRow][iCol]=dateObj.getTime(); dateObj.setTime(dateObj.getTime()+1000*3600*24); } var monthNames=this.getopt(this.options,'monthNames',this._default_month_names); this.monthNameObj.innerHTML=dateObj.getFullYear()+', '+monthNames[curMonth]; while (dateObj.getMonth()==curMonth) { var enabled=this.isDateEnabled(dateObj); var selected=dateObj.getFullYear()==this.selectedDate.getFullYear() && dateObj.getMonth()==this.selectedDate.getMonth() && dateObj.getDate()==this.selectedDate.getDate(); UNIWITS.Toolbox.setStyles(this.dateTable[iRow][iCol],enabled?(selected?this.selecteddaystyles:this.daystyles):this.disableddaystyles); if (enabled && dateObj.getDay()==0) UNIWITS.Toolbox.setStyles(this.dateTable[iRow][iCol],this.sundaystyles); if (enabled && dateObj.getDay()==6) UNIWITS.Toolbox.setStyles(this.dateTable[iRow][iCol],this.saturdaystyles); this.dateLinkTable[iRow][iCol].innerHTML=dateObj.getDate(); this.timeTable[iRow][iCol]=dateObj.getTime(); dateObj.setTime(dateObj.getTime()+1000*3600*24); iCol++; if (iCol>=7) { iRow++; iCol=0; } } for (;iRow<6;iRow++) { for (;iCol<7;iCol++) { var enabled=this.isDateEnabled(dateObj); UNIWITS.Toolbox.setStyles(this.dateTable[iRow][iCol],enabled?this.othermonthdaystyles:this.disableddaystyles); this.dateLinkTable[iRow][iCol].innerHTML=dateObj.getDate(); this.timeTable[iRow][iCol]=dateObj.getTime(); dateObj.setTime(dateObj.getTime()+1000*3600*24); } iCol=0; } }; this.onDayClick=function (iRow,iCol) { var cf=this.getopt(this.options,'ondayclick',null); if (cf) { var d=new Date(); d.setTime(this.timeTable[iRow][iCol]); if (this.isDateEnabled(d)) cf(d); } }; this.onClose=function () { var cf=this.getopt(this.options,'onclose',null); if (cf) cf(); }; this.onPageLeft=function () { var curYear=this.selectedDate.getFullYear(); var curMonth=this.selectedDate.getMonth(); if (curMonth==0) { curYear--; curMonth=11; } else curMonth--; this.selectedDate.setFullYear(curYear); this.selectedDate.setMonth(curMonth); this.recreateCalendar(); }; this.onPageRight=function () { var curYear=this.selectedDate.getFullYear(); var curMonth=this.selectedDate.getMonth(); if (curMonth==11) { curYear++; curMonth=0; } else curMonth++; this.selectedDate.setFullYear(curYear); this.selectedDate.setMonth(curMonth); this.recreateCalendar(); }; this.getCalendarPanel=function () { return this.calendarPanel; }; this.getSelectedDate=function () { return this.selectedDate; }; this.setYearMonthDate=function (y,m,d) { this.selectedDate.setFullYear(y); this.selectedDate.setMonth(m); this.selectedDate.setDate(d); this.recreateCalendar(); }; this.initialize(); this.recreateCalendar(); }; UNIWITS._Toolbox.gradualResize={ resizeObjs: new Array() }; UNIWITS.Toolbox.gradualResize=function (element,settings) { var index=0; for (;index<UNIWITS._Toolbox.gradualResize.resizeObjs.length;index++) if (UNIWITS._Toolbox.gradualResize.resizeObjs[index].element==element) break; if (index>=UNIWITS._Toolbox.gradualResize.resizeObjs.length) { UNIWITS._Toolbox.gradualResize.resizeObjs.length++; UNIWITS._Toolbox.gradualResize.resizeObjs[index]={ element: element, intervalID: -1 }; } var resizeObj=UNIWITS._Toolbox.gradualResize.resizeObjs[index]; resizeObj.toWidth=settings.toWidth; resizeObj.toHeight=settings.toHeight; resizeObj.dWidth=settings.dWidth; resizeObj.dHeight=settings.dHeight; resizeObj.intervalms=settings.intervalms; resizeObj.onStep=settings.onStep; resizeObj.onFinish=settings.onFinish; resizeObj.callbackdata=settings.callbackdata; if (resizeObj.intervalID==-1) resizeObj.intervalID=window.setInterval("UNIWITS._Toolbox.gradualResize_do("+index+")",settings.intervalms); }; UNIWITS._Toolbox.gradualResize_do=function (index) { var resizeObj=UNIWITS._Toolbox.gradualResize.resizeObjs[index]; var hdone=true,vdone=true; if (resizeObj.dWidth) { hdone=false; if (Math.abs(resizeObj.element.clientWidth-resizeObj.toWidth)<resizeObj.dWidth) { resizeObj.element.style.width=resizeObj.toWidth+"px"; hdone=true; } else if (resizeObj.element.clientWidth>resizeObj.toWidth) resizeObj.element.style.width=resizeObj.element.clientWidth-resizeObj.dWidth+"px"; else resizeObj.element.style.width=resizeObj.element.clientWidth+resizeObj.dWidth+"px"; } if (resizeObj.dHeight) { vdone=false; if (Math.abs(resizeObj.element.clientHeight-resizeObj.toHeight)<resizeObj.dHeight) { resizeObj.element.style.height=resizeObj.toHeight+"px"; vdone=true; } else if (resizeObj.element.clientHeight>resizeObj.toHeight) resizeObj.element.style.height=resizeObj.element.clientHeight-resizeObj.dHeight+"px"; else resizeObj.element.style.height=resizeObj.element.clientHeight+resizeObj.dHeight+"px"; } if (hdone && vdone) { window.clearInterval(resizeObj.intervalID); resizeObj.intervalID=-1; } if (typeof resizeObj.onStep=="function") resizeObj.onStep(resizeObj.callbackdata); if (hdone && vdone && typeof resizeObj.onFinish=="function") resizeObj.onFinish(resizeObj.callbackdata); }; if (!UNIWITS._Toolbox.FloatingSideMenu) UNIWITS._Toolbox.FloatingSideMenu={ menulist: Array() }; UNIWITS.Toolbox.FloatingSideMenu=function (options) { this.index=UNIWITS._Toolbox.FloatingSideMenu.menulist.length++; UNIWITS._Toolbox.FloatingSideMenu.menulist[this.index]=this; this.options=options; this.initialize=function () { this.containerDIV=UNIWITS.Toolbox.createElement('DIV',null,null,{width: '0px', height: '1px', position: 'absolute', zIndex: UNIWITS.Toolbox.getopt(this.options,'zIndex',999), overflow: 'hidden', padding: '0px', margin: '0px', display: 'none'}); this.contentIFrame=UNIWITS.Toolbox.createElement('IFRAME',{src: this.options.src, name: this.options.name, width: this.options.resizesettingshow.toWidth+'px', height: this.options.resizesettingshow.toHeight+'px', marginWidth: "0", marginHeight: "0", scrolling: 'no', noResize: true, frameBorder: 0},null,{border: 'none'}); this.containerDIV.appendChild(this.contentIFrame); var f; eval("f=function () { UNIWITS._Toolbox.FloatingSideMenu.slidemenu("+this.index+"); }"); this.switchA=UNIWITS.Toolbox.createElement('A',{href: "javascript: ;", onclick: f},null,{display: 'none', zIndex: UNIWITS.Toolbox.getopt(this.options,'zIndex',999)}); document.body.appendChild(this.containerDIV); document.body.appendChild(this.switchA); var switchelem=UNIWITS.Toolbox.getopt(this.options,'switchelem',null); if (switchelem) this.switchA.appendChild(switchelem); eval("f=function () { UNIWITS._Toolbox.FloatingSideMenu.adjustPosition("+this.index+"); }"); UNIWITS.Toolbox.installWrapperEvent(window,'onscroll',f); UNIWITS.Toolbox.installWrapperEvent(window,'onresize',f); }; this.show=function () { this.containerDIV.style.display=''; this.switchA.style.display=''; UNIWITS._Toolbox.FloatingSideMenu.slidemenu(this.index); }; this.hide=function () { this.containerDIV.style.display='none'; this.switchA.style.display='block'; }; this.slidein=function () { var settings=UNIWITS.Toolbox.getopt(this.options,'resizesettingshow',null); if (settings) { settings=UNIWITS.Toolbox.mergeObject({},settings); eval("settings.onStep=function () { UNIWITS._Toolbox.FloatingSideMenu.onslidestep("+this.index+",true); }"); UNIWITS.Toolbox.gradualResize(this.containerDIV,settings); } var onslidein=UNIWITS.Toolbox.getopt(this.options,'onslidein',undefined); if (typeof onslidein=="function") onslidein(); }; this.slideout=function () { var settings=UNIWITS.Toolbox.getopt(this.options,'resizesettinghide',null); if (settings) { settings=UNIWITS.Toolbox.mergeObject({},settings); eval("settings.onStep=function () { UNIWITS._Toolbox.FloatingSideMenu.onslidestep("+this.index+",false); }"); UNIWITS.Toolbox.gradualResize(this.containerDIV,settings); } var onslideout=UNIWITS.Toolbox.getopt(this.options,'onslideout',undefined); if (typeof onslideout=="function") onslideout(); }; this.adjustPosition=function () { UNIWITS._Toolbox.FloatingSideMenu.adjustPosition(this.index); }; this.getMenuElement=function () { return this.containerDIV; }; this.getSwitchElement=function () { return this.switchA; }; this.initialize(); }; UNIWITS._Toolbox.FloatingSideMenu.adjustPosition=function (index) { var menuobj=UNIWITS._Toolbox.FloatingSideMenu.menulist[index]; UNIWITS.Toolbox.dockElement(menuobj.containerDIV,UNIWITS.Toolbox.getopt(menuobj.options,'dockto',undefined),UNIWITS.Toolbox.getopt(menuobj.options,'dockoptions',null)); window.setTimeout("UNIWITS._Toolbox.FloatingSideMenu.adjustSwitchPosition("+index+");",1); }; UNIWITS._Toolbox.FloatingSideMenu.adjustSwitchPosition=function (index) { var menuobj=UNIWITS._Toolbox.FloatingSideMenu.menulist[index]; UNIWITS.Toolbox.dockElement(menuobj.switchA,menuobj.containerDIV,UNIWITS.Toolbox.getopt(menuobj.options,'switchdockoptions',null)); var onadjust=UNIWITS.Toolbox.getopt(menuobj.options,'onadjust',undefined); if (typeof onadjust=="function") onadjust(); }; UNIWITS._Toolbox.FloatingSideMenu.slidemenu=function (index) { var menuobj=UNIWITS._Toolbox.FloatingSideMenu.menulist[index]; var settings,isshowing; if (menuobj.containerDIV.offsetWidth>0 && menuobj.containerDIV.offsetHeight>0) menuobj.slideout(); else menuobj.slidein(); }; UNIWITS._Toolbox.FloatingSideMenu.onslidestep=function (index,isshowing) { UNIWITS._Toolbox.FloatingSideMenu.adjustPosition(index); var menuobj=UNIWITS._Toolbox.FloatingSideMenu.menulist[index]; if (isshowing) settings=UNIWITS.Toolbox.getopt(menuobj.options,'resizesettinghide',null); else settings=UNIWITS.Toolbox.getopt(menuobj.options,'resizesettingshow',null); if (typeof settings.onStep=="function") settings.onStep(settings.callbackdata); };