#!/bin/sh

SRCPATH=$( dirname $0 );

echo "This script is used to perform minor upgrades of UORS_suv.";
echo "It updates the files except configurations and \"install\" directories.";
echo ;
echo "Please enter the path, without trailing slash,";
echo "under which /login and /reserv resides.";
echo -n ">>>";
read DESTPATH;
echo $DESTPATH;
rsync -av --exclude "config.common.inc.php" --exclude "config.locals.inc.php" --exclude "install" $SRCPATH/login/ $DESTPATH/login/
rsync -av --exclude "config.common.inc.php" --exclude "config.locals.inc.php" --exclude "config.plugins.inc.php" --exclude "install" $SRCPATH/reserv/ $DESTPATH/reserv/

TMPFILE=$( mktemp )
chmod 664 $TMPFILE
sed -r 's/(\$Config->VERSION='"')"'[0-9ab.]+('"'"'.*)$/\1'$( cat $SRCPATH/login/install/VERSION )'\2/g' $DESTPATH/login/base/config.common.inc.php > $TMPFILE
mv -f $TMPFILE $DESTPATH/login/base/config.common.inc.php

TMPFILE=$( mktemp )
chmod 664 $TMPFILE
sed -r 's/(\$Config->VERSION='"')"'[0-9ab.]+('"'"'.*)$/\1'$( cat $SRCPATH/reserv/install/VERSION )'\2/g' $DESTPATH/reserv/config.common.inc.php > $TMPFILE
mv -f $TMPFILE $DESTPATH/reserv/config.common.inc.php

echo "DONE";

