#Copyright (C) 2003 Gimite  <gimite@mx12.freecom.ne.jp>

#ܸʸȽѥ
$KCODE= "EUC"
require 'kconv'
require 'jcode'
require $REUDY_DIR+'/tango-mgm'
require $REUDY_DIR+'/wordset'
require $REUDY_DIR+'/word_searcher'
require $REUDY_DIR+'/message_log'
require $REUDY_DIR+'/similar_searcher'
require $REUDY_DIR+'/word_associator'
require $REUDY_DIR+'/wtml_manager'
require $REUDY_DIR+'/attention_decider'
require $REUDY_DIR+'/response_estimator'
require $REUDY_DIR+'/version'
require $REUDY_DIR+'/reudy_common'


module Gimite


#͹̵ǽǥ
class Reudy
  
  include(Gimite)
  
  def initialize(dir, fixedSettings= {})
    @attention= nil
    
    #С󥢥åץåɬפʤ顢ǡ򿷤Ѵ
    ReudyVersion.new().checkDataVersion(dir)
    
    #ɤ߹ࡣ
    @fixedSettings= fixedSettings
    @settingPath= dir+"/setting.txt"
    loadSettings()
    @autoSave= settings("disable_auto_saving")!="true"
    
    #ƯԤΥ֥ã롣
    jprint_to($stderr, "...\n")
    @log= MessageLog.new(dir+"/log.dat")
    @log.addObserver(self)
    @log.sync= @autoSave
    jprint_to($stderr, "ñ...\n")
    @wordSet= WordSet.new(dir+"/words.dat")
    @wordSearcher= WordSearcher.new(@wordSet)
    @wtmlManager= WordToMessageListManager.new(@wordSet, @log, @wordSearcher)
    @extractor= WordExtractor.new(14, method(:onAddWord))
    @simSearcher= SimilarSearcher.new(dir+"/similar.gdbm", @log)
    @associator= WordAssociator.new(dir+"/assoc.txt")
    @attention= AttentionDecider.new()
    @attention.setParameter(attentionParameters())
    @resEst= ResponseEstimator.new(@log, @wordSearcher,
      method(:isUsableBaseMsg), method(:canAdoptWord))
    
    #¾󥹥ѿν
    @client= nil
    @lastSpeachInput= nil
    @lastSpeach= nil
    @inputWords= []
    @newInputWords= []
    @recentUnusedCt= 100 #ǶnĤȯоݤȤʤ
    @repeatProofCt= 50 #nȯǻȤä١ȯϺѤʤ
    @recentBaseMsgNs= Array.new(@repeatProofCt) #ǶȤä١ȯֹ
    @thoughtFile= open(dir+"/thought.txt", "a") #׹ͲϿե
    @thoughtFile.sync= true
    
    #եå
    @log.updateByOuterFile(dir+"/log.txt")
    @wordSet.updateByOuterFile(dir+"/words.txt", @wtmlManager)
    setWordAdoptBorder()
    #Kernel.open(dir+"/words.log", "w"){ |f| @wordSet.output(f) } #
  end
  
  #ե뤫
  def loadSettings()
    file= Kernel.open(@settingPath)
    @settings= {}
    file.each_line() do |line|
      if line.chomp()=~/^\s*(\S+)(\s.*)?$/
        @settings[$1]= $2 ? $2.strip() : ""
      end
    end
    file.close()
    @fixedSettings.each() do |key, val|
      @settings[key]= val
    end
    #ѿ򹹿
    @targetNickReg= Regexp.new(@settings["target_nick"] || "")
      #˥ޥåʤNickȯϡ١ȯȤƻǽ
    s= @settings["forbidden_nick"]
    s= "(?!.*)" if !s || s==""
      #ˤޥåʤɽΤĤ
    @forbiddenNickReg= Regexp.new(s)
      #˥ޥåNickȯϡ١ȯȤƻǽ
    @myNicks= settings("nicks").split(/\s*,\s*/)
    changeMode(settings("default_mode").to_i())
  end
  
  #åȥ饤Ȥλ
  attr_writer(:client)
  
  #åȥ֥Ѥ
  def settings(key)
    return @settings[key]
  end
  
  #⡼ɤѹ
  def changeMode(mode)
    return false if mode==@mode
    @mode= mode
    @attention.setParameter(attentionParameters()) if @attention
    updateStatus()
    return true
  end
  
  def updateStatus()
    @client.status= ["", "", nil, ""][@mode] if @client
  end
  
  #ȽͿѥ᡼
  def attentionParameters()
    case @mode
      when 0 #ۥ⡼ɡ
        return { \
          :min     => 0.001, \
          :max     => 0.001, \
          :default => 0.001, \
          :called  => 0.001, \
          :self    => 0.0,   \
          :ignored => 0.0    \
        }
      when 1 #ۥ⡼ɡ
        return { \
          :min     => 0.1, \
          :max     => 0.3, \
          :default => 0.1, \
          :called  => 1.1, \
          :self    => 0.005, \
          :ignored => 0.002 \
        }
      when 2 #̾⡼ɡ
        return { \
          :min     => 0.5, \
          :max     => 1.1, \
          :default => 0.5, \
          :called  => 1.1, \
          :self    => 0.3, \
          :ignored => 0.002 \
        }
      when 3 #⡼ɡ
        return { \
          :min     => 0.8, \
          :max     => 1.1, \
          :default => 0.8, \
          :called  => 1.1, \
          :self    => 0.8, \
          :ignored => 0.01  \
        }
      when 4 #ɬ⡼ɡ
        return { \
          :min     => 1.1, \
          :max     => 1.1, \
          :default => 1.1, \
          :called  => 1.1, \
          :self    => 1.1, \
          :ignored => 1.1  \
        }
    end
  end
  
  #ñ줬¿иƤִʤɤоݤˤʤȤ
  #ܡ@wordAdoptBorder
  def setWordAdoptBorder()
    msgCts= @wordSet.map(){ |w| w.mids.size() }.sort().reverse()
    if msgCts.size()==0
      @wordAdoptBorder= 0
    else
      @wordAdoptBorder= msgCts[msgCts.size()/50]
    end
  end
  
  #ñ줬ִʤɤоݤˤʤ뤫
  def canAdoptWord(word)
    return word.msgNs.size()<@wordAdoptBorder
  end
  
  #ȯ١ȯȤƻѲǽ
  def isUsableBaseMsg(msgN)
    return false if msgN>=@log.size()
      #¸ߤʤȯ
    nick= @log[msgN].fromNick
    return false if settings("teacher_mode")!="true" &&
          @log.size()>@recentUnusedCt && msgN>=@log.size()-@recentUnusedCt
      #ȯ롣οͥ⡼ɤǤ̵
    return false if nick=="!"
      #ʬȤȯ
    return false if !(nick=~@targetNickReg) || nick=~@forbiddenNickReg
      #ȯԤȯϻȤʤ
    return false if @recentBaseMsgNs.index(msgN)
      #Ƕ᤽Υ١ȯȤä
    return true
  end
  
  #midܤȯؤֻʤȻפȯˤˤĤơ[ȯֹ,ֻ餷]֤
  #١ȯȤƻѤǤΤоݡ
  #Τ̵[nil,0]֤
  def responseTo(mid, debug= false)
    if settings("teacher_mode")
      if isUsableBaseMsg(mid+1) && @log[mid].fromNick=="!input"
        return [mid+1, 20]
      else
        return [nil, 0]
      end
    else
      return @resEst.responseTo(mid, debug)
    end
  end
  
  #ȯѤΥե륿
  def similarSearchFilter(msgN)
    return responseTo(msgN)[0]!=nil
  end
  
  #sentenceμʬNicktarget֤롣
  def replaceMyNicks(sentence, target)
    myNicksReg= Regexp.new(@myNicks.map(){ |n| Regexp.escape(n) }.join("|"))
    return sentence.gsub(myNicksReg){ target }
  end
  
  #ʸϤñ򽦤
  def pickUpInputWords(input)
    input= replaceMyNicks(input, " ")
    #Ϥ˴ޤޤñ
    @newInputWords= @wordSearcher.searchWords(input).select(){ |w| canAdoptWord(w) }
    #Ϥñ줬̵ϡϸѹ
    if @newInputWords.size()==0 && rand(50)==0
      word= @wordSet.words[rand(@wordSet.words.size())]
      @newInputWords= [word] if canAdoptWord(word)
    end
    #Ϣۤñɲ
    assocWords= @newInputWords.map(){ |w| @associator.associate(w.str) } \
      .select(){ |s| s }.map(){ |s| Word.new(s) }
    @newInputWords+= assocWords
    #ϸι
    if @newInputWords.size()>0
      if rand(5)!=0
        @inputWords= @newInputWords
      else
        @inputWords+= @newInputWords
      end
    end
  end
  
  #ñʸפȯѤ뤫롣
  #ñפȯϺѤˤ褦ˤ롣
  #ñ줬̵ȯϳμ¤˺Ѥ졢Υ᥽åɤϻȤʤ
  def shouldAdoptSaying(additionalLen)
    case additionalLen
      when 0
        return false
      when 1
        return rand()<0.125
      when 2, 3
        return rand()<0.25
      when 4...7
        return rand()<0.75
      else
        return true
    end
  end
  
  #inputWordsñޤȯˤĤơ֥å򷫤֤
  #֥åȯֹ˼롣
  #ȯνϥࡣ
  def eachMsgContainingWords(inputWords, &block)
    words= inputWords.clone()
    while words.size()>0
      word= words.delete_at(rand(words.size()))
      msgNs= word.msgNs.clone()
      while msgNs.size()>0
        block.call(msgNs.delete_at(rand(msgNs.size())))
      end
    end
  end
  
  #̤ñȯȡֻȯֹ֤
  #ŬڤʤΤ̵С[nil, nil]
  def getBaseMsgUsingKeyword(inputWords)
    maxMid= maxResMid= nil
    maxProb= 0
    i= 0
    eachMsgContainingWords(inputWords) do |mid|
      (resMid, prob)= responseTo(mid, true)
      if resMid
        if prob>maxProb
          maxMid= mid
          maxResMid= resMid
          maxProb= prob
        end
        i+=1
        break if i>=5
      end
    end
    dprint("ñȯ", @log[maxMid].body) if maxMid
    return [maxMid, maxResMid]
  end
  
  #ȯȡֻȯֹ֤
  #ŬڤʤΤ̵С[nil, nil]
  def getBaseMsgUsingSimilarity(sentence)
    maxMid= maxResMid= nil
    maxProb= 0
    i= 0
    @simSearcher.eachSimilarMsg(sentence) do |mid|
      (resMid, prob)= responseTo(mid, true)
      if resMid
        if prob>maxProb
          maxMid= mid
          maxResMid= resMid
          maxProb= prob
        end
        i+=1
        break if i>=5
      end
    end
    dprint("ȯ", @log[maxMid].body, maxProb) if maxMid
    return [maxMid, maxResMid]
  end
  
  #msgN֤ȯȤä١ȯʸ
  def getBaseMsgStr(msgN)
    str= @log[msgN].body
    #ʸθȾ[]ͭСθϥåȡ
    str= $1 if str=~/^(.*)[]/ && $1.length()>=str.length()/2
    return str
  end
  
  #baseδñnewWordsִΤ֤
  #toForcefalseξ硢ûʸϤˤʤäƤޤänil֤
  def replaceWords(base, newWords, toForce)
    #baseñʬ䤷partsˤ롣
    parts= [base]
    @wordSet.each() do |word|
      if @wordSearcher.hasWord(base, word) && canAdoptWord(word)
        newParts= []
        for i in 0...parts.size()
          part= parts[i]
          if i%2==0
            while part=~Regexp.new("^(.*?)"+Regexp.escape(word.str)+"(.*)$")
              newParts.push($1, word.str)
              part= $2
            end
          end
          newParts.push(part)
        end
        parts= newParts
      end
    end
    #Ƭ2ܰʹߤñľǥåȤꤷʤäꡣ
    if parts.size()>1
      cutPos= rand((parts.size()-1)/2)*2+1
      parts= [""]+parts[cutPos..-1] if cutPos>1
    end
    wordCt= (parts.size()-1)/2
    #ñʸϤûΤϤΨǵѲ
    if wordCt>0 && !toForce
      len= sigma(0...parts.size()){ |i| i%2==0 ? parts[i].jlength() : 0 }
      return nil if !shouldAdoptSaying(len)
    end
    #ñִ
    newWords= newWords.clone()
    while newWords.size()>0
      oldWordStr= parts[rand(wordCt)*2+1]
      newWordStr= newWords.delete_at(rand(newWords.size())).str
      for i in 0...wordCt
        parts[i*2+1]= newWordStr if parts[i*2+1]==oldWordStr
      end
      break if rand()<0.5
    end
    output= parts.join("")
    #Ĥ̤Ĥä˳̤䤦
    #ҤˤʤäƤꤷΤʤ
    case output
      when /^[^֡]*/
        output= ""+output
      when /^[^ʡ]*/
        output= ""+output
      when /^[^()]*\)/
        output= "("+output
    end
    return output
  end
  
  #ͳȯϿ롣
  def recordThought(pattern, simMid, resMid, words, output)
    wordsStr= words.map(){ |w| w.str }.join(",")
    row= [@log.size-1, pattern, simMid, resMid, wordsStr, output]
    @thoughtFile.print(row.join("\t")+"\n")
  end
  
  #ͳȯ롣
  def speakFreely(fromNick, origInput, mustRespond)
    input= replaceMyNicks(origInput, " ")
    output= nil
    simMsgN, baseMsgN= getBaseMsgUsingSimilarity(input)
      #ޤȤäƥ١ȯ롣
    if @newInputWords.size()>0
      if baseMsgN
        #ѥ1: ñͭȯͭꡣ
        output= replaceWords(getBaseMsgStr(baseMsgN), @inputWords, mustRespond)
        recordThought(1, simMsgN, baseMsgN, @newInputWords, output) if output
      else
        #ѥ2: ñͭȯ̵
        simMsgN, baseMsgN= getBaseMsgUsingKeyword(@newInputWords)
        output= getBaseMsgStr(baseMsgN) if baseMsgN
        recordThought(2, simMsgN, baseMsgN, @newInputWords, output) if output
      end
    else
      if baseMsgN
        #ѥ3: ñ̵ȯͭꡣ
        output= getBaseMsgStr(baseMsgN)
        if !@wordSearcher.searchWords(output).empty?()
          if mustRespond
            output= replaceWords(output, @inputWords, true)
          else
            output= nil
          end
        end
        recordThought(3, simMsgN, baseMsgN, @inputWords, output) if output
      else
        #ѥ4: ñ̵ȯ̵
        if mustRespond && @inputWords.size()>0
          #ǿǤʤϸȤäƥɸ
          simMsgN, baseMsgN= getBaseMsgUsingKeyword(@inputWords)
          output= getBaseMsgStr(baseMsgN) if baseMsgN
          recordThought(4, simMsgN, baseMsgN, @inputWords, output) if output
        end
      end
    end
    if mustRespond && !output
      #ȯ
      @log.size().times() do
        #ϥ󥰤Τɤᡢ̵¥롼פˤϤʤ
        msgN= rand(@log.size())
        if isUsableBaseMsg(msgN)
          baseMsgN= msgN
          output= getBaseMsgStr(baseMsgN)
          break
        end
      end
    end
    if output
      #ǶȤä١ȯ򹹿
      @recentBaseMsgNs.shift()
      @recentBaseMsgNs.push(baseMsgN)
      #ȯμʬNickNickѴ
      output= replaceMyNicks(output, fromNick)
      #ºݤȯ
      speak(origInput, output)
    end
  end
  
  #ͳȯäȤȯ롣
  def speak(input, output)
    @lastSpeachInput= input
    @lastSpeach= output
    studyMsg("!", output) #ʬȯ򵭲롣
    @client.outputInfo(""+input+"פȿ") if settings("teacher_mode")=="true"
    @attention.onSelfSpeak(@wordSearcher.searchWords(output))
    @client.speak(output)
  end
  
  #귿ޥɤ
  #Ϥ귿ޥɤǤбå֤
  #Ǥʤnil֤λޥɤä:exit֤
  def processCommand(input)
    if input=~/򹹿/
      loadSettings()
      return "򹹿ޤ"
    end
    return nil if settings("disable_commands")=="true"
      #ޥɤػߤƤ
    if input=~/ۤ|ۤʤ|ۤäƤ|ۥ⡼/
      return changeMode(0) ? "ۥ⡼ɤڤؤ롣" : ""
    elsif input=~/ۥ⡼/
      return changeMode(1) ? "ۥ⡼ɤڤؤ롣" : ""
    elsif input=~/̾⡼/
      return changeMode(2) ? "̾⡼ɤڤؤ롣" : ""
    elsif input=~/⡼/
      return changeMode(3) ? "⡼ɤڤؤ롣" : ""
    elsif input=~/٤ɤ|λʤ/
      save()
      @client.exit()
      return :exit
    elsif input=~/([\x21-\x7e]+)(||ʪ)(ޤ|)/
      begin
        @targetNickReg= Regexp.new($1)
        return $1+"ΤΤޤͤ򳫻Ϥ롣"
      rescue RegexpError
        return "ɽְäƤ롣"
      end
    elsif input=~/Ф|ä/ && input=~/ï/ && input=~/(.+?)/
      wordStr= $1
      wordIdx= @wordSet.words.index(Word.new(wordStr))
      if (wordIdx)
        author= @wordSet.words[wordIdx].author
        if (author.length()>0)
          return author+"ˡ"+wordStr
        else
          return "Գ"+wordStr
        end
      else
        return "ñϵƤʤ"
      end
    end
    return nil #귿ޥɤǤϤʤ
  end
  
  #̾ȯؽ
  def studyMsg(fromNick, input)
    return if settings("disable_studying")=="true"
    if settings("teacher_mode")=="true"
      @fromNick= fromNick
      @extractor.processLine(input) #ñФΤߡ
    else
      @log.addMsg(fromNick, input)
    end
  end
  
  #ؽƤư¸
  def save()
    @wordSet.save()
  end
  
  #ȯɲä줿
  def onAddMsg()
    msg= @log[@log.size()-1]
    @fromNick= msg.fromNick if msg.fromNick!="!"
    if settings("teacher_mode")!="true"
      #οͥ⡼ɤǤϡñФ̤ˤ롣
      @extractor.processLine(msg.body)
    end
    #@extractorʳΥ֥ȤϼϤ@logƻ뤷ƤΤǡ
    #ǲɬפ̵
  end
  
  #ꥢ줿
  def onClearLog
  end
  
  #ñ줬ɲä줿
  def onAddWord(wordStr)
    if @wordSet.addWord(wordStr, @fromNick)
      if @client
        @client.outputInfo("ñ"+wordStr+"פ򵭲")
      else
        jprint("ñ"+wordStr+"פ򵭲\n")
      end
      @wordSet.save() if @autoSave
    end
  end
  
  #³򳫻Ϥ
  def onBeginConnecting()
    jprint_to($stderr, "³...\n")
  end
  
  #ʬ
  def onSelfJoin()
    updateStatus()
  end
  
  #¾ͤ
  def onOtherJoin(fromNick)
  end

  #¾ͤȯ
  def onOtherSpeak(fromNick, input, shouldIgnore= false)
    output= nil #ȯ
    isCalled= there_exists?(@myNicks){ |n| input.index(n) }
    output= processCommand(input) if isCalled
    if output
      @client.speak(output) if output!=:exit && !output.empty?
    else #귿ޥɤǤϤʤ
      @lastSpeach= input
      studyMsg(fromNick, input)
      pickUpInputWords(input)
      prob= @attention.onOtherSpeak(fromNick, input, isCalled)
        #ȯΨ롣
      dprint("ȯΨ", prob, @attention.to_s())
      if (!shouldIgnore && rand()<prob) || prob>1.0
        #ͳȯá
        speakFreely(fromNick, input, prob>1.0)
      end
    end
  end
  
  #ȯinfoǤȯˤä
  def onControlMsg(str)
    return if settings("disable_studying")=="true" || settings("teacher_mode")!="true"
    if str=~/^(.+)(.+)$/
      input= $1
      output= $2
    else
      input= @lastSpeachInput
      output= str
    end
    if input
      @log.addMsg("!input", input)
      @log.addMsg("!teacher", output)
      if @client
        @client.outputInfo("ȿ%s%sפؽ" % [input, output])
      end
    end
  end
  
  #ۤФ餯³
  def onSilent()
    prob= @attention.onSilent()
    #dprint("ȯΨ", @attention.to_s())
    if rand()<prob && @lastSpeach
      #ȯȯ
      speakFreely(@fromNick, @lastSpeach, prob>rand()*1.1)
        #ȯȯǤϡȯ̵¤ꡢƱȯоݤˤĤŤ롣
        #Τ٤ʤʤΤɤᡢmustRespondONˤ롣
    end
  end
  
end


end #module Gimite

