#----------------------------------------------------------------------------
#
# IRCNCAgCu
#
#      Programed by NAKAUE.T (Meister)
#      Modified by Gimite s
#
#  2003.05.04  Version 1.0.0   gĂl̂Ń\[X𐮗
#  2003.05.10  Version 1.1.0   NICKǉ
#  2003.07.24  Version 1.2.0g  r[Ƀ}``lΉ(Gimite)
#  2003.09.27  Version 1.2.1   UltimateIRCdŔFؑOPINGɑΏ(Meister)
#                              (thanks for bancho)
#  2003.09.28  Version 1.2.2   R[hϊ𐮗(Meister)
#                              OƂ̂sR[hw肷
#                              (IRCJISgƂɂȂĂ)
#                              initializẽp[^ύXɂȂ̂ŒӁI
#  2003.09.28  Version 2.0.0   C^[tF[X(Meister)
#                              ݊ႭȂ̂ňCɃo[Wグ
#  2003.10.01  Version 2.0.1   NICK̃oOC(Meister)
#  2004.01.01  Version 2.0.2   CX^XɃ\Pbgn悤ɂ
#  2004.03.03  Version 2.0.3g  ڑ؂ꂽɁAIRCC#connectōĐڑł悤
#                              IRCG[IRCC#on_errorǉ(Gimite)
#
#
# ̃\tgEFAPublic Domain SoftwarełB
# RɗpEςč\܂B
# ς̗Lɂ炸ARɍĔzz邱Ƃo܂B
# ҂͂̃\tgEFAɊւāASĂ̌ƑSĂ̋`܂B
#
#----------------------------------------------------------------------------
# IRCvgRɂĂRFC2810-2813QƂ̂ƁB{󂠂܂B
#----------------------------------------------------------------------------
require 'kconv'
#----------------------------------------------------------------------------
class IRCC

  def initialize(sock,userinfo,kanjicode='s',disp=$stdout)
    @sock=sock
    @userinfo=userinfo
    @irc_nick=@userinfo['nick']
    setchannel(@userinfo['channel'])    # JOIN`l
                                        # ̃`l𔲂ƏI(dl)
    @channel_key=@userinfo['channel_key']||''

    @nicklist=[]
    @joined_channel=nil

    case kanjicode[0..0]
    when 's','S'
      @kconv_kanjicode=Kconv::SJIS
    when 'e','E'
      @kconv_kanjicode=Kconv::EUC
    when 'j','S'
      @kconv_kanjicode=Kconv::JIS
    else
      @kconv_kanjicode=Kconv::JIS
    end

    @disp=disp
  end

  def sock; @sock;    end
  def userinfo; @userinfo;  end
  def nicklist; @nicklist;  end
  def mynick;   @irc_nick;  end
  def joined_channel;   @joined_channel;    end


  # CX^X̃\Pbgڑ
  def connect(sock)
    @sock=sock
    @myprefix= nil
  end


  # JISR[hɕϊ
  def kconv_fromjis(buff)
    return Kconv.kconv(buff,@kconv_kanjicode,Kconv::JIS)
  end

  # R[hJISɕϊ
  def kconv_tojis(buff)
    return Kconv.kconv(buff,Kconv::JIS,@kconv_kanjicode)
  end

  # `lZbg
  # 킴킴֐ɂȂĂ̂́AYꂸJISR[hłKv邩
  def setchannel(channel)
    @irc_channel=channel
    @irc_channel_jis=Kconv.tojis(@irc_channel)
  end

  # bZ[W𑗐M()
  def sendmess(mess)
    @sock.print(kconv_tojis(mess))
    @disp.puts(mess.chop) if DEBUG
  end

  # bZ[W𑗐M()(R[hϊȂ)
  def sendmess_raw(mess)
    @sock.print(mess)
    @disp.puts(kconv_fromjis(mess.chop)) if DEBUG
  end

  # bZ[W̑M(ʏPRIVMSG)
  def sendpriv(mess)
    mess='' if mess==nil
    dispmess('>'+@irc_nick+'<',mess)
    buff='PRIVMSG '+@irc_channel+' :'+mess
    sendmess(buff+"\r\n")
  end

  # bZ[W̑M(NOTICE)
  def sendnotice(mess)
    mess='' if mess==nil
    dispmess('>'+@irc_nick+'<',mess)
    buff='NOTICE '+@irc_channel+' :'+mess
    sendmess(buff+"\r\n")
  end

  # ʂ̃`lɈړ
  def movechannel(channel)
    old_channel= @irc_channel_jis
    setchannel(channel)
      #PART̑OɂĂȂQUITĂ܂
    sendmess('PART '+old_channel+"\r\n")
    sendmess('JOIN '+@irc_channel+" "+@channel_key+"\r\n")
  end

  # I(ۂɂ̓`l𔲂Ă)
  def quit
    sendmess_raw('PART '+@irc_channel_jis+"\r\n")
  end

  # T[o󂯎bZ[W
  def on_recv(s)
    s.chomp!("\n")
    s.chomp!("\r")
    @disp.puts('>'+kconv_fromjis(s)) if DEBUG

    prefix=":unknown!unknown@unknown"
    prefix,param=s.split(' ',2) if s[0..0]==':'
    nick,prefix=prefix.split('!',2)
    nick.slice!(0)
    param=s if !param

    param,param2=param.split(/ :/,2)
    param=param.split(' ')
    param << param2 if param2

    case param[0]
    when 'PRIVMSG','NOTICE' # ʏ̃bZ[W(NOTICEւBOT̔͋֎~Ă)
      if param[2][1..1]!="\001"
        mess=kconv_fromjis(param[-1])
        if (param[1]).downcase==(@irc_channel_jis).downcase
          on_priv(param[0],nick,mess)
        else
          # `l̊O̔
          on_external_priv(param[0],nick,kconv_fromjis(param[1]),mess)
        end
      end
    when '372','375'    # MOTD(Message Of The Day)
      on_motd(kconv_fromjis(param[-1]))
    when '353'      # `lQo[̃Xg
      @nicklist+=param[-1].gsub(/@/,'').split
    when 'JOIN' # N`lɎQ
      channel=kconv_fromjis(param[1])
      if @myprefix==prefix
        @joined_channel=channel
        on_myjoin(channel)
      else
        @nicklist|=[nick]
        on_join(nick,channel)
      end
    when 'PART' # N`l甲
      channel=kconv_fromjis(param[1])
      if @myprefix==prefix
        @nicklist=[]
        @joined_channel=nil
        on_mypart(channel)
        # IV[PXQUIT
        sendmess_raw("QUIT\r\n") if (param[1]).downcase==(@irc_channel_jis).downcase
      else
        @nicklist.delete(nick)
        on_part(nick,channel)
      end
    when 'QUIT' # NI
      mess=kconv_fromjis(param[-1])
      if @myprefix==prefix
        @nicklist=[]
        on_myquit(mess)
      else
        @nicklist.delete(nick)
        on_quit(nick,mess)
      end
    when 'KICK' # N`lRꂽ
      kicker=nick
      channel=kconv_fromjis(param[1])
      nick=param[2]
      mess=param[3]||''

      if nick==@irc_nick
        if (param[1]).downcase==(@irc_channel_jis).downcase
          @nicklist=[]
          @joined_channel=nil
        end
        on_mykick(channel,mess,kicker)
        # Rꂽ̂QUIT
        sendmess_raw("QUIT\r\n") if (param[1]).downcase==(@irc_channel_jis).downcase
      else
        @nicklist.delete(nick)
        on_kick(nick,channel,mess,kicker)
      end
    when 'NICK'     # NNICKύX
      nick_new=param[1]

      @irc_nick=nick_new if nick==@irc_nick

      @nicklist.delete(nick)
      @nicklist|=[nick_new]

      on_nick(nick,nick_new)
    when 'INVITE'     # N҂
      if param[1]==@irc_nick
        on_myinvite(nick,kconv_fromjis(param[-1]))
      end
    when 'PING'     # NCAg̐mF
      if @myhostname
        sendmess_raw('PONG '+@myhostname+' '+param[1]+"\r\n")
      else
        # UltimateIRCdłMOTDOPING
        # mȃNCAg̃zXgsȂ߁AKPONGԂ
        sendmess_raw('PONG dummy '+param[1]+"\r\n")
      end
    when '376','422'    # MOTD̏I=OCV[PX̏I
      # prefixmF邽WHOIS𔭍s
      sendmess_raw('WHOIS '+@irc_nick+"\r\n")
    when '311'      # WHOISւ̉
      if @myprefix==nil
        # prefix擾
        @myhostname=param[4]
        @myprefix=param[3]+'@'+@myhostname
        on_login()
      end
    when '433'      # nickd
      on_error('433')
      # ͏dȂnickōēxNICK𔭍s
    when '451'      # F؂ĂȂ
      on_error('451')
      @disp.puts('unknown login sequence!!') if DEBUG
    end
  end

  # ڑm̏
  def on_connect
    @disp.puts('connect') if DEBUG
    dispmess(nil,'Login...')

    if @userinfo['pass'] && @userinfo['pass']!=""
      sendmess('PASS '+@userinfo['pass']+"\r\n")
    end
    sendmess('NICK '+@irc_nick+"\r\n")
    sendmess('USER '+@userinfo['user']+' 0 * :'+@userinfo['realname']+"\r\n")
  end


  # 牺̓I[o[Ch鎖z肵Ă

  # bZ[W\(R[h͕ϊȂ)
  def dispmess(nick,mess)
    buff=Time.now.strftime('%H:%M:%S ')
    buff=buff+nick+' ' if nick
    buff=buff+mess
    @disp.puts(buff)
    @disp.flush()
  end

  # ڑEF؂A`lJOINł
  def on_login
    sendmess_raw('JOIN '+@irc_channel_jis+" "+@channel_key+"\r\n")
  end

  # MOTD(T[õOCbZ[W)
  def on_motd(mess)
    dispmess(nil,mess)
  end

  # ʏ탁bZ[WM̏
  def on_priv(type,nick,mess)
    dispmess('<'+nick+'>',mess)
  end

  # `l̊O̒ʏ탁bZ[WM̏
  def on_external_priv(type,nick,channel,mess)
  end

  # JOINM̏
  def on_join(nick,channel)
    dispmess(nick,'JOIN '+channel)
  end

  # PARTM̏
  def on_part(nick,channel)
    dispmess(nick,'PART '+channel)
  end

  # QUITM̏
  def on_quit(nick,mess)
    dispmess(nick,'QUIT '+mess)
  end

  # KICKM̏
  def on_kick(nick,channel,mess,kicker)
    dispmess(nick,'KICK '+channel+' '+kicker+' '+mess)
  end

  # JOINM̏
  def on_myjoin(channel)
    on_join(@irc_nick,channel)
  end

  # PARTM̏
  def on_mypart(channel)
    on_part(@irc_nick,channel)
  end

  # QUITM̏
  def on_myquit(mess)
    on_quit(@irc_nick,mess)
  end

  # KICKM̏
  def on_mykick(channel,mess,kicker)
    on_kick(@irc_nick,channel,mess,kicker)
  end

  # NICKM̏
  def on_nick(nick_old,nick_new)
    dispmess(nick_old,'NICK '+nick_new)
  end

  # INVITEꂽ̏
  def on_myinvite(nick,channel)
    dispmess(nick,'INVITE '+channel)
  end
  
  # G[̎̏
  def on_error(code)
    @disp.puts("Error: "+code)
    sendmess_raw("QUIT\r\n")  # ʓ|Ȃ̂ŏIɂĂ
  end
  
end
#----------------------------------------------------------------------------

