#Copyright (C) 2003 Gimite  <gimite@mx12.freecom.ne.jp>

#ܸʸȽѥ
DEBUG= false
require 'socket'
require 'thread'
require 'kconv'
require 'jcode'
require $REUDY_DIR+'/irc-client'
require $REUDY_DIR+'/reudy_common'


module Gimite


#ʸɤ$OUT_KCODEѴƽϤ롢$stdoutɤȴ
JSTDOUT= Object.new()
class << JSTDOUT
  
  include(Gimite)
  
  def puts(str)
    jprint_to($stdout, str+"\n")
  end
  
  def flush()
    $stdout.flush()
  end
  
end


#ܥåѤIRC饤
class BotIRCClient < IRCC
  
  include(Gimite)
  
  SILENT_SECOND= 20.0 #ۤ³ȽǤÿ
  
  def initialize(user, logOut= JSTDOUT)
    @user= user
    @isExitting= false
    @channel= @user.settings("channel")
    @infoChannel= @user.settings("info_channel")
    @nick= @user.settings("nick")
    @user.client= self
    @user.onBeginConnecting()
    pass= @user.settings("login_password")
    option= {
      'user'=>@user.settings("name"), \
      'realname'=>@user.settings("real_name"), \
      'pass'=>pass, \
      'nick'=>@nick, \
      'channel'=>@channel, \
      'channel_key'=>@user.settings("channel_key") \
    }
    super(nil, option, $KCODE, logOut)
  end
  
  #IRCΥåҤ롼ס
  def processLoop()
    while true
      begin
        @isJoiningInfoChannel= false
        @prevTime= Time.now() #onSilentѡ
        @receiveQue= Queue.new() #ä̾ȯΥ塼
        @controlQue= Queue.new() #äȯΥ塼
        connect(TCPSocket.open(@user.settings("host"), @user.settings("port").to_i(),
          @user.settings("localhost")))
        on_connect() #å³ν
        pingThread= Thread.new(){ pingProcess() }
        receiveThread= Thread.new(){ receiveProcess() }
        #롼ס
        while line= sock().gets()
          on_recv(line)
          if Time.now()-@prevTime>=SILENT_SECOND
            @prevTime= Time.now()
            @user.onSilent()
              #ۤФ餯³
              #ȯ̵ƤpingProcess()ΤŪ˥åǤΤǡ
              #ǥåOK
          end
        end
        jprint("Ǥޤ\n")
      rescue SystemCallError, SocketError, IOError => ex
        jprint("Ǥޤ"+ex.message()+"\n")
      end
      pingThread.exit() if pingThread
      @receiveQue.push(nil)
      receiveThread.join() if receiveThread
      break if @isExitting || @user.settings("auto_reconnect")!="true"
      sleep(10)
      break if !queryReconnect()
      jprint("³...\n")
    end
  end
  
  #
  def outputInfo(s)
    sleep(@user.settings("wait_before_info").to_f()) if @user.settings("wait_before_info")
    sendmess("NOTICE "+@infoChannel+" :"+s+"\n")
  end
  
  #ȯ
  def speak(s)
    if @user.settings("speak_with_privmsg")=="true"
      sendpriv(s)
    else
      sendnotice(s)
    end
  end
  
  #ͥư³ϤäȤ
  def moveChannel(channel)
    greeting= @user.settings("leaving_message")
    speak(greeting) if greeting
    @channel= channel
    movechannel(@channel)
  end
  
  #ͥѹϤäȤ
  def setChannel(channel)
    @channel= channel
    setchannel(@channel)
  end
  
  def status=(status)
  end
  
  #λ
  def exit()
    @isExitting= true
    greeting= @user.settings("leaving_message")
    sendmess(greeting ? "QUIT :"+greeting+"\r\n" : "QUIT\r\n")
  end
  
  #ʲIRCCΥ᥽åɤΥХ饤
  
  def on_priv(type, nick, mess)
    super(type, nick, mess)
    onPriv(type, nick, mess)
  end
  
  def on_external_priv(type, nick, to, mess)
    super(type, nick, to, mess)
    onExternalPriv(type, nick, to, mess)
  end
  
  def on_join(nick, channel)
    super(nick, channel)
    onJoin(nick, channel)
  end
  
  def on_myjoin(channel)
    #IRCC#on_myjoinǤon_joinƤФƤޤΤǡ
    #superƤǤϤʤ
    onMyJoin(channel)
  end
  
  def on_myinvite(nick, channel)
    super(nick, channel)
    onInvite(nick, channel)
  end
  
  def on_error(code)
    onError(code)
  end
  
  #ʲ饹ǥХ饤ɲǽʥ᥽å
  
  #̤Υå
  def onPriv(type, nick, mess)
    if nick!=@nick && (@user.settings("respond_to_notice")=="true" || type=="PRIVMSG")
      @prevTime= Time.now()
      @receiveQue.push([nick, mess.strip()])
    end
  end
  
  #ͥγ̤Υå
  def onExternalPriv(type, nick, to, mess)
    return if nick==@nick || (@user.settings("respond_to_notice")!="true" && type!="PRIVMSG")
    @prevTime= Time.now()
    if @user.settings("respond_to_external")!="true"
      #ͥ볰ȯȯȤʲ͡
      @controlQue.push(mess.strip())
      @receiveQue.push(:nop) #å롼פΥ֥å򤯡
    else
      @receiveQue.push([nick, mess.strip()])
    end
  end
  
  #¾ͤJOIN
  def onJoin(nick, channel)
    greeting= @user.settings("private_greeting")
    sendmess("NOTICE "+nick+" :"+greeting+"\n") if greeting && greeting!=""
    @user.onOtherJoin(nick)
  end
  
  #ʬJOIN
  def onMyJoin(channel)
    if channel.strip().downcase == @channel.downcase
      greeting= @user.settings("joining_message")
      speak(greeting) if greeting
      @user.onSelfJoin()
    end
    if !@isJoiningInfoChannel
      sendmess("JOIN "+@infoChannel+"\r\n") 
      @isJoiningInfoChannel= true
    end
  end
  
  #Ԥ줿
  def onInvite(nick, channel)
    moveChannel(channel)
  end
  
  #³˸ƤӽФ롣
  #false֤ȡ³˽λ롣
  def queryReconnect()
    return true
  end
  
  #顼
  def onError(code)
    if code=="433"
      jprint("Error: ˥å͡ "+@nick+" ϡ̤οͤ˻ȤƤޤ\n")
    else
      jprint("Error: 顼 "+code+"\n")
    end
    sendmess_raw("QUIT\r\n") #QUITƺ³
  end
  
  private
  
  #ƥ塼ˤޤäƤȯ롣
  def receiveProcess()
    while args= popMessage()
      while args
        if @user.settings("wait_before_speak")
          sleep(@user.settings("wait_before_speak").to_f()*(0.5+rand()))
        end
        if @receiveQue.empty?()
          @user.onOtherSpeak(*(args+[false]))
          break
        end
        while !@receiveQue.empty?() && args
          #¾οͤȯä硢ȯ϶̵뤹롣
          @user.onOtherSpeak(*(args+[true]))
          args= popMessage()
          return if !args
        end
      end
    end
  end
  
  #ƥ塼ˤޤäƤȯФ
  #ȯͥ褷ƽ롣
  def popMessage()
    while true
      mess= @receiveQue.pop()
      while !@controlQue.empty?
        @user.onControlMsg(@controlQue.pop())
      end
      return mess if mess!=:nop
    end
  end
  
  #Ū˰̵̣åꡢ̿ڤƤʤΤ롣
  #̿ڤ줿顢sock().gets()Υ֥å֤뤿sock().close()롣
  def pingProcess()
    while true
      sleep(SILENT_SECOND)
      begin
        sendmess("TOPIC "+@channel+"\r\n")
      rescue
        sock.close()
        Thread.exit()
      end
    end
  end
  
end


end #module Gimite
