<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsltlib="http://jsa.or.jp/xsltlib/convert_zenkaku_hankaku"
  exclude-result-prefixes="xsltlib"
  version="1.0">

  <xsl:variable name="xsltlib:convert_zenkaku_hankaku_target" select="//*"/>

  <xsl:variable name="xsltlib:convert_zenkaku_hankaku_recursive"/>

  <xsl:variable name="xsltlib:zenkaku" select="'０１２３４５６７８９ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ！”＃＄％＆（）＊＋，−．／：；＜＝＞？＠［￥］＾＿｀｛｜｝〜。、・「」ヲァィゥェォャュョッーアイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワン゛゜’'"/>

  <xsl:variable name="xsltlib:hankaku" select="concat('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!&#x22;#$%&#x26;()*+,-./:;&lt;=&gt;?@[\]^_`{|}~｡､･｢｣ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ',&quot;&apos;&quot;)"/>
<!-- 記号類を追加 2007.3.16 ogiso --><!-- 半角カタカナを追加 2009.4.30 ogiso -->

  <xsl:template name="xsltlib:convert_zenkaku_to_hankaku">
    <xsl:apply-templates select="/*" mode="xsltlib:convert_zenkaku_hankaku">
      <xsl:with-param name="dir" select="'z2h'"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template name="xsltlib:convert_hankaku_to_zenkaku">
    <xsl:apply-templates select="/*" mode="xsltlib:convert_zenkaku_hankaku">
      <xsl:with-param name="dir" select="'h2z'"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="*|text()" mode="xsltlib:convert_zenkaku_hankaku">
    <xsl:param name="dir"/>
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:choose>
        <xsl:when test="count(.|$xsltlib:convert_zenkaku_hankaku_target)=count($xsltlib:convert_zenkaku_hankaku_target)">
          <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku_each">
            <xsl:with-param name="dir" select="$dir"/>
          </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku">
            <xsl:with-param name="dir" select="$dir"/>
          </xsl:apply-templates>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="xsltlib:convert_zenkaku_to_hankaku_each">
    <xsl:param name="convert_zenkaku_hankaku_target"/>
    <xsl:for-each select="$convert_zenkaku_hankaku_target">
      <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku_each">
          <xsl:with-param name="dir" select="'z2h'"/>
        </xsl:apply-templates>
      </xsl:copy>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="xsltlib:convert_hankaku_to_zenkaku_each">
    <xsl:param name="convert_zenkaku_hankaku_target"/>
    <xsl:for-each select="$convert_zenkaku_hankaku_target">
      <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku_each">
          <xsl:with-param name="dir" select="'h2z'"/>
        </xsl:apply-templates>
      </xsl:copy>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="*" mode="xsltlib:convert_zenkaku_hankaku_each">
    <xsl:param name="dir"/>
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:choose>
        <xsl:when test="$xsltlib:convert_zenkaku_hankaku_recursive = true()">
          <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku_each">
            <xsl:with-param name="dir" select="$dir"/>
          </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates mode="xsltlib:convert_zenkaku_hankaku">
            <xsl:with-param name="dir" select="$dir"/>
          </xsl:apply-templates>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="text()" mode="xsltlib:convert_zenkaku_hankaku_each">
    <xsl:param name="dir"/>
    <xsl:choose>
      <xsl:when test="$dir = 'z2h'">
        <xsl:value-of select="translate(., $xsltlib:zenkaku, $xsltlib:hankaku)"/>
      </xsl:when>
      <xsl:when test="$dir = 'h2z'">
        <xsl:value-of select="translate(., $xsltlib:hankaku, $xsltlib:zenkaku)"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
