<?xml version="1.0"?>

<!-- XSLT stylesheet for NumTrans            -->
<!--                              ver. 0.51  -->
<!--               2008-06-20 by Studio ARC  -->
<!-- Copyright (c) 2006-2008 Studio ARC      -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:num="http://www.unidic.org/numtrans/ns/structure/1.0"
  version="1.0"
  xml:lang="ja">

  <xsl:output method="xml" encoding="UTF-8" omit-xml-declaration="yes" indent="no"/>

  <!-- all_mode: '', 'read', 'cor' -->
  <xsl:param name="all_mode" select="''"/>

  <!-- 変数群 -->
  <xsl:variable name="trans_tag" select="'num:A'"/>
  <xsl:variable name="scope_tag" select="'num:S'"/>

  <xsl:variable name="reject_msg" select="'*REJECT*'"/>

  <xsl:variable name="ZENKAKU_PERIOD" select="'．'"/>
  <xsl:variable name="ZENKAKU_COMMA" select="'，'"/>
  <xsl:variable name="ZENKAKU_NAKAGURO" select="'・'"/>
  <xsl:variable name="ZENKAKU_TOUTEN" select="'、'"/>
  <xsl:variable name="ZENKAKU_NO" select="'の'"/>
  <xsl:variable name="ZENKAKU_KARA" select="'～'"/>
  <xsl:variable name="ZENKAKU_WAVE" select="'〜'"/>
  <xsl:variable name="ZENKAKU_DASH" select="'―'"/>
  <xsl:variable name="ZENKAKU_HYPHEN" select="'‐'"/>
  <xsl:variable name="ZENKAKU_MINUS" select="'−'"/>
  <xsl:variable name="ZENKAKU_SLASH" select="'／'"/>
  <xsl:variable name="ZENKAKU_COLON" select="'：'"/>
  <xsl:variable name="ZENKAKU_KAKKO_KAI" select="'（'"/>
  <xsl:variable name="ZENKAKU_KAKKO_HEI" select="'）'"/>
  <xsl:variable name="ZENKAKU_APOS" select="'’'"/>
  <xsl:variable name="KANSUUJI_SEN" select="'千'"/>
  <xsl:variable name="ZENKAKU_0" select="'０'"/>
  <xsl:variable name="ZENKAKU_1" select="'１'"/>
  <xsl:variable name="ZENKAKU_2" select="'２'"/>
  <xsl:variable name="ZENKAKU_3" select="'３'"/>
  <xsl:variable name="YEN_MARK" select="'￥'"/>
  <xsl:variable name="KANJI_YEN" select="'円'"/>
  <xsl:variable name="KANJI_SEN" select="'銭'"/>

  <xsl:variable name="digit" select="'0123456789'"/>
  <xsl:variable name="sansuuji" select="'０１２３４５６７８９'"/>
  <xsl:variable name="kansuuji" select="'〇一二三四五六七八九'"/>
  <xsl:variable name="ketakanji" select="'一十百千万十百千億十百千兆十百千'"/>
  <xsl:variable name="ketakanji_s" select="'十百千'"/>
  <xsl:variable name="ketakanji_es" select="'百千万億兆'"/>
  <xsl:variable name="ketakanji_e" select="'十百千万億兆'"/>
  <xsl:variable name="tsuukamark" select="'￥＄'"/>
  <xsl:variable name="alphabet_l" select="'ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ'"/>
  <xsl:variable name="alphabet_u" select="'ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ'"/>

  <xsl:variable name="BUNSUU_INS" select="'分の'"/>
  <xsl:variable name="BUNSUU_INS_C" select="'分'"/>
  <xsl:variable name="KANJI_JOU" select="'乗'"/>
  <xsl:variable name="KANJI_TAI" select="'対'"/>
  <xsl:variable name="KANSUUJI_REI" select="'零'"/>
  <xsl:variable name="KANSUUJI_ZERO" select="'〇'"/>
  <xsl:variable name="KANA_ZERO" select="'ゼロ'"/>

  <xsl:variable name="KANJI_JIKAN" select="'時間'"/>
  <xsl:variable name="KANJI_JI" select="'時'"/>
  <xsl:variable name="KANJI_HUN" select="'分'"/>
  <xsl:variable name="KANJI_BYOU" select="'秒'"/>
  <xsl:variable name="KANJI_NEN" select="'年'"/>
  <xsl:variable name="KANJI_GETSU" select="'月'"/>
  <xsl:variable name="KANJI_HI" select="'日'"/>
  <xsl:variable name="KIGOU_POSTAL" select="'〒'"/>

  <xsl:variable name="zuhyou_pre" select="' 図 表 '"/>
  <xsl:variable name="zuhyou_post" select="' 図 表 条 節 '"/>
  <xsl:variable name="nengou_pre" select="' 昭 平 '"/>
  <xsl:variable name="nengou_pre2" select="' 明治 大正 昭和 平成 '"/>
  <xsl:variable name="time_pre" select="' 前 後 朝 昼 夜 '"/>
  <xsl:variable name="unit_post" select="' ％ ℃ '"/>
  <xsl:variable name="youbi_post" select="' （月） （火） （水） （木） （金） （土） （日） '"/>
  <xsl:variable name="phone_pre" select="' 内線 '"/>
  <xsl:variable name="postal_pre" select="' 郵便番号 '"/>
  <xsl:variable name="eng_1st" select="'ｓｔ'"/>
  <xsl:variable name="eng_2nd" select="'ｎｄ'"/>
  <xsl:variable name="eng_3rd" select="'ｒｄ'"/>
  <xsl:variable name="eng_nth" select="'ｔｈ'"/>
  <xsl:variable name="eng_post" select="concat(' ', $eng_1st, ' ', $eng_2nd, ' ', $eng_3rd, ' ', $eng_nth, ' ｅｒ ’ｓ ')"/>

  <xsl:variable name="k_starts" select="concat($kansuuji, $ketakanji_s, $tsuukamark, $ZENKAKU_PERIOD)"/>
  <xsl:variable name="s_starts" select="concat($sansuuji, $tsuukamark, $ZENKAKU_PERIOD)"/>
  <xsl:variable name="mids" select="concat($ZENKAKU_PERIOD, $ZENKAKU_COMMA, $ZENKAKU_NAKAGURO, $ZENKAKU_SLASH, $ZENKAKU_KARA, $ZENKAKU_WAVE, $ZENKAKU_COLON, $ZENKAKU_TOUTEN, $ZENKAKU_DASH, $ZENKAKU_HYPHEN, $ZENKAKU_KAKKO_KAI, $ZENKAKU_KAKKO_HEI)"/>
  <xsl:variable name="k_ends" select="concat($kansuuji, $ketakanji_e, $KANJI_YEN)"/>
  <xsl:variable name="s_ends" select="concat($sansuuji, $ketakanji_es, $KANJI_YEN)"/>
  <xsl:variable name="zero_hen" select="concat($KANJI_JI, $KANJI_HUN, $KANJI_BYOU, $KANJI_GETSU, $KANJI_HI)"/>
  <xsl:variable name="zeros" select="concat($ZENKAKU_0, $KANSUUJI_ZERO)"/>

  <!-- 外部データファイルの指定 -->
  <xsl:variable name="datafile" select="document('trans_data.xml')"/>
  <xsl:variable name="maru_list" select="$datafile//maru_list"/>
  <xsl:key name="msuuji" match="maru" use="@unicode"/>
  <xsl:variable name="keta_list" select="$datafile//keta_list"/>
  <xsl:key name="kkanji" match="keta" use="@kanji"/>
  <xsl:variable name="currency_list" select="$datafile//currency_list"/>
  <xsl:key name="cmark" match="currency" use="@mark"/>
  <xsl:variable name="measure_list" select="$datafile//measure_list"/>
  <xsl:key name="mmark" match="measure" use="@mark"/>
  <xsl:key name="pmark" match="pre" use="@mark"/>
  <xsl:variable name="super_list" select="$datafile//super_list"/>
  <xsl:key name="smark" match="super" use="@suuji"/>

  <xsl:variable name="modefile" select="document('trans_mode.xml')"/>
  <xsl:variable name="mode_list" select="$modefile//mode_list"/>
  <xsl:key name="mode" match="mode" use="@type"/>

  <xsl:variable name="scope">
    <xsl:for-each select="$mode_list">
      <xsl:value-of select="key('mode', 'scope')/@ins"/>
    </xsl:for-each>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <!-- デフォルトテンプレート -->
  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <!-- Aタグの処理（無変換） -->
  <xsl:template match="A">
    <xsl:copy-of select="."/>
  </xsl:template>

  <!-- fractionタグ（分数）の処理 -->
  <xsl:template match="fraction">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:choose>
        <!-- SLASHは1つのみ -->
        <xsl:when test="(string-length(.) - string-length(translate(., $ZENKAKU_SLASH, ''))) = 1">
          <!-- 範囲チェック -->
          <xsl:choose>
            <xsl:when test="not(child::*) and (translate(substring-before(., $ZENKAKU_SLASH), concat($sansuuji, $kansuuji, $ketakanji, $ZENKAKU_COMMA, $ZENKAKU_PERIOD), '') = '') and (translate(substring-after(., $ZENKAKU_SLASH), concat($sansuuji, $kansuuji, $ketakanji, $ZENKAKU_COMMA, $ZENKAKU_PERIOD), '') = '')">
              <xsl:call-template name="trans_fraction">
                <xsl:with-param name="mode">
                  <xsl:call-template name="get_mode">
                    <xsl:with-param name="target" select="'fraction'"/>
                  </xsl:call-template>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="starts-with(substring-before(., $ZENKAKU_SLASH), $ZENKAKU_MINUS) or starts-with(substring-after(., $ZENKAKU_SLASH), $ZENKAKU_MINUS)">
              <xsl:element name="{$trans_tag}">
                <xsl:attribute name="type">
                  <xsl:text>Warning: fraction starts with minus!</xsl:text>
                </xsl:attribute>
                <xsl:attribute name="origText">
                  <xsl:value-of select="."/>
                </xsl:attribute>
                <xsl:value-of select="."/>
              </xsl:element>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <!-- SLASHが2つ以上ある場合は警告を出す -->
        <xsl:otherwise>
          <xsl:element name="{$trans_tag}">
            <xsl:attribute name="type">
              <xsl:text>Warning: fraction contains too many slash!</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="origText">
              <xsl:value-of select="."/>
            </xsl:attribute>
            <xsl:value-of select="."/>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="get_mode">
    <xsl:param name="target"/>
    <xsl:choose>
      <xsl:when test="$all_mode = ''">
        <xsl:for-each select="$mode_list">
          <xsl:value-of select="key('mode', $target)/@trans"/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$all_mode"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="trans_fraction">
    <xsl:param name="mode"/>
    <xsl:choose>
      <xsl:when test="$mode = 'read'">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>fraction</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="."/>
          </xsl:attribute>
          <xsl:call-template name="num_chk">
            <xsl:with-param name="buf" select="substring-after(., $ZENKAKU_SLASH)"/>
            <xsl:with-param name="pre" />
            <xsl:with-param name="post" />
          </xsl:call-template>
          <xsl:value-of select="$BUNSUU_INS"/>
          <xsl:call-template name="num_chk">
            <xsl:with-param name="buf" select="substring-before(., $ZENKAKU_SLASH)"/>
            <xsl:with-param name="pre" />
            <xsl:with-param name="post" />
          </xsl:call-template>
        </xsl:element>
      </xsl:when>
      <xsl:when test="$mode = 'cor'">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>fraction:denominator</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="substring-after(., $ZENKAKU_SLASH)"/>
          </xsl:attribute>
          <xsl:call-template name="num_chk">
            <xsl:with-param name="buf" select="substring-after(., $ZENKAKU_SLASH)"/>
            <xsl:with-param name="pre" />
            <xsl:with-param name="post" />
          </xsl:call-template>
        </xsl:element>
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>fraction</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$ZENKAKU_SLASH"/>
          </xsl:attribute>
          <xsl:value-of select="$BUNSUU_INS_C"/>
        </xsl:element>
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>fraction:numerator</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="substring-before(., $ZENKAKU_SLASH)"/>
          </xsl:attribute>
          <xsl:call-template name="num_chk">
            <xsl:with-param name="buf" select="substring-before(., $ZENKAKU_SLASH)"/>
            <xsl:with-param name="pre" />
            <xsl:with-param name="post" />
          </xsl:call-template>
        </xsl:element>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- superScriptタグ（上付）の処理 -->
  <xsl:template match="superScript">
    <xsl:call-template name="trans_superscript">
      <xsl:with-param name="mode">
        <xsl:call-template name="get_mode">
          <xsl:with-param name="target" select="'superscript'"/>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="trans_superscript">
    <xsl:param name="mode"/>
    <!-- superScriptタグの内容 -->
    <xsl:variable name="cont" select="."/>
    <!-- 直前のテキストノード -->
    <xsl:variable name="pretext" select="preceding-sibling::text()[1]"/>
    <!-- 最後の文字 -->
    <xsl:variable name="lastc" select="substring($pretext, string-length($pretext))"/>
    <xsl:choose>
      <!-- タグの内容が２または３の場合 -->
      <xsl:when test="($mode = 'read') and (($cont = $ZENKAKU_2) or ($cont = $ZENKAKU_3))">
        <!-- 最後の文字の計測単位読み -->
        <xsl:variable name="myomi">
          <xsl:for-each select="$measure_list">
            <xsl:value-of select="key('mmark', $lastc)/@yomi"/>
          </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
          <!-- 直前が計測単位の場合 -->
          <xsl:when test="string-length($myomi) > 0">
            <!-- 最後から2つめの文字 -->
            <xsl:variable name="lastc2" select="substring($pretext, string-length($pretext) - 1, 1)"/>
            <!-- 最後から2つめの文字の計測単位読み -->
            <xsl:variable name="pyomi">
              <xsl:for-each select="$measure_list">
                <xsl:value-of select="key('pmark', $lastc2)/@yomi"/>
              </xsl:for-each>
            </xsl:variable>
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>superscript</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:if test="string-length($pyomi) > 0">
                  <xsl:value-of select="$lastc2"/>
                </xsl:if>
                <xsl:value-of select="concat($lastc, '&lt;superScript&gt;', $cont, '&lt;/superScript&gt;')"/>
              </xsl:attribute>
              <xsl:for-each select="$super_list">
                <xsl:value-of select="key('smark', $cont)/@kanji"/>
              </xsl:for-each>
              <xsl:value-of select="concat($pyomi, $myomi)"/>              
            </xsl:element>
          </xsl:when>
          <!-- 直前が数字又はアルファベットの場合 -->
          <xsl:when test="$lastc and contains(concat($sansuuji, $alphabet_l, $alphabet_u), $lastc)">
            <xsl:copy>
              <xsl:element name="{$trans_tag}">
                <xsl:attribute name="type">
                  <xsl:choose>
                    <xsl:when test="parent::fraction">
                      <xsl:text>decimal</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text>superscript</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="origText">
                  <xsl:value-of select="$cont"/>
                </xsl:attribute>
                <xsl:call-template name="suuji2decimal">
                  <xsl:with-param name="str" select="$cont"/>
                </xsl:call-template>
                <xsl:if test="not(parent::fraction)">
                  <xsl:value-of select="$KANJI_JOU"/>
                </xsl:if>
              </xsl:element>
            </xsl:copy>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- タグの内容が数字(−で始まる場合を含む)の場合 -->
      <xsl:when test="(starts-with($cont, $ZENKAKU_MINUS) and (translate(substring($cont, 2), concat($sansuuji, $ZENKAKU_COMMA, $ZENKAKU_PERIOD), '') = '')) or (translate($cont, concat($sansuuji, $ZENKAKU_COMMA, $ZENKAKU_PERIOD), '') = '')">
        <xsl:choose>
          <!-- 直前が数字又はアルファベットの場合 -->
          <xsl:when test="$lastc and (contains($sansuuji, $lastc) or (($mode = 'read') and contains(concat($alphabet_l, $alphabet_u), $lastc)))">
            <xsl:copy>
              <xsl:choose>
                <xsl:when test="string-length(translate($cont, concat($ZENKAKU_COMMA, $ZENKAKU_MINUS), '')) > string-length($ketakanji)">
                  <xsl:element name="{$trans_tag}">
                    <xsl:attribute name="type">
                      <xsl:text>Warning: Too long digits!</xsl:text>
                    </xsl:attribute>
                    <xsl:attribute name="origText">
                      <xsl:value-of select="$cont"/>
                    </xsl:attribute>
                    <xsl:value-of select="$cont"/>
                  </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="starts-with($cont, $ZENKAKU_MINUS)">
                    <xsl:value-of select="$ZENKAKU_MINUS"/>
                  </xsl:if>
                  <xsl:variable name="cont2">
                    <xsl:choose>
                      <xsl:when test="starts-with($cont, $ZENKAKU_MINUS)">
                        <xsl:value-of select="substring($cont, 2)"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="$cont"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
                  <xsl:element name="{$trans_tag}">
                    <xsl:attribute name="type">
                      <xsl:choose>
                        <xsl:when test="parent::fraction">
                          <xsl:text>decimal</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:text>superscript</xsl:text>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="origText">
                      <xsl:value-of select="$cont2"/>
                    </xsl:attribute>
                    <xsl:call-template name="suuji2decimal">
                      <xsl:with-param name="str" select="translate($cont2, $ZENKAKU_COMMA, '')"/>
                    </xsl:call-template>
                    <xsl:if test="not(parent::fraction)">
                      <xsl:value-of select="$KANJI_JOU"/>
                    </xsl:if>
                  </xsl:element>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:copy>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy>
              <xsl:call-template name="num_decimal">
                <xsl:with-param name="buf" select="."/>
              </xsl:call-template>
            </xsl:copy>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy>
          <xsl:call-template name="num_trans">
            <xsl:with-param name="str" select="."/>
          </xsl:call-template>
        </xsl:copy>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- superScriptタグの直前のテキストノードの処理 -->
  <xsl:template match="text()[following-sibling::*[1][self::superScript]]">
    <xsl:variable name="mode">
      <xsl:call-template name="get_mode">
        <xsl:with-param name="target" select="'superscript'"/>
      </xsl:call-template>
    </xsl:variable>
    <!-- 直後のsuperScriptタグの内容 -->
    <xsl:variable name="cont" select="following-sibling::superScript[1]"/>
    <!-- 最後の文字 -->
    <xsl:variable name="lastc" select="substring(., string-length(.))"/>
    <xsl:choose>
      <!-- タグの内容が２または３の場合 -->
      <xsl:when test="($mode = 'read') and (($cont = $ZENKAKU_2) or ($cont = $ZENKAKU_3))">
        <xsl:variable name="myomi">
          <xsl:for-each select="$measure_list">
            <xsl:value-of select="key('mmark', $lastc)/@yomi"/>
          </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
          <!-- 直前が計測単位の場合 -->
          <xsl:when test="string-length($myomi) > 0">
            <xsl:variable name="lastc2" select="substring(., string-length(.) -1, 1)"/>
            <xsl:variable name="pyomi">
              <xsl:for-each select="$measure_list">
                <xsl:value-of select="key('pmark', $lastc2)/@yomi"/>
              </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="string-length($pyomi) > 0">
                <xsl:call-template name="num_trans">
                  <xsl:with-param name="str" select="substring(., 1, string-length(.) - 2)"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_trans">
                  <xsl:with-param name="str" select="substring(., 1, string-length(.) - 1)"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="num_trans">
              <xsl:with-param name="str" select="."/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="num_trans">
          <xsl:with-param name="str" select="."/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="comment()">
    <xsl:copy-of select="."/>
  </xsl:template>

  <!-- テキストノードの処理 -->
  <xsl:template match="text()">
    <xsl:call-template name="sep_text">
      <xsl:with-param name="str" select="."/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="sep_text">
    <xsl:param name="str"/>
    <!-- 改行までを引数としてnum_transを呼び出す -->
    <xsl:choose>
      <xsl:when test="contains($str, '&#xA;')">
        <xsl:call-template name="num_trans">
          <xsl:with-param name="str" select="substring-before($str, '&#xA;')"/>
        </xsl:call-template>
        <xsl:text>&#xA;</xsl:text>
        <xsl:call-template name="sep_text">
          <xsl:with-param name="str" select="substring-after($str, '&#xA;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="num_trans">
          <xsl:with-param name="str" select="$str"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 数字列の変換 -->
  <xsl:template name="num_trans">
    <xsl:param name="str"/>
    <xsl:call-template name="num_ext">
      <xsl:with-param name="str" select="$str"/>
      <xsl:with-param name="nmode" select="0"/>
      <xsl:with-param name="buf" select="''"/>
      <xsl:with-param name="pre" select="''"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 数字列変換対象候補の切り出し（再帰） -->
  <xsl:template name="num_ext">
    <!-- 処理対象文字列 -->
    <xsl:param name="str"/>
    <!-- 数字モードフラグ（0: no suuji, 1: kansuuji, 2: sansuuji） -->
    <xsl:param name="nmode"/>
    <!-- 数字列バッファ -->
    <xsl:param name="buf"/>
    <!-- 直前の文字 -->
    <xsl:param name="pre"/>
    <!-- 先頭の文字 -->
    <xsl:variable name="char" select="substring($str, 1, 1)"/>
    <xsl:choose>
      <!-- 処理対象文字列が存在する場合 -->
      <xsl:when test="string-length($str) > 0">
        <xsl:choose>
          <!-- 直前までが数字列の場合 -->
          <xsl:when test="$nmode > 0">
            <xsl:variable name="ends">
              <xsl:choose>
                <xsl:when test="$nmode = 1">
                  <xsl:value-of select="$k_ends"/>
                </xsl:when>
                <xsl:when test="$nmode = 2">
                  <xsl:value-of select="$s_ends"/>
                </xsl:when>
              </xsl:choose>
            </xsl:variable>
            <xsl:choose>
              <!-- 先頭文字が切り出し対象文字（末尾可能）である場合 -->
              <xsl:when test="$char and contains($ends, $char)">
                <!-- 当該文字をバッファに追加して，再帰呼び出し -->
                <xsl:call-template name="num_ext">
                  <xsl:with-param name="str" select="substring($str, 2)"/>
                  <xsl:with-param name="nmode" select="$nmode"/>
                  <xsl:with-param name="buf" select="concat($buf, $char)"/>
                  <xsl:with-param name="pre" select="$pre"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 先頭文字が切り出し対象文字（末尾可能）でない場合 -->
              <xsl:otherwise>
                <xsl:choose>
                  <!-- 先頭文字が切り出し対象文字（内部のみ）である場合 -->
                  <xsl:when test="$char and contains($mids, $char)">
                    <xsl:choose>
                      <!-- 次の文字が切り出し対象文字（末尾可能）である場合 -->
                      <xsl:when test="substring($str, 2, 1) and contains($ends, substring($str, 2, 1))">
                        <!-- 当該文字及び次の文字をバッファに追加して，再帰呼び出し -->
                        <xsl:call-template name="num_ext">
                          <xsl:with-param name="str" select="substring($str, 3)"/>
                          <xsl:with-param name="nmode" select="$nmode"/>
                          <xsl:with-param name="buf" select="concat($buf, substring($str, 1, 2))"/>
                          <xsl:with-param name="pre" select="$pre"/>
                        </xsl:call-template>
                      </xsl:when>
                      <!-- 次の文字が切り出し対象文字（末尾可能）でない場合 -->
                      <xsl:otherwise>
                        <!-- 数字列切り出しの終了処理 -->
                        <xsl:call-template name="num_terminate">
                          <xsl:with-param name="str" select="substring($str, 2)"/>
                          <xsl:with-param name="buf" select="$buf"/>
                          <xsl:with-param name="pre" select="$pre"/>
                          <xsl:with-param name="char" select="$char"/>
                        </xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <!-- 先頭文字が切り出し対象文字（内部のみ）でない場合 -->
                  <xsl:otherwise>
                    <!-- 数字列切り出しの終了処理 -->
                    <xsl:call-template name="num_terminate">
                      <xsl:with-param name="str" select="substring($str, 2)"/>
                      <xsl:with-param name="buf" select="$buf"/>
                      <xsl:with-param name="pre" select="$pre"/>
                      <xsl:with-param name="char" select="$char"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- 直前までが数字列でない場合 -->
          <xsl:otherwise>
            <xsl:choose>
              <!-- 先頭文字が切り出し対象文字（算数字列先頭可能）である場合 -->
              <xsl:when test="$char and contains($s_starts, $char)">
                <!-- 当該文字をバッファに追加して，再帰呼び出し -->
                <xsl:call-template name="num_ext">
                  <xsl:with-param name="str" select="substring($str, 2)"/>
                  <xsl:with-param name="nmode" select="2"/>
                  <xsl:with-param name="buf" select="concat($buf, $char)"/>
                  <xsl:with-param name="pre" select="$pre"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 先頭文字が切り出し対象文字（漢数字列先頭可能）である場合 -->
              <xsl:when test="$char and contains($k_starts, $char)">
                <!-- 当該文字をバッファに追加して，再帰呼び出し -->
                <xsl:call-template name="num_ext">
                  <xsl:with-param name="str" select="substring($str, 2)"/>
                  <xsl:with-param name="nmode" select="1"/>
                  <xsl:with-param name="buf" select="concat($buf, $char)"/>
                  <xsl:with-param name="pre" select="$pre"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 先頭文字が切り出し対象文字（先頭可能）でない場合 -->
              <xsl:otherwise>
                <!-- 当該文字の処理 -->
                <xsl:call-template name="maru_repl_one">
                  <xsl:with-param name="char" select="$char"/>
                </xsl:call-template>
                <!-- 次文字以降について再帰呼び出し -->
                <xsl:call-template name="num_ext">
                  <xsl:with-param name="str" select="substring($str, 2)"/>
                  <xsl:with-param name="nmode" select="0"/>
                  <xsl:with-param name="buf" select="''"/>
                  <xsl:with-param name="pre" select="concat($pre, $char)"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 処理対象文字列が空の場合 -->
      <xsl:otherwise>
        <!-- 数字列バッファが空でなければ，バッファを処理 -->
        <xsl:if test="$buf">
          <xsl:call-template name="num_chk">
            <xsl:with-param name="buf" select="$buf"/>
            <xsl:with-param name="pre" select="$pre"/>
            <xsl:with-param name="post" select="$char"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 数字列変換対象候補の切り出し終了処理 -->
  <xsl:template name="num_terminate">
    <!-- 次の処理対象文字列 -->
    <xsl:param name="str"/>
    <!-- 数字列バッファ -->
    <xsl:param name="buf"/>
    <!-- 直前の文字 -->
    <xsl:param name="pre"/>
    <!-- 現在の文字 -->
    <xsl:param name="char"/>
    <!-- バッファの処理 -->
    <xsl:call-template name="num_chk">
      <xsl:with-param name="buf" select="$buf"/>
      <xsl:with-param name="pre" select="$pre"/>
      <xsl:with-param name="post" select="concat($char, $str)"/>
    </xsl:call-template>
    <!-- 当該文字の処理 -->
    <xsl:call-template name="maru_repl_one">
      <xsl:with-param name="char" select="$char"/>
    </xsl:call-template>
    <!-- 次文字以降について再帰呼び出し -->
    <xsl:call-template name="num_ext">
      <xsl:with-param name="str" select="$str"/>
      <xsl:with-param name="nmode" select="0"/>
      <xsl:with-param name="buf" select="''"/>
      <xsl:with-param name="pre" select="concat($pre, $char)"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 数字列の変換モードのチェック（「円」） -->
  <xsl:template name="num_chk">
    <!-- チェック対象数字列 -->
    <xsl:param name="buf"/>
    <!-- 数字列の直前の文字列 -->
    <xsl:param name="pre"/>
    <!-- 数字列の直後の文字列 -->
    <xsl:param name="post"/>
    <xsl:choose>
      <!-- 「円」が含まれている場合 -->
      <xsl:when test="contains($buf, $KANJI_YEN)">
        <xsl:call-template name="num_chk_2">
          <xsl:with-param name="buf" select="concat(substring-before($buf, $KANJI_YEN), $KANJI_YEN)"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="concat(substring-after($buf, $KANJI_YEN), $post)"/>
        </xsl:call-template>
        <xsl:if test="substring-after($buf, $KANJI_YEN)">
          <xsl:variable name="next" select="substring(substring-after($buf, $KANJI_YEN), 1, 1)"/>
          <xsl:choose>
            <xsl:when test="contains($mids, $next)">
              <xsl:value-of select="$next"/>
              <xsl:call-template name="num_chk_2">
                <xsl:with-param name="buf" select="substring(substring-after($buf, $KANJI_YEN), 2)"/>
                <xsl:with-param name="pre" select="concat($pre, substring-before($buf, $KANJI_YEN), $KANJI_YEN, $next)"/>
                <xsl:with-param name="post" select="$post"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="num_chk_2">
                <xsl:with-param name="buf" select="substring-after($buf, $KANJI_YEN)"/>
                <xsl:with-param name="pre" select="concat($pre, substring-before($buf, $KANJI_YEN), $KANJI_YEN)"/>
                <xsl:with-param name="post" select="$post"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="num_chk_2">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 数字列の変換モードのチェック（「，」「、」） -->
  <xsl:template name="num_chk_2">
    <!-- チェック対象数字列 -->
    <xsl:param name="buf"/>
    <!-- 数字列の直前の文字列 -->
    <xsl:param name="pre"/>
    <!-- 数字列の直後の文字列 -->
    <xsl:param name="post"/>
    <xsl:choose>
      <!-- 「、」が含まれている場合 -->
      <xsl:when test="contains($buf, $ZENKAKU_TOUTEN)">
        <xsl:choose>
          <xsl:when test="contains($buf, $ZENKAKU_KAKKO_KAI)">
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_KAKKO_KAI)"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="concat($ZENKAKU_KAKKO_KAI, substring-after($buf, $ZENKAKU_KAKKO_KAI), $post)"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_KAI"/>
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_KAKKO_KAI)"/>
              <xsl:with-param name="pre" select="concat($pre, $ZENKAKU_KAKKO_KAI, substring-before($buf, $ZENKAKU_KAKKO_KAI))"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="contains($buf, $ZENKAKU_KAKKO_HEI)">
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="concat($ZENKAKU_KAKKO_HEI, substring-after($buf, $ZENKAKU_KAKKO_HEI), $post)"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_HEI"/>
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre" select="concat($pre, $ZENKAKU_KAKKO_HEI, substring-before($buf, $ZENKAKU_KAKKO_HEI))"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <!-- 漢数字のチェック -->
            <xsl:choose>
              <xsl:when test="translate($buf, concat($kansuuji, $ZENKAKU_TOUTEN), '') = ''">
                <!-- 3桁区切りのチェック -->
                <xsl:variable name="head" select="substring-before($buf, $ZENKAKU_TOUTEN)"/>
                <xsl:variable name="res">
                  <xsl:choose>
                    <xsl:when test="(translate($head, $ketakanji_es, '') = $head) and (string-length($head) > 3)">
                      <xsl:value-of select="$reject_msg"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:call-template name="num_delim_chk">
                        <xsl:with-param name="str" select="substring-after($buf, $ZENKAKU_TOUTEN)"/>
                        <xsl:with-param name="delim" select="$ZENKAKU_TOUTEN"/>
                      </xsl:call-template>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:choose>
                  <!-- 桁区切りの「、」ではない場合 -->
                  <xsl:when test="contains($res, $reject_msg)">
                    <xsl:call-template name="num_chk_delim">
                      <xsl:with-param name="delim" select="$ZENKAKU_TOUTEN"/>
                      <xsl:with-param name="buf" select="$buf"/>
                      <xsl:with-param name="pre" select="$pre"/>
                      <xsl:with-param name="post" select="$post"/>
                    </xsl:call-template>
                  </xsl:when>
                  <!-- 桁区切りの場合 -->
                  <xsl:otherwise>
                    <xsl:call-template name="num_chk_main">
                      <xsl:with-param name="buf" select="$buf"/>
                      <xsl:with-param name="pre" select="$pre"/>
                      <xsl:with-param name="post" select="$post"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_chk_delim">
                  <xsl:with-param name="delim" select="$ZENKAKU_TOUTEN"/>
                  <xsl:with-param name="buf" select="$buf"/>
                  <xsl:with-param name="pre" select="$pre"/>
                  <xsl:with-param name="post" select="$post"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「，」が含まれている場合 -->
      <xsl:when test="contains($buf, $ZENKAKU_COMMA)">
        <xsl:choose>
          <xsl:when test="contains($buf, $ZENKAKU_KAKKO_KAI)">
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_KAKKO_KAI)"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="concat($ZENKAKU_KAKKO_KAI, substring-after($buf, $ZENKAKU_KAKKO_KAI), $post)"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_KAI"/>
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_KAKKO_KAI)"/>
              <xsl:with-param name="pre" select="concat($pre, $ZENKAKU_KAKKO_KAI, substring-before($buf, $ZENKAKU_KAKKO_KAI))"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="contains($buf, $ZENKAKU_KAKKO_HEI)">
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="concat($ZENKAKU_KAKKO_HEI, substring-after($buf, $ZENKAKU_KAKKO_HEI), $post)"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_HEI"/>
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre" select="concat($pre, $ZENKAKU_KAKKO_HEI, substring-before($buf, $ZENKAKU_KAKKO_HEI))"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="contains($buf, $ZENKAKU_WAVE)">
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_WAVE)"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="concat($ZENKAKU_WAVE, substring-after($buf, $ZENKAKU_WAVE), $post)"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_WAVE"/>
            <xsl:call-template name="num_chk_2">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_WAVE)"/>
              <xsl:with-param name="pre" select="concat($pre, $ZENKAKU_WAVE, substring-before($buf, $ZENKAKU_WAVE))"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <!-- 3桁区切りのチェック -->
            <xsl:variable name="head" select="substring-before($buf, $ZENKAKU_COMMA)"/>
            <xsl:variable name="res">
              <xsl:choose>
                <xsl:when test="(translate($head, $ketakanji_es, '') = $head) and (string-length($head) > 3)">
                  <xsl:value-of select="$reject_msg"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="num_delim_chk">
                    <xsl:with-param name="str" select="substring-after($buf, $ZENKAKU_COMMA)"/>
                    <xsl:with-param name="delim" select="$ZENKAKU_COMMA"/>
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:choose>
              <!-- 桁区切りの「，」ではない場合 -->
              <xsl:when test="contains($res, $reject_msg)">
                <xsl:call-template name="num_chk_delim">
                  <xsl:with-param name="delim" select="$ZENKAKU_COMMA"/>
                  <xsl:with-param name="buf" select="$buf"/>
                  <xsl:with-param name="pre" select="$pre"/>
                  <xsl:with-param name="post" select="$post"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 桁区切りの場合 -->
              <xsl:otherwise>
                <xsl:call-template name="num_chk_main">
                  <xsl:with-param name="buf" select="$buf"/>
                  <xsl:with-param name="pre" select="$pre"/>
                  <xsl:with-param name="post" select="$post"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「，」「、」が含まれていない場合 -->
      <xsl:otherwise>
        <xsl:call-template name="num_chk_main">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁区切りデリミタのチェック -->
  <xsl:template name="num_delim_chk">
    <!-- チェック対象文字列 -->
    <xsl:param name="str"/>
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <xsl:variable name="str2">
      <xsl:choose>
        <xsl:when test="contains($str, $ZENKAKU_PERIOD)">
          <xsl:value-of select="substring-before($str, $ZENKAKU_PERIOD)"/>
        </xsl:when>
        <xsl:when test="contains($str, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-before($str, $ZENKAKU_NAKAGURO)"/>
        </xsl:when>
        <xsl:when test="substring($str, string-length($str), 1) = $KANJI_YEN">
          <xsl:value-of select="substring($str, 1, string-length($str) - 1)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$str"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="3 > string-length($str2)">
        <xsl:value-of select="$reject_msg"/>
      </xsl:when>
      <xsl:when test="(string-length($str2) = 3) or (substring($str2, 4, 1) and contains($ketakanji_e, substring($str2, 4, 1)))">
        <xsl:call-template name="chk_three_suuji">
          <xsl:with-param name="str" select="substring($str2, 1, 3)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="substring($str2, 4, 1) = $delim">
        <xsl:call-template name="chk_three_suuji">
          <xsl:with-param name="str" select="substring($str2, 1, 3)"/>
        </xsl:call-template>
        <xsl:call-template name="num_delim_chk">
          <xsl:with-param name="str" select="substring-after($str2, $delim)"/>
          <xsl:with-param name="delim" select="$delim"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$reject_msg"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="chk_three_suuji">
    <xsl:param name="str"/>
    <xsl:if test="(translate($str, $sansuuji, '') != '') and (translate($str, $kansuuji, '') != '')">
      <xsl:value-of select="$reject_msg"/>
    </xsl:if>
  </xsl:template>

  <!-- デリミタで区切られた数字列のチェック（再帰） -->
  <xsl:template name="num_chk_delim">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <!-- 数字列の直前の文字列 -->
    <xsl:param name="pre"/>
    <!-- 数字列の直後の文字列 -->
    <xsl:param name="post"/>
    <xsl:choose>
      <!-- 数字列にデリミタが含まれている場合 -->
      <xsl:when test="$delim and contains($buf, $delim)">
        <!-- デリミタまでの数字列をチェック -->
        <xsl:call-template name="num_chk_main">
          <xsl:with-param name="buf" select="substring-before($buf, $delim)"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
        <xsl:value-of select="$delim"/>
        <xsl:call-template name="num_chk_delim">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="buf" select="substring-after($buf, $delim)"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 数字列にデリミタが含まれていない場合 -->
      <xsl:otherwise>
        <xsl:call-template name="num_chk_main">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 数字列の変換モードのチェック（メイン） -->
  <xsl:template name="num_chk_main">
    <!-- チェック対象数字列 -->
    <xsl:param name="buf"/>
    <!-- 数字列の直前の文字列 -->
    <xsl:param name="pre"/>
    <!-- 数字列の直後の文字列 -->
    <xsl:param name="post"/>
    <xsl:choose>
      <!-- 数字が含まれていない場合 -->
      <xsl:when test="($buf = translate($buf, $sansuuji, '')) and ($buf = translate($buf, $kansuuji, ''))">
        <xsl:value-of select="$buf"/>
      </xsl:when>
      <!-- 「（」「）」 -->
      <xsl:when test="(string-length($buf) - string-length(translate($buf, $ZENKAKU_KAKKO_KAI, '')) = 1) and (string-length(substring-after($buf, $ZENKAKU_KAKKO_KAI)) - string-length(translate(substring-after($buf, $ZENKAKU_KAKKO_KAI), $ZENKAKU_KAKKO_HEI, '')) = 1)">
        <xsl:variable name="pchk">
          <xsl:call-template name="phone2_chk">
            <xsl:with-param name="delim" select="$ZENKAKU_KAKKO_KAI"/>
            <xsl:with-param name="str" select="$buf"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($pchk, 'F')">
            <xsl:call-template name="num_chk_main">
              <xsl:with-param name="buf" select="substring-before($buf, $ZENKAKU_KAKKO_KAI)"/>
              <xsl:with-param name="pre"/>
              <xsl:with-param name="post"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_KAI"/>
            <xsl:call-template name="num_chk_main">
              <xsl:with-param name="buf" select="substring-before(substring-after($buf, $ZENKAKU_KAKKO_KAI), $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre"/>
              <xsl:with-param name="post"/>
            </xsl:call-template>
            <xsl:value-of select="$ZENKAKU_KAKKO_HEI"/>
            <xsl:call-template name="num_chk_main">
              <xsl:with-param name="buf" select="substring-after($buf, $ZENKAKU_KAKKO_HEI)"/>
              <xsl:with-param name="pre"/>
              <xsl:with-param name="post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="ins_scope_tag">
              <xsl:with-param name="content" select="$buf"/>
              <xsl:with-param name="type" select="'tel1'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「（」 -->
      <xsl:when test="contains($buf, $ZENKAKU_KAKKO_KAI)">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_KAKKO_KAI"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「）」 -->
      <xsl:when test="contains($buf, $ZENKAKU_KAKKO_HEI)">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_KAKKO_HEI"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 図表番号 -->
      <xsl:when test="($pre and contains($zuhyou_pre, concat(' ', substring($pre, string-length($pre), 1), ' '))) or ($post and contains($zuhyou_post, concat(' ', substring($post, 1, 1), ' ')))">
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:call-template name="zuhyou_mode">
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'zuhyou'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
          <xsl:with-param name="type" select="'zuhyou'"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 通貨単位 -->
      <xsl:when test="substring($buf, 1, 1) and contains($tsuukamark, substring($buf, 1, 1))">
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:call-template name="tsuuka_mode">
              <xsl:with-param name="mark" select="substring($buf, 1, 1)"/>
              <xsl:with-param name="buf" select="substring($buf, 2)"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'price'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
          <xsl:with-param name="type" select="'price'"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 郵便番号 -->
      <xsl:when test="$pre and ((substring($pre, string-length($pre), 1) = $KIGOU_POSTAL) or contains($postal_pre, concat(' ', substring($pre, string-length($pre) - 3, 4), ' ')))">
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content" select="$buf"/>
          <xsl:with-param name="type" select="'zip'"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 内線番号 -->
      <xsl:when test="$pre and contains($phone_pre, concat(' ', substring($pre, string-length($pre) - 1, 2), ' '))">
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content" select="$buf"/>
          <xsl:with-param name="type" select="'tel3'"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「の」 -->
      <xsl:when test="contains($buf, $ZENKAKU_NO)">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_NO"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「～」 -->
      <xsl:when test="contains($buf, $ZENKAKU_KARA)">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_KARA"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「〜」 -->
      <xsl:when test="contains($buf, $ZENKAKU_WAVE)">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_WAVE"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「―」が三つ以上 -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_DASH, '')) > 2">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_DASH"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「―」が二つ -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_DASH, '')) = 2">
        <xsl:call-template name="delim_phone_date_chk">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="delim" select="$ZENKAKU_DASH"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「―」 -->
      <xsl:when test="contains($buf, $ZENKAKU_DASH)">
        <xsl:variable name="pchk">
          <xsl:call-template name="phone_chk">
            <xsl:with-param name="delim" select="$ZENKAKU_DASH"/>
            <xsl:with-param name="str" select="$buf"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($pchk, 'F')">
            <xsl:call-template name="num_delim">
              <xsl:with-param name="delim" select="$ZENKAKU_DASH"/>
              <xsl:with-param name="str" select="$buf"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="ins_scope_tag">
              <xsl:with-param name="content" select="$buf"/>
              <xsl:with-param name="type" select="'tel2'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「‐」 -->
      <xsl:when test="contains($buf, $ZENKAKU_HYPHEN)">
        <xsl:variable name="cnt" select="string-length($buf) - string-length(translate($buf, $ZENKAKU_HYPHEN, ''))"/>
        <xsl:choose>
          <!-- 「‐」が三つ以上 -->
          <xsl:when test="$cnt > 2">
            <xsl:call-template name="starts_with_zero_chk">
              <xsl:with-param name="delim" select="$ZENKAKU_HYPHEN"/>
              <xsl:with-param name="str" select="$buf"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 「‐」が二つ -->
          <xsl:when test="$cnt = 2">
            <xsl:call-template name="delim_phone_date_chk">
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="delim" select="$ZENKAKU_HYPHEN"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 「‐」 -->
          <xsl:when test="contains($buf, $ZENKAKU_HYPHEN)">
            <xsl:variable name="pchk">
              <xsl:call-template name="phone_chk">
                <xsl:with-param name="delim" select="$ZENKAKU_HYPHEN"/>
                <xsl:with-param name="str" select="$buf"/>
              </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="contains($pchk, 'F')">
                <xsl:call-template name="starts_with_zero_chk">
                  <xsl:with-param name="delim" select="$ZENKAKU_HYPHEN"/>
                  <xsl:with-param name="str" select="$buf"/>
                  <xsl:with-param name="pre" select="$pre"/>
                  <xsl:with-param name="post" select="$post"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="ins_scope_tag">
                  <xsl:with-param name="content" select="$buf"/>
                  <xsl:with-param name="type" select="'tel2'"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
         </xsl:when>
        </xsl:choose>
      </xsl:when>
      <!-- 「：」 -->
      <xsl:when test="contains($buf, $ZENKAKU_COLON)">
        <xsl:call-template name="colon_mode">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「／」 -->
      <xsl:when test="contains($buf, $ZENKAKU_SLASH)">
        <xsl:variable name="pos">
          <xsl:call-template name="date_slash_cnt">
            <xsl:with-param name="buf" select="$buf"/>
            <xsl:with-param name="post" select="substring($post, 1, 1)"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$pos = 4">
            <xsl:call-template name="num_delim">
              <xsl:with-param name="delim" select="$ZENKAKU_SLASH"/>
              <xsl:with-param name="str" select="$buf"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 直前が年号 -->
          <xsl:when test="$pre and (contains($nengou_pre2, concat(' ', substring($pre, string-length($pre) - 1, 2), ' ')) or contains($nengou_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')))">
            <xsl:call-template name="date_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_SLASH"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="pos" select="10"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="date_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_SLASH"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="pos" select="$pos"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「．」が三つ以上 -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) > 2">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「．」が二つ -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 2">
        <xsl:call-template name="delim_phone_date_chk">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「・」が三つ以上 -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) > 2">
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「・」が二つ -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 2">
        <xsl:call-template name="delim_phone_date_chk">
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 「．」で始まる -->
      <xsl:when test="starts-with($buf, $ZENKAKU_PERIOD)">
        <xsl:choose>
          <!-- 直前の文字が英字 -->
          <xsl:when test="$pre and contains(concat($alphabet_l, $alphabet_u), substring($pre, string-length($pre), 1))">
            <xsl:value-of select="$ZENKAKU_PERIOD"/>
            <xsl:call-template name="num_decimal">
              <xsl:with-param name="buf" select="substring($buf, 2)"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 直後が曜日 -->
          <xsl:when test="$post and contains($youbi_post, concat(' ', substring($post, 1, 3), ' '))">
            <xsl:value-of select="$ZENKAKU_PERIOD"/>
            <xsl:call-template name="date_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="pos" select="3"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="num_decimal">
              <xsl:with-param name="buf" select="$buf"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「．」が1つで，直前が年号 -->
      <xsl:when test="(string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 1) and $pre and (contains($nengou_pre2, concat(' ', substring($pre, string-length($pre) - 1, 2), ' ')) or contains($nengou_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')))">
        <xsl:call-template name="date_mode">
          <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pos" select="10"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'date'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <!-- 「・」が1つで，直前が年号 -->
      <xsl:when test="(string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 1) and $pre and (contains($nengou_pre2, concat(' ', substring($pre, string-length($pre) - 1, 2), ' ')) or contains($nengou_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')))">
        <xsl:call-template name="date_mode">
          <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pos" select="10"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'date'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <!-- 「．」が1つで，直前が時間前接表現，かつ直後が単位語でない -->
      <xsl:when test="(string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 1) and $pre and contains($time_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')) and not(contains($unit_post, concat(' ', substring($post, 1, 1), ' ')))">
        <xsl:call-template name="time_chk">
          <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'time'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <!-- 「・」が1つで，直前が時間前接表現，かつ直後が単位語でない -->
      <xsl:when test="(string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 1) and $pre and contains($time_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')) and not(contains($unit_post, concat(' ', substring($post, 1, 1), ' ')))">
        <xsl:call-template name="time_chk">
          <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'time'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <!-- 「円」で終わる -->
      <xsl:when test="substring($buf, string-length($buf), 1) = $KANJI_YEN">
        <xsl:variable name="mode">
          <xsl:call-template name="get_mode">
            <xsl:with-param name="target" select="'price'"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:choose>
              <!-- 「．」が1つで，小数パートが2桁 -->
              <xsl:when test="($mode = 'read') and (string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 1) and string-length(substring-after($buf, $ZENKAKU_PERIOD)) = 3 and (translate(substring(substring-after($buf, $ZENKAKU_PERIOD), 1, 2), $sansuuji, '') = '')">
                <xsl:call-template name="yen_sen_mode">
                  <xsl:with-param name="buf" select="$buf"/>
                  <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 「・」が1つで，小数パートが2桁 -->
              <xsl:when test="($mode = 'read') and (string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 1) and string-length(substring-after($buf, $ZENKAKU_NAKAGURO)) = 3 and (translate(substring(substring-after($buf, $ZENKAKU_NAKAGURO), 1, 2), $sansuuji, '') = '')">
                <xsl:call-template name="yen_sen_mode">
                  <xsl:with-param name="buf" select="$buf"/>
                  <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_decimal">
                  <xsl:with-param name="buf" select="substring($buf, 1, string-length($buf) - 1)"/>
                </xsl:call-template>
                <xsl:value-of select="$KANJI_YEN"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="type" select="'price'"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 直前が「秒」 -->
      <xsl:when test="substring($pre, string-length($pre), 1) = $KANJI_BYOU">
        <xsl:copy-of select="$buf"/>
      </xsl:when>
      <!-- 直後が曜日 -->
      <xsl:when test="$post and contains($youbi_post, concat(' ', substring($post, 1, 3), ' '))">
        <xsl:call-template name="date_mode">
          <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="pos" select="3"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'date'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <!-- 「０」「〇」で始まる -->
      <xsl:when test="substring($buf, 1, 1) and contains($zeros, substring($buf, 1, 1))">
        <xsl:variable name="mode">
          <xsl:call-template name="get_mode">
            <xsl:with-param name="target" select="'decimal'"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <!-- ２文字目が「．」「・」 -->
          <xsl:when test="substring($buf, 2, 1) and contains(concat($ZENKAKU_PERIOD, $ZENKAKU_NAKAGURO), substring($buf, 2, 1))">
            <xsl:call-template name="num_decimal">
              <xsl:with-param name="buf" select="$buf"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="$mode = 'cor'">
            <xsl:value-of select="$buf"/>
          </xsl:when>
          <!--直後が「年」 -->
          <xsl:when test="substring($post, 1, 1) = $KANJI_NEN">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>decimal</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <xsl:call-template name="suuji2year">
                <xsl:with-param name="str" select="$buf"/>
                <xsl:with-param name="chk" select="'no'"/>
                <xsl:with-param name="mode">
                  <xsl:call-template name="get_mode">
                    <xsl:with-param name="target" select="'date'"/>
                  </xsl:call-template>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:element>
          </xsl:when>
          <!--直後が「時」「分」「秒」「月」「日」 -->
          <xsl:when test="$post and contains($zero_hen, substring($post, 1, 1))">
            <xsl:call-template name="num_decimal">
              <xsl:with-param name="buf" select="$buf"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 「．」が1つ -->
          <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 1">
            <xsl:call-template name="date_time_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_PERIOD"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="date_mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="time_mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'time'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <!-- 「・」が1つ -->
          <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 1">
            <xsl:call-template name="date_time_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_NAKAGURO"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="date_mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="time_mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'time'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$buf"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 英語の序数等 -->
      <xsl:when test="$post and contains($eng_post, substring($post, 1, 2))">
        <xsl:choose>
          <xsl:when test="((substring($post, 1, 2) = $eng_1st) and (substring($buf, string-length($buf), 1) != $ZENKAKU_1)) or ((substring($post, 1, 2) = $eng_2nd) and (substring($buf, string-length($buf), 1) != $ZENKAKU_2)) or ((substring($post, 1, 2) = $eng_3rd) and (substring($buf, string-length($buf), 1) != $ZENKAKU_3)) or ((substring($post, 1, 2) = $eng_nth) and contains(concat($ZENKAKU_1, $ZENKAKU_2, $ZENKAKU_3), substring($buf, string-length($buf), 1)))">
            <xsl:call-template name="num_decimal">
              <xsl:with-param name="buf" select="$buf"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$buf"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 桁読み -->
      <xsl:otherwise>
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="starts_with_zero_chk">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:choose>
      <xsl:when test="$delim = $ZENKAKU_HYPHEN">
        <xsl:variable name="starts_with_zero">
          <xsl:call-template name="chk_first_zero">
            <xsl:with-param name="delim" select="$delim"/>
            <xsl:with-param name="str" select="$str"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$starts_with_zero = 'T'">
            <xsl:call-template name="ins_scope_tag">
              <xsl:with-param name="content" select="$str"/>
              <xsl:with-param name="type" select="'starts_with_zero'"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="num_delim">
              <xsl:with-param name="delim" select="$delim"/>
              <xsl:with-param name="str" select="$str"/>
              <xsl:with-param name="pre" select="$pre"/>
              <xsl:with-param name="post" select="$post"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="str" select="$str"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="chk_first_zero">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:choose>
      <xsl:when test="contains($str, $delim)">
        <xsl:choose>
          <xsl:when test="contains($zeros, substring($str, 1, 1))">
            <xsl:value-of select="'T'"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="chk_first_zero">
              <xsl:with-param name="delim" select="$delim"/>
              <xsl:with-param name="str" select="substring-after($str, $delim)"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="contains($zeros, substring($str, 1, 1))">
        <xsl:value-of select="'T'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="delim_phone_date_chk">
    <xsl:param name="buf"/>
    <xsl:param name="pre"/>
    <xsl:param name="delim"/>
    <xsl:choose>
      <xsl:when test="substring($pre, string-length($pre), 1) = $delim">
        <xsl:call-template name="starts_with_zero_chk">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="pchk">
          <xsl:call-template name="phone2_chk">
            <xsl:with-param name="delim" select="$delim"/>
            <xsl:with-param name="str" select="$buf"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($pchk, 'F')">
            <xsl:call-template name="date_mode">
              <xsl:with-param name="delim" select="$delim"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="pos">
                <xsl:choose>
                  <xsl:when test="$pre and (substring($pre, string-length($pre), 1) = $ZENKAKU_APOS) or (contains($nengou_pre2, concat(' ', substring($pre, string-length($pre) - 1, 2), ' ')) or contains($nengou_pre, concat(' ', substring($pre, string-length($pre), 1), ' ')))">
                    <xsl:value-of select="10"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="1"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'date'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise> 
            <xsl:call-template name="ins_scope_tag">
              <xsl:with-param name="content" select="$buf"/>
              <xsl:with-param name="type" select="'tel1'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>    

  <!-- 電話番号等のチェック（３区切り） -->
  <xsl:template name="phone2_chk">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:variable name="top" select="substring-before($str, $delim)"/>
    <xsl:variable name="delim2">
      <xsl:choose>
        <xsl:when test="$delim = $ZENKAKU_KAKKO_KAI">
          <xsl:value-of select="$ZENKAKU_KAKKO_HEI"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$delim"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="substring($top, 1, 1) and contains($zeros, substring($top, 1, 1))">
        <xsl:choose>
          <xsl:when test="(string-length($top) = 3) and contains($zeros, substring($top, 3, 1))">
            <xsl:call-template name="phone2_chk_keitai_2nd">
              <xsl:with-param name="delim" select="$delim2"/>
              <xsl:with-param name="str" select="substring-after($str, $delim)"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="string-length($top) = 4">
            <xsl:call-template name="phone2_chk_2nd_6">
              <xsl:with-param name="delim" select="$delim2"/>
              <xsl:with-param name="str" select="substring-after($str, $delim)"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:when test="(string-length($top) > 1) and (string-length($top) &lt; 6)">
            <xsl:call-template name="phone2_chk_2nd">
              <xsl:with-param name="delim" select="$delim2"/>
              <xsl:with-param name="str" select="substring-after($str, $delim)"/>
              <xsl:with-param name="len" select="6 - string-length($top)"/>
            </xsl:call-template>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="phone2_chk_keitai_2nd">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:variable name="top" select="substring-before($str, $delim)"/>
    <xsl:choose>
      <xsl:when test="string-length($top) = 3">
        <xsl:call-template name="phone2_chk_3rd">
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="len" select="5"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string-length($top) = 4">
        <xsl:call-template name="phone2_chk_3rd">
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="len" select="4"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="phone2_chk_3rd">
    <xsl:param name="str"/>
    <xsl:param name="len"/>
    <xsl:choose>
      <xsl:when test="string-length($str) = $len">
        <xsl:value-of select="'T'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="phone2_chk_2nd">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:param name="len"/>
    <xsl:variable name="top" select="substring-before($str, $delim)"/>
    <xsl:choose>
      <xsl:when test="string-length($top) = $len">
        <xsl:call-template name="phone2_chk_3rd">
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="len" select="4"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="phone2_chk_2nd_6">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:variable name="top" select="substring-before($str, $delim)"/>
    <xsl:call-template name="phone2_chk_3rd">
      <xsl:with-param name="str" select="substring-after($str, $delim)"/>
      <xsl:with-param name="len" select="6 - string-length($top)"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 電話番号等のチェック（２区切り） -->
  <xsl:template name="phone_chk">
    <xsl:param name="delim"/>
    <xsl:param name="str"/>
    <xsl:variable name="top" select="substring-before($str, $delim)"/>
    <xsl:choose>
      <xsl:when test="contains($zeros, substring($top, 1, 1)) and string-length($top) = 6">
        <xsl:call-template name="phone2_chk_3rd">
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="len" select="4"/>
        </xsl:call-template>
      </xsl:when>
      <!-- xsl:when test="(string-length($top) > 0) and (string-length($top) &lt; 5)" -->
      <xsl:when test="(string-length($top) > 0) and (string-length($top) &lt; 4)">
        <xsl:call-template name="phone2_chk_3rd">
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="len" select="4"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'F'"/>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <!-- 図表番号の処理（再帰） -->
  <xsl:template name="zuhyou_mode">
    <!-- 図表番号 -->
    <xsl:param name="buf"/>
    <xsl:param name="mode"/>
    <!-- 数字のデリミタ -->
    <xsl:variable name="delim" select="substring(translate($buf, concat($sansuuji, $kansuuji, $ketakanji), ''), 1, 1)"/>
    <xsl:choose>
      <!-- デリミタがない場合 -->
      <xsl:when test="$delim = ''">
        <!-- 桁読み -->
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:when>
      <!-- デリミタがある場合 -->
      <xsl:otherwise>
        <!-- デリミタの直前までを桁読み -->
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="substring-before($buf, $delim)"/>
        </xsl:call-template>
        <!-- デリミタの処理 -->
        <xsl:choose>
          <!-- 「．」はそのまま -->
          <xsl:when test="$delim = $ZENKAKU_PERIOD">
            <xsl:value-of select="$delim"/>
          </xsl:when>
          <!-- 「・」は「．」に -->
          <xsl:when test="$delim = $ZENKAKU_NAKAGURO">
            <xsl:choose>
              <xsl:when test="$mode = 'read'">
                <xsl:element name="{$trans_tag}">
                  <xsl:attribute name="type">
                    <xsl:text>delimiter</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="origText">
                    <xsl:value-of select="$delim"/>
                  </xsl:attribute>
                  <xsl:value-of select="$ZENKAKU_PERIOD"/>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$delim"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- 「―」は無変換 -->
          <xsl:when test="($delim = $ZENKAKU_DASH) or ($delim = $ZENKAKU_HYPHEN)">
            <xsl:value-of select="$delim"/>
          </xsl:when>
          <!-- 「／」は無変換 -->
          <xsl:when test="$delim = $ZENKAKU_SLASH">
            <xsl:value-of select="$delim"/>
          </xsl:when>
          <!-- それ以外は警告 -->
          <xsl:otherwise>
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>Warning: Unknown delimiter!</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$delim"/>
              </xsl:attribute>
              <xsl:value-of select="$delim"/>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
        <!-- デリミタ以降について再帰呼び出し -->
        <xsl:call-template name="zuhyou_mode">
          <xsl:with-param name="buf" select="substring-after($buf, $delim)"/>
          <xsl:with-param name="mode" select="$mode"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 通貨単位の処理 -->
  <xsl:template name="tsuuka_mode">
    <!-- 通貨単位 -->
    <xsl:param name="mark"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:param name="mode"/>
    <xsl:variable name="int-part">
      <xsl:choose>
        <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_PERIOD)"/>
        </xsl:when>
        <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_NAKAGURO)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="pnt-part">
      <xsl:choose>
        <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
          <xsl:value-of select="substring-after($buf, $ZENKAKU_PERIOD)"/>
        </xsl:when>
        <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-after($buf, $ZENKAKU_NAKAGURO)"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="target">
      <xsl:choose>
        <xsl:when test="$mode = 'read'">
          <xsl:value-of select="concat($mark, $buf)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$mode = 'cor'">
      <xsl:value-of select="$mark"/>
    </xsl:if>
    <xsl:choose>
      <!-- 変換可能桁を超えている場合 -->
      <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>Warning: Too long digits!</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$target"/>
          </xsl:attribute>
          <xsl:value-of select="$target"/>
        </xsl:element>
      </xsl:when>
      <xsl:when test="$mode = 'read'">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>price</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$target"/>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test="($mark = $YEN_MARK) and (string-length($pnt-part) = 2)">
              <!-- 円銭読み -->
              <xsl:call-template name="suuji2decimal">
                <xsl:with-param name="str" select="translate($int-part, concat($ZENKAKU_COMMA, $ZENKAKU_TOUTEN), '')"/>
              </xsl:call-template>
              <xsl:value-of select="$KANJI_YEN"/>
              <xsl:call-template name="suuji2decimal">
                <xsl:with-param name="str" select="translate($pnt-part, concat($ZENKAKU_COMMA, $ZENKAKU_TOUTEN), '')"/>
              </xsl:call-template>
              <xsl:value-of select="$KANJI_SEN"/>
            </xsl:when>
            <xsl:otherwise>
              <!-- 桁読み -->
              <xsl:call-template name="suuji2decimal">
                <!-- 「，」「、」はチェック済みとして無視している -->
                <xsl:with-param name="str" select="translate($buf, concat($ZENKAKU_NAKAGURO, $ZENKAKU_COMMA, $ZENKAKU_TOUTEN), $ZENKAKU_PERIOD)"/>
              </xsl:call-template>
              <!-- 通貨単位の読み -->
              <xsl:for-each select="$currency_list">
                <xsl:value-of select="key('cmark', $mark)/@kanji"/>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 円，銭モード -->
  <xsl:template name="yen_sen_mode">
    <xsl:param name="buf"/>
    <xsl:param name="delim"/>
    <xsl:variable name="int-part" select="substring-before($buf, $delim)"/>
    <xsl:variable name="pnt-part" select="substring-after(substring($buf, 1, string-length($buf) - 1), $delim)"/>
    <xsl:choose>
      <!-- 変換可能桁を超えている場合 -->
      <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>Warning: Too long digits!</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:value-of select="$buf"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>price</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:call-template name="suuji2decimal">
            <xsl:with-param name="str" select="translate($int-part, concat($ZENKAKU_COMMA, $ZENKAKU_TOUTEN), '')"/>
          </xsl:call-template>
          <xsl:value-of select="$KANJI_YEN"/>
          <xsl:call-template name="suuji2decimal">
            <xsl:with-param name="str" select="translate($pnt-part, concat($ZENKAKU_COMMA, $ZENKAKU_TOUTEN), '')"/>
          </xsl:call-template>
          <xsl:value-of select="$KANJI_SEN"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- デリミタで区切られた数字列の処理（再帰） -->
  <xsl:template name="num_delim">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <xsl:param name="pre"/>
    <xsl:param name="post"/>
    <xsl:choose>
      <!-- 数字列にデリミタが含まれている場合 -->
      <xsl:when test="$delim and contains($str, $delim)">
        <!-- デリミタまでの数字列を桁読み -->
        <xsl:call-template name="num_chk_main">
          <xsl:with-param name="buf" select="substring-before($str, $delim)"/>
          <xsl:with-param name="pre" select="$pre"/>
          <xsl:with-param name="post" select="$delim"/>
        </xsl:call-template>
        <!-- デリミタの処理 -->
        <xsl:value-of select="$delim"/>
        <!-- 一つめのデリミタ以降を再帰処理 -->
        <xsl:call-template name="num_delim">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="str" select="substring-after($str, $delim)"/>
          <xsl:with-param name="pre" select="$delim"/>
          <xsl:with-param name="post" select="$post"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 数字列にデリミタが含まれていない場合 -->
      <xsl:otherwise>
        <xsl:call-template name="num_chk_main">
          <xsl:with-param name="buf" select="$str"/>
          <xsl:with-param name="pre"/>
          <xsl:with-param name="post"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 時間表記 -->
  <xsl:template name="time_chk">
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:param name="mode"/>
    <xsl:variable name="time_str">
      <xsl:call-template name="time_str">
        <xsl:with-param name="delim" select="$delim"/>
        <xsl:with-param name="buf" select="$buf"/>
        <xsl:with-param name="pos" select="1"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($time_str, $reject_msg)">
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:choose>
              <xsl:when test="$mode = 'read'">
                <!-- 時間表記 -->
                <xsl:element name="{$trans_tag}">
                  <xsl:attribute name="type">
                    <xsl:text>time</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="origText">
                    <xsl:value-of select="$buf"/>
                  </xsl:attribute>
                  <xsl:value-of select="$time_str"/>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_delim">
                  <xsl:with-param name="delim" select="$delim"/>
                  <xsl:with-param name="str" select="$buf"/>
                  <xsl:with-param name="pre"/>
                  <xsl:with-param name="post"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="type" select="'time'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- コロン表記の処理 -->
  <xsl:template name="colon_mode">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:variable name="time_str">
      <xsl:choose>
        <xsl:when test="contains(substring-after($buf, $ZENKAKU_COLON), $ZENKAKU_PERIOD)">
          <xsl:call-template name="time_str">
            <xsl:with-param name="delim" select="$ZENKAKU_COLON"/>
            <xsl:with-param name="buf" select="$buf"/>
            <xsl:with-param name="pos" select="2"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="time_str">
            <xsl:with-param name="delim" select="$ZENKAKU_COLON"/>
            <xsl:with-param name="buf" select="$buf"/>
            <xsl:with-param name="pos" select="1"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($time_str, $reject_msg)">
        <!-- 比の表記 -->
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:call-template name="rate_mode">
              <xsl:with-param name="delim" select="$ZENKAKU_COLON"/>
              <xsl:with-param name="buf" select="$buf"/>
              <xsl:with-param name="mode">
                <xsl:call-template name="get_mode">
                  <xsl:with-param name="target" select="'rate'"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:with-param>
          <xsl:with-param name="type" select="'rate'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="time_mode">
          <xsl:with-param name="delim" select="$ZENKAKU_COLON"/>
          <xsl:with-param name="buf" select="$buf"/>
          <xsl:with-param name="time_str" select="$time_str"/>
          <xsl:with-param name="mode">
            <xsl:call-template name="get_mode">
              <xsl:with-param name="target" select="'time'"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="time_mode">
    <xsl:param name="delim"/>
    <xsl:param name="buf"/>
    <xsl:param name="time_str"/>
    <xsl:param name="mode"/>
    <xsl:call-template name="ins_scope_tag">
      <xsl:with-param name="content">
        <xsl:choose>
          <xsl:when test="$mode = 'read'">
            <!-- 時間表記 -->
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>time</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <xsl:value-of select="$time_str"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="num_delim">
              <xsl:with-param name="delim" select="$delim"/>
              <xsl:with-param name="str" select="$buf"/>
              <xsl:with-param name="pre"/>
              <xsl:with-param name="post"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
      <xsl:with-param name="type" select="'time'"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 時間表記の変換（再帰） -->
  <xsl:template name="time_str">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <!-- 変換位置（時=1, 分=2, 秒=3） -->
    <xsl:param name="pos"/>
    <xsl:choose>
      <!-- 数字列にデリミタが含まれている場合 -->
      <xsl:when test="$delim and contains($buf, $delim)">
        <!-- デリミタまでの数字列を桁読み -->
        <xsl:call-template name="suuji2decimal">
          <xsl:with-param name="str" select="substring-before($buf, $delim)"/>
        </xsl:call-template>
        <!-- 時間単位の付与 -->
        <xsl:call-template name="time_unit">
          <xsl:with-param name="num" select="substring-before($buf, $delim)"/>
          <xsl:with-param name="pos" select="$pos"/>
        </xsl:call-template>
        <!-- 一つめのデリミタ以降を再帰処理 -->
        <xsl:call-template name="time_str">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="buf" select="substring-after($buf, $delim)"/>
          <xsl:with-param name="pos" select="$pos + 1"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 数字列にデリミタが含まれず小数表記の場合 -->
      <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
        <!-- 整数部を桁読み -->
        <xsl:call-template name="suuji2decimal">
          <xsl:with-param name="str" select="substring-before($buf, $ZENKAKU_PERIOD)"/>
        </xsl:call-template>
        <!-- 時間単位の付与 -->
        <xsl:call-template name="time_unit">
          <xsl:with-param name="num" select="$buf"/>
          <xsl:with-param name="pos" select="$pos"/>
        </xsl:call-template>
        <xsl:copy-of select="substring-after($buf, $ZENKAKU_PERIOD)"/>
      </xsl:when>
      <!-- 数字列にデリミタが含まれていない場合 -->
      <xsl:otherwise>
        <!-- 数字列を桁読み -->
        <xsl:call-template name="suuji2decimal">
          <xsl:with-param name="str" select="$buf"/>
        </xsl:call-template>
        <!-- 時間単位の付与 -->
        <xsl:call-template name="time_unit">
          <xsl:with-param name="num" select="$buf"/>
          <xsl:with-param name="pos" select="$pos"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 時間単位の処理 -->
  <xsl:template name="time_unit">
    <!-- 算用数字 -->
    <xsl:param name="num"/>
    <!-- 位置 -->
    <xsl:param name="pos"/>
    <!-- 数値 -->
    <xsl:variable name="val" select="number(translate($num, $sansuuji, $digit))"/>
    <xsl:choose>
      <!-- 位置が時(=1)の場合 -->
      <xsl:when test="$pos = 1">
        <xsl:choose>
          <!-- 値が30を超えた場合，「時間」 -->
          <xsl:when test="$val > 30">
            <xsl:value-of select="$KANJI_JIKAN"/>
          </xsl:when>
          <!-- 値が30以下の場合，「時」 -->
          <xsl:otherwise>
            <xsl:value-of select="$KANJI_JI"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 位置が分(=2)の場合 -->
      <xsl:when test="$pos = 2">
        <xsl:choose>
          <!-- 値が59を超えた場合，時間表現ではない -->
          <xsl:when test="$val > 59">
            <xsl:value-of select="$reject_msg"/>
          </xsl:when>
          <!-- 値が59以下の場合，「分」 -->
          <xsl:otherwise>
            <xsl:value-of select="$KANJI_HUN"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 位置が秒(=3)の場合 -->
      <xsl:when test="$pos = 3">
        <xsl:choose>
          <!-- 値が59を超えた場合，時間表現ではない -->
          <xsl:when test="$val > 59">
            <xsl:value-of select="$reject_msg"/>
          </xsl:when>
          <!-- 値が59以下の場合，「秒」 -->
          <xsl:otherwise>
            <xsl:value-of select="$KANJI_BYOU"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- 比の表記の変換（再帰） -->
  <xsl:template name="rate_mode">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:param name="mode"/>
    <xsl:choose>
      <!-- 数字列にデリミタが含まれている場合 -->
      <xsl:when test="$delim and contains($buf, $delim)">
        <!-- デリミタまでの数字列をタグ付き桁読み -->
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="substring-before($buf, $delim)"/>
        </xsl:call-template>
        <xsl:choose>
          <xsl:when test="$mode = 'read'">
            <!-- デリミタの変換 -->
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>delimiter</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$delim"/>
              </xsl:attribute>
              <xsl:value-of select="$KANJI_TAI"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$delim"/>
          </xsl:otherwise>
        </xsl:choose>
        <!-- 一つめのデリミタ以降を再帰処理 -->
        <xsl:call-template name="rate_mode">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="buf" select="substring-after($buf, $delim)"/>
          <xsl:with-param name="mode" select="$mode"/>
        </xsl:call-template>
      </xsl:when>
      <!-- 数字列にデリミタが含まれていない場合 -->
      <xsl:otherwise>
        <!-- 数字列を桁読み -->
        <xsl:call-template name="num_decimal">
          <xsl:with-param name="buf" select="$buf"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 日付中の「／」のカウント -->
  <xsl:template name="date_slash_cnt">
    <!-- 文字列 -->
    <xsl:param name="buf"/>
    <!-- 直後の文字 -->
    <xsl:param name="post"/>
    <!-- 文字列中の「／」の数 -->
    <xsl:variable name="cnt" select="string-length($buf) - string-length(translate($buf, $ZENKAKU_SLASH, ''))"/>
    <xsl:choose>
      <!-- 「／」が2個の場合 -->
      <xsl:when test="$cnt = 2">
        <xsl:value-of select="1"/>
      </xsl:when>
      <!-- 「／」が1個の場合 -->
      <xsl:when test="$cnt = 1">
        <xsl:choose>
          <!-- 次の文字が「月」の場合 -->
          <xsl:when test="$post = $KANJI_GETSU">
            <xsl:value-of select="11"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="2"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「／」が3つ以上ある場合 -->
      <xsl:otherwise>
        <xsl:value-of select="4"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 日付の処理（リジェクトを含む） -->
  <xsl:template name="date_mode">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <!-- 変換位置（年=1,11,10 月=2, 日=3） -->
    <xsl:param name="pos"/>
    <xsl:param name="mode"/>
    <xsl:variable name="date_str">
      <xsl:call-template name="date_str">
        <xsl:with-param name="delim" select="$delim"/>
        <xsl:with-param name="buf" select="$buf"/>
        <xsl:with-param name="pos" select="$pos"/>
        <xsl:with-param name="mode" select="$mode"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($date_str, $reject_msg)">
        <!-- 非日付の表記 -->
        <xsl:call-template name="starts_with_zero_chk">
          <xsl:with-param name="delim" select="$delim"/>
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="pre"/>
          <xsl:with-param name="post"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:choose>
              <xsl:when test="$mode = 'read'">
                <!-- 日付の表記 -->
                <xsl:element name="{$trans_tag}">
                  <xsl:attribute name="type">
                    <xsl:text>date</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="origText">
                    <xsl:value-of select="$buf"/>
                  </xsl:attribute>
                  <xsl:value-of select="$date_str"/>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_delim">
                  <xsl:with-param name="delim" select="$delim"/>
                  <xsl:with-param name="str" select="$buf"/>
                  <xsl:with-param name="pre"/>
                  <xsl:with-param name="post"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="type" select="'date'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 日付ないし時間の処理（「０ｘ．ｘｘ」「０ｘ・ｘｘ」） -->
  <xsl:template name="date_time_mode">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:param name="date_mode"/>
    <xsl:param name="time_mode"/>
    <!-- 月日 -->
    <xsl:variable name="mmdd_str">
      <xsl:call-template name="date_str">
        <xsl:with-param name="delim" select="$delim"/>
        <xsl:with-param name="buf" select="$buf"/>
        <xsl:with-param name="pos" select="2"/>
        <xsl:with-param name="mode" select="$date_mode"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($mmdd_str, $reject_msg)">
        <!-- 年月 -->
        <xsl:variable name="yymm_str">
          <xsl:call-template name="date_str">
            <xsl:with-param name="delim" select="$delim"/>
            <xsl:with-param name="buf" select="$buf"/>
            <xsl:with-param name="pos" select="1"/>
            <xsl:with-param name="mode" select="$date_mode"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="contains($yymm_str, $reject_msg)">
            <!-- 時分 -->
            <xsl:variable name="hhmm_str">
              <xsl:call-template name="time_str">
                <xsl:with-param name="delim" select="$delim"/>
                <xsl:with-param name="buf" select="$buf"/>
                <xsl:with-param name="pos" select="1"/>
              </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="contains($hhmm_str, $reject_msg)">
                <xsl:call-template name="num_delim">
                  <xsl:with-param name="delim" select="$delim"/>
                  <xsl:with-param name="str" select="$buf"/>
                  <xsl:with-param name="pre"/>
                  <xsl:with-param name="post"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <!-- 時分の表記 -->
                <xsl:call-template name="ins_scope_tag">
                  <xsl:with-param name="content">
                    <xsl:choose>
                      <xsl:when test="$time_mode = 'read'">
                        <xsl:element name="{$trans_tag}">
                          <xsl:attribute name="type">
                            <xsl:text>time</xsl:text>
                          </xsl:attribute>
                          <xsl:attribute name="origText">
                            <xsl:value-of select="$buf"/>
                          </xsl:attribute>
                          <xsl:value-of select="$hhmm_str"/>
                        </xsl:element>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:call-template name="num_delim">
                          <xsl:with-param name="delim" select="$delim"/>
                          <xsl:with-param name="str" select="$buf"/>
                          <xsl:with-param name="pre"/>
                          <xsl:with-param name="post"/>
                        </xsl:call-template>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:with-param>
                  <xsl:with-param name="type" select="'time'"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <!-- 年月の表記 -->
            <xsl:call-template name="ins_scope_tag">
              <xsl:with-param name="content">
                <xsl:choose>
                  <xsl:when test="$date_mode = 'read'">
                    <xsl:element name="{$trans_tag}">
                      <xsl:attribute name="type">
                        <xsl:text>date</xsl:text>
                      </xsl:attribute>
                      <xsl:attribute name="origText">
                        <xsl:value-of select="$buf"/>
                      </xsl:attribute>
                      <xsl:value-of select="$yymm_str"/>
                    </xsl:element>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="num_delim">
                      <xsl:with-param name="delim" select="$delim"/>
                      <xsl:with-param name="str" select="$buf"/>
                      <xsl:with-param name="pre"/>
                      <xsl:with-param name="post"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="type" select="'date'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- 月日の表記 -->
        <xsl:call-template name="ins_scope_tag">
          <xsl:with-param name="content">
            <xsl:choose>
              <xsl:when test="$date_mode = 'read'">
                <xsl:element name="{$trans_tag}">
                  <xsl:attribute name="type">
                    <xsl:text>date</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="origText">
                    <xsl:value-of select="$buf"/>
                  </xsl:attribute>
                  <xsl:value-of select="$mmdd_str"/>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="num_delim">
                  <xsl:with-param name="delim" select="$delim"/>
                  <xsl:with-param name="str" select="$buf"/>
                  <xsl:with-param name="pre"/>
                  <xsl:with-param name="post"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="type" select="'date'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 日付表記の変換（再帰） -->
  <xsl:template name="date_str">
    <!-- デリミタ -->
    <xsl:param name="delim"/>
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <!-- 変換位置（年=1,11,10 月=2, 日=3） -->
    <xsl:param name="pos"/>
    <xsl:param name="mode"/>
    <!-- 変換対象数字列 -->
    <xsl:variable name="str">
      <xsl:choose>
        <!-- 数字列にデリミタが含まれている場合 -->
        <xsl:when test="$delim and contains($buf, $delim)">
          <xsl:value-of select="substring-before($buf, $delim)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="($pos = 1) or ($pos = 11)">
        <!-- 変換対象数字列を年読み -->
        <xsl:call-template name="suuji2year">
          <xsl:with-param name="str" select="$str"/>
          <xsl:with-param name="chk" select="'yes'"/>
          <xsl:with-param name="mode" select="$mode"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="$pos = 10">
        <!-- 変換対象数字列を年読み -->
        <xsl:call-template name="suuji2year">
          <xsl:with-param name="str" select="$str"/>
          <xsl:with-param name="chk" select="'no'"/>
          <xsl:with-param name="mode" select="$mode"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <!-- 変換対象数字列を桁読み -->
        <xsl:call-template name="suuji2decimal">
          <xsl:with-param name="str" select="$str"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    <!-- 日付単位の付与 -->
    <xsl:call-template name="date_unit">
      <xsl:with-param name="num" select="$str"/>
      <xsl:with-param name="pos" select="$pos"/>
    </xsl:call-template>
    <!-- 数字列にデリミタが含まれている場合 -->
    <xsl:if test="$delim and contains($buf, $delim)">
      <!-- 一つめのデリミタ以降を再帰処理 -->
      <xsl:call-template name="date_str">
        <xsl:with-param name="delim" select="$delim"/>
        <xsl:with-param name="buf" select="substring-after($buf, $delim)"/>
        <xsl:with-param name="pos">
          <xsl:choose>
            <xsl:when test="$pos = 10">
              <xsl:value-of select="2"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$pos + 1"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
        <xsl:with-param name="mode" select="$mode"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- 日付単位の処理 -->
  <xsl:template name="date_unit">
    <!-- 算用数字 -->
    <xsl:param name="num"/>
    <!-- 位置 -->
    <xsl:param name="pos"/>
    <!-- 数値 -->
    <xsl:variable name="val">
      <xsl:choose>
        <xsl:when test="translate($num, $kansuuji, '') = $num">
          <xsl:value-of select="number(translate($num, $sansuuji, $digit))"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="number(translate($num, $kansuuji, $digit))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$val = 'NaN'">
        <xsl:value-of select="$reject_msg"/>
      </xsl:when>
      <!-- 位置が年(=1,11,10)の場合 -->
      <xsl:when test="($pos = 1) or ($pos = 11) or ($pos = 10)">
        <xsl:value-of select="$KANJI_NEN"/>
      </xsl:when>
      <!-- 位置が月(=2)の場合 -->
      <xsl:when test="$pos = 2">
      <xsl:choose>
          <!-- 値が12を超えた場合，日付表現ではない -->
          <xsl:when test="$val > 12">
            <xsl:value-of select="$reject_msg"/>
          </xsl:when>
          <!-- 値が12以下の場合，「月」 -->
          <xsl:otherwise>
            <xsl:value-of select="$KANJI_GETSU"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 位置が日(=3)の場合 -->
      <xsl:when test="$pos = 3">
        <xsl:choose>
          <!-- 値が31を超えた場合，日付表現ではない -->
          <xsl:when test="$val > 31">
            <xsl:value-of select="$reject_msg"/>
          </xsl:when>
          <!-- 値が31以下の場合，「日」 -->
          <xsl:otherwise>
            <xsl:value-of select="$KANJI_HI"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- 任意の数字列を桁読み変換 -->
  <xsl:template name="num_decimal">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <!-- 変換対象部分 -->
    <xsl:variable name="buf2">
      <xsl:choose>
        <xsl:when test="contains($buf, $ZENKAKU_PERIOD) and translate(substring-after($buf, $ZENKAKU_PERIOD), $ketakanji_e, '') = substring-after($buf, $ZENKAKU_PERIOD)">
          <xsl:if test="string-length(substring-before($buf, $ZENKAKU_PERIOD)) > 1">
            <xsl:value-of select="$buf"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO) and translate(substring-after($buf, $ZENKAKU_NAKAGURO), $ketakanji_e, '') = substring-after($buf, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_NAKAGURO)"/>
          <xsl:value-of select="$ZENKAKU_NAKAGURO"/>
          <xsl:if test="string-length(substring-before($buf, $ZENKAKU_NAKAGURO)) > 1">
            <xsl:value-of select="substring-after($buf, $ZENKAKU_NAKAGURO)"/>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="ins_scope_tag">
      <xsl:with-param name="content">
        <xsl:choose>
          <xsl:when test="string-length($buf2) = 0"/>
          <!-- 算用数字が含まれていない場合 -->
          <xsl:when test="$buf2 = translate($buf2, $sansuuji, '')">
            <xsl:choose>
              <!-- 桁漢字が含まれていない場合 -->
              <xsl:when test="$buf2 = translate($buf2, $ketakanji_e, '')">
                <xsl:call-template name="kansuuji_without_ketakanji">
                  <xsl:with-param name="buf" select="$buf2"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 桁漢字が含まれている場合 -->
              <xsl:otherwise>
                <xsl:call-template name="kansuuji_with_ketakanji">
                  <xsl:with-param name="buf" select="$buf2"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <!-- 算用数字が含まれている場合 -->
          <!-- memo: 漢数字（桁漢字を除く），算用数字の混在はあるか？ -->
          <xsl:otherwise>
            <xsl:choose>
              <!-- 桁漢字が含まれていない場合 -->
              <xsl:when test="$buf2 = translate($buf2, $ketakanji_e, '')">
                <xsl:call-template name="sansuuji_without_ketakanji">
                  <xsl:with-param name="buf" select="$buf2"/>
                </xsl:call-template>
              </xsl:when>
              <!-- 桁漢字が含まれている場合 -->
              <xsl:otherwise>
                <xsl:call-template name="sansuuji_with_ketakanji">
                  <xsl:with-param name="buf" select="$buf2"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$buf != $buf2">
          <xsl:value-of select="substring($buf, string-length($buf2) + 1)"/>
        </xsl:if>
      </xsl:with-param>
      <xsl:with-param name="type" select="'decimal'"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 桁漢字を含まない漢数字列の桁読み -->
  <xsl:template name="kansuuji_without_ketakanji">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:variable name="int-part">
      <xsl:choose>
        <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_PERIOD)"/>
        </xsl:when>
        <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_NAKAGURO)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <!-- 1桁の場合，変換しない -->
      <xsl:when test="string-length($int-part) = 1">
        <xsl:value-of select="$int-part"/>
        <xsl:choose>
          <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>decimal</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$ZENKAKU_NAKAGURO"/>
              </xsl:attribute>
              <xsl:value-of select="$ZENKAKU_PERIOD"/>
            </xsl:element>
          </xsl:when>
          <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
            <xsl:value-of select="$ZENKAKU_PERIOD"/>
            <xsl:value-of select="substring-after($buf, $ZENKAKU_PERIOD)"/>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <!-- 変換可能桁を超えている場合 -->
      <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>Warning: Too long digits!</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:value-of select="$buf"/>
        </xsl:element>
      </xsl:when>
      <!-- 2桁以上で変換可能な場合 -->
      <xsl:otherwise>
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>decimal</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:call-template name="sansuuji2decimal">
            <!-- 「，」「、」はチェック済みとして無視している -->
            <xsl:with-param name="str" select="translate($buf, concat($kansuuji, $ZENKAKU_NAKAGURO, $ZENKAKU_COMMA, $ZENKAKU_TOUTEN), concat($sansuuji, $ZENKAKU_PERIOD))"/>
          </xsl:call-template>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁漢字を含まない算用数字列の桁読み -->
  <xsl:template name="sansuuji_without_ketakanji">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:variable name="int-part">
      <xsl:choose>
        <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_PERIOD)"/>
        </xsl:when>
        <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
          <xsl:value-of select="substring-before($buf, $ZENKAKU_NAKAGURO)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$buf"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string-length($int-part) = 0"/>
      <xsl:when test="string-length($int-part) = 1">
        <!-- 1桁の場合，変換しない -->
        <xsl:value-of select="$int-part"/>
        <xsl:choose>
          <xsl:when test="contains($buf, $ZENKAKU_NAKAGURO)">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>decimal</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$ZENKAKU_NAKAGURO"/>
              </xsl:attribute>
              <xsl:value-of select="$ZENKAKU_PERIOD"/>
            </xsl:element>
          </xsl:when>
          <xsl:when test="contains($buf, $ZENKAKU_PERIOD)">
            <xsl:value-of select="$ZENKAKU_PERIOD"/>
            <xsl:value-of select="substring-after($buf, $ZENKAKU_PERIOD)"/>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <!-- 変換可能桁を超えている場合 -->
      <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>Warning: Too long digits!</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:value-of select="$buf"/>
        </xsl:element>
      </xsl:when>
      <!-- 2桁以上で変換可能な場合 -->
      <xsl:otherwise>
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>decimal</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:call-template name="sansuuji2decimal">
            <!-- 「，」はチェック済みとして無視している -->
            <xsl:with-param name="str" select="translate($buf, concat($ZENKAKU_NAKAGURO, $ZENKAKU_COMMA), $ZENKAKU_PERIOD)"/>
          </xsl:call-template>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁漢字を含まない数字列の年読み -->
  <xsl:template name="suuji2year">
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <xsl:param name="chk"/>
    <xsl:param name="mode"/>
    <!-- 算数字列 -->
    <xsl:variable name="str2">
      <xsl:choose>
        <!-- 漢数字を含まない場合 -->
        <xsl:when test="$str = translate($str, $kansuuji, '')">
          <xsl:value-of select="$str"/>
        </xsl:when>
        <!-- 漢数字を含む場合 -->
        <xsl:otherwise>
          <xsl:value-of select="translate($str, $kansuuji, $sansuuji)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="($chk = 'yes') and (string-length($str2) != 4) and not(starts-with($str2, $ZENKAKU_0)) and not(starts-with($str2, '９'))">
        <xsl:value-of select="$reject_msg"/>
      </xsl:when>
      <!-- 「００」 -->
      <xsl:when test="$str2 = concat($ZENKAKU_0, $ZENKAKU_0)">
        <xsl:choose>
          <xsl:when test="$mode = 'read'">
            <xsl:value-of select="$KANA_ZERO"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$str2"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 「０」で始まる -->
      <xsl:when test="starts-with($str2, $ZENKAKU_0)">
        <xsl:choose>
          <xsl:when test="$mode = 'read'">
            <xsl:value-of select="$KANA_ZERO"/>
            <xsl:call-template name="sansuuji2decimal">
              <xsl:with-param name="str" select="substring($str2, 2)"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$str2"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sansuuji2decimal">
          <xsl:with-param name="str" select="$str2"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁漢字を含まない数字列の桁読み -->
  <xsl:template name="suuji2decimal">
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <!-- 算数字列 -->
    <xsl:variable name="str2">
      <xsl:choose>
        <!-- 漢数字を含まない場合 -->
        <xsl:when test="$str = translate($str, $kansuuji, '')">
          <xsl:value-of select="$str"/>
        </xsl:when>
        <!-- 漢数字を含む場合 -->
        <xsl:otherwise>
          <xsl:value-of select="translate($str, $kansuuji, $sansuuji)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="sansuuji2decimal">
      <xsl:with-param name="str" select="$str2"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 算用数字列の桁読み -->
  <xsl:template name="sansuuji2decimal">
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <xsl:choose>
      <!-- 一桁の場合 -->
      <xsl:when test="string-length($str) = 1">
        <xsl:value-of select="$str"/>
      </xsl:when>
      <!-- 小数点を含む場合 -->
      <xsl:when test="contains($str, $ZENKAKU_PERIOD)">
        <xsl:call-template name="sansuuji2ketakansuuji">
          <xsl:with-param name="str" select="substring-before($str, $ZENKAKU_PERIOD)"/>
        </xsl:call-template>
        <xsl:value-of select="$ZENKAKU_PERIOD"/>
        <!-- 小数点以下の変換 -->
        <xsl:choose>
          <xsl:when test="string-length(substring-before($str, $ZENKAKU_PERIOD)) > 1">
            <xsl:value-of select="translate(substring-after($str, $ZENKAKU_PERIOD), $sansuuji, $kansuuji)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="substring-after($str, $ZENKAKU_PERIOD)"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when> 
      <!-- 小数点を含まない場合 -->
     <xsl:otherwise>
        <!-- 全体を位取り変換 -->
        <xsl:call-template name="sansuuji2ketakansuuji">
          <xsl:with-param name="str" select="$str"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁漢字を含む漢数字列の桁読み -->
  <xsl:template name="kansuuji_with_ketakanji">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:variable name="mode">
      <xsl:call-template name="get_mode">
        <xsl:with-param name="target" select="'decimal'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <!-- 小数点「．」を含む場合 -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_PERIOD, '')) = 1">
        <xsl:choose>
          <xsl:when test="contains(substring-after($buf, $ZENKAKU_PERIOD), $KANSUUJI_ZERO)">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>decimal</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <xsl:value-of select="substring-before($buf, $ZENKAKU_PERIOD)"/>
              <xsl:value-of select="$ZENKAKU_PERIOD"/>
              <xsl:call-template name="repl_zero">
                <xsl:with-param name="str" select="substring-after($buf, $ZENKAKU_PERIOD)"/>
              </xsl:call-template>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$buf"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 小数点「・」を含む場合 -->
      <xsl:when test="string-length($buf) - string-length(translate($buf, $ZENKAKU_NAKAGURO, '')) = 1">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="type">
            <xsl:text>decimal</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="origText">
            <xsl:value-of select="$buf"/>
          </xsl:attribute>
          <xsl:value-of select="substring-before($buf, $ZENKAKU_NAKAGURO)"/>
          <xsl:value-of select="$ZENKAKU_PERIOD"/>
          <xsl:call-template name="repl_zero">
            <xsl:with-param name="str" select="substring-after($buf, $ZENKAKU_NAKAGURO)"/>
          </xsl:call-template>
        </xsl:element>
      </xsl:when>
      <xsl:when test="$mode = 'cor'">
        <xsl:call-template name="sep_with_ketakanji">
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="buf" select="''"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <!-- TODO: 「百三四十」を除外 -->
        <!-- 文字列が表す数の計算 -->
        <xsl:variable name="num">
          <xsl:call-template name="sum_ketakanji">
            <!-- 「，」はチェック済みとして無視している -->
            <xsl:with-param name="str" select="translate($buf, concat($ZENKAKU_NAKAGURO, $ZENKAKU_COMMA), $ZENKAKU_PERIOD)"/>
            <xsl:with-param name="suuji" select="$kansuuji"/>
            <xsl:with-param name="total" select="0"/>
            <xsl:with-param name="subtotal" select="0"/>
            <xsl:with-param name="digits" select="''"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="int-part">
          <xsl:choose>
            <xsl:when test="contains($num, '.')">
              <xsl:value-of select="substring-before($num, '.')"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$num"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>Warning: Too long digits!</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <xsl:value-of select="$buf"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="kval">
              <!-- 数の桁読み -->
              <xsl:call-template name="sansuuji2decimal">
                <xsl:with-param name="str" select="translate($num, concat($digit, '.'), concat($sansuuji, $ZENKAKU_PERIOD))"/>
              </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="$buf = $kval">
                <xsl:value-of select="$buf"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:element name="{$trans_tag}">
                  <xsl:attribute name="type">
                    <xsl:text>decimal</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="origText">
                    <xsl:value-of select="$buf"/>
                  </xsl:attribute>
                  <xsl:value-of select="$kval"/>
                </xsl:element>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 桁漢字を含む算用数字列の桁読み -->
  <xsl:template name="sansuuji_with_ketakanji">
    <!-- 数字列 -->
    <xsl:param name="buf"/>
    <xsl:variable name="mode">
      <xsl:call-template name="get_mode">
        <xsl:with-param name="target" select="'decimal'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$mode = 'cor'">
        <xsl:call-template name="sep_with_ketakanji">
          <xsl:with-param name="str" select="$buf"/>
          <xsl:with-param name="buf" select="''"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <!-- 文字列が表す数の計算 -->
        <xsl:variable name="num">
          <xsl:call-template name="sum_ketakanji">
            <!-- 「，」はチェック済みとして無視している -->
            <xsl:with-param name="str" select="translate($buf, concat($ZENKAKU_NAKAGURO, $ZENKAKU_COMMA), $ZENKAKU_PERIOD)"/>
            <xsl:with-param name="suuji" select="$sansuuji"/>
            <xsl:with-param name="total" select="0"/>
            <xsl:with-param name="subtotal" select="0"/>
            <xsl:with-param name="digits" select="''"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="int-part">
          <xsl:choose>
            <xsl:when test="contains($num, '.')">
              <xsl:value-of select="substring-before($num, '.')"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$num"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="string-length(translate($int-part, $ZENKAKU_COMMA, '')) > string-length($ketakanji)">
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>Warning: Too long digits!</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <xsl:value-of select="$buf"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{$trans_tag}">
              <xsl:attribute name="type">
                <xsl:text>decimal</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="origText">
                <xsl:value-of select="$buf"/>
              </xsl:attribute>
              <!-- 数の桁読み -->
              <xsl:call-template name="sansuuji2decimal">
                <xsl:with-param name="str" select="translate($num, concat($digit, '.'), concat($sansuuji, $ZENKAKU_PERIOD))"/>
              </xsl:call-template>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="sep_with_ketakanji">
    <xsl:param name="str"/>
    <xsl:param name="buf"/>
    <xsl:variable name="first" select="substring($str, 1, 1)"/>
    <xsl:variable name="rest" select="substring($str, 2)"/>
    <xsl:choose>
      <xsl:when test="contains($ketakanji_e, $first)">
        <xsl:if test="string-length($buf) > 0">
          <xsl:call-template name="num_decimal">
            <xsl:with-param name="buf" select="$buf"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:value-of select="$first"/>
        <xsl:if test="string-length($rest) > 0">
          <xsl:call-template name="sep_with_ketakanji">
            <xsl:with-param name="str" select="$rest"/>
            <xsl:with-param name="buf" select="''"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sep_with_ketakanji">
          <xsl:with-param name="str" select="$rest"/>
          <xsl:with-param name="buf" select="concat($buf, $first)"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 数字列が表す数の計算（再帰） -->
  <xsl:template name="sum_ketakanji">
    <!-- 算用数字，桁漢字列 -->
    <xsl:param name="str"/>
    <!-- 文字種 -->
    <xsl:param name="suuji"/>
    <!-- 合計 -->
    <xsl:param name="total"/>
    <!-- 小計 -->
    <xsl:param name="subtotal"/>
    <!-- 数字 -->
    <xsl:param name="digits"/>
    <!-- 先頭文字 -->
    <xsl:variable name="char" select="substring($str, 1, 1)"/>
    <xsl:choose>
      <!-- 入力文字列が空の場合 -->
      <xsl:when test="string-length($str) = 0">
        <xsl:choose>
          <!-- 数字が保存してあれば，合計，小計，数字が表す数の和を返す -->
          <xsl:when test="$digits">
            <xsl:value-of select="format-number($total + $subtotal + number($digits), '#.#')"/>
          </xsl:when>
          <!-- 数字が空であれば，合計と小計の和を返す -->
          <xsl:otherwise>
            <xsl:value-of select="format-number($total + $subtotal, '#.#')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 先頭が桁漢字の場合 -->
      <xsl:when test="$char and contains($ketakanji_e, $char)">
        <!-- 当該桁漢字が表す数 -->
        <xsl:variable name="multi">
          <xsl:for-each select="$keta_list">
            <xsl:value-of select="key('kkanji', $char)/@num"/>
          </xsl:for-each>
        </xsl:variable>
        <!-- 桁漢字以前の数 -->
        <xsl:variable name="num">
          <xsl:choose>
            <xsl:when test="string-length($digits) = 0">
              <xsl:value-of select="0"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="number($digits)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <!-- 「千」以下の桁漢字の場合 -->
          <xsl:when test="$char and contains($ketakanji_s, $char)">
            <xsl:variable name="num2">
              <xsl:choose>
                <xsl:when test="$num = 0">
                  <xsl:value-of select="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$num"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:variable name="num3">
              <xsl:call-template name="multiply">
                <xsl:with-param name="num" select="$num2"/>
                <xsl:with-param name="multi" select="$multi"/>
              </xsl:call-template>
            </xsl:variable>
            <!-- 小計に加えて，再帰呼び出し -->
            <xsl:call-template name="sum_ketakanji">
              <xsl:with-param name="str" select="substring($str, 2)"/>
              <xsl:with-param name="suuji" select="$suuji"/>
              <xsl:with-param name="total" select="$total"/>
              <xsl:with-param name="subtotal" select="$subtotal + number($num3)"/>
              <xsl:with-param name="digits" select="''"/>
            </xsl:call-template>
          </xsl:when>
          <!-- 「万」以上の桁漢字の場合 -->
          <xsl:otherwise>
            <!-- 小計 -->
            <xsl:variable name="st">
              <xsl:choose>
                <xsl:when test="$subtotal = 0">
                  <xsl:value-of select="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$subtotal"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <xsl:variable name="num3">
              <xsl:call-template name="multiply">
                <xsl:with-param name="num" select="$subtotal + $num"/>
                <xsl:with-param name="multi" select="$multi"/>
              </xsl:call-template>
            </xsl:variable>
            <!-- 合計に加えて，再帰呼び出し -->
            <xsl:call-template name="sum_ketakanji">
              <xsl:with-param name="str" select="substring($str, 2)"/>
              <xsl:with-param name="suuji" select="$suuji"/>
              <!-- xsl:with-param name="total" select="$total + $st * $multi * $num"/ -->
              <xsl:with-param name="total" select="$total + number($num3)"/>
             <xsl:with-param name="subtotal" select="0"/>
              <xsl:with-param name="digits" select="''"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- 算用数字の場合 -->
      <xsl:otherwise>
        <!-- 数字を追加して，再帰呼び出し -->
        <xsl:call-template name="sum_ketakanji">
          <xsl:with-param name="str" select="substring($str, 2)"/>
          <xsl:with-param name="suuji" select="$suuji"/>
          <xsl:with-param name="total" select="$total"/>
          <xsl:with-param name="subtotal" select="$subtotal"/>
          <xsl:with-param name="digits" select="concat($digits, translate($char, concat($suuji, $ZENKAKU_PERIOD, $ZENKAKU_NAKAGURO), concat($digit, '..')))"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="multiply">
    <xsl:param name="num"/>
    <xsl:param name="multi"/>
    <xsl:choose>
      <xsl:when test="contains($num, '.')">
        <xsl:variable name="pnt-part" select="substring-after($num, '.')"/>
        <xsl:variable name="pnt-len" select="string-length($pnt-part)"/>
        <xsl:choose>
          <xsl:when test="string-length($multi) > $pnt-len">
            <xsl:value-of select="concat(translate($num, '.', ''), substring($multi, $pnt-len + 2))"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat(substring-before($num, '.'), substring($pnt-part, 1, string-length($multi) - 1), '.', substring($pnt-part, string-length($multi)))"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat($num, substring-after($multi, '1'))"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 算用数字列（小数点，カンマ等を含まない）の桁読み -->
  <xsl:template name="sansuuji2ketakansuuji">
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <!-- 数に変換して位取り -->
    <xsl:call-template name="digits2ketakansuuji">
      <xsl:with-param name="digits" select="translate($str, $sansuuji, $digit)"/>
      <xsl:with-param name="pref" select="0"/>
      <xsl:with-param name="apref" select="0"/>
      <xsl:with-param name="onlyzero" select="1"/>
    </xsl:call-template>
  </xsl:template>

  <!-- 数の桁読み（再帰） -->
  <xsl:template name="digits2ketakansuuji">
    <!-- 数 -->
    <xsl:param name="digits"/>
    <!-- 4桁区切り内で前に数字が存在したか否かを表すフラグ -->
    <xsl:param name="pref"/>
    <!-- 全体で前に数字が存在したか否かを表すフラグ -->
    <xsl:param name="apref"/>
    <!-- 0のみであることを表すフラグ -->
    <xsl:param name="onlyzero"/>
    <!-- 数の一文字め -->
    <xsl:variable name="num" select="substring($digits, 1, 1)"/>
    <!-- 数の桁数 -->
    <xsl:variable name="kt" select="string-length($digits)"/>
    <!-- 桁数を4で割った余り -->
    <xsl:variable name="mod4" select="$kt mod 4"/>
    <!-- 先頭文字の処理 -->
    <xsl:call-template name="d2kk_one">
      <xsl:with-param name="num" select="$num"/>
      <xsl:with-param name="kt" select="$kt"/>
      <xsl:with-param name="pref" select="$pref"/>
      <xsl:with-param name="apref" select="$apref"/>
      <xsl:with-param name="onlyzero" select="$onlyzero"/>
      <xsl:with-param name="rest3zero">
        <xsl:choose>
          <xsl:when test="substring($digits, 2, 3) = '000'">
            <xsl:value-of select="1"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="0"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
    <!-- まだ桁が残っていれば，再帰呼び出し -->
    <xsl:if test="substring($digits, 2)">
      <xsl:call-template name="digits2ketakansuuji">
        <xsl:with-param name="digits" select="substring($digits, 2)"/>
        <xsl:with-param name="pref">
          <xsl:choose>
            <xsl:when test="$mod4 = 1">
              <xsl:value-of select="0"/>
            </xsl:when>
            <xsl:when test="$num != 0">
              <xsl:value-of select="1"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$pref"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
        <xsl:with-param name="apref">
          <xsl:choose>
            <xsl:when test="$num != 0">
              <xsl:value-of select="1"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$apref"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
        <xsl:with-param name="onlyzero">
          <xsl:choose>
            <xsl:when test="$onlyzero = 0 or $num != 0">
              <xsl:value-of select="0"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$onlyzero"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- 一つの桁の桁読み -->
  <xsl:template name="d2kk_one">
    <!-- 数字 -->
    <xsl:param name="num"/>
    <!-- 桁数 -->
    <xsl:param name="kt"/>
    <!-- 4桁区切り内で前に数字が存在したか否かを表すフラグ -->
    <xsl:param name="pref"/>
    <!-- 全体で前に数字が存在したか否かを表すフラグ -->
    <xsl:param name="apref"/>
    <!-- 0のみであることを表すフラグ -->
    <xsl:param name="onlyzero"/>
    <!-- ３つの0が後続することを表すフラグ -->
    <xsl:param name="rest3zero"/>
    <!-- 桁数を4で割った余り -->
    <xsl:variable name="mod4" select="$kt mod 4"/>
    <xsl:variable name="mode">
      <xsl:call-template name="get_mode">
        <xsl:with-param name="target" select="'decimal'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <!-- 漢数字を挿入 -->
      <xsl:when test="($num != 0) and (($num > 1) or ($mod4 = 1))">
        <xsl:value-of select="substring($kansuuji, $num + 1, 1)"/>
      </xsl:when>
      <xsl:when test="($mode = 'read') and ($num = 1) and ($mod4 = 0) and (($apref = 1) or (($kt > 4) and ($rest3zero = 1)))">
        <xsl:value-of select="substring($kansuuji, $num + 1, 1)"/>
      </xsl:when>
      <!-- ０を挿入 -->
      <xsl:when test="$onlyzero = 1 and $num = 0 and $kt = 1">
        <xsl:value-of select="$ZENKAKU_0"/>
      </xsl:when>
    </xsl:choose>
    <!-- 桁漢字を挿入 -->
    <xsl:if test="(($pref = 1) or ($num > 0)) and ($kt > 1) and (($num > 0) or ($mod4 = 1))">
      <xsl:value-of select="substring($ketakanji, $kt, 1)"/>
    </xsl:if>
  </xsl:template>

  <!-- 算用数字の単漢数字列への変換 -->
  <xsl:template name="sansuuji2kansuuji">
    <xsl:param name="str"/>
    <xsl:call-template name="repl_zero">
      <xsl:with-param name="str" select="translate($str, $sansuuji, $kansuuji)"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="ins_scope_tag">
    <xsl:param name="content"/>
    <xsl:param name="type"/>
    <xsl:choose>
      <xsl:when test="$scope = 'yes'">
        <xsl:element name="{$scope_tag}">
          <xsl:attribute name="type">
            <xsl:value-of select="$type"/>
          </xsl:attribute>
          <xsl:copy-of select="$content"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="$content"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- ゼロの処理 -->
  <xsl:template name="repl_zero">
    <!-- 数字列 -->
    <xsl:param name="str"/>
    <xsl:call-template name="rz_one">
      <xsl:with-param name="char" select="substring($str, 1, 1)"/>
    </xsl:call-template>
    <!-- 数字列が残っていれば，再帰呼び出し -->
    <xsl:if test="substring($str, 2)">
      <xsl:call-template name="repl_zero">
        <xsl:with-param name="str" select="substring($str, 2)"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- 一つの数字に対するゼロの処理 -->
  <xsl:template name="rz_one">
    <!-- 数字 -->
    <xsl:param name="char"/>
    <xsl:variable name="mode">
      <xsl:call-template name="get_mode">
        <xsl:with-param name="target" select="'decimal'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <!-- 漢数字の〇はカナのゼロにする -->
      <xsl:when test="($mode = 'read') and ($char = $KANSUUJI_ZERO)">
        <xsl:value-of select="$KANA_ZERO"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$char"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 丸数字の処理 -->
  <xsl:template name="maru_repl_one">
    <!-- 対象文字 -->
    <xsl:param name="char"/>
    <!-- 変換候補 -->
    <xsl:variable name="repl">
      <xsl:for-each select="$maru_list">
        <xsl:value-of select="key('msuuji', $char)/@kanji"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <!-- 変換候補が存在すれば，変換する -->
      <xsl:when test="string-length($repl) > 0">
        <xsl:element name="{$trans_tag}">
          <xsl:attribute name="origText">
            <xsl:value-of select="$char"/>
          </xsl:attribute>
          <xsl:value-of select="$repl"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$char"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
