/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.mainmenu_api;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.aetherteam.mainmenu_api.MainMenuAPI;
import net.aetherteam.mainmenu_api.MenuBaseConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.util.MathHelper;

public class JukeboxPlayer {
    public SoundManager soundManager;
    private int musicInterval;
    public List jukeboxMusic;
    public boolean defaultMusic;
    public String musicFileName;
    public boolean songIsPlaying;

    public JukeboxPlayer() {
        this.soundManager = MainMenuAPI.proxy.getClient().field_71416_A;
        this.defaultMusic = true;
        this.musicFileName = null;
        this.songIsPlaying = false;
    }

    public void process() {
        StringBuilder stringBuilder = new StringBuilder();
        Minecraft.func_71410_x();
        File streaming = new File(stringBuilder.append(Minecraft.func_71380_b()).append("/resources/streaming/").toString());
        if (streaming.exists()) {
            this.jukeboxMusic = this.listMusic(streaming, false);
        }
    }

    public void start() {
        MenuBaseConfig.loadConfig();
        if (MenuBaseConfig.hasStartedMusic || this.getMusicFileName() != null) {
            // empty if block
        }
        MenuBaseConfig.hasStartedMusic = true;
        MenuBaseConfig.setProperty("hasStartedMusic", "true");
        this.process();
    }

    public void run() {
        this.musicInterval = this.songIsPlaying && !MenuBaseConfig.muteMusic ? ++this.musicInterval : 0;
        if (this.musicInterval > 100) {
            this.songIsPlaying = false;
            this.musicInterval = 0;
        }
        if (this.jukeboxMusic != null) {
            if (MenuBaseConfig.musicIndex > this.jukeboxMusic.size() - 1) {
                MenuBaseConfig.musicIndex = 0;
                MenuBaseConfig.setProperty("musicIndex", String.valueOf(MenuBaseConfig.musicIndex));
            }
            if (MenuBaseConfig.musicIndex < 0) {
                MenuBaseConfig.musicIndex = this.jukeboxMusic.size() - 1;
                MenuBaseConfig.setProperty("musicIndex", String.valueOf(MenuBaseConfig.musicIndex));
            }
        }
        if (MenuBaseConfig.muteMusic) {
            this.muteMusic();
        }
        this.playMenuMusic();
    }

    public int getIndexFromName(String musicName) {
        this.process();
        if (this.jukeboxMusic != null) {
            for (int count = 0; count < this.jukeboxMusic.size(); ++count) {
                if (!((String)this.jukeboxMusic.get(count)).equalsIgnoreCase(musicName)) continue;
                return count;
            }
        }
        return MenuBaseConfig.musicIndex;
    }

    public List listMusic(File folder, boolean extension) {
        if (folder.exists()) {
            ArrayList<String> files = new ArrayList<String>();
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory()) {
                    this.listMusic(fileEntry, extension);
                    continue;
                }
                String nameExtension = fileEntry.getName();
                String nameNoExtension = fileEntry.getName().replaceFirst("[.][^.]+$", "");
                if (files.contains(extension ? nameExtension : nameNoExtension)) continue;
                files.add(extension ? nameExtension : nameNoExtension);
            }
            return files;
        }
        return null;
    }

    private void setToNextSong() {
        if (this.jukeboxMusic != null && !MenuBaseConfig.musicSet) {
            MenuBaseConfig.musicSet = true;
            MenuBaseConfig.setProperty("musicSet", "true");
            if (MenuBaseConfig.musicIndex > this.jukeboxMusic.size() - 2) {
                MenuBaseConfig.musicIndex = 0;
                MenuBaseConfig.setProperty("musicIndex", String.valueOf(MenuBaseConfig.musicIndex));
            } else {
                MenuBaseConfig.setProperty("musicIndex", String.valueOf(++MenuBaseConfig.musicIndex));
            }
        }
    }

    public String getCurrentSongName() {
        String name = this.getCurrentSong();
        return name.isEmpty() ? "" : name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String getCurrentSong() {
        if (this.jukeboxMusic != null) {
            return (String)this.jukeboxMusic.get(this.defaultMusic ? this.getIndexFromName(this.getMusicFileName()) : MathHelper.func_76125_a((int)MenuBaseConfig.musicIndex, (int)0, (int)(this.jukeboxMusic.size() - 1)));
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMusicPlaying() {
        if (SoundManager.field_77381_a == null) return false;
        if (!SoundManager.field_77381_a.playing("streaming")) return false;
        return true;
    }

    public void muteMusic() {
        SoundManager cfr_ignored_0 = MainMenuAPI.proxy.getClient().field_71416_A;
        SoundManager.field_77381_a.stop("streaming");
    }

    public void toggleMute() {
        MenuBaseConfig.muteMusic = !MenuBaseConfig.muteMusic;
        MenuBaseConfig.setProperty("muteMusic", String.valueOf(MenuBaseConfig.muteMusic));
        if (MenuBaseConfig.muteMusic) {
            this.muteMusic();
        } else {
            this.playMenuMusic();
        }
    }

    public void toggleLoop() {
        MenuBaseConfig.loopMusic = !MenuBaseConfig.loopMusic;
        MenuBaseConfig.setProperty("loopMusic", String.valueOf(MenuBaseConfig.loopMusic));
    }

    private void playMusicFile(String musicFile) {
        if (!MenuBaseConfig.muteMusic) {
            if (SoundManager.field_77381_a != null) {
                if (!SoundManager.field_77381_a.playing("streaming")) {
                    System.out.println("Playing Music File: " + musicFile);
                    float x = (float)MenuBaseConfig.playerPosX;
                    float y = (float)MenuBaseConfig.playerPosY;
                    float z = (float)MenuBaseConfig.playerPosZ;
                    this.soundManager.func_77368_a(musicFile, x != 0.0f ? x : 0.0f, y != 0.0f ? y : 0.0f, z != 0.0f ? z : 0.0f);
                }
            }
        }
    }

    public String getMusicFileName() {
        return this.musicFileName;
    }

    public JukeboxPlayer setMusicFileName(String name) {
        this.musicFileName = name;
        return this;
    }

    public void playMenuMusic() {
        block7: {
            block8: {
                SoundManager cfr_ignored_0 = MainMenuAPI.proxy.getClient().field_71416_A;
                if (SoundManager.field_77381_a == null) break block7;
                if (!MenuBaseConfig.hasPlayedMusic) break block8;
                if (SoundManager.field_77381_a.playing("streaming") || !MenuBaseConfig.hasPlayedMusic) break block7;
            }
            if (MenuBaseConfig.hasStartedMusic) {
                if (!MenuBaseConfig.muteMusic) {
                    if (!SoundManager.field_77381_a.playing("streaming") && !this.songIsPlaying) {
                        this.songIsPlaying = true;
                        if (!MenuBaseConfig.loopMusic) {
                            this.setToNextSong();
                        }
                        this.playMusicFile(this.getCurrentSong());
                    }
                }
                MenuBaseConfig.hasPlayedMusic = true;
                MenuBaseConfig.setProperty("hasPlayedMusic", "true");
            }
        }
        MenuBaseConfig.musicSet = false;
        MenuBaseConfig.setProperty("musicSet", "false");
    }
}

